<?php
// SESSION
require dirname(__DIR__).'/ajax/is_logged.php';

require dirname(__DIR__).'/Connection/Conection.php';
require dirname(__DIR__).'/Model/ConexionVentas.php';
require dirname(__DIR__).'/Model/ConexionLog.php';



date_default_timezone_set('America/Lima');

if (isset($_POST['function']) && !empty($_POST['function'])) {

    $function = json_decode($_POST['function']);

    switch ($function->array) {
        case 'array1':
            $consulta = new Venta;
            $consulta->ListarVentas();
            break;
        case 'array2':
            $consulta = new Venta;
            $consulta->selectListarVentasTotales();
            break;
        //CERTIFICACION VENTA    
        case 'array3':
            $consulta = new Venta;
            $consulta->GuardarVentaCertificada();
            break;
        case 'array4':
            $consulta = new Venta;
            $consulta->GuardarRespuestaComercial();
            break;
        case 'array5':
            $consulta = new Venta;
            $consulta->GuardarRespuestaComercialModal();
            break;
        case 'array6':
            $consulta = new Venta;
            $consulta->historialRespuestaComercialModal();
            break;
        case 'array7':
            $consulta = new Venta;
            $consulta->GuardarGestionlModal();
            break;
        case 'array8':
            $consulta = new Venta;
            $consulta->historialGestionlModal();
            break;
        case 'array9':
            $consulta = new Venta;
            $consulta->GuardarResumenVenta();
            break;
        case 'array10':
            $consulta = new Venta;
            $consulta->selectListarCertificacion();
            break;            
        default:
            echo "Error no se encontro la data";
            break;
    }

}


class Venta
{
    public function ListarVentas()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionVentas();
        
        $datos=$conexion->mostrarTodosVentas($function);

        print_r(json_encode($datos));
        
    }

    public function selectListarVentasTotales()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionVentas();
        
        $datos=$conexion->selectListarVentasTotales($function);

        print_r(json_encode($datos));
        
    }
    public function GuardarVentaCertificada(){
        $function = json_decode($_POST['function']);
    
        $gestor = htmlspecialchars($function->gestor);
        $lblfechacierre_cert=htmlspecialchars($function->lblfechacierre_cert);

        if ($lblfechacierre_cert == '' || empty($lblfechacierre_cert)){
            $lblfechacierre_certgrabar=NULL;
        } else {
            $lblfechacierre_certconvert=  myUrlEncode($lblfechacierre_cert);
            $lblfechacierre_certgrabar=  format_date_Y_mm_dd(str_replace('/', '-', $lblfechacierre_certconvert));
        }        
        
        $lbltipocierre_cert=htmlspecialchars($function->lbltipocierre_cert);
        $lblmotivoincidencia_cert=htmlspecialchars($function->lblmotivoincidencia_cert);
        $lblsolucionincidencia_cert=htmlspecialchars($function->lblsolucionincidencia_cert);
        $hidden_hojacertificacion=htmlspecialchars($function->hidden_hojacertificacion);
        $hidden_inci_tecnica=htmlspecialchars($function->hidden_inci_tecnica);
        $hidden_certificadovalidado=htmlspecialchars($function->hidden_certificadovalidado);
        $idventa=htmlspecialchars($function->ediventa);
        $idcertventa=htmlspecialchars($function->idcertventa);
        $lblfechaapertura_cert=htmlspecialchars($function->lblfechaapertura_cert);
        $lblformapago_cert=htmlspecialchars($function->lblformapago_cert);
        $lblcomentario_cert=htmlspecialchars($function->lblcomentario_cert);
        $hidden_kitnoinstalado=htmlspecialchars($function->hidden_kitnoinstalado);
        $lblfechacorrecion_kitnoinstalado=htmlspecialchars($function->lblfechacorrecion_kitnoinstalado);
        
        if ($lblfechacorrecion_kitnoinstalado == '' || empty($lblfechacorrecion_kitnoinstalado)){
            $lblfechacorrecion_kitnoinstalado=NULL;
        } else {
            $lblfechacorrecion_kitnoinstalado=myUrlEncode($lblfechacorrecion_kitnoinstalado);
            $lblfechacorrecion_kitnoinstalado=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_kitnoinstalado));
        } 
        
        $hidden_errorcomprobantepago=htmlspecialchars($function->hidden_errorcomprobantepago);
        $lblfechacorrecion_errorcomprobantepago=htmlspecialchars($function->lblfechacorrecion_errorcomprobantepago);
        if ($lblfechacorrecion_errorcomprobantepago == '' || empty($lblfechacorrecion_errorcomprobantepago)){
            $lblfechacorrecion_errorcomprobantepago=NULL;
        } else {
            $lblfechacorrecion_errorcomprobantepago=myUrlEncode($lblfechacorrecion_errorcomprobantepago);
            $lblfechacorrecion_errorcomprobantepago=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_errorcomprobantepago));
        }        
        $hidden_errorsegmento=htmlspecialchars($function->hidden_errorsegmento);
        $lblfechacorrecion_errorsegmento=htmlspecialchars($function->lblfechacorrecion_errorsegmento);
        if ($lblfechacorrecion_errorsegmento == '' || empty($lblfechacorrecion_errorsegmento)){
            $lblfechacorrecion_errorsegmento=NULL;
        } else {
            $lblfechacorrecion_errorsegmento=myUrlEncode($lblfechacorrecion_errorsegmento);
            $lblfechacorrecion_errorsegmento=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_errorsegmento));
        }        
        $hidden_fueranomalcomercial=htmlspecialchars($function->hidden_fueranomalcomercial);
        $lblfechacorrecion_fueranomalcomercial=htmlspecialchars($function->lblfechacorrecion_fueranomalcomercial);
        if ($lblfechacorrecion_fueranomalcomercial == '' || empty($lblfechacorrecion_fueranomalcomercial)){
            $lblfechacorrecion_fueranomalcomercial=NULL;
        } else {
            $lblfechacorrecion_fueranomalcomercial=myUrlEncode($lblfechacorrecion_fueranomalcomercial);
            $lblfechacorrecion_fueranomalcomercial=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_fueranomalcomercial));
        }        
        $hidden_fueranormativatecnica=htmlspecialchars($function->hidden_fueranormativatecnica);
        $lblfechacorrecion_fueranormativatecnica=htmlspecialchars($function->lblfechacorrecion_fueranormativatecnica);
        if ($lblfechacorrecion_fueranormativatecnica == '' || empty($lblfechacorrecion_fueranormativatecnica)){
            $lblfechacorrecion_fueranormativatecnica=NULL;
        } else {
            $lblfechacorrecion_fueranormativatecnica=myUrlEncode($lblfechacorrecion_fueranormativatecnica);
            $lblfechacorrecion_fueranormativatecnica=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_fueranormativatecnica));
        }        
        $hidden_incidenciadatos=htmlspecialchars($function->hidden_incidenciadatos);
        $lblfechacorrecion_incidenciadatos=htmlspecialchars($function->lblfechacorrecion_incidenciadatos);
        if ($lblfechacorrecion_incidenciadatos == '' || empty($lblfechacorrecion_incidenciadatos)){
            $lblfechacorrecion_incidenciadatos=NULL;
        } else {
            $lblfechacorrecion_incidenciadatos=myUrlEncode($lblfechacorrecion_incidenciadatos);
            $lblfechacorrecion_incidenciadatos=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_incidenciadatos));
        }        
        $hidden_inconformidadfuncionamiento=htmlspecialchars($function->hidden_inconformidadfuncionamiento);
        $lblfechacorrecion_inconformidadfuncionamiento=htmlspecialchars($function->lblfechacorrecion_inconformidadfuncionamiento);
        if ($lblfechacorrecion_inconformidadfuncionamiento == '' || empty($lblfechacorrecion_inconformidadfuncionamiento)){
            $lblfechacorrecion_inconformidadfuncionamiento=NULL;
        } else {
            $lblfechacorrecion_inconformidadfuncionamiento=myUrlEncode($lblfechacorrecion_inconformidadfuncionamiento);
            $lblfechacorrecion_inconformidadfuncionamiento=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_inconformidadfuncionamiento));
        }        
        $hidden_inconformidadpagoinicial=htmlspecialchars($function->hidden_inconformidadpagoinicial);
        $lblfechacorrecion_inconformidadpagoinicial=htmlspecialchars($function->lblfechacorrecion_inconformidadpagoinicial);
        if ($lblfechacorrecion_inconformidadpagoinicial == '' || empty($lblfechacorrecion_inconformidadpagoinicial)){
            $lblfechacorrecion_inconformidadpagoinicial=NULL;
        } else {
            $lblfechacorrecion_inconformidadpagoinicial=myUrlEncode($lblfechacorrecion_inconformidadpagoinicial);
            $lblfechacorrecion_inconformidadpagoinicial=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_inconformidadpagoinicial));
        }        
        $hidden_inconformidadpagomensual=htmlspecialchars($function->hidden_inconformidadpagomensual);
        $lblfechacorrecion_inconformidadpagomensual=htmlspecialchars($function->lblfechacorrecion_inconformidadpagomensual);
        if ($lblfechacorrecion_inconformidadpagomensual == '' || empty($lblfechacorrecion_inconformidadpagomensual)){
            $lblfechacorrecion_inconformidadpagomensual=NULL;
        } else {
            $lblfechacorrecion_inconformidadpagomensual=myUrlEncode($lblfechacorrecion_inconformidadpagomensual);
            $lblfechacorrecion_inconformidadpagomensual=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_inconformidadpagomensual));
        }        
        $hidden_inconformidadtiempopermanencia=htmlspecialchars($function->hidden_inconformidadtiempopermanencia);
        $lblfechacorrecion_inconformidadtiempopermanencia=htmlspecialchars($function->lblfechacorrecion_inconformidadtiempopermanencia);
        if ($lblfechacorrecion_inconformidadtiempopermanencia == '' || empty($lblfechacorrecion_inconformidadtiempopermanencia)){
            $lblfechacorrecion_inconformidadtiempopermanencia=NULL;
        } else {
            $lblfechacorrecion_inconformidadtiempopermanencia=myUrlEncode($lblfechacorrecion_inconformidadtiempopermanencia);
            $lblfechacorrecion_inconformidadtiempopermanencia=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_inconformidadtiempopermanencia));
        }        
        $hidden_inconformidadubicaciondispositivos=htmlspecialchars($function->hidden_inconformidadubicaciondispositivos);
        $lblfechacorrecion_inconformidadubicaciondispositivos=htmlspecialchars($function->lblfechacorrecion_inconformidadubicaciondispositivos);
        if ($lblfechacorrecion_inconformidadubicaciondispositivos == '' || empty($lblfechacorrecion_inconformidadubicaciondispositivos)){
            $lblfechacorrecion_inconformidadubicaciondispositivos=NULL;
        } else {
            $lblfechacorrecion_inconformidadubicaciondispositivos=myUrlEncode($lblfechacorrecion_inconformidadubicaciondispositivos);
            $lblfechacorrecion_inconformidadubicaciondispositivos=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_inconformidadubicaciondispositivos));
        }        
        $hidden_noconcefuncionamiento=htmlspecialchars($function->hidden_noconcefuncionamiento);
        $lblfechacorrecion_noconcefuncionamiento=htmlspecialchars($function->lblfechacorrecion_noconcefuncionamiento);
        if ($lblfechacorrecion_noconcefuncionamiento == '' || empty($lblfechacorrecion_noconcefuncionamiento)){
            $lblfechacorrecion_noconcefuncionamiento=NULL;
        } else {
            $lblfechacorrecion_noconcefuncionamiento=myUrlEncode($lblfechacorrecion_noconcefuncionamiento);
            $lblfechacorrecion_noconcefuncionamiento=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_noconcefuncionamiento));
        }        
        $hidden_notienecontrato=htmlspecialchars($function->hidden_notienecontrato);
        $lblfechacorrecion_notienecontrato=htmlspecialchars($function->lblfechacorrecion_notienecontrato);
        if ($lblfechacorrecion_notienecontrato == '' || empty($lblfechacorrecion_notienecontrato)){
            $lblfechacorrecion_notienecontrato=NULL;
        } else {
            $lblfechacorrecion_notienecontrato=myUrlEncode($lblfechacorrecion_notienecontrato);
            $lblfechacorrecion_notienecontrato=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_notienecontrato));
        }        
        $hidden_promesaspendientes=htmlspecialchars($function->hidden_promesaspendientes);
        $lblfechacorrecion_promesaspendientes=htmlspecialchars($function->lblfechacorrecion_promesaspendientes);
        if ($lblfechacorrecion_promesaspendientes == '' || empty($lblfechacorrecion_promesaspendientes)){
            $lblfechacorrecion_promesaspendientes=NULL;
        } else {
            $lblfechacorrecion_promesaspendientes=myUrlEncode($lblfechacorrecion_promesaspendientes);
            $lblfechacorrecion_promesaspendientes=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_promesaspendientes));
        }        
        $hidden_reclamocomercial=htmlspecialchars($function->hidden_reclamocomercial);
        $lblfechacorrecion_reclamocomercial=htmlspecialchars($function->lblfechacorrecion_reclamocomercial);
        if ($lblfechacorrecion_reclamocomercial == '' || empty($lblfechacorrecion_reclamocomercial)){
            $lblfechacorrecion_reclamocomercial=NULL;
        } else {
            $lblfechacorrecion_reclamocomercial=myUrlEncode($lblfechacorrecion_reclamocomercial);
            $lblfechacorrecion_reclamocomercial=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_reclamocomercial));
        }        
        $hidden_solicitabaja=htmlspecialchars($function->hidden_solicitabaja);
        $lblfechacorrecion_solicitabaja=htmlspecialchars($function->lblfechacorrecion_solicitabaja);
        if ($lblfechacorrecion_solicitabaja == '' || empty($lblfechacorrecion_solicitabaja)){
            $lblfechacorrecion_solicitabaja=NULL;
        } else {
            $lblfechacorrecion_solicitabaja=myUrlEncode($lblfechacorrecion_solicitabaja);
            $lblfechacorrecion_solicitabaja=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_solicitabaja));
        }        
        $hidden_tarjetaafiliadanopertenecetitular=htmlspecialchars($function->hidden_tarjetaafiliadanopertenecetitular);
        $lblfechacorrecion_tarjetaafiliadanopertenecetitular=htmlspecialchars($function->lblfechacorrecion_tarjetaafiliadanopertenecetitular);
        if ($lblfechacorrecion_tarjetaafiliadanopertenecetitular == '' || empty($lblfechacorrecion_tarjetaafiliadanopertenecetitular)){
            $lblfechacorrecion_tarjetaafiliadanopertenecetitular=NULL;
        } else {
            $lblfechacorrecion_tarjetaafiliadanopertenecetitular=myUrlEncode($lblfechacorrecion_tarjetaafiliadanopertenecetitular);
            $lblfechacorrecion_tarjetaafiliadanopertenecetitular=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_tarjetaafiliadanopertenecetitular));
        }        
        $hidden_recepmanual=htmlspecialchars($function->hidden_recepmanual);
        $lblfechacorrecion_recepmanual=htmlspecialchars($function->lblfechacorrecion_recepmanual);
        if ($lblfechacorrecion_recepmanual == '' || empty($lblfechacorrecion_recepmanual)){
            $lblfechacorrecion_recepmanual=NULL;
        } else {
            $lblfechacorrecion_recepmanual=myUrlEncode($lblfechacorrecion_recepmanual);
            $lblfechacorrecion_recepmanual=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_recepmanual));
        }        
        $hidden_descargaapp=htmlspecialchars($function->hidden_descargaapp);
        $lblfechacorrecion_descargaapp=htmlspecialchars($function->lblfechacorrecion_descargaapp);
        if ($lblfechacorrecion_descargaapp == '' || empty($lblfechacorrecion_descargaapp)){
            $lblfechacorrecion_descargaapp=NULL;
        } else {
            $lblfechacorrecion_descargaapp=myUrlEncode($lblfechacorrecion_descargaapp);
            $lblfechacorrecion_descargaapp=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_descargaapp));
        }        
        $hidden_capacitado=htmlspecialchars($function->hidden_capacitado);
        $lblfechacorrecion_capacitado=htmlspecialchars($function->lblfechacorrecion_capacitado);
        if ($lblfechacorrecion_capacitado == '' || empty($lblfechacorrecion_capacitado)){
            $lblfechacorrecion_capacitado=NULL;
        } else {
            $lblfechacorrecion_capacitado=myUrlEncode($lblfechacorrecion_capacitado);
            $lblfechacorrecion_capacitado=format_date_Y_mm_dd(str_replace('/', '-', $lblfechacorrecion_capacitado));
        }        
        $lblnumerollamadas=htmlspecialchars($function->lblnumerollamadas);
        $lbltipoaccion=htmlspecialchars($function->lbltipoaccion);
        
        if($lbltipoaccion=="gestion"){
            $lblnumerollamadas++;
        }
         
        if (empty($idcertventa)){
            $idcertventa = NULL;
        }

        $FechaPendiente=htmlspecialchars($function->FechaPendiente);
        if ($FechaPendiente == '' || empty($FechaPendiente)){
            $FechaPendiente=NULL;
        }
        $FechaPrimeraGestion=htmlspecialchars($function->FechaPrimeraGestion);

        if ($FechaPrimeraGestion == '' || empty($FechaPrimeraGestion)){
            $FechaPrimeraGestion=NULL;
        }
        
        if($lbltipocierre_cert=="Pendiente"){
            if (empty($FechaPrimeraGestion)){
                $FechaPendiente=date("Y-m-d H:i:s");
            }
        }
        
        if($lbltipoaccion=="gestion"){
            
            if (empty($FechaPrimeraGestion)){
                $FechaPrimeraGestion=date("Y-m-d H:i:s");
            }
            
        }
        
        $FechaFinalizadoconIncidencia=htmlspecialchars($function->FechaFinalizadoconIncidencia);
        if ($FechaFinalizadoconIncidencia == '' || empty($FechaFinalizadoconIncidencia)){
            $FechaFinalizadoconIncidencia=NULL;
        }
        
        if($lbltipocierre_cert=="Finalizada con Incidencia"){
            if (empty($FechaFinalizadoconIncidencia)){
                $FechaFinalizadoconIncidencia=date("Y-m-d H:i:s");
            }
        } 
        
        $FechaResuelto=htmlspecialchars($function->FechaResuelto);
        if ($FechaResuelto == '' || empty($FechaResuelto)){
            $FechaResuelto=NULL;
        }        

        if($lblsolucionincidencia_cert=="Resuelto"){
            if (empty($FechaResuelto)){
                $FechaResuelto=date("Y-m-d H:i:s");
            }
        }

        $conexion = new ConexionVentas();
        




        if ($idcertventa == NULL){
            $idcertventa = $conexion->insertarCertificacion($lblfechacierre_certgrabar,$lbltipocierre_cert,$lblmotivoincidencia_cert,$hidden_inci_tecnica,$lblsolucionincidencia_cert,$lblformapago_cert,$lblcomentario_cert,$hidden_kitnoinstalado,$lblfechacorrecion_kitnoinstalado,$hidden_errorcomprobantepago,$lblfechacorrecion_errorcomprobantepago,$hidden_errorsegmento,$lblfechacorrecion_errorsegmento,$hidden_fueranomalcomercial,$lblfechacorrecion_fueranomalcomercial,$hidden_fueranormativatecnica,$lblfechacorrecion_fueranormativatecnica,$hidden_incidenciadatos,$lblfechacorrecion_incidenciadatos,$hidden_inconformidadfuncionamiento,$lblfechacorrecion_inconformidadfuncionamiento,$hidden_inconformidadpagoinicial,$lblfechacorrecion_inconformidadpagoinicial,$hidden_inconformidadpagomensual,$lblfechacorrecion_inconformidadpagomensual,$hidden_inconformidadtiempopermanencia,$lblfechacorrecion_inconformidadtiempopermanencia,$hidden_inconformidadubicaciondispositivos,$lblfechacorrecion_inconformidadubicaciondispositivos,$hidden_noconcefuncionamiento,$lblfechacorrecion_noconcefuncionamiento,$hidden_notienecontrato,$lblfechacorrecion_notienecontrato,$hidden_promesaspendientes,$lblfechacorrecion_promesaspendientes,$hidden_reclamocomercial,$lblfechacorrecion_reclamocomercial,$hidden_solicitabaja,$lblfechacorrecion_solicitabaja,$hidden_tarjetaafiliadanopertenecetitular,$lblfechacorrecion_tarjetaafiliadanopertenecetitular,$hidden_recepmanual,$lblfechacorrecion_recepmanual,$hidden_descargaapp,$lblfechacorrecion_descargaapp,$hidden_capacitado,$lblfechacorrecion_capacitado,$lblnumerollamadas,$FechaPendiente,$FechaPrimeraGestion,$FechaFinalizadoconIncidencia,$FechaResuelto);
            if($idcertventa>0){
              $resultadoventa=$conexion->actualizarVenta($idventa,$hidden_certificadovalidado,$gestor,$hidden_hojacertificacion,$idcertventa,$lblfechaapertura_cert);
                //INSERTAR LOG HISTORIAL DE VENTA CERTIFICADA
                $conexion->insertarCertificacionHist($idcertventa, $idventa, $gestor, $lblfechaapertura_cert, $lblfechacierre_certgrabar, $lbltipocierre_cert, $hidden_inci_tecnica, $lblformapago_cert, $lblcomentario_cert,$hidden_kitnoinstalado,$lblfechacorrecion_kitnoinstalado,$hidden_errorcomprobantepago,$lblfechacorrecion_errorcomprobantepago,$hidden_errorsegmento,$lblfechacorrecion_errorsegmento,$hidden_fueranomalcomercial,$lblfechacorrecion_fueranomalcomercial,$hidden_fueranormativatecnica,$lblfechacorrecion_fueranormativatecnica,$hidden_incidenciadatos,$lblfechacorrecion_incidenciadatos,$hidden_inconformidadfuncionamiento,$lblfechacorrecion_inconformidadfuncionamiento,$hidden_inconformidadpagoinicial,$lblfechacorrecion_inconformidadpagoinicial,$hidden_inconformidadpagomensual,$lblfechacorrecion_inconformidadpagomensual,$hidden_inconformidadtiempopermanencia,$lblfechacorrecion_inconformidadtiempopermanencia,$hidden_inconformidadubicaciondispositivos,$lblfechacorrecion_inconformidadubicaciondispositivos,$hidden_noconcefuncionamiento,$lblfechacorrecion_noconcefuncionamiento,$hidden_notienecontrato,$lblfechacorrecion_notienecontrato,$hidden_promesaspendientes,$lblfechacorrecion_promesaspendientes,$hidden_reclamocomercial,$lblfechacorrecion_reclamocomercial,$hidden_solicitabaja,$lblfechacorrecion_solicitabaja,$hidden_tarjetaafiliadanopertenecetitular,$lblfechacorrecion_tarjetaafiliadanopertenecetitular,$hidden_recepmanual,$lblfechacorrecion_recepmanual,$hidden_descargaapp,$lblfechacorrecion_descargaapp,$hidden_capacitado,$lblfechacorrecion_capacitado,$lblnumerollamadas,$lbltipoaccion);
              $respuesta=json_encode(array('respuesta' => 'exito', 'id_registro' => $idcertventa));
            }else{
                $respuesta=json_encode(array('respuesta' => 'error'));
            }
            
            
        }else{
            $resultadocertificacion= $conexion->actualizarCertificacion($idcertventa,$lblfechacierre_certgrabar,$lbltipocierre_cert,$lblmotivoincidencia_cert,$hidden_inci_tecnica,$lblsolucionincidencia_cert,$lblformapago_cert,$lblcomentario_cert,$hidden_kitnoinstalado,$lblfechacorrecion_kitnoinstalado,$hidden_errorcomprobantepago,$lblfechacorrecion_errorcomprobantepago,$hidden_errorsegmento,$lblfechacorrecion_errorsegmento,$hidden_fueranomalcomercial,$lblfechacorrecion_fueranomalcomercial,$hidden_fueranormativatecnica,$lblfechacorrecion_fueranormativatecnica,$hidden_incidenciadatos,$lblfechacorrecion_incidenciadatos,$hidden_inconformidadfuncionamiento,$lblfechacorrecion_inconformidadfuncionamiento,$hidden_inconformidadpagoinicial,$lblfechacorrecion_inconformidadpagoinicial,$hidden_inconformidadpagomensual,$lblfechacorrecion_inconformidadpagomensual,$hidden_inconformidadtiempopermanencia,$lblfechacorrecion_inconformidadtiempopermanencia,$hidden_inconformidadubicaciondispositivos,$lblfechacorrecion_inconformidadubicaciondispositivos,$hidden_noconcefuncionamiento,$lblfechacorrecion_noconcefuncionamiento,$hidden_notienecontrato,$lblfechacorrecion_notienecontrato,$hidden_promesaspendientes,$lblfechacorrecion_promesaspendientes,$hidden_reclamocomercial,$lblfechacorrecion_reclamocomercial,$hidden_solicitabaja,$lblfechacorrecion_solicitabaja,$hidden_tarjetaafiliadanopertenecetitular,$lblfechacorrecion_tarjetaafiliadanopertenecetitular,$hidden_recepmanual,$lblfechacorrecion_recepmanual,$hidden_descargaapp,$lblfechacorrecion_descargaapp,$hidden_capacitado,$lblfechacorrecion_capacitado,$lblnumerollamadas,$FechaPendiente,$FechaPrimeraGestion,$FechaFinalizadoconIncidencia,$FechaResuelto);
            
            $resultadoventa=$conexion->actualizarVenta($idventa,$hidden_certificadovalidado,$gestor,$hidden_hojacertificacion,$idcertventa,$lblfechaapertura_cert);
            
            //INSERTAR LOG HISTORIAL DE VENTA CERTIFICADA
            $conexion->insertarCertificacionHist($idcertventa, $idventa, $gestor, $lblfechaapertura_cert, $lblfechacierre_certgrabar, $lbltipocierre_cert, $hidden_inci_tecnica, $lblformapago_cert, $lblcomentario_cert,$hidden_kitnoinstalado,$lblfechacorrecion_kitnoinstalado,$hidden_errorcomprobantepago,$lblfechacorrecion_errorcomprobantepago,$hidden_errorsegmento,$lblfechacorrecion_errorsegmento,$hidden_fueranomalcomercial,$lblfechacorrecion_fueranomalcomercial,$hidden_fueranormativatecnica,$lblfechacorrecion_fueranormativatecnica,$hidden_incidenciadatos,$lblfechacorrecion_incidenciadatos,$hidden_inconformidadfuncionamiento,$lblfechacorrecion_inconformidadfuncionamiento,$hidden_inconformidadpagoinicial,$lblfechacorrecion_inconformidadpagoinicial,$hidden_inconformidadpagomensual,$lblfechacorrecion_inconformidadpagomensual,$hidden_inconformidadtiempopermanencia,$lblfechacorrecion_inconformidadtiempopermanencia,$hidden_inconformidadubicaciondispositivos,$lblfechacorrecion_inconformidadubicaciondispositivos,$hidden_noconcefuncionamiento,$lblfechacorrecion_noconcefuncionamiento,$hidden_notienecontrato,$lblfechacorrecion_notienecontrato,$hidden_promesaspendientes,$lblfechacorrecion_promesaspendientes,$hidden_reclamocomercial,$lblfechacorrecion_reclamocomercial,$hidden_solicitabaja,$lblfechacorrecion_solicitabaja,$hidden_tarjetaafiliadanopertenecetitular,$lblfechacorrecion_tarjetaafiliadanopertenecetitular,$hidden_recepmanual,$lblfechacorrecion_recepmanual,$hidden_descargaapp,$lblfechacorrecion_descargaapp,$hidden_capacitado,$lblfechacorrecion_capacitado,$lblnumerollamadas,$lbltipoaccion);
            
            if($resultadocertificacion==0 && $resultadoventa == 0){
                $respuesta=json_encode(array('respuesta' => 'SinCambios'));
            }else if($resultadocertificacion>0 && $resultadoventa>0){
                $respuesta=json_encode(array('respuesta' => 'exito', 'id_registro' => $idcertventa));
            }else if($resultadocertificacion>0 && $resultadoventa==0){
                $respuesta=json_encode(array('respuesta' => 'exito', 'id_registro' => $idcertventa));
            }else if($resultadocertificacion==0 && $resultadoventa > 0){
                $respuesta=json_encode(array('respuesta' => 'exito', 'id_registro' => $idcertventa));
            }else{
                $respuesta=json_encode(array('respuesta' => 'error'));
            }
            
        }
        
                //ENVIAR CORREO DE Finalizada con Incidencia
        if($lbltipoaccion == 'gestion'){ 
            if($lbltipocierre_cert=='Finalizada con Exito' || $lbltipocierre_cert=='Finalizada con Incidencia' || $lbltipocierre_cert=='Ilocalizado' || $lbltipocierre_cert=='No colabora' || $lbltipocierre_cert=='No contesta'){

            $arrayNotificaciones=$conexion->InformacionCorreoCertificacionIncidencia($idventa);
            
            EnvioCorreoIncidenciaCertificacion($arrayNotificaciones);
            }
        }
        
        
        die($respuesta);


         
    }
    
    public function GuardarRespuestaComercial(){
            $function = json_decode($_POST['function']);

            $lblcomentario_comercial = htmlspecialchars($function->lblcomentario_comercial);
            $lblhorariosugerido2 = htmlspecialchars($function->lblhorariosugerido2);
            $idventa=htmlspecialchars($function->ediventa);
            $idcertventa=htmlspecialchars($function->idcertventa);
            $TipoAccion='Informacion';
            $RespComercial='SI';
            
            $gestor=htmlspecialchars($function->matricula);
            
            $conexion = new ConexionVentas();
            
            $resultadocertificacion= $conexion->ingresarRespuestaComercial($idcertventa,$lblcomentario_comercial,$lblhorariosugerido2,$RespComercial);
            $conexion->insertarCertificacionHistRespuestaComercial($idcertventa, $idventa, $gestor, $TipoAccion,$lblcomentario_comercial,$lblhorariosugerido2,$RespComercial);
            
            if($resultadocertificacion==0){
                $respuesta=json_encode(array('respuesta' => 'SinCambios'));
            }else if($resultadocertificacion>0){
                $respuesta=json_encode(array('respuesta' => 'exito', 'id_registro' => $idcertventa));
            }else{
                $respuesta=json_encode(array('respuesta' => 'error'));
            }
            
            die($respuesta);
        
        
    }
    
        public function GuardarRespuestaComercialModal(){
            $function = json_decode($_POST['function']);

            $lblcomentario_comercial = htmlspecialchars($function->lblcomentario_comercial);
            $lblhorariosugerido2 = htmlspecialchars($function->lblhorariosugerido2);
            $idventa=htmlspecialchars($function->ediventa);
            $idcertventa=htmlspecialchars($function->idcertventa);
            $tipocierre_cert=htmlspecialchars($function->lbltipocierre_cert);
            $matricula=htmlspecialchars($function->matricula);
            
            
            $TipoAccion='Informacion';
            $RespComercial='SI';
            
            $gestor=htmlspecialchars($function->matricula);
            
            $conexion = new ConexionVentas();
            
            $resultadocertificacion= $conexion->ingresarRespuestaComercialModal($idcertventa,$lblcomentario_comercial,$lblhorariosugerido2,$RespComercial,$tipocierre_cert,$matricula,$idventa);
            //$conexion->insertarCertificacionHistRespuestaComercial($idcertventa, $idventa, $gestor, $TipoAccion,$lblcomentario_comercial,$lblhorariosugerido2,$RespComercial);
            
            if($resultadocertificacion==0){
                $respuesta=json_encode(array('respuesta' => 'SinCambios'));
            }else if($resultadocertificacion>0){
                $respuesta=json_encode(array('respuesta' => 'exito', 'id_registro' => $idcertventa));
            }else{
                $respuesta=json_encode(array('respuesta' => 'error'));
            }
            
            die($respuesta);
        
        
    }
    
        public function historialRespuestaComercialModal(){
            $function = json_decode($_POST['function']);

            $idventa=htmlspecialchars($function->idventa);
            
            $conexion = new ConexionVentas();
            
            $arrayHistorialRespuesta= $conexion->historialRespuestaComercialModal($idventa);
            //$conexion->insertarCertificacionHistRespuestaComercial($idcertventa, $idventa, $gestor, $TipoAccion,$lblcomentario_comercial,$lblhorariosugerido2,$RespComercial);
            
            print_r(json_encode($arrayHistorialRespuesta));
        
        
    }    
    public function historialGestionlModal(){
            $function = json_decode($_POST['function']);

            $idventa=htmlspecialchars($function->idventa);
            
            $conexion = new ConexionVentas();
            
            $arrayHistorialRespuesta= $conexion->historialGestionlModal($idventa);
            //$conexion->insertarCertificacionHistRespuestaComercial($idcertventa, $idventa, $gestor, $TipoAccion,$lblcomentario_comercial,$lblhorariosugerido2,$RespComercial);
            
            print_r(json_encode($arrayHistorialRespuesta));
        
        
    } 
    
    
     public function GuardarGestionlModal(){
            $function = json_decode($_POST['function']);

            $modalestadollamada = htmlspecialchars($function->modalestadollamada);
            $modalfechahoraRellamada = htmlspecialchars($function->modalfechahoraRellamada);
            $modalcomentario_cert = htmlspecialchars($function->modalcomentario_cert);

            $idventa=htmlspecialchars($function->ediventa);
            $idcertventa=htmlspecialchars($function->idcertventa);
            $tipocierre_cert=htmlspecialchars($function->lbltipocierre_cert);
            $matricula=htmlspecialchars($function->matricula);
            $lblasignado=htmlspecialchars($function->lblasignado);
            $lblfechaapertura_cert=htmlspecialchars($function->lblfechaapertura_cert);
            $numerollamadas=htmlspecialchars($function->numerollamadas);
            

            if ($lblfechaapertura_cert == '' || empty($lblfechaapertura_cert)){
                $lblfechaapertura_cert = NULL;
            }
            
            if ($modalfechahoraRellamada == '' || empty($modalfechahoraRellamada)){
                $modalfechahoraRellamada = NULL;
            } else {
                $modalfechahoraRellamada =  date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $modalfechahoraRellamada)));
            }

            $conexion = new ConexionVentas();
            
            $resultadocertificacion= $conexion->ingresarGestionModal($lblasignado,$lblfechaapertura_cert,$matricula,$modalestadollamada,$modalcomentario_cert,$modalfechahoraRellamada,$tipocierre_cert,$numerollamadas,$idcertventa,$idventa);
            
            
            $respuesta=json_encode($resultadocertificacion);
            
            die($respuesta);
        
        
    }
    
         public function GuardarResumenVenta(){
            $function = json_decode($_POST['function']);


          
            

            $lblasignado=htmlspecialchars($function->lblasignado);
            $lblfechaapertura_cert=htmlspecialchars($function->lblfechaapertura_cert);
            $tipocierre_cert=htmlspecialchars($function->lbltipocierre_cert);
            $lblsolucionincidencia_cert = htmlspecialchars($function->lblsolucionincidencia_cert);
            $lblfechanacimiento = htmlspecialchars($function->lblfechanacimiento);
            $lbltipogenero = htmlspecialchars($function->lbltipogenero);
            $lblformapago_cert = htmlspecialchars($function->lblformapago_cert);
            $detalleIncidencia = $function->detalleIncidencia;

            $idventa=htmlspecialchars($function->ediventa);
            $idcertventa=htmlspecialchars($function->idcertventa);
            $matricula=htmlspecialchars($function->matricula);
            
            $lblcomentario_cert=htmlspecialchars($function->lblcomentario_cert);
            
            if ($lblfechaapertura_cert == '' || empty($lblfechaapertura_cert)){
                $lblfechaapertura_cert = date("Y-m-d H:i:s");
            }
            
            if ($lblfechanacimiento == '' || empty($lblfechanacimiento)){
                $lblfechanacimiento = NULL;
            } else {
                $lblfechanacimiento =  date("Y-m-d", strtotime(str_replace('/', '-', $lblfechanacimiento)));
            }            
            
            $conexion = new ConexionVentas();

            $resultadocertificacion= $conexion->guardarresumenventa($lblasignado,
            $lblfechaapertura_cert,
            $tipocierre_cert,
            $lblsolucionincidencia_cert,
            $lblfechanacimiento,
            $lbltipogenero,
            $lblformapago_cert,
            $detalleIncidencia,
            $idcertventa,
            $idventa);
            
            $respuesta=json_encode($resultadocertificacion);

            if($tipocierre_cert=='Finalizada con Exito' || $tipocierre_cert=='Incidencia' || $tipocierre_cert=='Ilocalizado' || $tipocierre_cert=='No colabora' || $tipocierre_cert=='Ilocalizado' || $tipocierre_cert=='En gestion'){

            $arrayNotificaciones=$conexion->InformacionCorreoCertificacionIncidenciaModal($idventa);
            $arrayNotificaciones[0]["ComentarioCERT"]=$lblcomentario_cert;

            $respuestaenvio=EnvioCorreoIncidenciaCertificacionModal($arrayNotificaciones);
            
            }  
            
            
            die($respuesta);
        
        
    }
    
    
    
        public function selectListarCertificacion()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionVentas();
        
        $datos=$conexion->selectListarCertificacion($function);

        print_r(json_encode($datos));
        
    }
    
    
    
    
}

//FUNCIONES UFT8 Y Fecha
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

function EnvioCorreoIncidenciaCertificacion($arrayDatos){
    
    
    
        $contrato=$arrayDatos[0]['NContrato'];
        $cliente=$arrayDatos[0]['Cliente'];
        $CC=$arrayDatos[0]['CC'];
        
        $kitnoinstalado= $arrayDatos[0]['kitnoinstalado'];
        $fechacorrecion_kitnoinstalado= $arrayDatos[0]['fechacorrecion_kitnoinstalado'];
        $errorcomprobantepago= $arrayDatos[0]['errorcomprobantepago'];
        $fechacorrecion_errorcomprobantepago= $arrayDatos[0]['fechacorrecion_errorcomprobantepago'];
        $errorsegmento= $arrayDatos[0]['errorsegmento'];
        $fechacorrecion_errorsegmento= $arrayDatos[0]['fechacorrecion_errorsegmento'];
        $fueranomalcomercial= $arrayDatos[0]['fueranomalcomercial'];
        $fechacorrecion_fueranomalcomercial= $arrayDatos[0]['fechacorrecion_fueranomalcomercial'];
        $fueranormativatecnica= $arrayDatos[0]['fueranormativatecnica'];
        $fechacorrecion_fueranormativatecnica= $arrayDatos[0]['fechacorrecion_fueranormativatecnica'];
        $incidenciadatos= $arrayDatos[0]['incidenciadatos'];
        $fechacorrecion_incidenciadatos= $arrayDatos[0]['fechacorrecion_incidenciadatos'];
        $inconformidadfuncionamiento= $arrayDatos[0]['inconformidadfuncionamiento'];
        $fechacorrecion_inconformidadfuncionamiento= $arrayDatos[0]['fechacorrecion_inconformidadfuncionamiento'];
        $inconformidadpagoinicial= $arrayDatos[0]['inconformidadpagoinicial'];
        $fechacorrecion_inconformidadpagoinicial= $arrayDatos[0]['fechacorrecion_inconformidadpagoinicial'];
        $inconformidadpagomensual= $arrayDatos[0]['inconformidadpagomensual'];
        $fechacorrecion_inconformidadpagomensual= $arrayDatos[0]['fechacorrecion_inconformidadpagomensual'];
        $inconformidadtiempopermanencia= $arrayDatos[0]['inconformidadtiempopermanencia'];
        $fechacorrecion_inconformidadtiempopermanencia= $arrayDatos[0]['fechacorrecion_inconformidadtiempopermanencia'];
        $inconformidadubicaciondispositivos= $arrayDatos[0]['inconformidadubicaciondispositivos'];
        $fechacorrecion_inconformidadubicaciondispositivos= $arrayDatos[0]['fechacorrecion_inconformidadubicaciondispositivos'];
        $noconcefuncionamiento= $arrayDatos[0]['noconcefuncionamiento'];
        $fechacorrecion_noconcefuncionamiento= $arrayDatos[0]['fechacorrecion_noconcefuncionamiento'];
        $notienecontrato= $arrayDatos[0]['notienecontrato'];
        $fechacorrecion_notienecontrato= $arrayDatos[0]['fechacorrecion_notienecontrato'];
        $promesaspendientes= $arrayDatos[0]['promesaspendientes'];
        $fechacorrecion_promesaspendientes= $arrayDatos[0]['fechacorrecion_promesaspendientes'];
        $reclamocomercial= $arrayDatos[0]['reclamocomercial'];
        $fechacorrecion_reclamocomercial= $arrayDatos[0]['fechacorrecion_reclamocomercial'];
        $solicitabaja= $arrayDatos[0]['solicitabaja'];
        $fechacorrecion_solicitabaja= $arrayDatos[0]['fechacorrecion_solicitabaja'];
        $tarjetaafiliadanopertenecetitular= $arrayDatos[0]['tarjetaafiliadanopertenecetitular'];
        $fechacorrecion_tarjetaafiliadanopertenecetitular= $arrayDatos[0]['fechacorrecion_tarjetaafiliadanopertenecetitular'];
        $recepmanual= $arrayDatos[0]['recepmanual'];
        $fechacorrecion_recepmanual= $arrayDatos[0]['fechacorrecion_recepmanual'];
        $descargaapp= $arrayDatos[0]['descargaapp'];
        $fechacorrecion_descargaapp= $arrayDatos[0]['fechacorrecion_descargaapp'];
        $capacitado= $arrayDatos[0]['capacitado'];
        $fechacorrecion_capacitado= $arrayDatos[0]['fechacorrecion_capacitado'];
        $Comentario= $arrayDatos[0]['Comentario'];
        $TipoCierre= $arrayDatos[0]['TipoCierre'];
        $SolucionIncidencia= $arrayDatos[0]['SolucionIncidencia'];
        $CorreoComercial= $arrayDatos[0]['CorreoComercial'];
        $CorreoJefeVenta= $arrayDatos[0]['CorreoJefeVenta'];
        
        
        $incidencia="";

        //$texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." CON INCIDENCIA";
        
        if($TipoCierre=='Finalizada con Exito'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." FINALIZADA CON EXITO";
            $texto1="VALIDACION CONFORME";
            
        }        
        if($TipoCierre=='Finalizada con Incidencia' && $SolucionIncidencia=='No resuelto'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." CON INCIDENCIA";
            $texto1="VALIDACION PARALIZADA";
        }
        if($TipoCierre=='Finalizada con Incidencia' && $SolucionIncidencia=='Reincidencia'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." CON REINCIDENCIA";
            $texto1="VALIDACION PARALIZADA";
        }
        if($TipoCierre=='Finalizada con Incidencia' && $SolucionIncidencia=='Resuelto'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." RESUELTO"; 
            $texto1="VALIDACION CONFORME";
        }

        if($TipoCierre=='Ilocalizado'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." ILOCALIZADO"; 
            $texto1="VALIDACION PARALIZADA";
            $incidencia.='- ILOCALIZADO <br>';
        } 
        if($TipoCierre=='No colabora'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." NO COLABORA"; 
            $texto1="VALIDACION PARALIZADA";
            $incidencia.='- NO COLABORA <br>';
        }   
        if($TipoCierre=='No contesta'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." NO CONTESTA"; 
            $texto1="VALIDACION PARALIZADA";
            $incidencia.='- NO CONTESTA <br>';
        }           
        
        if($texto1=='VALIDACION PARALIZADA'){
            $color='#dc0000';
        }else{
            $color='#28a732';
        }

        if($kitnoinstalado=='SI'){
                    $incidencia.='- KIT NO INSTALADO <br>';
                }

        if($errorcomprobantepago=='SI'){
                    $incidencia.='- ERROR COMPROBANTE DE PAGO <br>';
                }
        
        if($errorsegmento=='SI'){
                    $incidencia.='- ERROR SEGMENTO <br>';
                }
       
        if($fueranomalcomercial=='SI'){
                    $incidencia.='- FUERA NORMAL COMERCIAL <br>';
                }
       
        if($fueranormativatecnica=='SI'){
                    $incidencia.='- FUERA NORMATIVA TÉCNICA <br>';
                }
       
        if($incidenciadatos=='SI'){
                    $incidencia.='- INCIDENCIA DATOS <br>';
                }
        
        if($inconformidadfuncionamiento=='SI'){
                    $incidencia.='- INCONFORMIDAD FUNCIONAMIENTO <br>';
                }
       
        if($inconformidadpagoinicial=='SI'){
                    $incidencia.='- INCONFORMIDAD PAGO INICIAL <br>';
                }
        
        if($inconformidadpagomensual=='SI'){
                    $incidencia.='- INCONFORMIDAD PAGO MENSUAL <br>';
                }
        
        if($inconformidadtiempopermanencia=='SI'){
                    $incidencia.='- INCONFORMIDAD TIEMPO PERMANENCIA <br>';
                }
       
        if($inconformidadubicaciondispositivos=='SI'){
                    $incidencia.='- INCONFORMIDAD UBICACIÓN DISPOSITIVOS <br>';
                }
        
        if($noconcefuncionamiento=='SI'){
                    $incidencia.='- NO CONOCE FUNCIONAMIENTO <br>';
                }
        
        if($notienecontrato=='SI'){
                    $incidencia.='- NO TIENE CONTRATO <br>';
                }
       
        if($promesaspendientes=='SI'){
                    $incidencia.='- PROMESAS PENDIENTES <br>';
                }
        
        if($reclamocomercial=='SI'){
                    $incidencia.='- RECLAMO COMERCIAL <br>';
                }
        
        if($solicitabaja=='SI'){
                    $incidencia.='- SOLICITA BAJA <br>';
                }
       
        if($tarjetaafiliadanopertenecetitular=='SI'){
                    $incidencia.='- TARJETA AFILIADA NO PERTENECE A TITULAR<br>';
                }
       
        if($recepmanual=='SI'){
                    $incidencia.='- RECEP MANUAL<br>';
                }
        
        if($descargaapp=='SI'){
                    $incidencia.='- DESCARGA APP <br>';
                }
       
        if($capacitado=='SI'){
                    $incidencia.='- CAPACITADO<br>';
                }
        
//HTML DE NOTIFICACION
   $mensajeCorreo = '
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                        <title>A Simple Responsive HTML Email</title>
                        <style type="text/css">
                            body {
                                margin: 0;
                                padding: 0;
                                min-width: 100%!important;
                                font-family: sans-serif;
                                font-size: 14px;
                            }
                            
                            img {
                                height: auto;
                            }
                            
                            .content {
                                width: 100%;
                                max-width: 600px;
                            }
                            
                            .header {
                                padding: 5px 20px 5px 20px;
                            }
                            
                            .innerpadding {
                                padding: 20px 30px 0px 30px;
                            }
                            
                            .borderbottom {
                                border-bottom: 1px solid #f2eeed;
                            }
                            
                            .subhead {
                                font-size: 15px;
                                color: #ffffff;
                                font-family: sans-serif;
                                letter-spacing: 10px;
                            }
                            
                            .h1 {
                                font-family: sans-serif;
                                color: #ffffff;
                                font-size: 23px;
                                line-height: 38px;
                                font-weight: bold;
                            }
                            
                            .h2 {
                                color: #000000;
                                font-family: sans-serif;
                                padding: 0 0 15px 0;
                                font-size: 24px;
                                line-height: 28px;
                                font-weight: bold;
                            }
                            
                            .h3 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                                font-weight: bold;
                            }
                            
                            .h4 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 16px;
                                line-height: 30px;
                                font-weight: bold;
                            }
                            
                            .bodycopy {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 12px;
                                line-height: 22px;
                            }
                            
                            .button {
                                text-align: center;
                                font-size: 18px;
                                font-family: sans-serif;
                                font-weight: bold;
                                padding: 0 30px 0 30px;
                            }
                            
                            .button a {
                                color: #ffffff;
                                text-decoration: none;
                            }
                            
                            .footer {
                                padding: 20px 30px 15px 30px;
                            }
                            
                            .footercopy {
                                font-family: sans-serif;
                                font-size: 14px;
                                color: #ffffff;
                            }
                            
                            .footercopy a {
                                color: #ffffff;
                                text-decoration: underline;
                            }
                            
                            .coldiv115 {
                                width: 115px;
                            }
                            
                            .coldiv380 {
                                width: 380px;
                            }
                            
                            @media only screen and (max-width: 550px),
                            screen and (max-device-width: 550px) {
                                body[yahoo] .hide {
                                    display: none!important;
                                }
                                body[yahoo] .buttonwrapper {
                                    background-color: transparent!important;
                                }
                                body[yahoo] .button {
                                    padding: 0px!important;
                                }
                                body[yahoo] .button a {
                                    background-color: #e05443;
                                    padding: 15px 15px 13px!important;
                                }
                                body[yahoo] .unsubscribe {
                                    display: block;
                                    margin-top: 20px;
                                    padding: 10px 50px;
                                    background: #2f3942;
                                    border-radius: 5px;
                                    text-decoration: none!important;
                                    font-weight: bold;
                                }
                            }
                        </style>
                    </head>

                    <body yahoo bgcolor="#f2f2f2">
                        <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
                                    <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                                        <tr>
                                            <td bgcolor="#ffffff" class="header">
                                                <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">
                                                    <tr>
                                                        <td height="70" style="padding: 0 20px 20px 0;">
                                                            <img class="fix" src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td bgcolor="'.$color.'" class="header">
                                                <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">
                                                    <tr>
                                                        <td height="70">
                                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                <tr>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">NOTIFICACION DE CERTIFICACIÓN</h1>';                
           
                 $mensajeCorreo.='<h1 class="h1" align="center" style="padding: 0 0 0 0;">'.$texto1.'</h1>';
              
                 $mensajeCorreo.='</tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>';
                 $mensajeCorreo.='     
                                        <tr>
                                            <td class="innerpadding">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td class="h2">
                                                            Estimado usuario,
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>';
                                                             $mensajeCorreo.='<p>Se observan las siguientes incidencia de instalación tras la revision del cliente:</p>
                                                            <p>'.$contrato.' '.$cliente.'</p>';

                                                    $mensajeCorreo.='    
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>';
                                        
                                         if($TipoCierre=='Finalizada con Exito' || ($TipoCierre=='Finalizada con Incidencia' && $SolucionIncidencia=='Resuelto')){
                                         //VACIO
                                         }else{
                                         //INCIDENCIAS
                                            $mensajeCorreo.='<tr>
                                                <td class="innerpadding">
                                                    <p><strong>Motivos de incidencias:</strong></p>
                                                    <p>'.$incidencia.'</p>
                                                </td>
                                            </tr>';
                                         }
                                   
                                        $mensajeCorreo.='<tr>
                                            <td class="innerpadding">
                                                <p><strong>Comentario:</strong></p>
                                                <p>'.$Comentario.'</p>
                                            </td>
                                        </tr>';              
                                  
                                        $mensajeCorreo.='<tr>
                                            <td class="innerpadding">
                                                <p>Por favor, para cualquier consulta puede escribir al correo oficial de certificación: certificaciondelaventa@verisure.pe <br><strong>POR FAVOR, NO RESPONDER ESTE CORREO.</strong></p>
                                                <p>Muchas gracias</p>
                                                <p>Certificación de la Venta</p>
                                            </td>
                                        </tr>                                           
                                        <tr>
                                            <td class="footer" bgcolor="#44525f">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td align="center" class="footercopy">
                                                            2023 &reg; Verisure Perú SAC<br/> Av. Primavera 1050 – Oficina 501<br/> Santiago de Surco – Urbanización Chacarilla del Estanque<br/> Lima – Perú
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </body>
            
            </html>
        ';
        

        
        $CorreoSupervisorTeleventa="joseenrique.nanquen@verisure.pe";
        $CorreoBuzonAgenda="certificaciondelaventa@verisure.pe";
        
        if($TipoCierre=='No contesta'){
           $CorreoBuzonAgenda='';
        }
        
        if($CC==511 || $CC==512){

            $arrayemail=array (
                0 => 'alejandro.delsante@verisure.pe',
                1 => 'sonia.chavez@verisure.pe',
                2 => 'kenny.rejas@verisure.pe',
                3 => 'stephany.esquivel@verisure.pe'
              );            
        }else{
            $arrayemail=array (
                0 => $CorreoComercial,
                1 => $CorreoJefeVenta,
              );
        }
        

        
        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
            )
        );
        
        $context = stream_context_create($opts);
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Certificacion Venta',
            'From' => 'certificaciondelaventa@verisure.pe',
            'To' => 
            array (
              'Email' => $arrayemail
            ),
            'Cc' => 
            array (
              'Email' => 
              array (
                0 => $CorreoBuzonAgenda,
              )
            ),
            'Bcc' => 
            array (
              'Email' => 
              array (
                0 => 'joseenrique.nanquen@verisure.pe',
              )
            ),
            'Message' => 
            array (
              'Subject' => $texto,
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                "Value"=> $mensajeCorreo
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );

        $dataSC_string = json_encode($dataSC);
        
        
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 60,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }
            
    
    }    
   
function EnvioCorreoIncidenciaCertificacionModal($arrayDatos){
    


        $contrato=$arrayDatos[0]['NContrato'];
        $cliente=$arrayDatos[0]['Cliente'];
        $CC=$arrayDatos[0]['CC'];
        $jsonIncidencias = json_decode($arrayDatos[0]['jsonIncidencias'], true);
        $Comentario=$arrayDatos[0]['ComentarioCERT'];
        $TipoCierre= $arrayDatos[0]['TipoCierre'];
        $SolucionIncidencia= $arrayDatos[0]['SolucionIncidencia'];
        $CorreoComercial= $arrayDatos[0]['CorreoComercial'];
        $CorreoJefeVenta= $arrayDatos[0]['CorreoJefeVenta'];

      
        
        $incidencia="";

        //$texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." CON INCIDENCIA";
        
        $texto="";
        
        if($TipoCierre=='Finalizada con Exito'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." FINALIZADA CON EXITO";
            $texto1="VALIDACION CONFORME";
            
        }
        
        if(($TipoCierre=='Finalizada con Incidencia' || $TipoCierre=='Incidencia') && $SolucionIncidencia=='Pendiente'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." CON INCIDENCIA";
            $texto1="VALIDACION EN PROCESO";
        }
        if(($TipoCierre=='Finalizada con Incidencia' || $TipoCierre=='Incidencia') && $SolucionIncidencia=='Solucion completa'){
           $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." SOLUCION COMPLETA"; 
            $texto1="VALIDACION CONFORME";
        }
        if(($TipoCierre=='Finalizada con Incidencia' || $TipoCierre=='Incidencia') && $SolucionIncidencia=='Solucion parcial'){
           $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." SOLUCION PARCIAL"; 
            $texto1="VALIDACION CONFORME";
        }
        if(($TipoCierre=='Finalizada con Incidencia' || $TipoCierre=='Incidencia') && $SolucionIncidencia=='No solucionado'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." CON INCIDENCIA";
            $texto1="VALIDACION PARALIZADA";
        } 
        if(($TipoCierre=='Finalizada con Incidencia' || $TipoCierre=='Incidencia') && $SolucionIncidencia=='No resuelto'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." CON INCIDENCIA";
            $texto1="VALIDACION PARALIZADA";
        }
        if(($TipoCierre=='Finalizada con Incidencia' || $TipoCierre=='Incidencia') && $SolucionIncidencia=='Resuelto'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." CON INCIDENCIA";
            $texto1="VALIDACION CONFORME";
        }         
        if($TipoCierre=='Incidencia' && $SolucionIncidencia=='Reincidencia'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." CON REINCIDENCIA";
            $texto1="VALIDACION PARALIZADA";
        }
        if($TipoCierre=='Incidencia' && $SolucionIncidencia=='Resuelto'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." RESUELTO"; 
            $texto1="VALIDACION CONFORME";
        }

        if($TipoCierre=='Ilocalizado'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." ILOCALIZADO"; 
            $texto1="VALIDACION PARALIZADA";
            $incidencia.='- ILOCALIZADO <br>';
        } 
        if($TipoCierre=='No colabora'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." NO COLABORA"; 
            $texto1="VALIDACION PARALIZADA";
            $incidencia.='- NO COLABORA <br>';
        }   
        if($TipoCierre=='No contesta'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." NO CONTESTA"; 
            $texto1="VALIDACION PARALIZADA";
            $incidencia.='- NO CONTESTA <br>';
        }
        if($TipoCierre=='En gestion'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." EN GESTION"; 
            $texto1="VALIDACION EN PROCESO";
        }
        
        if($TipoCierre=='Pendiente'){
            $texto="NOTIFICACIÓN CERTIFICACION - ".$contrato." EN GESTION"; 
            $texto1="VALIDACION EN PROCESO";
        }           
        
        if($texto1=='VALIDACION PARALIZADA'){
            $color='#dc0000';
        }else{
            $color='#28a732';
        }

if ($jsonIncidencias === null || empty($jsonIncidencias)) {

    
}else{
    
     if(count($jsonIncidencias)>0){
            foreach ($jsonIncidencias as $clave => $valor) {
                $incidencia.='- '.$valor['SubMotivo'].' <br>';
            }  
            
        }
    
}


  
//HTML DE NOTIFICACION
   $mensajeCorreo = '
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                        <title>A Simple Responsive HTML Email</title>
                        <style type="text/css">
                            body {
                                margin: 0;
                                padding: 0;
                                min-width: 100%!important;
                                font-family: sans-serif;
                                font-size: 14px;
                            }
                            
                            img {
                                height: auto;
                            }
                            
                            .content {
                                width: 100%;
                                max-width: 600px;
                            }
                            
                            .header {
                                padding: 5px 20px 5px 20px;
                            }
                            
                            .innerpadding {
                                padding: 20px 30px 0px 30px;
                            }
                            
                            .borderbottom {
                                border-bottom: 1px solid #f2eeed;
                            }
                            
                            .subhead {
                                font-size: 15px;
                                color: #ffffff;
                                font-family: sans-serif;
                                letter-spacing: 10px;
                            }
                            
                            .h1 {
                                font-family: sans-serif;
                                color: #ffffff;
                                font-size: 23px;
                                line-height: 38px;
                                font-weight: bold;
                            }
                            
                            .h2 {
                                color: #000000;
                                font-family: sans-serif;
                                padding: 0 0 15px 0;
                                font-size: 24px;
                                line-height: 28px;
                                font-weight: bold;
                            }
                            
                            .h3 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                                font-weight: bold;
                            }
                            
                            .h4 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 16px;
                                line-height: 30px;
                                font-weight: bold;
                            }
                            
                            .bodycopy {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 12px;
                                line-height: 22px;
                            }
                            
                            .button {
                                text-align: center;
                                font-size: 18px;
                                font-family: sans-serif;
                                font-weight: bold;
                                padding: 0 30px 0 30px;
                            }
                            
                            .button a {
                                color: #ffffff;
                                text-decoration: none;
                            }
                            
                            .footer {
                                padding: 20px 30px 15px 30px;
                            }
                            
                            .footercopy {
                                font-family: sans-serif;
                                font-size: 14px;
                                color: #ffffff;
                            }
                            
                            .footercopy a {
                                color: #ffffff;
                                text-decoration: underline;
                            }
                            
                            .coldiv115 {
                                width: 115px;
                            }
                            
                            .coldiv380 {
                                width: 380px;
                            }
                            
                            @media only screen and (max-width: 550px),
                            screen and (max-device-width: 550px) {
                                body[yahoo] .hide {
                                    display: none!important;
                                }
                                body[yahoo] .buttonwrapper {
                                    background-color: transparent!important;
                                }
                                body[yahoo] .button {
                                    padding: 0px!important;
                                }
                                body[yahoo] .button a {
                                    background-color: #e05443;
                                    padding: 15px 15px 13px!important;
                                }
                                body[yahoo] .unsubscribe {
                                    display: block;
                                    margin-top: 20px;
                                    padding: 10px 50px;
                                    background: #2f3942;
                                    border-radius: 5px;
                                    text-decoration: none!important;
                                    font-weight: bold;
                                }
                            }
                        </style>
                    </head>

                    <body yahoo bgcolor="#f2f2f2">
                        <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
                                    <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                                        <tr>
                                            <td bgcolor="#ffffff" class="header">
                                                <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">
                                                    <tr>
                                                        <td height="70" style="padding: 0 20px 20px 0;">
                                                            <img class="fix" src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td bgcolor="'.$color.'" class="header">
                                                <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">
                                                    <tr>
                                                        <td height="70">
                                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                <tr>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">NOTIFICACION DE CERTIFICACIÓN</h1>';                
           
                 $mensajeCorreo.='<h1 class="h1" align="center" style="padding: 0 0 0 0;">'.$texto1.'</h1>';
              
                 $mensajeCorreo.='</tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>';
                 $mensajeCorreo.='     
                                        <tr>
                                            <td class="innerpadding">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td class="h2">
                                                            Estimado usuario,
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>';
                                                             $mensajeCorreo.='<p>Se observan las siguientes incidencia de instalación tras la revision del cliente:</p>
                                                            <p>'.$contrato.' '.$cliente.'</p>';

                                                    $mensajeCorreo.='    
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>';
                                        
                                         if($TipoCierre=='Finalizada con Exito' || ($TipoCierre=='Incidencia' && $SolucionIncidencia=='Resuelto')){
                                         //VACIO
                                         }else{
                                         //INCIDENCIAS
                                            $mensajeCorreo.='<tr>
                                                <td class="innerpadding">
                                                    <p><strong>Motivos de incidencias:</strong></p>
                                                    <p>'.$incidencia.'</p>
                                                </td>
                                            </tr>';
                                         }
                                   
                                        $mensajeCorreo.='<tr>
                                            <td class="innerpadding">
                                                <p><strong>Comentario:</strong></p>
                                                <p>'.$Comentario.'</p>
                                            </td>
                                        </tr>';              
                                  
                                        $mensajeCorreo.='<tr>
                                            <td class="innerpadding">
                                                <p>Por favor, para cualquier consulta puede escribir al correo oficial de certificación: certificaciondelaventa@verisure.pe <br><strong>POR FAVOR, NO RESPONDER ESTE CORREO.</strong></p>
                                                <p>Muchas gracias</p>
                                                <p>Certificación de la Venta</p>
                                            </td>
                                        </tr>                                           
                                        <tr>
                                            <td class="footer" bgcolor="#44525f">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td align="center" class="footercopy">
                                                            2023 &reg; Verisure Perú SAC<br/> Av. Primavera 1050 – Oficina 501<br/> Santiago de Surco – Urbanización Chacarilla del Estanque<br/> Lima – Perú
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </body>
            
            </html>
        ';
        

        $CorreoBuzonAgenda="certificaciondelaventa@verisure.pe";
        
        if($TipoCierre=='No contesta'){
           $CorreoBuzonAgenda='';
        }
        
        if($CC==511 || $CC==512){
            $arrayemail=array (
                0 => 'alejandro.delsante@verisure.pe',
                1 => 'sonia.chavez@verisure.pe',
                2 => 'kenny.rejas@verisure.pe',
                3 => 'stephany.esquivel@verisure.pe'
              );            
        }else{
            $arrayemail=array (
                0 => $CorreoComercial,
                1 => $CorreoJefeVenta,
              );
        }
        

        
        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
            )
        );
        
        $context = stream_context_create($opts);
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Certificacion Venta',
            'From' => 'certificaciondelaventa@verisure.pe',
            'To' => 
            array (
              'Email' => $arrayemail
            ),
            'Cc' => 
            array (
              'Email' => 
              array (
                0 => $CorreoBuzonAgenda,
              )
            ),
            'Bcc' => 
            array (
              'Email' => 
              array (
                0 => 'joseenrique.nanquen@verisure.pe',
              )
            ),
            'Message' => 
            array (
              'Subject' => $texto,
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                "Value"=> $mensajeCorreo
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );

        $dataSC_string = json_encode($dataSC);
        
        
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 60,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }
            
    
    }    

?>