<?php
require dirname(__DIR__).'/ajax/is_logged.php';
require dirname(__DIR__).'/Connection/Conection.php';
require dirname(__DIR__).'/Model/ConexionRPA.php';

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}


if (isset($_POST['function']) && !empty($_POST['function'])) {

    $function = json_decode($_POST['function']);

    switch ($function->array) {
        case 'array1':
            $consulta = new RPA;
            $consulta->ObtenerAFILIACION();
            break;
        case 'array2':
            $consulta = new RPA;
            $consulta->CambioEstadoAFILIACION();
            break;
        case 'array3':
            $consulta = new RPA;
            $consulta->ListarRpa();
            break;
        case 'array4':
            $consulta = new RPA;
            $consulta->CambioEstadoAFILIACIONEnvioCorreo();
            break;            
        // case 'array5':
        //     $consulta = new TVReferidos;
        //     $consulta->ObtenerDatosUsuario();
        //     break;
        // case 'array6':
        //     $consulta = new TVReferidos;
        //     $consulta->ActualizarClienteProspecto();
        //     break;            
        default:
            echo "Error no se encontro la data";
            break;
    }

}



class RPA
{
    public function ListarRpa()
    {

        $function = json_decode($_POST['function']);

        $conexion = new ConexionRPA();
        
        $datos=$conexion->ListarRpa($function);

        print_r(json_encode($datos)); 
        

    }

    public function ObtenerAFILIACION()
    {
        $function = json_decode($_POST['function']);
        $contrato=htmlspecialchars($function->contrato);
        
        $conexion = new ConexionRPA();

		$datosVisa_MasterCard = $conexion->getAfiliacionVisa_MasterCard($contrato);
		$datosOtros = $conexion->getAfiliacionOtros($contrato);
		$datos=array();
		
		$datosV=array();
		if(count($datosVisa_MasterCard)>0){
		    foreach($datosVisa_MasterCard as $clave => $valor){

            $estadoafiliacion=$valor['status'];
            $ACTION_DESCRIPTION=$valor['ACTION_DESCRIPTION'];
            $dataMap=$valor['dataMap'];

                if(isset($dataMap) && !empty($dataMap)){
                    $objAfiliacion=json_decode($dataMap, true);
                    if(isset($objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'])){
                        $card=$objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'];
                        $tipocuenta='Tarjeta';
                    }else{
                        $card='';
                        $tipocuenta='';
                    }
                }
            
                $datos[0]=[
                     'resultado'=>'encontrado',
                     'estadoafiliacion'=> $estadoafiliacion,
                     'ACTION_DESCRIPTION'=> $ACTION_DESCRIPTION,
                     'cardafiliacion'=> $card,
                     'tipocuentafiliacion'=> $tipocuenta,
                    ];
		        
		    } 
    
		}else{
		    
                $datos[0]=[
                     'resultado'=>'noencontrado',
                     'estadoafiliacion'=> 'Pendiente',
                     'ACTION_DESCRIPTION'=> '',
                     'cardafiliacion'=> '',
                     'tipocuentafiliacion'=> '',
                    ];		    
		    
		}
		
        $datosO=array();
        $variablecuenta=array('Diners Club','visa','mastercard','American Express');
		if(count($datosOtros)>0){
		    foreach($datosOtros as $clave => $valor){

            $idnmdp=$valor['id'];
            $estadoafiliacionmdp=$valor['status'];
            $motivomdp=$valor['motivo'];
            $cardmdp=$valor['numero'];
            $tipomdp=$valor['tipo'];
            $correoenviomdp=$valor['correo'];
            if(in_array($tipomdp,$variablecuenta)){
               $tipocuentamdp='Tarjeta'; 
            }else{
               $tipocuentamdp='Cuenta'; 
            }
            
                $datos[0]+=[
                    'resultadomdp'=>'encontrado',
                    'idnmdp'=> $idnmdp,
                    'estadoafiliacionmdp'=> $estadoafiliacionmdp,
                    'motivomdp'=> $motivomdp,
                    'cardmdp'=> $cardmdp,
                    'tipomdp'=> $tipomdp,
                    'correoenviomdp'=> $correoenviomdp,
                    'tipocuentamdp'=> $tipocuentamdp,
                    ];
		        
		    } 
    
		}else{

                $datos[0]+=[
                    'resultadomdp'=>'noencontrado',
                    'idnmdp'=> '',
                    'estadoafiliacionmdp'=> '',
                    'motivomdp'=> '',
                    'cardmdp'=> '',
                    'tipomdp'=> '',
                    'correoenviomdp'=> '',
                    'tipocuentamdp'=> '',
                    ];
		    
		}
		
// 		$datos = array_merge($datosV, $datosO);
		
        print_r(json_encode($datos));
        
    }

    public function CambioEstadoAFILIACION()
    {
        //ContratoPrueba:1579625
        $function = json_decode($_POST['function']);
        $idafiliacion=htmlspecialchars($function->idafiliacion);
        $lblstatusafiliacion=htmlspecialchars($function->lblstatusafiliacion);
        $lblmotivoafiliacion=htmlspecialchars($function->lblmotivoafiliacion);
        $correoenviomdp=htmlspecialchars($function->correoenviomdp);
        $contrato=htmlspecialchars($function->contrato);
        $fechahoramod = date("Y-m-d H:i:s");
        
        $conexion = new ConexionRPA();
        
    

        $resultadoAfiliacion = $conexion->actualizarAfiliacion($idafiliacion,$lblstatusafiliacion,$lblmotivoafiliacion,$fechahoramod);
        if($resultadoAfiliacion>0){
            $resultado=array('respuesta'=>'exito');
        }else{
            $resultado=array('respuesta'=>'error');
        }
        
        $afiliacionotros=$conexion->findAfiliacionOtros($contrato);
        if($afiliacionotros>0){
            $resultadoAfiliacionOtros=$conexion->actualizarAfiliacionOtros($afiliacionotros,$lblstatusafiliacion);
        }
        
        // $datosClientesVentas=$conexion->getDatosClientesVentas($contrato);
    
// 		if(count($datosClientesVentas)>0){
// 		    EnvioCorreo_Respuesta($datosClientesVentas,$correoenviomdp,$lblstatusafiliacion,$lblmotivoafiliacion);
// 		}
        

        
        print_r(json_encode($resultado));

        
        
    }
    

    public function CambioEstadoAFILIACIONEnvioCorreo()
    {
        //ContratoPrueba:1579625
        $function = json_decode($_POST['function']);
        $idafiliacion=htmlspecialchars($function->idafiliacion);
        $lblstatusafiliacion=htmlspecialchars($function->lblstatusafiliacion);
        $lblmotivoafiliacion=htmlspecialchars($function->lblmotivoafiliacion);
        $correoenviomdp=htmlspecialchars($function->correoenviomdp);
        $contrato=htmlspecialchars($function->contrato);
        
        $conexion = new ConexionRPA();
    
        $datosClientesVentas=$conexion->getDatosClientesVentas($contrato);

		if(count($datosClientesVentas)>0){
		    EnvioCorreo_Respuesta($datosClientesVentas,$correoenviomdp,$lblstatusafiliacion,$lblmotivoafiliacion);
		    $resultado = 'exito';
		}
        
        print_r(json_encode($resultado));

        
        
    }
        

}


    function EnvioCorreo_Respuesta($arrayCliente,$correoenviomdp,$lblstatusafiliacion,$lblmotivoafiliacion){
        //ESTRUCTURA DEL CORREO ACTUALIZADO
        //DELEGADO
        //VARIABLES GLOBALES

        $NContrato=$arrayCliente[0]['NContrato'];
        $Cliente=$arrayCliente[0]['Cliente'];
        
        $arrayNombre=explode(" ",$Cliente);
        
        $NombresScoring=$arrayCliente[0]['NombresScoring'];
        $ApellidoPaternoScoring=$arrayCliente[0]['ApellidoPaternoScoring'];
        $ApellidoMaternoScoring=$arrayCliente[0]['ApellidoMaternoScoring'];
        $TipoDocumentoScoring=$arrayCliente[0]['TipoDocumentoScoring'];
        $DocumentoScoring=$arrayCliente[0]['DocumentoScoring'];
        
        if($TipoDocumentoScoring==6 || $TipoDocumentoScoring==""){
                    $TipoDocumentoScoring="0";
                    $DocumentoScoring="00000000";
                    if(count($arrayNombre)==1){
                        $NombresScoring=$arrayNombre[0];
                        $ApellidoPaternoScoring=" ";
                        $ApellidoMaternoScoring=" ";                    
                    }else if(count($arrayNombre)==2){
                        $NombresScoring=$arrayNombre[0];
                        $ApellidoPaternoScoring=$arrayNombre[1];
                        $ApellidoMaternoScoring=" ";   
                    }else{
                        $NombresScoring=$arrayNombre[0];
                        $ApellidoPaternoScoring=$arrayNombre[1];
                        $ApellidoMaternoScoring=$arrayNombre[2];
                    }         
            
        }else if($TipoDocumentoScoring==3){
                    $TipoDocumentoScoring=1;
                    $DocumentoScoring=substr($DocumentoScoring, 3);
        }else{
                    $TipoDocumentoScoring=0;
                    $DocumentoScoring=substr($DocumentoScoring, 3);
        }

        $url="";
        $url=$NContrato."-".$NombresScoring."-".$ApellidoPaternoScoring." ".$ApellidoMaternoScoring."-".$DocumentoScoring."-".$TipoDocumentoScoring."-".$correoenviomdp;
        
        if($lblstatusafiliacion=="RECHAZADO"){
        $titulo = "Solicitud de Afiliación Rechazada - Verisure Perú " . $NContrato;
        $codigo=400;
        $concatenado=$codigo."/".rawurlencode($lblmotivoafiliacion)."/".rawurlencode($url);
        }else if($lblstatusafiliacion=="AFILIADO"){
        $titulo = "Solicitud de Afiliación Aprobada - Verisure Perú " . $NContrato;
        $codigo=201;
        $concatenado=$codigo;
        }else{
        $titulo = "Solicitud de Afiliación En Proceso - Verisure Perú " . $NContrato;
        $codigo=200;
        $concatenado=$codigo;
        }
        
        $mensajeCorreo = '
<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=480, user-scalable=1" />
<title>Verisure Perú</title>
<link href="https://fonts.googleapis.com/css?family=Fira+Sans:400,700" rel="stylesheet">

</head>

<body style="margin-left: 0px; margin-top: 0px; margin-right: 0px; margin-bottom: 0px; background-color:#F4F4F4;">

<div class="container">
  <div class="row">
    <table width="600" align="center" border="0" cellspacing="0" cellpadding="0" bgcolor="#F4F4F4" style="background-color: #F4F4F4;">
      <tr>
        <td align="center">
          <!-- CREATIVIDAD -->
          <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0" style="background-color: #ffffff;">
            <tr>
              <td width="600"><img src="https://clientesverisure.com/apps/public/images/afiliacion-otros/cabecera.png" alt="Alarmas para tu Hogar" width="600" border="0" style="display:block; padding:0; border:0" /></td>
            </tr>
          </table>
          <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0" style="background-color: #ffffff;">

            <tr>
              <td width="600">
                <img ' . ((isset($codigo) && $codigo==200) ? 'src="https://clientesverisure.com/apps/public/images/afiliacion-otros/banner2.png"' : ((isset($codigo) && $codigo==400) ? 'src="https://clientesverisure.com/apps/public/images/afiliacion-rechazada/banner.png"' : 'src="https://clientesverisure.com/apps/public/images/banner_v2.png"')) . ' alt="Alarmas para tu Hogar" width="600" border="0" style="display:block; padding:0; border:0" />
              </td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
    <div class="col-md-12">
      <table width="600" align="center" border="0" cellspacing="0" cellpadding="0" class="tablaM" bgcolor="#F4F4F4" style="background-color: #F4F4F4;">
        <tr>
          <td align="center">
            <table style="background-color: #ffffff;" width="550" cellspacing="0" cellpadding="0" border="0">
              <tbody>
                <tr>
                  <td width="500">';
                    if(isset($codigo) && $codigo==200){
                      $mensajeCorreo .= '<p style="text-align: justify;font-size: 15px;font-family:\'Fira Sans\', Arial;color: #757575;margin-bottom: 5px; padding:0px 20px 0px;"><strong>Estimado(a) cliente: </strong>  
                      <br>
                      <br>
                      Su solicitud de afiliación se encuentra en proceso, en un aproximado de 48 horas le estaremos notificando el registro de su afiliación.<br>
                      </p>
                      <p style="text-align: center;font-size: 17px;font-family:  \'Fira Sans\', Arial;color: #ed002f;padding:0px 10px 0px;"><strong>Si desea mayor información<br>sobre los servicios contratados, ingrese a: </strong>
                      </p>';
                    }elseif(isset($codigo) && $codigo==201){
                      $mensajeCorreo .= '<p style="text-align: justify;font-size: 15px;font-family:\'Fira Sans\', Arial;color: #757575;margin-bottom: 5px; padding:0px 20px 0px;"><strong>Estimado(a) cliente: </strong>  
                      <br>
                      <br>
                      Su solicitud de afiliación se encuentra registrada exitosamente.<br>
                      </p>
                      <p style="text-align: center;font-size: 17px;font-family:  \'Fira Sans\', Arial;color: #ed002f;padding:0px 10px 0px;"><strong>Si desea mayor información<br>sobre los servicios contratados, ingrese a: </strong>
                      </p>';
                    }elseif(isset($codigo) && $codigo==400){
                      $mensajeCorreo .= '<p style="text-align: justify;font-size: 15px;font-family:\'Fira Sans\', Arial;color: #757575;margin-bottom: 5px; padding:0px 20px 0px;"><strong>Estimado(a) cliente: </strong>  
                      <br>
                      <br>
                      Su tarjeta/cuenta afiliada ha sido rechazada como medio de pago para el servicio mensual por el siguiente motivo: <span style="color:#ff0033; font-weight:bold;">' . (isset($lblmotivoafiliacion) ? $lblmotivoafiliacion : 'Error afiliación') . '</span><br>
                      </p>';
                      if(isset($concatenado)){
                        $mensajeCorreo .= '<p style="text-align: justify;font-size: 15px;font-family:\'Fira Sans\', Arial;color: #757575;margin-bottom: 5px; padding:0px 20px 0px;">Por favor ingrese nuevamente y afilie otra cuenta/tarjeta o verifique <br>la información previamente registrada:
                        </p>';
                      }
                    }else{
                      $mensajeCorreo .= '<p style="font-family:\'Fira Sans\',Arial;font-size: 16px; padding-right: 25px; padding-left: 25px;color: #606060; text-align: justify;">La afiliación de su tarjeta o cuenta, <span style="color:#ff0033; font-weight:bold;">ha sido cancelada. <br></span>Un error ha ocurrido mientras se procesaba su solicitud
                      <p style="font-family:\'Fira Sans\',Arial;font-size: 18px; color: #ffffff; text-align: center;font-weight: 600;background-color: #01B37B;border-radius: 20px;padding: 10px 0px; margin:0px 100px;"><a style="color:#ffffff; text-decoration: none;" href="' . URL::previous() . '">Ir afiliar tarjeta/cuenta</a></p>
                      <p style="font-family:\'Fira Sans\',Arial;font-size: 16px; padding-right: 25px; padding-left: 25px;color: #606060; text-align: justify;"><br>Atentamente,<br><span style="color:#ff0033;">Verisure Perú </span><br></p>';
                    }
                $mensajeCorreo .= '</td>
				</tr>
			  </tbody>
			</table>
		  </td>
		</tr>
	  </table>
	</div>
	<table width="600" align="center" border="0" cellspacing="0" cellpadding="0" bgcolor="#F4F4F4" style="background-color: #F4F4F4;">
			  <tr>
				  <td align="center">
					  <!-- CREATIVIDAD -->
					  <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
								<tr>
								  <td width="600">';
	                                if(isset($codigo) && $codigo==400){
	                                    if(isset($concatenado)){
	                                        $mensajeCorreo .= '<a href="https://clientesverisure.com/apps/afiliacion/'.str_replace('-', '/', $concatenado).'"  target="_blank"> <img src="https://clientesverisure.com/apps/public/images/afiliese.png" alt="Alarmas para tu Hogar" width="600" border="0" style="display:block; padding:0; border:0;" /></a>';
	                                    }
	                                }else{
	                                    $mensajeCorreo .= '<a href="https://clientesverisure.com/" target="_blank"> <img src="https://clientesverisure.com/apps/public/images/afiliacion-otros/3-simples-pasos.png" alt="Alarmas para tu Hogar" width="600"  border="0" style="display:block; padding:0; border:0" /></a>';
	                                }
	                           $mensajeCorreo .='</td>
							  </tr>
					  </table> 
				  </td>
			  </tr>
		  </table> ';
	
	$mensajeCorreo .= '	  <div class="col-md-12">
		  <table width="600" align="center" border="0" cellspacing="0" cellpadding="0" class="tablaM" bgcolor="#F4F4F4" style="background-color: #F4F4F4;">
			  <tr>
				  <td align="center">
					  <br><br>
					  <table width="550" height="0" border="0" cellspacing="0" cellpadding="0">
						  <tr>
							  <td align="left" style="font-size: 14px; line-height: 1px; font-family: Fira Sans, sans-serif; color: #747474; text-align: left;"><img alt="-------" src="https://www.verisure.co.uk/alarms/customers/emails/html/img/line_dotted.gif" style="display: block; margin: 0 auto; display: inline-block; max-width: 100%; height: auto;" width="118" height="1" border="0" /><img alt="-------" src="https://www.verisure.co.uk/alarms/customers/emails/html/img/line_dotted.gif" style="display: block; margin: 0 auto; display: inline-block; max-width: 100%; height: auto;" width="118" height="1" border="0" /></td>
							  <td>
								  <p style="font-family:Fira Sans,Arial;font-size: 16px;color: #4d4d4d;text-align: center;margin: 0;line-height: 20px;padding: 0px 40px;"> <strong>Servicio disponible las 24 horas del día:</strong></p>
							  </td>
							  <td align="right" style="font-size: 14px; line-height: 1px; font-family: Fira Sans, sans-serif; color: #747474; text-align: right;">
								  <img alt="-------" src="https://www.verisure.co.uk/alarms/customers/emails/html/img/line_dotted.gif" style="display: block; margin: 0 auto; display: inline-block; max-width: 100%; height: auto;" width="118" height="1" border="0"><img alt="-------" src="https://www.verisure.co.uk/alarms/customers/emails/html/img/line_dotted.gif" style="display: block; margin: 0 auto; display: inline-block; max-width: 100%; height: auto;" width="118" height="1" border="0" />
							  </td>
						  </tr>
					  </table>
					  <br><br>
					  <table width="550" height="0" border="0" cellspacing="0" cellpadding="0">
						  <tr>
							<td style="padding-left: 5px; padding-right: 5px; padding-bottom: 16px; font-size: 11px; line-height: 13px; font-family: Lucida Grande, Lucida Sans Unicode, Lucida Sans, DejaVu Sans, Verdana, sans-serif; color: #888888; text-align: center;" width="33.333%" align="center">
							  E-mail
							</td>
							<td style="padding-left: 5px; padding-right: 5px; padding-bottom: 16px; font-size: 11px; line-height: 13px; font-family: Lucida Grande, Lucida Sans Unicode, Lucida Sans, DejaVu Sans, Verdana, sans-serif; color: #888888; text-align: center;" width="33.333%" align="center">
							  Teléfono
							</td>
						  </tr>
						  <tr>
							  <td style="padding-left: 5px; padding-right: 5px; font-size: 14px; line-height: 42px; font-family: Arial, sans-serif; color: #333333; text-align: center; border-right: 0px solid #979797" width="33.333%" align="center">
								  <img alt="•" src="https://clientesverisure.com/apps/public/images/ico-m.png" style="display: inline-block;" width="34" height="42" border="0">
							  </td>
							  <td style="padding-left: 5px; padding-right: 5px; font-size: 14px; line-height: 42px; font-family: Arial, sans-serif; color: #333333; text-align: center;" width="33.333%" align="center">
								  <img alt="•" src="https://clientesverisure.com/apps/public/images/ico-telefono.png" style="display: inline-block;" width="45" height="42" border="0">
							  </td>
						  </tr>
						  <tr>
							  <td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
								  <a href="mailto:clientes@verisure.pe" style="color: #737373; text-decoration: none; display: block; font-family: Fira Sans, Lucida Sans Unicode, Lucida Sans, DejaVu Sans, Verdana, sans-serif; font-size: 14px;"><span>clientes@verisure.pe</span><br><span style="color: #a9a9a9; display: block; font-family: Lucida Grande, Lucida Sans Unicode, Lucida Sans, DejaVu Sans, Verdana, sans-serif; font-size: 14px; padding-top: 4px;">24h</span></a>
							  </td>
							  <td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
								  <a href="tel:0 800 2 12 12" style="color: #737373; text-decoration: none; display: block; font-family: Fira Sans, Lucida Sans Unicode, Lucida Sans, DejaVu Sans, Verdana, sans-serif; font-size: 14px;"><span>0 800 2 12 12</span><br><span style="color: #a9a9a9; display: block; font-family: Fira Sans, Lucida Sans Unicode, Lucida Sans, DejaVu Sans, Verdana, sans-serif; font-size: 14px; padding-top: 4px;">24h</span></a>
							  </td>
						  </tr>
					  </table>
					  <br><br>
					  <table style="border-radius: 0px 0px 45px 45px;background-color: #ffffff;" width="550" cellspacing="0" cellpadding="0" border="0" bgcolor="#ffffff" align="center">
						  <tbody>
							  <tr>
								  <td width="600">
									  <p style="text-align: center;  font-size: 16px;font-family:  Fira Sans, Arial;color: #ff0033; margin-top: 20px;">Personas que protegen a personas</p>
									  <p style="text-align: center;font-size: 12px;font-family:  Fira Sans, Arial;color: #606060;margin-bottom: 5px;">S&iacute;guenos en redes sociales</p>
								  </td>
							  </tr>
							  <tr>
								  <td width="600">
									  <p style="text-align: center;font-size: 12px;font-family:Fira Sans, Arial;color: #606060;"><a href="https://www.facebook.com/AlarmasVerisurePeru/" style="color:#ff0033">Facebook</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;<a href="https://www.youtube.com/channel/UCsC7LzKdqytaOQ58IL011eQ" style="color:#ff0033">Youtube</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;<a href="https://twitter.com/VerisurePeru" style="color:#ff0033">Twitter</a></p>
								  </td>
							  </tr>
						  </tbody>
					  </table>
				  </td>
			  </tr>
		  </table>
	  </div>
  </div>
</div>

</body>

</html>';


        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
        ));
        $context = stream_context_create($opts);
    
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Administración - Verisure Perú',
            'From' => 'administracion@verisure.pe',
            'To' => 
                array (
                  'Email' => 
                  array (
                    0 => $correoenviomdp
                  )
                ),
            'Cc' => 
                array (
                  'Email' => 
                    array (
                        0 => '',
                    )
                ),
            'Bcc' => 
                array (
                    'Email' => 
                        array (
                            0 => 'joseenrique.nanquen@verisure.pe'
                        )
                ),
            'Message' => 
                array (
                    'Subject' => $titulo,
                    'Classification' => 'C',
                    'Body' => 
                        array (
                            'Format' => 'html',
                            // 'Value' => file_get_contents("https://clientesverisure.com/apps/afiliacion-otros/email-otros/$concatenado",false,$context),
                            'Value' => $mensajeCorreo,
                        )
                ),
            'Options' => 
                array (
                  'OpenTracking' => 'true',
                  'ClickTracking' => 'true',
                  'TextHtmlTracking' => 'true',
                  'AutoTextBody' => 'false',
                )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $dataSC_string,
            CURLOPT_HTTPHEADER => array(
                "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
                "cache-control: no-cache",
                "content-type: application/json"
            ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }    
    
    }



?>