
const tableComprobantesOrdenCompra = new DataTable("#tblComprobantesOrdenCompra");
let pondXMLProveedor;
let pondPDFProveedor;
$(function () {
    FilePond.registerPlugin(FilePondPluginFileValidateType);
});

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* ORDEN DE COMPRA */

/* ------------------------------- */

function imprimir_oc(idOrdenCompra) 
{
    VentanaCentrada(baseUrl + '/pdf-orden-compra/' + idOrdenCompra, 'Orden de Compra Nro '+idOrdenCompra, '', '1024', '768', 'true');
}

/* ------------------------------- */

$(document).on('click', '.adjuntar-facturas-oc', function(e) 
{
    let modal = $(this).data("bs-target");
    
    let idOrdenCompra = $(this).data("oc");
    
    pondXMLProveedor.removeFiles();
    pondPDFProveedor.removeFiles();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    $.post(baseUrl + '/obtener-datos-orden-compra', 
    {         
        idOrdenCompra : idOrdenCompra
    }, 
    function(response) 
    {
        Swal.close();
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            $('#txtIDOrdenCompra_rfoc').val(idOrdenCompra);
            $('#txtNroOrdenCompra').val(idOrdenCompra);
            $("#txtConceptoOrdenCompra").val(response.concepto);
            $("#txtProveedorOrdenCompra").val(response.proveedor);
            $("#txtFechaEmisionOrdenCompra").val(response.fechaemision);
            $("#txtMontoTotalOrdenCompra").val(response.montototal);
            $("#spnSimboloMontoOrdenCompra").text(response.simbolo);
        }
    }, 'json'); 
    
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('submit', '.formularioAdjuntarFacturaOC', function(event) {
    event.preventDefault();
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFilesXML = pondXMLProveedor.getFiles();
    const pondFilesPDF = pondPDFProveedor.getFiles();

    if (pondFilesXML.length === 0) {
        Swal.fire({
            text: "Debe adjuntar el archivo XML del comprobante.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    
    if (pondFilesPDF.length === 0) {
        Swal.fire({
            text: "Debe adjuntar el archivo PDF del comprobante.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFilesPDF.length; i++) {
        formData.append('itemsPDF', pondFilesPDF[i].file);
    }
    
    for (var i = 0; i < pondFilesXML.length; i++) {
        formData.append('itemsXML', pondFilesXML[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            // clickOne(true);
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            clickOne(false);
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '.observacion-comprobante-oc', function(e) 
{
    let idComprobanteOC = $(this).data("comprobante");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    $.post(baseUrl + '/obtener-datos-comprobante-orden-compra', 
    {         
        idComprobanteOC : idComprobanteOC
    }, 
    function(response) 
    {
        Swal.close();
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            Swal.fire({
                title: 'Observación',
                text: response.observacionvalido,
                icon: 'info',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        }
    }, 'json'); 
    
});

/* ------------------------------- */

$(document).on('click', '#btnReemplazarComprobante', function(e) 
{
    let idComprobanteOC = $(this).data("comprobante");
    let extension = $(this).data("extension");
    $(".txtIDComprobanteOC_rfoc").val(idComprobanteOC);
    $("#reemplazarComprobante"+extension).modal("show");
});

/* ------------------------------- */

$(document).on('submit', '.formularioReemplazarComprobanteXML', function(event) {
    event.preventDefault();
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondXMLProveedor.getFiles();

    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar el archivo XML del comprobante.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('items', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            clickOne(true);
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            clickOne(false);
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('submit', '.formularioReemplazarComprobantePDF', function(event) {
    event.preventDefault();
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondPDFProveedor.getFiles();

    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar el archivo PDF del comprobante.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('items', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            clickOne(true);
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            clickOne(false);
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */
