<?php
namespace App\Models;
use CodeIgniter\Model;

class ExternosAccesoModel extends Model
{
    protected $table      = 'externos_acceso';
    protected $primaryKey = 'IDExterno';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Nombres', 'Apellidos', 'NroDocumento', 'NroContacto', 'CorreoElectronico', 'Password', 'Cargo', 'IDPerfil', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoExternosAcceso($array)
    {
        $this->select('
            externos_acceso.IDExterno,
            externos_acceso.Nombres,
            externos_acceso.Apellidos,
            externos_acceso.NroDocumento,
            externos_acceso.NroContacto,
            externos_acceso.CorreoElectronico,
            externos_acceso.Password,
            externos_acceso.Cargo,
            externos_acceso.IDPerfil,
            externos_acceso.Estado');
            
        if(!empty($array))
        {
            if(isset($array['like']) && $array['like'] == true)
            {
                //VISUALIZO TODAS LAS PETICIONES DE MI GRUPO DE TRABAJO QUE NO ESTÉN APROBADOS CANCELADOS O AA
                $this->groupStart(); // Inicia un grupo de condiciones
                $this->orLike("externos_acceso.IDExterno", $array['busqueda']);
                $this->orLike("externos_acceso.Nombres", $array['busqueda']);
                $this->orLike("externos_acceso.Apellidos", $array['busqueda']);
                $this->orLike("externos_acceso.NroDocumento", $array['busqueda']);
                $this->orLike("externos_acceso.NroContacto", $array['busqueda']);
                $this->orLike("externos_acceso.CorreoElectronico", $array['busqueda']);
                $this->orLike("externos_acceso.Cargo", $array['busqueda']);
                $this->groupEnd(); // Finaliza el grupo de condiciones
                
            }
            
        }
        
        $datos = $this->findAll();
        return $datos;
        
    }
    
}