<?php

namespace App\Libraries;

require_once APPPATH. 'Libraries/dompdf/autoload.inc.php';
use Dompdf\Dompdf;
use Dompdf\Options;
 
class Pdf
{
    public function generar($html, $filename, $stream=TRUE, $paper = 'A4', $orientation = "landscape")
      {
        $options = new Options(); 
        $options->set('isPhpEnabled',TRUE);
        $options->set('isRemoteEnabled', TRUE);
        $options->set('isHtml5ParserEnabled', TRUE);
        $options->set('defaultFont', 'Helvetica');

        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html);
        $dompdf->setPaper($paper, $orientation);
        $dompdf->render();
        header("Content-type: application/pdf");
        header("Content-Disposition: inline; filename=documento.pdf");        
        //$canvas = $dompdf ->get_canvas();
        //$canvas->page_text(0, 0, "Page {PAGE_NUM} of {PAGE_COUNT}", null, 10, array(0, 0, 0));
    if ($stream) {
            // "Attachment" => 1 hará que por defecto los PDF se descarguen en lugar de presentarse en pantalla.
            $dompdf->stream($filename.".pdf", array("Attachment" => false));
        }
    else 
        {
          return $dompdf->output();
        }
    }
}
