<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Manual extends BaseController
{
	public function __construct(){
 		
	}

    public function vistaManualUsuario()
    {
        if (isset($this->items['idUsuarioSession'])) 
    	{
            $data = array (
				'session'               => 'on',
				'titulo'                => 'Manual de Usuario | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Manual de Usuario'
			);
			
            $data = array_merge($data, $this->items);

            return view('manual/vista_manual_usuario', $data);
        } else {
            return view('errors/500');
        }
    }
    
    public function pdfManualUsuario()
    {
        
        // Ruta al archivo PDF
        // $path = WRITEPATH . 'uploads/pdfs/' . $filename;
        $path = "/home/yifi58ge/public_html/proveedor/public/docs/Manuales/Manual - Proveedor.pdf";
        
        // Verifica si el archivo existe
        if (!file_exists($path)) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException("El archivo PDF no se encuentra.");
        }

        // Establecer las cabeceras apropiadas para un archivo PDF
        return $this->response
            ->setHeader('Content-Type', 'application/pdf')
            ->setHeader('Content-Disposition', 'inline; filename="ManualDeUsuario"')
            ->setHeader('Cache-Control', 'no-store') // Impide cachear el archivo
            ->setBody(file_get_contents($path));
    }
    
}