<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<?php
								if (in_array("ADDGTR", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-grupo-trabajo" data-bs-toggle="modal" data-bs-target="#informacionGrupoTrabajo" data-id="0" data-accion="crear" id="crear-grupo-trabajo">
									<i class="mdi mdi-plus-circle"></i> Añadir
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblGruposTrabajo" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Grupo de Trabajo</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach($listadoGruposTrabajo as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDGrupoTrabajo'] ?></td>
										<td class="text-center align-middle"><?= $items['GrupoTrabajo'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
											<?php
											if (in_array("ESTGTR", $permisos)) 
											{
											?>
											<button class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-grupo-trabajo" data-estado="<?= $items['Estado'] ?>" data-id="<?= $items['IDGrupoTrabajo'] ?>">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</button>
											<?php
											}
											else
											{
											?>
											<span class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
												<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-grupo-trabajo" data-bs-toggle="modal" data-bs-target="#informacionGrupoTrabajo" data-id="<?= $items['IDGrupoTrabajo'] ?>" data-accion="ver" id="ver-grupo-trabajo">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDGTR", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-grupo-trabajo" data-bs-toggle="modal" data-bs-target="#informacionGrupoTrabajo" data-id="<?= $items['IDGrupoTrabajo'] ?>" data-accion="editar" id="editar-grupo-trabajo">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													
													if (in_array("ASUSGT", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/listar-usuarios-grupo-trabajo/<?= $items['IDGrupoTrabajo'] ?>" class="dropdown-item">
															<i class="mdi mdi-account align-bottom me-2 text-muted"></i> Usuarios
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Requerimiento -->
<div class="modal fade" id="informacionGrupoTrabajo" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionGrupoTrabajo" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionGrupoTrabajo">Información de Grupo de Trabajo</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionGrupoTrabajo" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDGrupoTrabajo_i" name="txtIDGrupoTrabajo_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtGrupoTrabajo_i" class="form-label">Grupo de Trabajo</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Grupo de Trabajo" id="txtGrupoTrabajo_i" name="txtGrupoTrabajo_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtDireccionGrupoTrabajoUsuario_i" class="form-label">Dirección</label>
							<select class="form-select" aria-label="Cargo" id="txtDireccionGrupoTrabajoUsuario_i" name="txtDireccionGrupoTrabajoUsuario_i">
								<option value="">Seleccione una opción</option>
									
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtAreaGrupoTrabajo_i" class="form-label">Area</label>
							<select class="form-select" aria-label="Cargo" id="txtAreaGrupoTrabajo_i" name="txtAreaGrupoTrabajo_i">
								<option value="">Seleccione una opción</option>
									
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtSubArea_i" class="form-label">Sub Area</label>
							<select class="form-select" aria-label="Cargo" id="txtSubArea_i" name="txtSubArea_i">
								<option value="">Seleccione una opción</option>
									
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtJefeGrupoTrabajo_i" class="form-label">Jefe Grupo Trabajo</label>
							<select class="form-select" aria-label="Cargo" id="txtJefeGrupoTrabajo_i" name="txtJefeGrupoTrabajo_i">
								<option value="">Seleccione una opción</option>
									
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacionGrupoTrabajo_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionGrupoTrabajo_i" name="txtObservacionGrupoTrabajo_i" rows="3"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarGrupoTrabajo" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>