<?php
namespace App\Models;
use CodeIgniter\Model;

class GruposTrabajoModel extends Model
{
    protected $table      = 'grupostrabajo';
    protected $primaryKey = 'IDGrupoTrabajo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['GrupoTrabajo', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'JefeGrupoTrabajo','IdSubarea'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function obtenerGrupoTrabajo($idGrupoTrabajo)
    {
        $this->select('grupostrabajo.*,
            estructura_subarea.IDArea,
            estructura_area.IDDireccion');
        $this->join('estructura_subarea', 'grupostrabajo.IdSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->where('grupostrabajo.IDGrupoTrabajo', $idGrupoTrabajo);
        $datos = $this->first();
        return $datos;
    }

}