<?php
namespace App\Models;
use CodeIgniter\Model;

class CargosModel extends Model
{
    protected $table      = 'cargos';
    protected $primaryKey = 'IDCargo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Cargo', 'Categoria', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoCargosSelect($variable)
    {
        $this->select('IDCargo,
            Cargo,
            Categoria');
        $this->like("Cargo", $variable);
        $this->orLike("Categoria", $variable);
        
        $datos = $this->findAll();
        return $datos;
    }
}