<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Configuracion extends BaseController
{
	public function __construct(){
		$this->grupostrabajo = new \App\Models\GruposTrabajoModel();
		
		$this->usuarioGruposTrabajo = new \App\Models\UsuarioGruposTrabajoModel();
		
	}

	public function listarGruposTrabajo()
	{
    	if(isset($this->items['id'])){

			/* ACCIONES */
			$listadoGruposTrabajo = $this->grupostrabajo->findAll();
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Grupos de Trabajo | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Grupos de Trabajo',
				'listadoGruposTrabajo'  => $listadoGruposTrabajo
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_grupos_trabajo',$data);			
		} else {
			return view('errors/500');
		}	
	}

	public function registrarGrupoTrabajo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoTrabajo  = ucwords(mb_strtolower($this->request->getPost('txtGrupoTrabajo_i')));
        $observacion    = $this->request->getPost('txtObservacionGrupoTrabajo_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$gtExistente = $this->grupostrabajo->where("GrupoTrabajo", $grupoTrabajo)->findAll();
        
        if(count($gtExistente)>0)
        {
            $msgExistencia .= "<li>El grupo de trabajo ya fue registrado. [CAMPO] <small>GRUPO DE TRABAJO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'GrupoTrabajo'  => $grupoTrabajo,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de grupo de trabajo.",    
            'Estado'        => 'A'
        );

        $lastId = $this->grupostrabajo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $grupoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosGrupoTrabajo()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idGrupoTrabajo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosGrupoTrabajo = $this->grupostrabajo->obtenerGrupoTrabajo($idGrupoTrabajo);

		if(!empty($datosGrupoTrabajo)){
			$resultado = array(
				'idgrupotrabajo'    => (string) $idGrupoTrabajo,
				'IDDireccion'    => (string) $datosGrupoTrabajo['IDDireccion'],
				'IDArea'    => (string) $datosGrupoTrabajo['IDArea'],
				'IdSubarea'    => (string) $datosGrupoTrabajo['IdSubarea'],
				'JefeGrupoTrabajo'    => (string) $datosGrupoTrabajo['JefeGrupoTrabajo'],
				'grupotrabajo'      => (string) $datosGrupoTrabajo['GrupoTrabajo'],
				'observacion'       => (string) $datosGrupoTrabajo['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarGrupoTrabajo($idGrupoTrabajo)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoTrabajo  = ucwords(mb_strtolower($this->request->getPost('txtGrupoTrabajo_i'))) ;
        $observacion    = $this->request->getPost('txtObservacionGrupoTrabajo_i');
        $direccion    = $this->request->getPost('txtDireccionGrupoTrabajoUsuario_i');
        $area    = $this->request->getPost('txtAreaGrupoTrabajo_i');
        $subarea    = $this->request->getPost('txtSubArea_i');
        $jefeGrupoTrabajo    = $this->request->getPost('txtJefeGrupoTrabajo_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'GrupoTrabajo'      => $grupoTrabajo,
            'Observacion'       => $observacion,
            'JefeGrupoTrabajo'  => $jefeGrupoTrabajo,
            'IdSubarea'         => $subarea,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->grupostrabajo->update([$idGrupoTrabajo], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $grupoTrabajo);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoGrupoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|numeric', 'ID Grupo de Trabajo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->grupostrabajo->update([$idGrupoTrabajo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idGrupoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoGruposTrabajo()
    {
        // $tipoRequerimiento = $this->request->getPost("tipoRequerimiento");
        
        // if($tipoRequerimiento != '' && $tipoRequerimiento != null && $tipoRequerimiento != "undefined")
        // {
        //     $listado = $this->requerimientos->where("Tipo", $tipoRequerimiento)->findAll();
        // }
        // else
        // {
        //     $listado = $this->requerimientos->findAll();
        // }
        
        $listado = $this->grupostrabajo->findAll();
        
        $elementos=array();

		if (!empty($listado)) {
            foreach ($listado as $items) {
                $elementos[] = array(
					'id' => (string) $items['IDGrupoTrabajo'],
                    'text' => (string) $items['GrupoTrabajo']
                );
            }

            $resultado = array(
				'listadoGruposTrabajo' => json_encode($elementos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
    public function listarUsuariosGrupoTrabajo($idGrupoTrabajo)
    {
        if(isset($this->items['id'])){
			/* BUSCAR ACCIONES */
			$whereUGT = array(
			    "idgrupotrabajo"    => $idGrupoTrabajo
			);
			$grupoTrabajo = $this->grupostrabajo->where("IDGrupoTrabajo", $idGrupoTrabajo)->first();
			$listaUsuarios = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Usuarios - Grupo de Trabajo | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Usuarios asociados - '.$grupoTrabajo['GrupoTrabajo'],
                'previo'            => 'listar-grupos-trabajo',
				'listaUsuarios'     => $listaUsuarios,
                'idGrupoTrabajo'    => $idGrupoTrabajo
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_usuarios_grupo_trabajo',$data);			
		} else {
			return view('errors/500');	
		}
    }
    
    public function asociarUsuarioGrupoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|number', 'ID Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereUGT = array(
            'IdUsuario'         => $idUsuario,
            'IDGrupoTrabajo'    => $idGrupoTrabajo
        );
        
		$combinacionExistente = $this->usuarioGruposTrabajo->where($whereUGT)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>El usuario ya fue agregado al grupo de trabajo. [CAMPO] <small>USUARIO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoTrabajo'    => $idGrupoTrabajo,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );

        $lastId = $this->usuarioGruposTrabajo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function eliminarUsuarioGrupoTrabajo()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|number', 'ID Grupo de Trabajo');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoTrabajo'    => $idGrupoTrabajo
        );

        $lastId = $this->usuarioGruposTrabajo->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function listarUsuariosGrupoTrabajoSelect()
    {
        $elemento = $this->request->getPost('term');
        $infoPeticion = $this->peticiones->where("IDPeticion", $elemento['peticion'])->first();
        $whereUGT = array(
		    "idgrupotrabajo"=> $infoPeticion['IDGrupoTrabajo'],
		    "like"          => $elemento['term']
		);
		
		$listado = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
        
        // $listado = $this->usuarioModelo->listadoUsuariosSelect($elemento['term'], '', 'Activo');
        
        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']
            );
        }

        echo json_encode($elementos);
    }
}