<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

require 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

class Clientes extends BaseController
{
	public function __construct(){
		$this->clienteModelo = new \App\Models\ClienteModelo();
		$this->gestionModelo = new \App\Models\GestionModelo();
		$this->accionModelo = new \App\Models\AccionModelo();
		$this->subAccionModelo = new \App\Models\SubAccionModelo();
	}

	public function listar(){
		if(isset($this->items['id'])){

			/* ACCIONES */
			$listaAcciones = $this->accionModelo
							->findAll();

			$data = array (
				'session' => 'on',
				'titulo' => 'Porfolio | Verisure',
				'breadcrumb' => 'Porfolio',
				'listaAcciones' => $listaAcciones
			);
			$data = array_merge($data, $this->items);
			return view('cliente/listar',$data);			
		} else {
			return view('errors/500');
		}
	}

    public function grabarClientes() {
		if($_FILES["estructura"]["name"] != ''){
			$allowedExtensions = array("xls","csv","xlsx");
			$fileArray = explode(".", $_FILES["estructura"]["name"]);
			$fileExtension = end($fileArray);
			
			if(in_array($fileExtension, $allowedExtensions)){
				$object = IOFactory::load($_FILES["estructura"]["tmp_name"]);
				$worksheet = $object->getSheet(0);

					$highestRow = $worksheet->getHighestRow();
					$highestColumn = $worksheet->getHighestColumn();
                    
					$error = '';
		
					// for ($row = 2; $row <= $highestRow; $row++) {
					// 	/* VALIDAR QUE EL CAMPO DE ID CLIENTE SIEMPRE ESTÉ LLENO SI HAY DATOS EN LAS OTRAS CELDAS */
					// 	if ($worksheet->getCellByColumnAndRow(1, $row)->getValue() == '') { //A1
					// 		if ($worksheet->getCellByColumnAndRow(2, $row)->getValue() != '') { //C1
					// 			$error .= '<li>Por favor especifique el ID de cliente en la fila '. $row .'</li>';
					// 		}
					// 	}
		
					// 	/* VALIDAR QUE AL MENOS UN CAMPO ESTÉ LLENO SI EL ID DE EMPLEADO ESTÁ LLENO */
					// 	if ($worksheet->getCellByColumnAndRow(1, $row)->getValue() != '') {
					// 		if ($worksheet->getCellByColumnAndRow(2, $row)->getValue() == '') {
					// 			$error .= '<li>Por favor especifique el abreviado en la fila '. $row .'</li>';
					// 		}
					// 	}
					// }
		
					// if ($error != '') {
					// 	$message = sprintf($this->mensajeError->msg201, $error);
					// 	echo $this->alertas->alertaError($message);
					// 	EXIT;
					// }
                    
					for ($row = 2; $row <= $highestRow; $row++) {                        
						$numeroInstalacion = $worksheet->getCellByColumnAndRow(1, $row)->getValue(); //NUMERO DE INSTALACION
						$fechaInstalacion = $worksheet->getCellByColumnAndRow(2, $row)->getValue(); //FECHA DE INSTALACION
						$segmento = $worksheet->getCellByColumnAndRow(3, $row)->getValue(); //SEGMENTO
						$ubicacion = $worksheet->getCellByColumnAndRow(4, $row)->getValue(); //UBICACION

                        /* VALDAR SI YA SE ENCUENTRA EN LA TABLA DE CLIENTES */
                        $whereCliente = array (
                            'cliente.numero_cliente' => $numeroInstalacion,
                            'cliente.eliminacion_logica' => 1
                        );
                        $datosCliente = $this->clienteModelo
                                            ->where($whereCliente)
                                            ->findAll();

                        if(empty($datosCliente)){
                            $dataCliente = array (
                                'numero_cliente' => $numeroInstalacion,
								'fecha_instalacion' => date("Y-m-d", (($fechaInstalacion  - 25568) * 86400)),
								'segmento' => strtoupper($segmento),
								'ubicacion' =>  strtoupper($ubicacion),
                                'fecha_registro' => date("Y-m-d H:i:s"),
                                'eliminacion_logica' => 1
                            );
                            $this->clienteModelo->insert($dataCliente, TRUE);
                        }
					}

					$message = sprintf($this->mensajeError->msg502, "tareo del día");
					echo $this->alertas->alertaExito($message);
					echo $this->alertas->refrescar(1);
			} else {
				$message = sprintf($this->mensajeError->msg201, "Extensión de archivo incorrecta");
				echo $this->alertas->alertaError($message);
				EXIT;
			}
		} else {
            $message = sprintf($this->mensajeError->msg201, "Por favor suba un archivo");
            echo $this->alertas->alertaError($message);
            EXIT;
		}
    }

    public function listarClienteDataTable(){
        $orderBy = " ORDER BY ";

        foreach ($this->request->getGet('order') as $order) {
            $orderBy .= $order['column'] + 1 . " {$order['dir']}, ";
        }

        $orderBy = substr($orderBy, 0, -2);
        $where = '';
        $columns = $this->request->getGet('columns');
        $fields = ['numero_cliente','fecha_instalacion','segmento','ubicacion','reincidente_id'];
        $where = '';

        foreach ($columns as $k => $column) {
            if ($this->request->getGet('search')['value']!="") {
                $where .= $fields[$k]." LIKE '%".$this->request->getGet('search')['value']."%' OR ";
            }
        }

        $where = substr($where, 0, -5);
        $length = $this->request->getGet('length');
        $start = $this->request->getGet('start'); 

        /* LISTAR ORDEN DE COMPRA */
        $listaClientes = $this->clienteModelo->listaGeneralClientes($orderBy,$where,$length,$start);
        echo json_encode($listaClientes, JSON_NUMERIC_CHECK);
    }

	public function obtenerDatosInstalacion() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$reincidente = $this->request->getPost('reincidente');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($reincidente, 'trim|minlength[1]|maxlength[8]', 'Reincidencia');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosGestion = $this->gestionModelo->obtenerDatosGestion($reincidente);

		/* OBTENER SUBACCIONES DE LA ACCIÓN SELECCIONADA */
		$whereSubAccion = array (
			'subaccion.accion_id' => $datosGestion[0]['accion_id']
		);
		$listaSubAcciones = $this->subAccionModelo
							->where($whereSubAccion)
							->findAll();
		
		if(!empty($datosGestion)){
			$resultado = array(
				'id_gestion' => (string) $datosGestion[0]['id_gestion'],
				'gestionable' => (string) $datosGestion[0]['gestionable'],
				'accion_id' => (string) $datosGestion[0]['accion_id'],
				'subaccion_id' => (string) $datosGestion[0]['subaccion_id'],
				'status' => (string) $datosGestion[0]['status'],
				'con_mantenimiento' => (string) $datosGestion[0]['con_mantenimiento'],
				'fecha_mantenimiento' => (string) $datosGestion[0]['fecha_mantenimiento'],
				'listaSubAcciones' => json_encode($listaSubAcciones)
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerGestionesCliente() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$cliente = $this->request->getPost('cliente');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($cliente, 'trim|minlength[1]|maxlength[8]', 'Cliente');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$listaGestiones = $this->gestionModelo->listaGeneralGestiones($cliente);
		
		if(!empty($listaGestiones)){
			foreach($listaGestiones as $items){
				$resultado[] = array(				
					'gestionable' => (string) $items['gestionable'],
					'categoria' => (string) $items['categoria'],
					'accion' => (string) $items['accion'],
					'subaccion' => (string) $items['subaccion'],
					'status' => (string) $items['status'],
					'fecha_gestion' => (string) date("d-m-Y H:i:s", strtotime($items['fecha_gestion'])),
				);
			}
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function reporteHeavyUsers(){
		$excel = new Spreadsheet();		
		$worksheet = $excel->getActiveSheet(0);

        foreach (range('A', 'M') as $columnID) {
            $excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
            $excel->getActiveSheet()->getStyle("A:M")->getFont()->setSize(9);
            $excel->getActiveSheet()->getStyle("A:M")->getAlignment()->setHorizontal('center');
            $excel->getActiveSheet()->getStyle('A:M')->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        }
        $excel->getActiveSheet()->getRowDimension(3)->setRowHeight(26);
		$excel->getActiveSheet()->getStyle('A3:M3')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('000000');

		$worksheet->setTitle("REPORTE");

		/* CABECERAS */
        $worksheet->setCellValue('A1', 'Reporte de Heavy Users ' . date('Y-m-d') . '.')->getStyle('A1')->getFont()->setBold(true);
		$worksheet->setCellValue('A3','N° Instalación')->getStyle('A3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('B3','Fecha Instalación')->getStyle('B3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('C3','Fecha Acción')->getStyle('C3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('D3','Estado')->getStyle('D3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('E3','Acción')->getStyle('E3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('F3','Subacción')->getStyle('F3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('G3','# Eventos')->getStyle('G3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('H3','Días c/ Eventos')->getStyle('H3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('I3','Ratio Día')->getStyle('I3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('J3','Ratio Prev')->getStyle('J3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('K3','Ratio Atc')->getStyle('K3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('L3','Días HU')->getStyle('L3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('M3','Reducción')->getStyle('M3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$rows = 4;
        $i = 1;
        $format = "dd/mm/yyyy";
		
		/* LISTAR MONITORING */
		$listaMonitoring = $this->monitoringModelo->listaGeneralMonitoring2();
		
		if($listaMonitoring == FALSE){
			$listaMonitoring = array();
		}

		foreach($listaMonitoring as $items){	
			if($items['fecha_accion'] != ''){
				$ratioDia = $items['totalEventos'] / $items['diasEventos'];
				$ratioPrev = $items['totalIncidenciasPrev'] / $items['totalDiasPrev'];
				$ratioAct = $items['totalIncidenciasAct'] / $items['totalDiasAct'];
				$reduccion = (($ratioAct / $ratioPrev) - 1) * 100;
				$fechaAccion = date("d-m-Y", strtotime($items['fecha_accion']));
			} else {
				$ratioDia = 0;
				$ratioPrev = 0;
				$ratioAct = 0;
				$reduccion = 0;
				$fechaAccion = "-";
			}
			
            $excel->getActiveSheet()->getRowDimension($rows)->setRowHeight(26);

			$worksheet->setCellValue('A' . $rows, $items['numero_instalacion']);
			$worksheet->setCellValue('B' . $rows, date("d-m-Y", strtotime($items['fecha_instalacion'])));
			$worksheet->setCellValue('C' . $rows, $fechaAccion);
			$worksheet->setCellValue('D' . $rows, $items['estado']);
			$worksheet->setCellValue('E' . $rows, $items['accion']);
			$worksheet->setCellValue('F' . $rows, $items['sub_accion']);
			$worksheet->setCellValue('G' . $rows, number_format($items['totalEventos'], 2, '.', ' '));
			$worksheet->setCellValue('H' . $rows, number_format($items['diasEventos'], 2, '.', ' '));
			$worksheet->setCellValue('I' . $rows, number_format($ratioDia, 2, '.', ' '));
			$worksheet->setCellValue('J' . $rows, number_format($ratioPrev, 2, '.', ' '));
			$worksheet->setCellValue('K' . $rows, number_format($ratioAct, 2, '.', ' '));
			$worksheet->setCellValue('L' . $rows, $items['diasHu']);
			$worksheet->setCellValue('M' . $rows, number_format($reduccion, 2, '.', ' ') . "%");

			$rows++; $i++;
		}

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Reporte de Heavy Users - "'.date("d-m-Y H:i:s").'".xlsx"');
		header('Cache-Control: max-age=0');
		
		$writer = IOFactory::createWriter($excel, 'Xlsx');
		$writer->save('php://output');
		exit;
	}	
}