<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}

/**
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Acceso');
$routes->setDefaultMethod('login');
$routes->setTranslateURIDashes(false);
/* 404 PERSONALIZADO */
$routes->set404Override(function()
{
    echo view('errors/404');
});
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Acceso::login');

/* ACCESO */
$routes->add('entrar','Acceso::entrar');
$routes->add('salir','Acceso::salir');
$routes->add('iniciar-sesion','Acceso::login');
$routes->add('olvido-contrasena', 'Acceso::olvidoContrasena');
$routes->add('solicitar-recuperacion', 'Acceso::solicitarRecuperacion');
$routes->add('recuperar-cuenta/(:any)', 'Acceso::recuperarCuenta/$1');
$routes->add('grabar-recuperacion/(:any)', 'Acceso::grabarRecuperacion/$1');

/* CLIENTES */
$routes->add('listar-clientes','Clientes::listar');
//$routes->add('listar-clientes-json','Clientes::listarClientesJson');
$routes->add('clientesServerside','Clientes::listarClienteDataTable');
$routes->add('grabar-clientes','Clientes::grabarClientes');
$routes->add('obtener-datos-instalacion','Clientes::obtenerDatosInstalacion');
$routes->add('obtener-gestiones-cliente','Clientes::obtenerGestionesCliente');

/* MONITORING */
$routes->add('listar-monitoring','Monitoring::listar');
//$routes->add('listar-monitoring-json','Monitoring::listarMonitoringJson');
$routes->add('clientesServersideMonitoring','Monitoring::listarMonitoringDataTable');
$routes->add('actualizar-gestion/(:any)','Monitoring::actualizarGestion/$1');
$routes->add('reporte-heavyusers','Monitoring::reporteHeavyUsers');
$routes->add('grabar-heavy-users','Monitoring::grabarHeavyUsers');
$routes->add('listar-clusterizacion','Monitoring::listarClusterizacion');

/* ADMINISTRACIÓN */
$routes->add('obtener-inei-departamentos','Administracion::obtenerINEIDepartamentos');
$routes->add('obtener-inei-provincias','Administracion::obtenerINEIProvincias');
$routes->add('obtener-inei-distritos','Administracion::obtenerINEIDistritos');
$routes->add('descargatxt/(:any)','Administracion::descargatxt/$1');/* NUEVO */


$routes->add('subacciones','Administracion::subacciones');
$routes->add('listar-usuarios','Administracion::listarUsuarios');/* NUEVO */
$routes->add('obtener-datos-tipo-cambio','Administracion::obtenerTipoCambio');

$routes->add('listar-perfiles','Administracion::listarPerfiles');/* NUEVO */
$routes->add('registrar-perfil','Administracion::registrarPerfil');/* NUEVO */
$routes->add('listado-perfil-select','Administracion::listadoPerfilesSelect');/* NUEVO */
$routes->add('obtener-datos-perfil','Administracion::obtenerDatosPerfil');/* NUEVO */
$routes->add('actualizar-perfil/(:any)','Administracion::actualizarPerfil/$1');/* NUEVO */
$routes->add('cambiar-estado-perfil','Administracion::modificarEstadoPerfil');/* NUEVO */
//$routes->add('reactivar-perfil/(:any)','Administracion::reactivarPerfil/$1');
$routes->add('listar-permisos-perfil/(:any)','Administracion::listarPermisosPerfil/$1');/* NUEVO */
$routes->add('grabar-permisos-perfil/(:any)','Administracion::guardarPermisosPerfil/$1');/* NUEVO */
$routes->add('listar-rutas-perfil/(:any)','Administracion::listarRutasPerfil/$1');/* NUEVO */
$routes->add('grabar-rutas-perfil/(:any)','Administracion::guardarRutasPerfil/$1');/* NUEVO */


$routes->add('obtener-cabecera','Administracion::obtenerCabecera');/* NUEVO */
$routes->add('listar-modulos','Administracion::listarModulos');/* NUEVO */
$routes->add('registrar-modulo','Administracion::registrarModulo');/* NUEVO */
$routes->add('cambiar-estado-modulo','Administracion::modificarEstadoModulo');/* NUEVO */
$routes->add('obtener-datos-modulo','Administracion::obtenerDatosModulo');/* NUEVO */
$routes->add('actualizar-modulo/(:any)','Administracion::modificarModulo/$1');/* NUEVO */
$routes->add('listar-rutas-modulo/(:any)','Administracion::listarRutasModulo/$1');/* NUEVO */
$routes->add('grabar-ruta/(:any)','Administracion::guardarRutaModulo/$1');/* NUEVO */
$routes->add('obtener-datos-ruta-modulo','Administracion::obtenerDatosRutaModulo');/* NUEVO */
$routes->add('actualizar-ruta-modulo/(:any)','Administracion::modificarRutaModulo/$1');/* NUEVO */
$routes->add('cambiar-estado-ruta-modulo','Administracion::modificarEstadoRutaModulo');/* NUEVO */
$routes->add('listar-acciones-modulo/(:any)','Administracion::listarAccionesModulo/$1');/* NUEVO */
$routes->add('grabar-accion/(:any)','Administracion::guardarAccionModulo/$1');/* NUEVO */


$routes->add('listar-sistemas','Administracion::listarSistemas');/* NUEVO */
$routes->add('registrar-sistema','Administracion::registrarSistema');/* NUEVO */
$routes->add('obtener-datos-sistema','Administracion::obtenerDatosSistema');/* NUEVO */
$routes->add('actualizar-sistema/(:any)','Administracion::actualizarSistema/$1');/* NUEVO */
$routes->add('cambiar-estado-sistema','Administracion::modificarEstadoSistema');/* NUEVO */


$routes->add('listado-areas','Administracion::listadoAreas');/* NUEVO */
$routes->add('listar-areas','Administracion::listarAreas');/* NUEVO */
$routes->add('registrar-area','Administracion::registrarArea');/* NUEVO */
$routes->add('obtener-datos-area','Administracion::obtenerDatosArea');/* NUEVO */
$routes->add('actualizar-area/(:any)','Administracion::actualizarArea/$1');/* NUEVO */
$routes->add('cambiar-estado-area','Administracion::modificarEstadoArea');/* NUEVO */


$routes->add('listado-direccion','Administracion::listadoDireccion'); /* NUEVO */
$routes->add('listar-direcciones','Administracion::listarDirecciones');/* NUEVO */
$routes->add('registrar-direccion','Administracion::registrarDireccion'); /* NUEVO */
$routes->add('obtener-datos-direccion','Administracion::obtenerDatosDireccion');/* NUEVO */
$routes->add('actualizar-direccion/(:any)','Administracion::actualizarDireccion/$1');/* NUEVO */
$routes->add('cambiar-estado-direccion','Administracion::modificarEstadoDireccion');/* NUEVO */

$routes->add('listado-cargos','Administracion::listadoCargos');/* NUEVO */
$routes->add('listar-cargos','Administracion::listarCargos');/* NUEVO */
$routes->add('registrar-cargo','Administracion::registrarCargo'); /* NUEVO */
$routes->add('obtener-datos-cargo','Administracion::obtenerDatosCargo');/* NUEVO */
$routes->add('actualizar-cargo/(:any)','Administracion::actualizarCargo/$1');/* NUEVO */
$routes->add('cambiar-estado-cargo','Administracion::modificarEstadoCargo');/* NUEVO */

$routes->add('listar-direcciones-estructura','Administracion::listarDireccionesEstructura');/* NUEVO */
$routes->add('registrar-direccion-estructura','Administracion::registrarDireccionEstructura');/* NUEVO */
$routes->add('obtener-datos-direccion-estructura','Administracion::obtenerDatosDireccionEstructura');/* NUEVO */
$routes->add('actualizar-direccion-estructura/(:any)','Administracion::modificarDireccionEstructura/$1');/* NUEVO */
$routes->add('cambiar-estado-direccion-estructura','Administracion::modificarEstadoDireccionEstructura');/* NUEVO */
$routes->add('listado-direccion-estructura','Administracion::listadoDireccionesEstructura');/* NUEVO */

$routes->add('listar-ubicaciones-acceso/(:any)','Administracion::listarUbicacionesAcceso/$1');/* NUEVO */
$routes->add('registrar-ubicacion-acceso/(:any)','Administracion::registrarUbicacionAcceso/$1');/* NUEVO */

$routes->add('listar-areas-estructura/(:any)','Administracion::listarAreasEstructura/$1');/* NUEVO */
$routes->add('registrar-area-estructura','Administracion::registrarAreaEstructura');/* NUEVO */
$routes->add('obtener-datos-area-estructura','Administracion::obtenerDatosAreaEstructura');/* NUEVO */
$routes->add('actualizar-area-estructura/(:any)','Administracion::modificarAreaEstructura/$1');/* NUEVO */
$routes->add('cambiar-estado-area-estructura','Administracion::modificarEstadoAreaEstructura');/* NUEVO */
$routes->add('listado-area-estructura','Administracion::listadoAreasEstructura');/* NUEVO */

$routes->add('listar-subareas-estructura/(:any)','Administracion::listarSubareasEstructura/$1');/* NUEVO */
$routes->add('registrar-subarea-estructura','Administracion::registrarSubareaEstructura');/* NUEVO */
$routes->add('obtener-datos-subarea-estructura','Administracion::obtenerDatosSubareaEstructura');/* NUEVO */
$routes->add('actualizar-subarea-estructura/(:any)','Administracion::modificarSubareaEstructura/$1');/* NUEVO */
$routes->add('cambiar-estado-subarea-estructura','Administracion::modificarEstadoSubareaEstructura');/* NUEVO */
$routes->add('listado-subarea-estructura','Administracion::listadoSubareasEstructura');/* NUEVO */

$routes->add('listado-usuario-subarea-estructura','Administracion::listadoUsuarioSubareasEstructura');/* NUEVO */

$routes->add('listar-delegaciones-subarea-estructura/(:any)','Administracion::listarDelegacionesSubareaEstructura/$1');/* NUEVO */
$routes->add('asociar-delegacion-subarea-estructura','Administracion::asociarDelegacionSubareaEstructura/$1');/* NUEVO */
$routes->add('eliminar-delegacion-subarea-estructura','Administracion::eliminarDelegacionSubareaEstructura');/* NUEVO */
$routes->add('listado-delegacion-subarea-estructura','Administracion::listadoDelegacionSubareaEstructura');/* NUEVO */

$routes->add('listar-delegaciones-estructura','Administracion::listarDelegacionessEstructura');/* NUEVO */
$routes->add('registrar-delegacion-estructura','Administracion::registrarDelegacionEstructura');/* NUEVO */
$routes->add('obtener-datos-delegacion-estructura','Administracion::obtenerDatosDelegacionEstructura');/* NUEVO */
$routes->add('actualizar-delegacion-estructura/(:any)','Administracion::modificarDelegacionEstructura/$1');/* NUEVO */
$routes->add('cambiar-estado-delegacion-estructura','Administracion::modificarEstadoDelegacionEstructura');/* NUEVO */
$routes->add('listado-delegacion-estructura','Administracion::listadoDelegacionesEstructura');/* NUEVO */
$routes->add('listado-delegacion-estructura-busqueda','Administracion::busquedaDelegacionesEstructura');/* NUEVO */

/* USUARIOS */
$routes->add('usuariosServerside','Usuarios::listarUsuarioDataTable');/* NUEVO */
$routes->add('registrar-usuario','Usuarios::registrarUsuario'); /* NUEVO */
$routes->add('obtener-datos-usuario','Usuarios::obtenerDatosUsuario');
$routes->add('actualizar-usuario/(:any)','Usuarios::actualizarUsuario/$1');/* NUEVO */
$routes->add('cambiar-estado-usuario','Usuarios::modificarEstadoUsuario');/* NUEVO */
$routes->add('modificar-perfil-usuario/(:any)','Usuarios::modificarPerfilUsuario/$1');/* NUEVO */
$routes->add('obtener-usuarios','Usuarios::obtenerUsuarios');/* NUEVO */
$routes->add('cambiar-password-usuario','Usuarios::modificarPasswordUsuario');/* NUEVO */
$routes->add('listado-usuarios-select','Usuarios::listadoUsuariosSelect');
$routes->add('importar-csv-usuario','Usuarios::importarCSVUsuario');/* NUEVO */
$routes->add('importar-csv-usuario-it','Usuarios::importarCSVUsuarioIT');/* NUEVO */
$routes->add('importar-csv-usuario-flota','Usuarios::importarCSVUsuarioFlota');/* NUEVO */
$routes->add('exportar-total-usuarios','Usuarios::exportarTotalUsuarios');/* NUEVO */
$routes->add('exportar-usuarios-sin-correo','Usuarios::exportarUsuariosSinCorreo');/* NUEVO */

$routes->add('listar-permisos-usuario/(:any)','Usuarios::listarPermisosUsuario/$1');/* NUEVO */
$routes->add('grabar-permisos-usuario/(:any)','Usuarios::guardarPermisosUsuario/$1');/* NUEVO */

$routes->add('listar-rutas-usuario/(:any)','Usuarios::listarRutasUsuario/$1');/* NUEVO */
$routes->add('grabar-rutas-usuario/(:any)','Usuarios::guardarRutasUsuario/$1');/* NUEVO */

$routes->add('listar-sistemas-usuario','Usuarios::listarSistemasUsuario');/* NUEVO */
$routes->add('grabar-sistemas-usuario/(:any)','Usuarios::guardarSistemasUsuario/$1');/* NUEVO */

$routes->add('listar-delegaciones-usuario/(:any)','Usuarios::listarDelegacionesUsuario/$1');/* NUEVO */
$routes->add('asociar-delegacion-usuario','Usuarios::asociarDelegacionUsuario');/* NUEVO */
$routes->add('eliminar-delegacion-usuario','Usuarios::eliminarDelegacionUsuario');/* NUEVO */

/* PLANIFICACION */
$routes->add('listar-planificacion','Planificacion::listarPlanificacion');/* NUEVO */
$routes->add('registrar-planificacion','Planificacion::registrarPlanificacion');/* NUEVO */
$routes->add('obtener-datos-planificacion','Planificacion::obtenerDatosPlanificacion');/* NUEVO */
$routes->add('actualizar-planificacion/(:any)','Planificacion::modificarPlanificacion/$1');/* NUEVO */
$routes->add('cambiar-estado-planificacion','Planificacion::modificarEstadoPlanificacion');/* NUEVO */
$routes->add('listado-planificacion','Planificacion::listadoPlanificacion');/* NUEVO */
$routes->add('listado-planificacion-busqueda','Planificacion::busquedaPlanificacion');/* NUEVO */

$routes->add('listado-grupo-trabajo-estructura','Planificacion::listadoGrupoTrabajoEstructuraPlanificacion');/* NUEVO */
$routes->add('listado-usuaios-grupo-trabajo-estructura','Planificacion::listadoUsuariosGrupoTrabajoEstructuraPlanificacion');/* NUEVO */
$routes->add('horarioDataTableModal','Planificacion::listarHorarioDataTableModal');/* NUEVO */
$routes->add('importar-csv-planificacion','Planificacion::importarPlanificacion');/* NUEVO */
$routes->add('planificacion-data-table','Planificacion::listarPlanificacionDataTable');/* NUEVO */

$routes->add('listar-planificacion-usuario/(:any)','Planificacion::listarPlanificacionUsuario/$1');/* NUEVO */
$routes->add('calendario-planificacion','Planificacion::CalendarioPlanificacion');/* NUEVO */
$routes->add('listado-detalle-horarios-calendario','Planificacion::listadoDetalleHorariosCalendario');/* NUEVO */
$routes->add('actualizar-planificacion-horaria','Planificacion::actualizarPlanificacionHoraria');/* NUEVO */
$routes->add('calendario-planificacion-crear','Planificacion::calendarioPlanificacionCrear');/* NUEVO */
$routes->add('calendario-planificacion-actualizar','Planificacion::calendarioPlanificacionActualizar');/* NUEVO */
$routes->add('registrar-hora-trabajo','Planificacion::registrartHoraTrabajo');/* NUEVO */

// $routes->add('ver-planificacion-usuario/(:any)','Planificacion::listarPlanificacionUsuario/$1');/* NUEVO */

/* CONFIGURACIÓN */
$routes->add('listar-grupos-trabajo','Configuracion::listarGruposTrabajo');/* NUEVO */
$routes->add('registrar-grupo-trabajo','Configuracion::registrarGrupoTrabajo');/* NUEVO */
$routes->add('obtener-datos-grupo-trabajo','Configuracion::obtenerDatosGrupoTrabajo');/* NUEVO */
$routes->add('actualizar-grupo-trabajo/(:any)','Configuracion::modificarGrupoTrabajo/$1');/* NUEVO */
$routes->add('cambiar-estado-grupo-trabajo','Configuracion::modificarEstadoGrupoTrabajo');/* NUEVO */
$routes->add('listado-grupos-trabajo','Configuracion::listadoGruposTrabajo');/* NUEVO */

$routes->add('listar-usuarios-grupo-trabajo/(:any)','Configuracion::listarUsuariosGrupoTrabajo/$1');/* NUEVO */
$routes->add('asociar-usuario-grupo-trabajo','Configuracion::asociarUsuarioGrupoTrabajo');/* NUEVO */
$routes->add('eliminar-usuario-grupo-trabajo','Configuracion::eliminarUsuarioGrupoTrabajo');/* NUEVO */
$routes->add('listado-usuarios-grupotrabajo-select','Configuracion::listarUsuariosGrupoTrabajoSelect');/* NUEVO */

/* HORARIOS */

$routes->add('listado-horarios','Horarios::listadoHorariosEstructura');/* NUEVO */
// $routes->add('listado-detalle-horarios-calendario','Horarios::listadoDetalleHorariosCalendario');/* NUEVO */

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
