toastr.options = {
    "positionClass": "toast-bottom-center",
    "newestOnTop": true,
    "preventDuplicates": true
}

const tableRutasModuloAgregar = new DataTable('#tblRutasModuloAgregar');
const tableSistemas = new DataTable('#tblSistemas');
const tableDepartamentos = new DataTable('#tblDepartamentos');
const tableAreas = new DataTable('#tblAreas');
const tableDirecciones = new DataTable('#tblDirecciones');
const tableCargos = new DataTable('#tblCargos');
const tableDireccionesEstructura = new DataTable("#tblDireccionesEstructura");
const tableAreasEstructura = new DataTable("#tblAreasEstructura");
const tableSubareasEstructura = new DataTable("#tblSubareasEstructura");
const tableDelegacionesEstructura = new DataTable("#tblDelegacionesEstructura");
const tableDelegacionesSubareEstructura = new DataTable("#tblDelegacionesSubareaEstructura");
const tableDelegacionesAsociadasSubarea = new DataTable("#tblDelegacionesAsociadasSubarea");
const tableUbicacionesAcceso = new DataTable("#tblUbicacionesAcceso");

const tableDelegacionesUsuarioEstructura = new DataTable("#tblDelegacionesUsuarioEstructura");
$(function () {
    
    /* ------------------------------- */
    //USUARIO
    $("#txtTipoDocumentoUsuario_i").select2();
    
    $(document).on('keypress', '#txtMatriculaUsuario_i', function(event) {
        var regex = new RegExp("^[a-zA-Z0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
          event.preventDefault();
          return false;
        }
        else if(this.value.length >= 6)
        {
            event.preventDefault();
            return false;
        }
    });

    $(document).on('change', '#txtTipoDocumentoUsuario_i', function(event) {
        $("#txtDocumentoUsuario_i").val('');
        $("#txtDocumentoUsuario_i").focus();
    });

    $(document).on('keypress', '#txtDocumentoUsuario_i', function(event) {
        var regex = new RegExp("^[0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        
        var tipo = $("#txtTipoDocumentoUsuario_i").val();
        
        if(tipo == '')
        {
            Swal.fire({
                html: 'Debe seleccionar el tipo de documento primero',
                heightAuto: true,
                showConfirmButton: true
            });
        }
        else
        {
            var limite = tipo == 'DNI' ? 8 : 12;
            
            if (!regex.test(key)) {
              event.preventDefault();
              return false;
            }
            else if(this.value.length >= limite)
            {
                event.preventDefault();
                return false;
            }
        }
        
    });

    $(document).on('keypress', '#txtFTEUsuario_i', function(event) {
        var regex = new RegExp("^[0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        
        if (!regex.test(key)) {
          event.preventDefault();
          return false;
        }
        else if(this.value.length >= 4)
        {
            event.preventDefault();
            return false;
        }
        
    });
    // $("#txtCargoUsuario_i").select2({
    //     minimumInputLength: 2,
    //     placeholder: 'Seleccione Cargo',
    //     dropdownParent: $('#informacionUsuario .modal-body'),
    //     allowClear: true,
    //     language: {
    //         errorLoading: function() {
    //             return "La carga falló";
    //         },
    //         noResults: function() {
    //             return "No hay resultado";
    //         },
    //         searching: function() {
    //             return "Buscando..";
    //         }
    //     },
    //     ajax: {
    //         url: baseUrl + '/listado-cargos',
    //         dataType: 'json',
    //         type: "POST",
    //         quietMillis: 50,
    //         data: function (term) {
    //             return {
    //                 term: term
    //             };
    //         },
    //         processResults: function (data) {
    //             return {
    //                 results: data
    //             };
    //         }
    //     }
    // });
    
    // $("#txtAreaUsuario_i").select2({
    //     minimumInputLength: 2,
    //     placeholder: 'Seleccione Área',
    //     dropdownParent: $('#informacionUsuario .modal-body'),
    //     allowClear: true,
    //     language: {
    //         errorLoading: function() {
    //             return "La carga falló";
    //         },
    //         noResults: function() {
    //             return "No hay resultado";
    //         },
    //         searching: function() {
    //             return "Buscando..";
    //         }
    //     },
    //     ajax: {
    //         url: baseUrl + '/listado-areas',
    //         dataType: 'json',
    //         type: "POST",
    //         quietMillis: 50,
    //         data: function (term) {
    //             return {
    //                 term: term
    //             };
    //         },
    //         processResults: function (data) {
    //             return {
    //                 results: data
    //             };
    //         }
    //     }
    // });
    
    $("#txtPerfilUsuario").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Perfil',
        dropdownParent: $('#editarPerfilUsuario .modal-body'),
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-perfil-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $("#txtDelegacionAsociarSubarea").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Delegación',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-delegacion-estructura-busqueda',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $("#txtDelegacionAsociarUsuario").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Delegación',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-delegacion-estructura-busqueda',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $(document).on('click', '.cambiar-password-usuario', function(event) {
        var idUsuario = $(this).data("id");
        var usuario = $(this).data("usuario");
        
        Swal.fire({
            title: '¿Estas seguro que deseas reestablecer la contraseña para '+usuario+'?',
            //text: "Recuerda que esta acción es permanente.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#282e38',
            cancelButtonColor: '#f35d5d',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
    
                var parametros = {
                    "idUsuario"  : idUsuario
        		};
                $.ajax({        
                    url: baseUrl + '/cambiar-password-usuario',
                    type: "POST",
                    data: parametros,
                    success: function(response) {
                        $('.respuesta_global').html(response);
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        //$.unblockUI({});
                        Swal.close();
                        alert('Ha ocurrido un error interno.');
                        console.log(jqXHR );
                        console.log(textStatus);
                        console.log(errorThrown);
                    }
                });
            }
        });
    
        return false;
    });

    
    
    /* ------------------------------- */

});

/* ------------------------------- */

function selectDireccionEstructura(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-direccion-estructura', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var direcciones = $.parseJSON(response.listadoDirecciones);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < direcciones.length; i++){
                $("#"+elemento).append('\
                    <option value="' + direcciones[i].id + '" '+(idSeleccionado == direcciones[i].id ? 'selected' : '')+'>' + direcciones[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectAreaEstructura(elemento, idDireccion, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-area-estructura', 
    {
        idDireccion : idDireccion
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var areas = $.parseJSON(response.listadoAreas);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < areas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + areas[i].id + '" '+(idSeleccionado == areas[i].id ? 'selected' : '' )+'>' + areas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectSubareaEstructura(elemento, idArea, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-subarea-estructura', 
    {
        idArea : idArea
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var subareas = $.parseJSON(response.listadoSubareas);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < subareas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + subareas[i].id + '" '+(idSeleccionado == subareas[i].id ? 'selected' : '' )+'>' + subareas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectDelegacionesSubareaEstructura(elemento, idSubarea, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-delegacion-subarea-estructura', 
    {
        idSubarea : idSubarea
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var delegaciones = $.parseJSON(response.listadoDelegaciones);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < delegaciones.length; i++){
                $("#"+elemento).append('\
                    <option value="' + delegaciones[i].id + '" '+(idSeleccionado == delegaciones[i].id ? 'selected' : '' )+'>' + delegaciones[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectDepartamentos(elemento, idSeleccionado, modal)
{
    $.post(baseUrl + '/obtener-departamentos', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var departamentos = $.parseJSON(response.listadoDepartamentos);

            for(var i = 0; i < departamentos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + departamentos[i].id + '" '+(idSeleccionado == departamentos[i].id ? 'selected' : '')+'>' + departamentos[i].departamento +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectCargos(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-cargos', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var cargos = $.parseJSON(response.listadoCargos);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < cargos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + cargos[i].id + '" '+(idSeleccionado == cargos[i].id ? 'selected' : '')+'>' + cargos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectAreas(elemento, idSeleccionado, idDepartamento, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-areas', 
    {
        idDepartamento : idDepartamento
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var areas = $.parseJSON(response.listadoAreas);

            for(var i = 0; i < areas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + areas[i].id + '" '+(idSeleccionado == areas[i].id ? 'selected' : '')+'>' + areas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectUsuarios(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-usuarios', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var usuarios = $.parseJSON(response.listadoUsuarios);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < usuarios.length; i++){
                $("#"+elemento).append('\
                    <option value="' + usuarios[i].id + '" '+(idSeleccionado == usuarios[i].id ? 'selected' : '')+'>' + usuarios[i].usuario +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectINEIDepartamentos(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-inei-departamentos', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var departamentos = $.parseJSON(response.listadoDepartamentos);

            for(var i = 0; i < departamentos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + departamentos[i].id + '" '+(idSeleccionado == departamentos[i].id ? 'selected' : '')+'>' + departamentos[i].departamento +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectINEIProvincias(elemento, idDepartamento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-inei-provincias', 
    {
        idDepartamento : idDepartamento
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var provincias = $.parseJSON(response.listadoProvincias);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < provincias.length; i++){
                $("#"+elemento).append('\
                    <option value="' + provincias[i].id + '" '+(idSeleccionado == provincias[i].id ? 'selected' : '' )+'>' + provincias[i].provincia +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectINEIDistritos(elemento, idProvincia, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-inei-distritos', 
    {
        idProvincia : idProvincia
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var distritos = $.parseJSON(response.listadoDistritos);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < distritos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + distritos[i].id + '" '+(idSeleccionado == distritos[i].id ? 'selected' : '' )+'>' + distritos[i].distrito +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectCabeceraModulo(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-cabecera', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var cabecera = $.parseJSON(response.listadoCabecera);

            for(var i = 0; i < cabecera.length; i++){
                $("#"+elemento).append('\
                    <option value="' + cabecera[i].id + '" '+(idSeleccionado == cabecera[i].id ? 'selected' : '')+'>' + cabecera[i].cabecera +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */
$(document).on('submit', '.formulario', function() {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });

    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData: false,
        success: function(response) {
            //$.unblockUI({});
            Swal.close();
            formulario.find('.respuesta').html(response);
            console.log(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            alert('Ha ocurrido un error interno.');
            console.log(jqXHR );
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
    return false;
});
/* ------------------------------- */
$(document).on('click', '.removerInfo', function(e) {
    e.preventDefault();
    vinculo = $(this).attr("data-url");
    respuesta = $(this).attr("data-response");

    Swal.fire({
        title: '¿Estas seguro que deseas continuar?',
        text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(vinculo, 
                { }, 
                function (response) {
                    $('.'+respuesta).html(response);
                });
                return false;
            }
    });
});
/* ------------------------------- */

/* ------------------------------- */

$(document).on('click', '.datos-modulo', function(e) {
    $('#btnEjecutarModulo').removeClass("d-none");
    var idModulo = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionModulo').text("Registrar módulo");
        $('#formInformacionModulo').attr('action', baseUrl + '/registrar-modulo');

        $('#btnEjecutarModulo').html('<i class="mdi mdi-content-save"></i> Guardar');

        selectCabeceraModulo("txtCabecera_i", "", "informacionModulo")

        $('#txtModulo_i').removeAttr("disabled");
        $('#txtOrden_i').removeAttr("disabled");
        $('#txtIcono_i').removeAttr("disabled");
        $('#txtObservacionModulo_i').removeAttr("disabled");

        $('#txtModulo_i').val("");
        $('#txtOrden_i').val("");
        $('#txtIcono_i').val("");
        $('#txtObservacionModulo_i').val("");
        $('#txtModulo_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-modulo', 
        {         
            idModulo : idModulo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionModulo').text("Información de módulo");
                    $('#btnEjecutarModulo').addClass("d-none");
                    $('#formInformacionModulo').attr('action', '');

                    $('#txtModulo_i').attr("disabled","disabled");
                    $('#txtIcono_i').attr("disabled","disabled");
                    $('#txtOrden_i').attr("disabled","disabled");
                    $('#txtObservacionModulo_i').attr("disabled","disabled");
                    $('#txtCabecera_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionModulo').text("Actualizar módulo");
                    $('#formInformacionModulo').attr('action', baseUrl + '/actualizar-modulo/' + idModulo);

                    $('#txtIcono_i').removeAttr("disabled");
                    $('#txtModulo_i').removeAttr("disabled");
                    $('#txtOrden_i').removeAttr("disabled");
                    $('#txtObservacionModulo_i').removeAttr("disabled");
                    $('#txtCabecera_i').removeAttr("disabled");
                }

                selectCabeceraModulo("txtCabecera_i", response.cabecera, "informacionModulo")

                $('#txtModulo_i').val(response.modulo);
                $('#txtOrden_i').val(response.orden);
                $('#txtIcono_i').val(response.icono);
                $('#txtObservacionModulo_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarRutasModulo', function(e) {
    var ruta = $("#txtRutaModulo").val();

    if(ruta == '')
    {
        Swal.fire({
            html: 'Debe digitar la ruta perteneciente al módulo.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        tableRutasModuloAgregar.row
            .add([
                ruta+"<input type='hidden' name='rutasModulo[]' value='"+ruta+"'>",
                "<button class='btn btn-danger btnDelete'><span class='mdi mdi-trash-can'></span></button>"
            ])
            .draw(false);
        
        $("#txtRutaModulo").val("");
        $("#txtRutaModulo").focus();
    }
});

tableRutasModuloAgregar.on('click', 'button.btnDelete', function(e) {
    e.preventDefault();
    let $tr = $(this).closest('tr');
  
    // Le pedimos al DataTable que borre la fila
    tableRutasModuloAgregar.row($tr).remove().draw(false);
  });
  
/* ------------------------------- */

$(document).on('keypress', '#txtCodigoAccionModulo', function(event) {
    var regex = new RegExp("^[a-zA-Z0-9]+$");
    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    if (!regex.test(key)) {
      event.preventDefault();
      return false;
    }
    else if(this.value.length >= 6)
    {
        event.preventDefault();
        return false;
    }
  });

/* ------------------------------- */

  $(document).on('click', '#editar-perfil-usuario', function(e) {
    
    var idUsuario = $(this).data('id');
    $('#formEditarPerfilUsuario').attr('action', baseUrl + '/modificar-perfil-usuario/' + idUsuario);
    
    $('#txtPerfilUsuario').val("");
    $('#txtPassword').focus();
});

/* ------------------------------- */
$(document).on('click', '.datos-ruta-modulo', function(e) {
    $('#btnEjecutarRutasModulo').removeClass("d-none");
    var idRutaModulo = $(this).data('id');
    var idModulo = $(this).data('modulo');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionRutasModulo').text("Crear Ruta");
        $('#formInformacionRutasModulo').attr('action', baseUrl + '/grabar-ruta/'+idModulo);

        $('#btnEjecutarRutasModulo').html('<i class="mdi mdi-content-save"></i> Guardar');
        $('#txtRutaModulo').removeAttr("disabled");
        $('#txtTipoRuta_i').removeAttr("disabled");
        $('#chkRutaRaiz').removeAttr("disabled");
        $('#chkRutaRaiz').removeAttr("checked", "checked");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-ruta-modulo', 
        {         
            idRutaModulo : idRutaModulo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionRutasModulo').text("Información de Ruta");
                    $('#btnEjecutarRutasModulo').addClass("d-none");
                    $('#formInformacionRutasModulo').attr('action', '');

                    $('#txtRutaModulo').attr("disabled","disabled");
                    $('#txtTipoRuta_i').attr("disabled","disabled");
                    $('#chkRutaRaiz').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionRutasModulo').text("Actualizar Ruta");
                    $('#formInformacionRutasModulo').attr('action', baseUrl + '/actualizar-ruta-modulo/' + idRutaModulo);

                    $('#txtRutaModulo').removeAttr("disabled");
                    $('#txtTipoRuta_i').removeAttr("disabled");
                    $('#chkRutaRaiz').removeAttr("disabled");
                }

                $('#txtIDRutaModulo_i').val(response.idruta);
                $('#txtRutaModulo').val(response.ruta);
                $('#txtTipoRuta_i').val(response.tipo);
                if(response.raiz=='Y')
                {
                    $('#chkRutaRaiz').attr("checked", "checked");
                }
                
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-ruta-modulo', function() {
    var idRutaModulo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la ruta?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idRutaModulo"  : idRutaModulo,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-ruta-modulo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-modulo', function() {
    var idModulo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el módulo?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idModulo"  : idModulo,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-modulo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-perfil', function(e) {
    $('#btnEjecutarPerfil').removeClass("d-none");
    var idPerfil = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionPerfil').text("Registrar perfil");
        $('#formInformacionPerfil').attr('action', baseUrl + '/registrar-perfil');

        $('#btnEjecutarPerfil').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtPerfil').removeAttr("disabled");
        $('#txtURLBasePerfil').removeAttr("disabled");
        
        $('#txtPerfil').val("");
        $('#txtURLBasePerfil').val("");
        
        $('#txtPerfil').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-perfil', 
        {         
            idPerfil : idPerfil
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionPerfil').text("Información de perfil");
                    $('#btnEjecutarPerfil').addClass("d-none");
                    $('#formInformacionPerfil').attr('action', '');

                    $('#txtPerfil').attr("disabled","disabled");
                    $('#txtURLBasePerfil').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionPerfil').text("Actualizar perfil");
                    $('#formInformacionPerfil').attr('action', baseUrl + '/actualizar-perfil/' + idPerfil);

                    $('#txtPerfil').removeAttr("disabled");
                    $('#txtURLBasePerfil').removeAttr("disabled");
                }

                $('#txtIDPerfil_i').val(response.idperfil);
                $('#txtPerfil').val(response.perfil);
                $('#txtURLBasePerfil').val(response.url);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-perfil', function() {
    var idPerfil = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el perfil?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idPerfil"  : idPerfil,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-perfil',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});
/* ------------------------------- */

$(document).on('click', '.datos-sistema', function(e) {
    $('#btnEjecutarSistema').removeClass("d-none");
    var idSistema = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionSistema').text("Registrar sistema");
        $('#formInformacionSistema').attr('action', baseUrl + '/registrar-sistema');

        $('#btnEjecutarSistema').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtSistema_i').removeAttr("disabled");
        $('#txtURLRaiz_i').removeAttr("disabled");
        $('#txtObservacion_i').removeAttr("disabled");

        $('#txtSistema_i').val("");
        $('#txtURLRaiz_i').val("");
        $('#txtObservacion_i').val("");
        
        $('#txtSistema_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-sistema', 
        {         
            idSistema : idSistema
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionSistema').text("Información de sistema");
                    $('#btnEjecutarSistema').addClass("d-none");
                    $('#formInformacionSistema').attr('action', '');

                    $('#txtSistema_i').attr("disabled","disabled");
                    $('#txtURLRaiz_i').attr("disabled","disabled");
                    $('#txtObservacion_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionSistema').text("Actualizar sistema");
                    $('#formInformacionSistema').attr('action', baseUrl + '/actualizar-sistema/' + idSistema);

                    $('#txtSistema_i').removeAttr("disabled");
                    $('#txtURLRaiz_i').removeAttr("disabled");
                    $('#txtObservacion_i').removeAttr("disabled");
                }

                $('#txtIDSistema_i').val(response.idsistema);
                $('#txtSistema_i').val(response.sistema);
                $('#txtURLRaiz_i').val(response.raiz);
                $('#txtObservacion_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-sistema', function() {
    var idSistema = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el sistema?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idSistema" : idSistema,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-sistema',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

  $(document).on('click', '#editar-sistemas-usuario', function(e) {
    $("#ctnSistemasUsuario").empty();
    $("#txtIDUsuario").val('');
    
    var idUsuario = $(this).data('id');
    
    $.post(baseUrl + '/listar-sistemas-usuario', 
    {         
        idUsuario : idUsuario
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            
            var sistemas = $.parseJSON(response.listadoSistemas);
            
            var opc = '';
            
            for(var i = 0; i < sistemas.length; i++)
            {
                opc += '<div class="col-xxl-12 col-md-12 col-12 my-2 px-3">\n\
					<div class="form-check form-switch" style="text-align: right;">\n\
						<input class="form-check-input" type="checkbox" role="switch" name="sistemas['+sistemas[i].idsistema+']" id="chkSistema'+sistemas[i].idsistema+'" '+(sistemas[i].activo == 1 ? "checked" : "")+' >\n\
						<label class="form-check-label" for="chkSistema'+sistemas[i].idsistema+'">'+sistemas[i].sistema+'</label>\n\
					</div>\n\
					<input type="hidden" name="nombre['+sistemas[i].idsistema+']" value="'+sistemas[i].sistema+'">\n\
					<input type="hidden" name="raiz['+sistemas[i].idsistema+']" value="'+sistemas[i].raiz+'">\n\
				</div>';
            }
            
            $('#formEditarSistemasUsuario').attr('action', baseUrl + '/grabar-sistemas-usuario/' + idUsuario);
            $("#txtIDUsuario").val(idUsuario);
            $("#ctnSistemasUsuario").html(opc);
        }
    }, 'json'); 
});

/* ------------------------------- */

$(document).on('click', '.datos-area', function(e) {
    $('#btnEjecutarArea').addClass("d-none");
    var idArea = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtArea_i').attr("disabled","disabled");
    $('#txtLN_i').attr("disabled","disabled");
    $('#txtDptoArea_i').attr("disabled","disabled");
    $('#txtResponsableArea_i').attr("disabled","disabled");
    
    $('#txtArea_i').val("");
    $('#txtLN_i').val("");
    $('#txtDptoArea_i').val("");
    $('#txtResponsableArea_i').val("");
        
    if(accion == 'crear')
    {
        selectDepartamentos("txtDptoArea_i",'', "informacionArea");
        selectUsuarios("txtResponsableArea_i",'', "informacionArea");
        
        $('#exampleinformacionArea').text("Registrar área");
        $('#formInformacionArea').attr('action', baseUrl + '/registrar-area');
        $('#btnEjecutarArea').removeClass("d-none");
        $('#btnEjecutarArea').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtArea_i').removeAttr("disabled");
        $('#txtLN_i').removeAttr("disabled");
        $('#txtDptoArea_i').removeAttr("disabled");
        $('#txtResponsableArea_i').removeAttr("disabled");

        $('#txtArea_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-area', 
        {         
            idArea : idArea
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionArea').text("Información del área");
                    $('#btnEjecutarArea').addClass("d-none");
                    $('#formInformacionArea').attr('action', '');

                    $('#txtArea_i').attr("disabled","disabled");
                    $('#txtLN_i').attr("disabled","disabled");
                    $('#txtDptoArea_i').attr("disabled","disabled");
                    $('#txtResponsableArea_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionArea').text("Actualizar área");
                    $('#formInformacionArea').attr('action', baseUrl + '/actualizar-area/' + idArea);
                    $('#btnEjecutarArea').removeClass("d-none");

                    $('#txtArea_i').removeAttr("disabled");
                    $('#txtLN_i').removeAttr("disabled");
                    $('#txtDptoArea_i').removeAttr("disabled");
                    $('#txtResponsableArea_i').removeAttr("disabled");
                }

                selectDepartamentos("txtDptoArea_i", response.iddepartamento, "informacionArea");
                selectUsuarios("txtResponsableArea_i", response.responsable, "informacionArea");
        
                $('#txtIDArea_i').val(response.idarea);
                $('#txtArea_i').val(response.area);
                $('#txtLN_i').val(response.ln);
                
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-area', function() {
    var idArea = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el área?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idArea"    : idArea,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-area',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});
/* ------------------------------- */

$(document).on('change', '#txtDepartamentoDireccion_i', function() {
    var idDepartamento = $(this).val();
    $("#txtProvinciaDireccion_i").empty();
    $("#txtDistritoDireccion_i").empty();
    selectINEIProvincias('txtProvinciaDireccion_i', idDepartamento, '', "informacionDireccion");
});
$(document).on('change', '#txtProvinciaDireccion_i', function() {
    var idProvincia = $(this).val();
    $("#txtDistritoDireccion_i").empty();
    selectINEIDistritos('txtDistritoDireccion_i', idProvincia, '', "informacionDireccion");
});

/* ------------------------------- */

$(document).on('click', '.datos-direccion', function(e) {
    $('#btnEjecutarDireccion').addClass("d-none");
    var idDireccion = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtDireccion_i').attr("disabled","disabled");
    $('#txtCodigoSunat_i').attr("disabled","disabled");
    
    $('#txtDepartamentoDireccion_i').attr("disabled","disabled");
    $('#txtProvinciaDireccion_i').attr("disabled","disabled");
    $('#txtDistritoDireccion_i').attr("disabled","disabled");
    
    $('#txtDireccion_i').val("");
    $('#txtCodigoSunat_i').val("");
    $('#txtDepartamentoDireccion_i').val("");
    $('#txtProvinciaDireccion_i').empty();
    $('#txtDistritoDireccion_i').empty();
        
    if(accion == 'crear')
    {
        selectINEIDepartamentos("txtDepartamentoDireccion_i", '', "informacionDireccion");
        
        $('#exampleinformacionDireccion').text("Registrar área");
        $('#formInformacionDireccion').attr('action', baseUrl + '/registrar-direccion');
        $('#btnEjecutarDireccion').removeClass("d-none");
        $('#btnEjecutarDireccion').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtDireccion_i').removeAttr("disabled");
        $('#txtCodigoSunat_i').removeAttr("disabled");
        $('#txtDepartamentoDireccion_i').removeAttr("disabled");
        $('#txtProvinciaDireccion_i').removeAttr("disabled");
        $('#txtDistritoDireccion_i').removeAttr("disabled");

        $('#txtDireccion_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-direccion', 
        {         
            idDireccion : idDireccion
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionDireccion').text("Información de la dirección");
                    $('#btnEjecutarDireccion').addClass("d-none");
                    $('#formInformacionDireccion').attr('action', '');

                    $('#txtDireccion_i').attr("disabled","disabled");
                    $('#txtCodigoSunat_i').attr("disabled","disabled");
                    $('#txtDepartamentoDireccion_i').attr("disabled","disabled");
                    $('#txtProvinciaDireccion_i').attr("disabled","disabled");
                    $('#txtDistritoDireccion_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionDireccion').text("Actualizar área");
                    $('#formInformacionDireccion').attr('action', baseUrl + '/actualizar-direccion/' + idDireccion);
                    $('#btnEjecutarDireccion').removeClass("d-none");

                    $('#txtDireccion_i').removeAttr("disabled");
                    $('#txtCodigoSunat_i').removeAttr("disabled");
                    $('#txtDepartamentoDireccion_i').removeAttr("disabled");
                    $('#txtProvinciaDireccion_i').removeAttr("disabled");
                    $('#txtDistritoDireccion_i').removeAttr("disabled");
                }

                selectINEIDepartamentos("txtDepartamentoDireccion_i", response.iddpto, "informacionDireccion");
                selectINEIProvincias("txtProvinciaDireccion_i", response.iddpto, response.idprovincia, "informacionDireccion");
                selectINEIDistritos("txtDistritoDireccion_i", response.idprovincia, response.iddistrito, "informacionDireccion");
                
                $('#txtIDDireccion_i').val(response.iddireccion);
                $('#txtDireccion_i').val(response.direccion);
                $('#txtCodigoSunat_i').val(response.sunat);
                
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-direccion', function() {
    var idDireccion = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "1")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = '0';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = '1';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la dirección?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {
            
            var parametros = {
                "idDireccion"    : idDireccion,
                "estado"    : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-direccion',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-cargo', function(e) {
    $('#btnEjecutarCargo').addClass("d-none");
    var idCargo = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtCargo_i').attr("disabled","disabled");
    $('#txtCategoria_i').attr("disabled","disabled");
    
    $('#txtCargo_i').val("");
    $('#txtCategoria_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionCargo').text("Registrar cargo");
        $('#formInformacionCargo').attr('action', baseUrl + '/registrar-cargo');
        $('#btnEjecutarCargo').removeClass("d-none");
        $('#btnEjecutarCargo').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtCargo_i').removeAttr("disabled");
        $('#txtCategoria_i').removeAttr("disabled");
        
        $('#txtCargo_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-cargo', 
        {         
            idCargo : idCargo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionCargo').text("Información del cargo");
                    $('#btnEjecutarCargo').addClass("d-none");
                    $('#formInformacionCargo').attr('action', '');

                    $('#txtCargo_i').attr("disabled","disabled");
                    $('#txtCategoria_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionCargo').text("Actualizar cargo");
                    $('#formInformacionCargo').attr('action', baseUrl + '/actualizar-cargo/' + idCargo);
                    $('#btnEjecutarCargo').removeClass("d-none");

                    $('#txtCargo_i').removeAttr("disabled");
                    $('#txtCategoria_i').removeAttr("disabled");
                }

                $('#txtIDCargo_i').val(response.idcargo);
                $('#txtCargo_i').val(response.cargo);
                $('#txtCategoria_i').val(response.categoria);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-cargo', function() {
    var idCargo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el cargo?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idCargo"   : idCargo,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-cargo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('change', '#txtDireccionEstrucUsuario_i', function() {
    var idDireccion = $(this).val();
    $("#txtAreaEstrucUsuario_i").empty();
    $("#txtSubareaEstrucUsuario_i").empty();
    $("#txtDelegacionSubareaEstrucUsuario_i").empty();
    var formulario=$(this).closest('form').attr("id");
    
    selectAreaEstructura('txtAreaEstrucUsuario_i', idDireccion, '', formulario);
});
$(document).on('change', '#txtAreaEstrucUsuario_i', function() {
    var idArea = $(this).val();
    $("#txtSubareaEstrucUsuario_i").empty();
    $("#txtDelegacionSubareaEstrucUsuario_i").empty();
    var formulario=$(this).closest('form').attr("id");
    
    selectSubareaEstructura('txtSubareaEstrucUsuario_i', idArea, '', formulario);
});
$(document).on('change', '#txtSubareaEstrucUsuario_i', function() {
    var idSubarea = $(this).val();
    $("#txtDelegacionSubareaEstrucUsuario_i").empty();
    var formulario=$(this).closest('form').attr("id");
    
    selectDelegacionesSubareaEstructura('txtDelegacionSubareaEstrucUsuario_i', idSubarea, '', formulario);
});
/* ------------------------------- */

$(document).on('click', '.datos-usuario', function(e) {
    $('#btnEjecutarUsuario').addClass("d-none");
    $('#btnRestablecerPassword').addClass("d-none");
    $('#btnRestablecerPassword').attr("data-id", "");
    var idUsuario = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=email]').attr("disabled","disabled");
    $(formulario + ' input[type=date]').attr("disabled","disabled");
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' input[type=email]').val("");
    $(formulario + ' input[type=date]').val("");
    $(formulario + ' input[type=number]').val("");
    $(formulario + ' select').val("");
    
    if(accion == 'crear')
    {
        selectCargos("txtCargoUsuario_i", '', formulario.substring(1));
        //selectAreas("txtAreaUsuario_i", '', 'TOTAL', formulario.substring(1));
        selectUsuarios("txtManagerUsuario_i", '', formulario.substring(1));
        selectDireccionEstructura("txtDireccionEstrucUsuario_i", '', formulario.substring(1));
        
        $('#exampleinformacionUsuario').text("Registrar usuario");
        $('#formInformacionUsuario').attr('action', baseUrl + '/registrar-usuario');
        $('#btnEjecutarUsuario').removeClass("d-none");
        $('#btnEjecutarUsuario').html('<i class="mdi mdi-content-save"></i> Guardar');
        
        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' input[type=email]').removeAttr("disabled");
        $(formulario + ' input[type=date]').removeAttr("disabled");
        $(formulario + ' input[type=number]').removeAttr("disabled");
        $(formulario + ' select').removeAttr("disabled");
        
        $('#txtMatriculaUsuario_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-usuario', 
        {         
            idUsuario : idUsuario
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                $('#btnRestablecerPassword').removeClass("d-none");
                $('#btnRestablecerPassword').attr("data-id", idUsuario);
                if(accion == 'ver')
                {
                    $('#exampleinformacionUsuario').text("Información del usuario");
                    $('#btnEjecutarUsuario').addClass("d-none");
                    $('#formInformacionUsuario').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' input[type=email]').attr("disabled","disabled");
                    $(formulario + ' input[type=date]').attr("disabled","disabled");
                    $(formulario + ' input[type=number]').attr("disabled","disabled");
                    $(formulario + ' select').attr("disabled","disabled");
                    
                }
                else
                {
                    $('#exampleinformacionUsuario').text("Actualizar usuario");
                    $('#formInformacionUsuario').attr('action', baseUrl + '/actualizar-usuario/' + idUsuario);
                    $('#btnEjecutarUsuario').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' input[type=email]').removeAttr("disabled");
                    $(formulario + ' input[type=date]').removeAttr("disabled");
                    $(formulario + ' input[type=number]').removeAttr("disabled");
                    $(formulario + ' select').removeAttr("disabled");
                }
                
                selectCargos("txtCargoUsuario_i", response.idcargo, formulario.substring(1));
                //selectAreas("txtAreaUsuario_i", response.idarea, 'TOTAL', formulario.substring(1));
                selectUsuarios("txtManagerUsuario_i", response.idmanager, formulario.substring(1));
                
                selectDireccionEstructura("txtDireccionEstrucUsuario_i", response.iddireccion, formulario.substring(1))
                selectAreaEstructura("txtAreaEstrucUsuario_i", response.iddireccion, response.idarea, formulario.substring(1))
                selectSubareaEstructura("txtSubareaEstrucUsuario_i", response.idarea, response.idsubarea, formulario.substring(1))
                selectDelegacionesSubareaEstructura("txtDelegacionSubareaEstrucUsuario_i", response.idsubarea, response.iddelegacion, formulario.substring(1))

                $('#txtIDUsuario_i').val(response.idusuario);
                $('#txtMatriculaUsuario_i').val(response.matricula);
                $('#txtNombresUsuario_i').val(response.nombres);
                $('#txtApellidosUsuario_i').val(response.apellidos);
                $('#txtTipoDocumentoUsuario_i').val(response.tipodoc).trigger('change');
                $('#txtDocumentoUsuario_i').val(response.documento);
                
                $('#txtFechaIngresoUsuario_i').val(response.fechaingreso);
                $('#txtFTEUsuario_i').val(response.fte);
                
                $('#txtCorreoUsuario_i').val(response.correo);
                $('#txtUsuarioIngreso_i').val(response.usuario);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-usuario', function() {
    var idUsuario = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "Activo")
    {
        var msgEstado = 'CESAR';
        var estado = 'Cesado';
        
        Swal.fire({
            title: '¿Estas seguro que deseas '+msgEstado+' al usuario?',
            //text: "Recuerda que esta acción es permanente.",
            html: '<div class="row col-12 m-0 p-0 px-2 my-2 d-flex">\n\
			    <div class="col-6 p-0 d-flex justify-content-start align-items-center">\n\
					<label class="form-label">Fecha Cese</label>\n\
				</div>\n\
			    <div class="col-6 p-0">\n\
					<div class="input-group">\n\
						<input type="date" class="form-control" aria-label="Fecha de Cese" id="txtFechaCeseUsuario_i" name="txtFechaCeseUsuario_i">\n\
					</div>\n\
				</div>\n\
			</div>\n\
			<div class="row col-12 m-0 p-0 px-2 my-2 d-flex">\n\
			    <div class="col-6 p-0 d-flex justify-content-start align-items-center">\n\
					<label class="form-label">Motivo Cese</label>\n\
				</div>\n\
			    <div class="col-6 p-0">\n\
					<div class="input-group">\n\
						<select class="form-select" id="txtMotivoCeseUsuario_i" name="txtMotivoCeseUsuario_i">\n\
							<option selected value="">Seleccione una opción</option>\n\
							<option value="RENUNCIA">RENUNCIA</option>\n\
							<option value="RENUNCIA CON INCENTIVOS">RENUNCIA CON INCENTIVOS</option>\n\
							<option value="DESPIDO O DESTITUCIÓN">DESPIDO O DESTITUCIÓN</option>\n\
							<option value="CESE COLECTIVO">CESE COLECTIVO</option>\n\
							<option value="JUBILACIÓN">JUBILACIÓN</option>\n\
							<option value="INVALIDEZ ABSOLUTA PERMANENTE">INVALIDEZ ABSOLUTA PERMANENTE</option>\n\
							<option value="TERMINACIÓN DE LA OBRA O SERVICIO O VENCIMIENTO DE PLAZO">TERMINACIÓN DE LA OBRA O SERVICIO O VENCIMIENTO DE PLAZO</option>\n\
							<option value="MUTUO DISENSO">MUTUO DISENSO</option>\n\
							<option value="FALLECIMIENTO">FALLECIMIENTO</option>\n\
							<option value="BAJA POR SUCESIÓN EN POSICIÓN DEL EMPLEADOR">BAJA POR SUCESIÓN EN POSICIÓN DEL EMPLEADOR</option>\n\
							<option value="EXTINCIÓN O LIQUIDACIÓN DEL EMPLEADOR">EXTINCIÓN O LIQUIDACIÓN DEL EMPLEADOR</option>\n\
							<option value="NO SE INICIÓ LA REL. LABORAL O PREST. DE SERVICIOS">NO SE INICIÓ LA REL. LABORAL O PREST. DE SERVICIOS</option>\n\
							<option value="BAJA IT">BAJA IT</option>\n\
						</select>\n\
					</div>\n\
				</div>\n\
			</div>',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#282e38',
            cancelButtonColor: '#f35d5d',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
                
                var motivo = result.value;
                var fechacese = $("#txtFechaCeseUsuario_i").val();
                var motivo = $("#txtMotivoCeseUsuario_i").val();
                
                var parametros = {
                    "idUsuario" : idUsuario,
                    "fechacese" : fechacese,
                    "estado"    : estado,
                    "motivo"    : motivo
        		};
                $.ajax({        
                    url: baseUrl + '/cambiar-estado-usuario',
                    type: "POST",
                    data: parametros,
                    success: function(response) {
                        $('.respuesta_global').html(response);
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        //$.unblockUI({});
                        Swal.close();
                        alert('Ha ocurrido un error interno.');
                        console.log(jqXHR );
                        console.log(textStatus);
                        console.log(errorThrown);
                    }
                });
            }
        });
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-usuario', 
        {         
            idUsuario : idUsuario
        }, 
        function(response) {
            var cese = response.fechacese;
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                Swal.fire({
                    html: 'Fecha de cese: '+cese,
                    heightAuto: true,
                    showConfirmButton: true
                });
            }
        }, 'json'); 
        
    }

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarDelegacionUsuario', function(e) {
    var idDelegacion = $("#txtDelegacionAsociarUsuario").val();
    var idUsuario = $(this).data("usuario");
    var textDelegacion = $("#txtDelegacionAsociarUsuario").select2('data')[0]['text'].split("|");

    var delegacion = textDelegacion[1];
    var cc = textDelegacion[0].split("-")[0];
    var ln = textDelegacion[0].split("-")[1];
    
    if(idDelegacion == '')
    {
        Swal.fire({
            html: 'Debe seleccionar la delegación a asociar.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        Swal.fire({
            title: '¿Estas seguro que deseas encargar la delegación '+delegacion+' con CC '+cc+' y LN '+ln+' al usuario?',
            //text: "Recuerda que esta acción es permanente.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#282e38',
            cancelButtonColor: '#f35d5d',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
                
                var parametros = {
                    "idDelegacion"  : idDelegacion,
                    "idUsuario"     : idUsuario
        		};
                $.ajax({        
                    url: baseUrl + '/asociar-delegacion-usuario',
                    type: "POST",
                    data: parametros,
                    success: function(response) {
                        $('.respuesta_global').html(response);
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        //$.unblockUI({});
                        Swal.close();
                        alert('Ha ocurrido un error interno.');
                        console.log(jqXHR );
                        console.log(textStatus);
                        console.log(errorThrown);
                    }
                });
            }
        });
    }
});

/* ------------------------------- */

$(document).on('click', '.eliminar-delegacion-usuario', function() {
    var idDelegacion = $(this).data("delegacion");
    var idUsuario = $(this).data("usuario");
    
    Swal.fire({
        title: '¿Estas seguro que deseas eliminar la delegación del usuario?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {
            
            var parametros = {
                "idUsuario"    : idUsuario,
                "idDelegacion" : idDelegacion
    		};
            $.ajax({        
                url: baseUrl + '/eliminar-delegacion-usuario',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-direccion-estructura', function(e) {
    $('#btnEjecutarDireccionEstructura').addClass("d-none");
    var idDireccion = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtDireccionEstructura_i').attr("disabled","disabled");
    $('#txtObservacionDireccionEstructura_i').attr("disabled","disabled");
    
    $('#txtDireccionEstructura_i').val("");
    $('#txtObservacionDireccionEstructura_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionDireccionEstructura').text("Registrar dirección");
        $('#formInformacionDireccionEstructura').attr('action', baseUrl + '/registrar-direccion-estructura');
        $('#btnEjecutarDireccionEstructura').removeClass("d-none");
        $('#btnEjecutarDireccionEstructura').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtDireccionEstructura_i').removeAttr("disabled");
        $('#txtObservacionDireccionEstructura_i').removeAttr("disabled");
        
        $('#txtDireccionEstructura_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-direccion-estructura', 
        {         
            idDireccion : idDireccion
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionDireccionEstructura').text("Información de la dirección");
                    $('#btnEjecutarDireccionEstructura').addClass("d-none");
                    $('#formInformacionDireccionEstructura').attr('action', '');

                    $('#txtDireccionEstructura_i').attr("disabled","disabled");
                    $('#txtObservacionDireccionEstructura_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionDireccionEstructura').text("Actualizar dirección");
                    $('#formInformacionDireccionEstructura').attr('action', baseUrl + '/actualizar-direccion-estructura/' + idDireccion);
                    $('#btnEjecutarDireccionEstructura').removeClass("d-none");

                    $('#txtDireccionEstructura_i').removeAttr("disabled");
                    $('#txtObservacionDireccionEstructura_i').removeAttr("disabled");
                }

                $('#txtIDDireccion_i').val(response.iddireccion);
                $('#txtDireccionEstructura_i').val(response.direccion);
                $('#txtObservacionDireccionEstructura_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-direccion-estructura', function() {
    var idDireccion = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la dirección?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idDireccion"   : idDireccion,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-direccion-estructura',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-area-estructura', function(e) {
    $('#btnEjecutarAreaEstructura').addClass("d-none");
    var idArea = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtAreaEstructura_i').attr("disabled","disabled");
    $('#txtObservacionAreaEstructura_i').attr("disabled","disabled");
    
    $('#txtAreaEstructura_i').val("");
    $('#txtObservacionAreaEstructura_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionAreaEstructura').text("Registrar área");
        $('#formInformacionAreaEstructura').attr('action', baseUrl + '/registrar-area-estructura');
        $('#btnEjecutarAreaEstructura').removeClass("d-none");
        $('#btnEjecutarAreaEstructura').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtAreaEstructura_i').removeAttr("disabled");
        $('#txtObservacionAreaEstructura_i').removeAttr("disabled");
        
        $('#txtAreaEstructura_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-area-estructura', 
        {         
            idArea : idArea
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionAreaEstructura').text("Información del área");
                    $('#btnEjecutarAreaEstructura').addClass("d-none");
                    $('#formInformacionAreaEstructura').attr('action', '');

                    $('#txtAreaEstructura_i').attr("disabled","disabled");
                    $('#txtObservacionAreaEstructura_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionAreaEstructura').text("Actualizar área");
                    $('#formInformacionAreaEstructura').attr('action', baseUrl + '/actualizar-area-estructura/' + idArea);
                    $('#btnEjecutarAreaEstructura').removeClass("d-none");

                    $('#txtAreaEstructura_i').removeAttr("disabled");
                    $('#txtObservacionAreaEstructura_i').removeAttr("disabled");
                }

                $('#txtIDAreaEstructura_i').val(response.idarea);
                $('#txtAreaEstructura_i').val(response.area);
                $('#txtObservacionAreaEstructura_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-area-estructura', function() {
    var idArea = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el área?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idArea"    : idArea,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-area-estructura',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-subarea-estructura', function(e) {
    $('#btnEjecutarSubareaEstructura').addClass("d-none");
    var idSubarea = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtSubareaEstructura_i').attr("disabled","disabled");
    $('#txtObservacionSubareaEstructura_i').attr("disabled","disabled");
    
    $('#txtSubareaEstructura_i').val("");
    $('#txtObservacionSubareaEstructura_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionSubareaEstructura').text("Registrar subárea");
        $('#formInformacionSubareaEstructura').attr('action', baseUrl + '/registrar-subarea-estructura');
        $('#btnEjecutarSubareaEstructura').removeClass("d-none");
        $('#btnEjecutarSubareaEstructura').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtSubareaEstructura_i').removeAttr("disabled");
        $('#txtObservacionSubareaEstructura_i').removeAttr("disabled");
        
        $('#txtSubareaEstructura_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-subarea-estructura', 
        {         
            idSubarea : idSubarea
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionSubareaEstructura').text("Información del subárea");
                    $('#btnEjecutarSubareaEstructura').addClass("d-none");
                    $('#formInformacionSubareaEstructura').attr('action', '');

                    $('#txtSubareaEstructura_i').attr("disabled","disabled");
                    $('#txtObservacionSubareaEstructura_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionSubareaEstructura').text("Actualizar subárea");
                    $('#formInformacionSubareaEstructura').attr('action', baseUrl + '/actualizar-subarea-estructura/' + idSubarea);
                    $('#btnEjecutarSubareaEstructura').removeClass("d-none");

                    $('#txtSubareaEstructura_i').removeAttr("disabled");
                    $('#txtObservacionSubareaEstructura_i').removeAttr("disabled");
                }

                $('#txtIDSubareaEstructura_i').val(response.idsubarea);
                $('#txtSubareaEstructura_i').val(response.subarea);
                $('#txtObservacionSubareaEstructura_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-subarea-estructura', function() {
    var idSubarea = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el subárea?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idSubarea"    : idSubarea,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-subarea-estructura',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-delegacion-estructura', function(e) {
    $('#btnEjecutarDelegacionEstructura').addClass("d-none");
    var idDelegacion = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtDelegacionEstructura_i').attr("disabled","disabled");
    $('#txtCCDelegacionEstructura_i').attr("disabled","disabled");
    $('#txtLNDelegacionEstructura_i').attr("disabled","disabled");
    $('#txtObservacionDelegacionEstructura_i').attr("disabled","disabled");
    
    $('#txtDelegacionEstructura_i').val("");
    $('#txtCCDelegacionEstructura_i').val("");
    $('#txtLNDelegacionEstructura_i').val("");
    $('#txtObservacionDelegacionEstructura_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionDelegacionEstructura').text("Registrar delegación");
        $('#formInformacionDelegacionEstructura').attr('action', baseUrl + '/registrar-delegacion-estructura');
        $('#btnEjecutarDelegacionEstructura').removeClass("d-none");
        $('#btnEjecutarDelegacionEstructura').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtDelegacionEstructura_i').removeAttr("disabled");
        $('#txtCCDelegacionEstructura_i').removeAttr("disabled");
        $('#txtLNDelegacionEstructura_i').removeAttr("disabled");
        $('#txtObservacionDelegacionEstructura_i').removeAttr("disabled");

        $('#txtDelegacionEstructura_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-delegacion-estructura', 
        {         
            idDelegacion : idDelegacion
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionDelegacionEstructura').text("Información de la delegación");
                    $('#btnEjecutarDelegacionEstructura').addClass("d-none");
                    $('#formInformacionDelegacionEstructura').attr('action', '');

                    $('#txtDelegacionEstructura_i').attr("disabled","disabled");
                    $('#txtCCDelegacionEstructura_i').attr("disabled","disabled");
                    $('#txtLNDelegacionEstructura_i').attr("disabled","disabled");
                    $('#txtObservacionDelegacionEstructura_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionDelegacionEstructura').text("Actualizar delegación");
                    $('#formInformacionDelegacionEstructura').attr('action', baseUrl + '/actualizar-delegacion-estructura/' + idDelegacion);
                    $('#btnEjecutarDelegacionEstructura').removeClass("d-none");

                    $('#txtDelegacionEstructura_i').removeAttr("disabled");
                    $('#txtCCDelegacionEstructura_i').removeAttr("disabled");
                    $('#txtLNDelegacionEstructura_i').removeAttr("disabled");
                    $('#txtObservacionDelegacionEstructura_i').removeAttr("disabled");
                }

                $('#txtIDDelegacionEstructura_i').val(response.iddelegacion);
                $('#txtDelegacionEstructura_i').val(response.delegacion);
                $('#txtCCDelegacionEstructura_i').val(response.cc);
                $('#txtLNDelegacionEstructura_i').val(response.ln);
                $('#txtObservacionDelegacionEstructura_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-delegacion-estructura', function() {
    var idDelegacion = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la delegación?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idDelegacion"      : idDelegacion,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-delegacion-estructura',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarDelegacionSubarea', function(e) {
    var idDelegacion = $("#txtDelegacionAsociarSubarea").val();
    var idSubarea = $(this).data("subarea");
    var textDelegacion = $("#txtDelegacionAsociarSubarea").select2('data')[0]['text'].split("|");

    var delegacion = textDelegacion[1];
    var cc = textDelegacion[0].split("-")[0];
    var ln = textDelegacion[0].split("-")[1];
    
    if(idDelegacion == '')
    {
        Swal.fire({
            html: 'Debe seleccionar la delegación a asociar.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        Swal.fire({
            title: '¿Estas seguro que deseas agregar la delegación '+delegacion+' con CC '+cc+' y LN '+ln+' a la subárea?',
            //text: "Recuerda que esta acción es permanente.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#282e38',
            cancelButtonColor: '#f35d5d',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
                
                var parametros = {
                    "idDelegacion"  : idDelegacion,
                    "idSubarea"     : idSubarea
        		};
                $.ajax({        
                    url: baseUrl + '/asociar-delegacion-subarea-estructura',
                    type: "POST",
                    data: parametros,
                    success: function(response) {
                        $('.respuesta_global').html(response);
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        //$.unblockUI({});
                        Swal.close();
                        alert('Ha ocurrido un error interno.');
                        console.log(jqXHR );
                        console.log(textStatus);
                        console.log(errorThrown);
                    }
                });
            }
        });
    }
});

/* ------------------------------- */

$(document).on('click', '.eliminar-delegacion-subarea-estructura', function() {
    var idSubarea = $(this).data("subarea");
    var idDelegacion = $(this).data("delegacion");
    
    Swal.fire({
        title: '¿Estas seguro que deseas eliminar la delegación de la subárea?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {
            
            var parametros = {
                "idSubarea"    : idSubarea,
                "idDelegacion"    : idDelegacion
    		};
            $.ajax({        
                url: baseUrl + '/eliminar-delegacion-subarea-estructura',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

function descargarTotalUsuarios()
{
    window.open(baseUrl+"/exportar-total-usuarios/",'_blank');
}

/* ------------------------------- */

function descargarUsuariosSinCorreo()
{
    window.open(baseUrl+"/exportar-usuarios-sin-correo/",'_blank');
}

/* ------------------------------- */
