<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">
	<head>
		<meta charset="utf-8">
		<title><?= $titulo ?></title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta content="Premium Multipurpose Admin & Dashboard Template" name="description">
		<meta content="Themesbrand" name="author">
		<!-- App favicon -->
		<link rel="shortcut icon" href="<?= $baseUrl ?>/public/images/favicon.ico">

		<!--datatable css-->
		<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">
		<!--datatable responsive css-->
		<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css">
		<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
		<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">

		<!-- Layout config Js -->
		<script src="<?= $baseUrl ?>/public/js/layout.js"></script>
		<!-- Bootstrap Css -->
		<link href="<?= $baseUrl ?>/public/css/bootstrap.min.css" rel="stylesheet" type="text/css">
		
		<link href="<?= $baseUrl ?>/public/libs/bootstrap-switch/css/bootstrap3/bootstrap-switch.min.css" rel="stylesheet" type="text/css">
		<!-- Icons Css -->
		<link href="<?= $baseUrl ?>/public/css/icons.min.css" rel="stylesheet" type="text/css">
		<!-- App Css-->
		<link href="<?= $baseUrl ?>/public/css/app.min.css" rel="stylesheet" type="text/css">
		<!-- custom Css-->
		<link href="<?= $baseUrl ?>/public/css/custom.min.css" rel="stylesheet" type="text/css">
		<!-- Toastr -->
		<link rel="stylesheet" href="<?= $baseUrl ?>/public/js/pages/plugins/toastr/toastr.min.css">
		<!-- SweetAlert -->
		<link rel="stylesheet" href="<?= $baseUrl ?>/public/js/pages/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">
	
		<!-- Styles propios -->
		<link rel="stylesheet" href="<?= $baseUrl ?>/public/css/styles.css?<?= $aleatorio ?>">
	</head>
	<body>
		<!-- Begin page -->
		<div id="layout-wrapper">
			<header id="page-topbar">
				<div class="layout-width">
					<div class="navbar-header">
						<div class="d-flex">
							<!-- LOGO -->
							<div class="navbar-brand-box horizontal-logo">
								<a href="<?= $baseUrl ?>/dashboard" class="logo logo-dark">
								<span class="logo-sm">
								<img src="<?= $baseUrl ?>/public/images/logob-sm.png" alt="" height="40">
								</span>
								<span class="logo-lg">
								<img src="<?= $baseUrl ?>/public/images/logob.png" alt="">
								</span>
								</a>
								<a href="<?= $baseUrl ?>/dashboard" class="logo logo-donbosco">
								<span class="logo-sm">
								<img src="<?= $baseUrl ?>/public/images/logob-sm.png" alt="" height="40">
								</span>
								<span class="logo-lg">
								<img src="<?= $baseUrl ?>/public/images/logob.png" alt="" height="40">
								</span>
								</a>
							</div>
							<button type="button" class="btn btn-sm px-3 fs-16 header-item vertical-menu-btn topnav-hamburger shadow-none" id="topnav-hamburger-icon">
							<span class="hamburger-icon">
							<span></span>
							<span></span>
							<span></span>
							</span>
							</button>
						</div>
						<div class="d-flex align-items-center">
							<div class="dropdown d-md-none topbar-head-dropdown header-item">
								<button type="button" class="btn btn-icon btn-topbar btn-ghost-secondary rounded-circle shadow-none" id="page-header-search-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<i class="bx bx-search fs-22"></i>
								</button>
								<div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0" aria-labelledby="page-header-search-dropdown">
									<form class="p-3">
										<div class="form-group m-0">
											<div class="input-group">
												<input type="text" class="form-control" placeholder="Search ..." aria-label="Recipient's username">
												<button class="btn btn-primary" type="submit"><i class="mdi mdi-magnify"></i></button>
											</div>
										</div>
									</form>
								</div>
							</div>
							<div class="ms-1 header-item d-none d-sm-flex">
							    <div class="btn-group">
                                    <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                        Sistemas Verisure
                                    </button>
                                    <div class="dropdown-menu" data-popper-placement="bottom-start" style="position: absolute; inset: 0px auto auto 0px; margin: 0px; transform: translate(0px, 40px);">
                                        <!-- item-->
                                        <?php
                                        foreach($sistemas as $items)
                                        {
                                        ?>
                                        <a class="dropdown-item" href="<?= 'https://www.verismart.com.pe/'.$items['Raiz'] ?>"><?= $items['Sistema'] ?></a>
                                        <?php
                                        }
                                        ?>
                                    </div>
                                </div>
							</div>
							<div class="ms-1 header-item d-none d-sm-flex">
								<button type="button" class="btn btn-icon btn-topbar btn-ghost-secondary rounded-circle shadow-none" data-toggle="fullscreen">
								<i class='bx bx-fullscreen fs-22'></i>
								</button>
							</div>
							<div class="ms-1 header-item d-none d-sm-flex">
								<button type="button" class="btn btn-icon btn-topbar btn-ghost-secondary rounded-circle light-dark-mode shadow-none">
								<i class='bx bx-moon fs-22'></i>
								</button>
							</div>
							<div class="dropdown ms-sm-3 header-item topbar-user">
								<button type="button" class="btn shadow-none" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<span class="d-flex align-items-center">
								<img class="rounded-circle header-profile-user" src="<?= $baseUrl ?>/public/images/users/user-dummy-img.jpg" alt="Header Avatar">
								<span class="text-start ms-xl-2">
								<span class="d-none d-xl-inline-block ms-1 fw-medium user-name-text"><?= $nombres.' '.$apellidos ?></span>
								<span class="d-none d-xl-block ms-1 fs-12 text-muted user-name-sub-text"><?= $perfil ?></span>
								</span>
								</span>
								</button>
								<div class="dropdown-menu dropdown-menu-end">
									<!-- item-->
									<h6 class="dropdown-header">¡Hola <?= $nombres ?>!</h6>
									<a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#cambiarContrasena">
										<i class="mdi mdi-lock text-muted fs-16 align-middle me-1"></i> <span class="align-middle">Cambiar contraseña</span>
									</a>
									<a class="dropdown-item" href="<?= $baseUrl ?>/salir">
										<i class="mdi mdi-logout text-muted fs-16 align-middle me-1"></i> <span class="align-middle" data-key="t-logout">Cerrar sesión</span>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</header>
			<!-- ========== App Menu ========== -->
			<div class="app-menu navbar-menu">
				<!-- LOGO -->
				<div class="navbar-brand-box">
					<!-- Dark Logo-->
					<a href="<?= $baseUrl ?>/dashboard" class="logo logo-dark">
					<span class="logo-sm">
					<img src="<?= $baseUrl ?>/public/images/logob-sm.png" alt="" height="35">
					</span>
					<span class="logo-lg">
					<img src="<?= $baseUrl ?>/public/images/logob.png" alt="" height="40">
					</span>
					</a>
					<!-- Light Logo-->
					<a href="<?= $baseUrl ?>/dashboard" class="logo logo-donbosco">
					<span class="logo-sm">
					<img src="<?= $baseUrl ?>/public/images/logob-sm.png" alt="" height="35">
					</span>
					<span class="logo-lg">
					<img src="<?= $baseUrl ?>/public/images/logob.png" alt="" height="40">
					</span>
					</a>
					<button type="button" class="btn btn-sm p-0 fs-20 header-item float-end btn-vertical-sm-hover" id="vertical-hover">
					<i class="ri-record-circle-line"></i>
					</button>
				</div>
				<div id="scrollbar">
					<div class="container-fluid">
						<div id="two-column-menu">
						</div>
						<ul class="navbar-nav" id="navbar-nav">
							<?php
							foreach($cabecera as $items)
							{
							    if(in_array($items['IDCabecera'], array_column($navbar, 'IDCabecera')))
							    {
    							?>
    							<li class="menu-title"><span data-key="t-menu"><?= $items['Cabecera'] ?></span></li>
    							<?php
    								foreach($navbar as $nav)
    								{
    									if($items['IDCabecera'] == $nav['IDCabecera'])
    									{
    									?>
    									<li class="nav-item">
    										<a class="nav-link menu-link <?php if($breadcrumb == $nav['Modulo']){ echo "active"; } ?>" href="<?= $baseUrl ?>/<?= $nav['Ruta'] ?>">
    										<i class="<?= $nav['Icono'] ?>"></i> <span data-key="t-widgets"><?= $nav['Modulo'] ?></span>
    										</a>
    									</li>
    									<?php
    									}
    								}
							    }
							}
							?>
							<!-- end Dashboard Menu -->
						</ul>
					</div>
					<!-- Sidebar -->
				</div>
				<div class="sidebar-background"></div>
			</div>
			<!-- Left Sidebar End -->
			<!-- Vertical Overlay-->
			<div class="vertical-overlay"></div>

        <?= $this->renderSection('content'); ?>
		</div>
		<!-- END layout-wrapper -->

		<!-- Modal Cambiar de Contraseña -->
		<div class="modal fade" id="cambiarContrasena" tabindex="-1" role="dialog" aria-labelledby="examplecambiarContrasena" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title" id="examplecambiarContrasena">Cambiar contraseña</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<form class="formulario" action="<?= $baseUrl ?>/actualizar-contrasena" method="POST">
						<span class="respuesta"></span>
						<div class="modal-body">
							<div class="row">
								<div class="col-xxl-12 col-md-12 col-12 mb-3">
									<div>
										<label for="contrasena" class="form-label">Contraseña</label>
										<input type="password" class="form-control" id="contrasena" name="contrasena">
									</div>
								</div>
								<div class="col-xxl-12 col-md-12 col-12 mb-3">
									<div>
										<label for="nueva_contrasena" class="form-label">Nueva Contraseña</label>
										<input type="password" class="form-control" id="nueva_contrasena" name="nueva_contrasena">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
							<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
						</div>
					</form>
				</div>
			</div>
		</div>		
		<!--start back-to-top-->
		<button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
		<i class="ri-arrow-up-line"></i>
		</button>
		<!--end back-to-top-->
		<!--preloader-->
		<div id="preloader">
			<div id="status">
				<div class="spinner-border text-primary avatar-sm" role="status">
					<span class="visually-hidden">Loading...</span>
				</div>
			</div>
		</div>
      	<script> window.baseUrl = "<?= base_url(); ?>"</script>
		<!-- jQuery -->
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/jquery/jquery.min.js"></script>
		<!-- JAVASCRIPT -->
		<script src="<?= $baseUrl ?>/public/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/simplebar/simplebar.min.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/node-waves/waves.min.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/feather-icons/feather.min.js"></script>
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/lord-icon-2.1.0.js"></script>
		<script src="<?= $baseUrl ?>/public/js/plugins.js"></script>
		<script src="<?= $baseUrl ?>/public/libs/bootstrap-switch/js/bootstrap-switch.min.js"></script>
		<!--datatable js-->
		<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
		<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
		<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
		<script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
		<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
		<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
		
		<script src="<?= $baseUrl ?>/public/js/pages/datatables.init.js"></script>      
		<!-- apexcharts -->
		<script src="<?= $baseUrl ?>/public/libs/apexcharts/apexcharts.min.js"></script>
		<!--select2 cdn-->
		<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
		<script src="<?= $baseUrl ?>/public/js/pages/select2.init.js"></script>
		<!-- echarts js -->
		<script src="<?= $baseUrl ?>/public/libs/echarts/echarts.min.js"></script>
		<!-- App js -->
		<script src="<?= $baseUrl ?>/public/js/app.js"></script>
		<!-- Toastr -->
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/toastr/toastr.min.js"></script>
		<!-- SweetAlert -->
		<script src="<?= $baseUrl ?>/public/js/pages/plugins/sweetalert2/sweetalert2.min.js"></script>
		<!-- Moment -->
		<script src="<?= $baseUrl ?>/public/libs/moment/moment.js"></script>
		<!-- Proceso -->
		<script src="<?= $baseUrl ?>/public/js/proceso.js?<?= $aleatorio ?>"></script>
		<!-- echarts init -->
		<!--<script src="assets/js/pages/echarts.init.js"></script>-->
		<?= $this->renderSection('js'); ?>
	</body>
</html>