<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<!-- Horizontal Form -->
					<div class="card">
						<div class="card-header d-flex align-items-center" style="background-color: #d2d6de;">
							<h5 class="card-title mb-0 flex-grow-1" style=""><?= $breadcrumb_alias ?> | <?= $moduloSeleccionado['Modulo'] ?></h5>
							<div>
								<?php
								if (in_array("ADDRUT", $permisos)) 
								{
								?>
								<button class="btn btn-primary datos-ruta-modulo" data-bs-toggle="modal" data-bs-target="#informacionRutasModulo" data-id="0" data-modulo="<?= $idModulo ?>" data-accion="crear" id="crear-ruta-modulo">
									<i class="mdi mdi-plus-circle"></i> Agregar
								</button>
								<?php
								}
								?>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
							</div>
						</div>
						<!-- /.card-header -->
						
						<div class="card-body row">
							<div class="col-lg-12">
								<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
									<thead>
										<tr>
											<th class="text-center align-middle">Código</th>
											<th class="text-center align-middle">Ruta</th>
											<th class="text-center align-middle">Tipo Ruta</th>
											<th class="text-center align-middle">Raíz Módulo</th>
											<th class="text-center align-middle">Estado</th>
											<th class="text-center align-middle">Accion</th>
										</tr>
									</thead>
									<tbody>
										<?php 
										foreach($listaRutas as $items){ ?>
										<tr>
											<td class="text-center align-middle"><?= $items['IDRuta'] ?></td>
											<td class="text-center align-middle"><?= $items['Ruta'] ?></td>
											<td class="text-center align-middle"><?= $items['TipoRuta'] ?></td>
											<td class="text-center align-middle">
												<?php 
												if($items['RaizModulo'] == 'Y')
												{
												?>
												<span class="badge bg-success border-0">SI</span>
												<?php
												} 
												else
												{
												?>
												<span class="badge bg-danger border-0">NO</span>
												<?php
												} 
												?>
											</td>
											<td class="text-center align-middle">
												<?php
												if (in_array("ESTRUT", $permisos)) 
												{
												?>
												<button class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-ruta-modulo" data-estado="<?= $items['Estado'] ?>" data-id="<?= $items['IDRuta'] ?>">
													<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
												</button>
												<?php
												}
												else
												{
												?>
												<span class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0" >
													<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
												</span>
												<?php
												}
												?>
											</td>
											<td class="text-center align-middle">
												<div class="dropdown d-inline-block">
													<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
														<i class="ri-more-fill align-middle"></i>
													</button>
													<ul class="dropdown-menu dropdown-menu-end">
														<li>
															<a href="#!" class="dropdown-item datos-ruta-modulo" data-bs-toggle="modal" data-bs-target="#informacionRutasModulo" data-id="<?= $items['IDRuta'] ?>" data-modulo="<?= $idModulo ?>" data-accion="ver" id="ver-ruta-modulo">
																<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
															</a>
														</li>
														<?php
														if (in_array("UPDRUT", $permisos)) 
														{
														?>
														<li>
															<a href="#!" class="dropdown-item edit-item-btn datos-ruta-modulo" data-bs-toggle="modal" data-bs-target="#informacionRutasModulo" data-id="<?= $items['IDRuta'] ?>" data-modulo="<?= $idModulo ?>" data-accion="editar" id="editar-ruta-modulo">
																<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
															</a>
														</li>
														<?php
														}
														?>
													</ul>
												</div>
											</td>
										</tr>
										<?php } ?>
									</tbody>
								</table>
							</div>
						</div>
						<!-- /.card-body -->
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<!-- Modal Información Rutas -->
<div class="modal fade" id="informacionRutasModulo" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionRutasModulo" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionRutasModulo">Información de Ruta</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionRutasModulo" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDRutaModulo_i" name="txtIDRutaModulo_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtRutaModulo" class="form-label">Ruta</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Ruta" id="txtRutaModulo" name="txtRutaModulo">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtTipoRuta_i" class="form-label">Tipo de Ruta</label>
							<select class="form-select" aria-label="Tipo de Ruta" id="txtTipoRuta_i" name="txtTipoRuta_i">
								<option selected="" value="">Seleccione una opción</option>
								<option value="VISTA">VISTA</option>
								<option value="ACCION">ACCIÓN</option>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div class="form-check form-switch">
								<label class="form-check-label" for="chkRutaRaiz">¿La ruta es la raíz del módulo?</label>
								<input class="form-check-input" type="checkbox" role="switch" name="chkRutaRaiz" id="chkRutaRaiz">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarRutasModulo" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>