<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb ?></h5>
                            <div>
								<?php
								if (in_array("ADDDIR", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-direccion" data-bs-toggle="modal" data-bs-target="#informacionDireccion" data-id="0" data-accion="crear" id="crear-direccion">
									<i class="mdi mdi-plus-circle"></i> Añadir
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblDirecciones" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Dirección</th>
										<th class="text-center align-middle">Distrito</th>
										<th class="text-center align-middle">Código Sunat</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach($listadoDirecciones as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['id_direccion'] ?></td>
										<td class="text-center align-middle"><?= $items['Direccion'] ?></td>
										<td class="text-center align-middle"><?= $items['desc_dep_inei'].' - '.$items['desc_prov_inei'].' - '.$items['desc_ubigeo_inei'] ?></td>
										<td class="text-center align-middle"><?= $items['codigoSunat'] ?></td>
										<td class="text-center align-middle">
											<?php
											if (in_array("ESTDIR", $permisos)) 
											{
											?>
											<button class="badge <?= $items['eliminacion_logica'] == '1' ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-direccion" data-estado="<?= $items['eliminacion_logica'] ?>" data-id="<?= $items['id_direccion'] ?>">
												<?= $items['eliminacion_logica'] == '1' ? 'ACTIVO' : 'INACTIVO' ?>
											</button>
											<?php
											}
											else
											{
											?>
											<span class="badge <?= $items['eliminacion_logica'] == '1' ? 'bg-success' : 'bg-warning' ?> border-0">
												<?= $items['eliminacion_logica'] == '1' ? 'ACTIVO' : 'INACTIVO' ?>
											</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
												<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-direccion" data-bs-toggle="modal" data-bs-target="#informacionDireccion" data-id="<?= $items['id_direccion'] ?>" data-accion="ver" id="ver-direccion">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDDIR", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-direccion" data-bs-toggle="modal" data-bs-target="#informacionDireccion" data-id="<?= $items['id_direccion'] ?>" data-accion="editar" id="editar-direccion">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													
													if(in_array("ADUBAC", $permisos))
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/listar-ubicaciones-acceso/<?= $items['id_direccion'] ?>" class="dropdown-item">
															<i class="mdi mdi-access-point align-bottom me-2 text-muted"></i> Ubicaciones de Acceso
														</a>
													</li>
													<?php
													    
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Departamento -->
<div class="modal fade" id="informacionDireccion" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionDireccion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionDireccion">Información de Dirección</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionDireccion" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDDireccion_i" name="txtIDDireccion_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtDireccion_i" class="form-label">Dirección</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Dirección" id="txtDireccion_i" name="txtDireccion_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtCodigoSunat_i" class="form-label">Código Sunat</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Código Sunat" id="txtCodigoSunat_i" name="txtCodigoSunat_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtDepartamentoDireccion_i" class="form-label">Departamento</label>
								<select class="form-select" aria-label="Distrito" id="txtDepartamentoDireccion_i" name="txtDepartamentoDireccion_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtProvinciaDireccion_i" class="form-label">Provincia</label>
								<select class="form-select" aria-label="Provincia" id="txtProvinciaDireccion_i" name="txtProvinciaDireccion_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtDistritoDireccion_i" class="form-label">Distrito</label>
								<select class="form-select" aria-label="Distrito" id="txtDistritoDireccion_i" name="txtDistritoDireccion_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarDireccion" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>