<?php namespace App\Models;

use CodeIgniter\Model;

class GestionModelo extends Model {
    protected $table = 'gestion';
    protected $primaryKey = 'id_gestion';
    protected $allowedFields = ['id_gestion','reincidente_id','gestionable','accion_id','subaccion_id','status','fecha_gestion','fecha_registro','eliminacion_logica'];

    public function listaGeneralGestiones($idCliente) {
        $consulta = 'SELECT
        c.numero_cliente,
        r.categoria,
        r.fecha_reincidente,
        r.incidentes,
        r.con_mantenimiento,
        r.fecha_mantenimiento,
        r.motivo,
        g.gestionable,
        g.accion_id,
        g.subaccion_id,
        a.accion,
        s.subaccion,
        g.status,
        g.fecha_gestion
        FROM cliente c
        INNER JOIN reincidente r ON r.cliente_id = c.id_cliente
        INNER JOIN gestion g ON r.id_reincidente = g.reincidente_id
        INNER JOIN accion a ON g.accion_id = a.id_accion
        INNER JOIN subaccion s ON g.subaccion_id = s.id_subaccion
        WHERE c.id_cliente = '.$idCliente.'
        AND g.fecha_gestion IS NOT NULL
        ORDER BY r.id_reincidente DESC';

        $obtieneConsulta = $this->db->query($consulta);
        //$obtieneConsulta->getResult();
        if ($obtieneConsulta->getNumRows() > 0) {
            return $obtieneConsulta->getResultArray();
        } else {
            return FALSE;
        }
    }

    public function obtenerDatosGestion($idReincidente) {
        $consulta = 'SELECT
        g.id_gestion,
        g.gestionable,
        g.accion_id,
        g.subaccion_id,
        a.accion,
        s.subaccion,
        g.status,
        g.fecha_gestion,
        r.fecha_mantenimiento,
        r.con_mantenimiento
        FROM cliente c
        INNER JOIN reincidente r ON r.cliente_id = c.id_cliente
        INNER JOIN gestion g ON r.id_reincidente = g.reincidente_id
        INNER JOIN accion a ON g.accion_id = a.id_accion
        INNER JOIN subaccion s ON g.subaccion_id = s.id_subaccion
        WHERE g.reincidente_id = '.$idReincidente.';';

        $obtieneConsulta = $this->db->query($consulta);
        //$obtieneConsulta->getResult();
        if ($obtieneConsulta->getNumRows() > 0) {
            return $obtieneConsulta->getResultArray();
        } else {
            return FALSE;
        }
    }

    public function clusterizacion($primerDia) {
        $consulta = '        

        SELECT
            cliente.numero_cliente,
            cliente.fecha_instalacion,
            IF(
                gestion.status = "Completado" AND DATE_FORMAT(gestion.fecha_gestion,"%Y-%m-%d") >= "' . $primerDia . '", DATE_FORMAT(gestion.fecha_gestion,"%Y-%m-%d") /* CASO 03 */, 	
                CASE
                    WHEN cliente.fecha_instalacion < "' . $primerDia . '" THEN "' . $primerDia . '" /* CASO 01*/
                    WHEN cliente.fecha_instalacion >= "' . $primerDia . '" THEN cliente.fecha_instalacion /* CASO 02 */
                END
            ) AS fechaInstalacionPrima,
            SUM(reincidente.incidentes) AS totalIncidentes,
            COUNT(reincidente.eliminacion_logica) AS totalDiasIncidentes,
            IF(
                gestion.status = "Completado" AND DATE_FORMAT(gestion.fecha_gestion,"%Y-%m-%d") >= "' . $primerDia . '", 
                
                (SELECT COUNT(reincidente.eliminacion_logica) FROM reincidente WHERE reincidente.fecha_reincidente >= DATE_FORMAT(gestion.fecha_gestion,"%Y-%m-%d") AND reincidente.cliente_id = cliente.id_cliente) /* CASO 03 */, 	
                CASE
                   WHEN cliente.fecha_instalacion < "' . $primerDia . '" THEN (SELECT COUNT(reincidente.eliminacion_logica) FROM reincidente WHERE reincidente.fecha_reincidente >= "' . $primerDia . '" AND reincidente.cliente_id = cliente.id_cliente) /* CASO 01 */
                   WHEN cliente.fecha_instalacion >= "' . $primerDia . '" THEN (SELECT COUNT(reincidente.eliminacion_logica) FROM reincidente WHERE reincidente.fecha_reincidente >= cliente.fecha_instalacion AND reincidente.cliente_id = cliente.id_cliente) /* CASO 02 */
                END
            ) AS totalDiasIncidenciasAntiguedad,
            IF(
                gestion.status = "Completado" AND DATE_FORMAT(gestion.fecha_gestion,"%Y-%m-%d") >= "' . $primerDia . '",
                
                DATEDIFF(CURDATE(), DATE_FORMAT(gestion.fecha_gestion,"%Y-%m-%d")),
                CASE
                   WHEN cliente.fecha_instalacion < "' . $primerDia . '" THEN DATEDIFF(CURDATE(), "' . $primerDia . '") /* CASO 01 */
                   WHEN cliente.fecha_instalacion >= "' . $primerDia . '" THEN DATEDIFF(CURDATE(), cliente.fecha_instalacion) /* CASO 02 */
                END
            ) AS totalDiasAntiguedad
        FROM cliente
        LEFT JOIN reincidente ON cliente.id_cliente = reincidente.cliente_id
        LEFT JOIN gestion ON reincidente.id_reincidente = gestion.reincidente_id
        WHERE reincidente.fecha_reincidente >= "' . $primerDia . '"
        GROUP BY cliente.numero_cliente';

        $obtieneConsulta = $this->db->query($consulta);
        //$obtieneConsulta->getResult();
        if ($obtieneConsulta->getNumRows() > 0) {
            return $obtieneConsulta->getResultArray();
        } else {
            return FALSE;
        }
    }
}
