<?php
namespace App\Models;
use CodeIgniter\Model;

class EstructuraSubareaModel extends Model
{
    protected $table      = 'estructura_subarea';
    protected $primaryKey = 'IDSubarea';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDArea', 'Subarea', 'Correo', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerSubareaXNombres($subarea, $area, $direccion)
    {
        $this->select('estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area.IDDireccion,
            estructura_direccion.Direccion');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->where('estructura_subarea.Subarea', $subarea);
        $this->where('estructura_area.Area', $area);
        $this->where('estructura_direccion.Direccion', $direccion);

        $datos = $this->first();
        return $datos;
    }
    
    public function obtenerSubarea($idSubarea)
    {
        $this->select('estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea.Correo,
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area.IDDireccion,
            estructura_direccion.Direccion');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->where('estructura_subarea.IDSubarea', $idSubarea);

        $datos = $this->first();
        return $datos;
    }
    
    // public function listadoCargosSelect($variable)
    // {
    //     $this->select('IDCargo,
    //         Cargo,
    //         Categoria');
    //     $this->like("Cargo", $variable);
    //     $this->orLike("Categoria", $variable);
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }
}