<?php
namespace App\Models;
use CodeIgniter\Model;

class DepartamentoModel extends Model
{
    //protected $DBGroup = 'baseT';
    protected $table      = 'tbldepartamento';
    protected $primaryKey = 'IdDpto';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['NombreDpto', 'CC', 'Tipo', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoCCSelect($variable)
    {
        $this->select('
        IdDpto,
        NombreDpto,
        CC,
        Tipo');
        $this->like("NombreDpto", $variable);
        $this->orLike("CC", $variable);
        
        $datos = $this->findAll();
        return $datos;
    }
}