<?php
namespace App\Models;
use CodeIgniter\Model;

class AreaModel extends Model
{
    //protected $DBGroup = 'baseT';
    protected $table      = 'tblarea';
    protected $primaryKey = 'IdArea';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IdDpto', 'LN', 'NombreArea', 'Responsable', 'UsuarioResponsable', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoAreas()
    {
        $this->select('tblarea.IdArea,
            tblarea.IdDpto, 
            tblarea.LN,
            tblarea.NombreArea,
            tblarea.Responsable,
            tblarea.UsuarioResponsable,
            tblarea.Estado,
            tbldepartamento.NombreDpto,
            tblusuario.Nombres,
            tblusuario.Apellidos');
        $this->join('tbldepartamento', "tblarea.IdDpto = tbldepartamento.IdDpto", "left");
        $this->join("tblusuario", "tblarea.UsuarioResponsable = tblusuario.IdUsuario", "left");
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listadoAreasSelect($variable)
    {
        $this->select('
            tblarea.IdArea,
            tblarea.LN,
            tblarea.NombreArea,
            tbldepartamento.NombreDpto,
            tbldepartamento.CC');
        $this->join('tbldepartamento', 'tblarea.IdDpto = tbldepartamento.IdDpto', 'left');
        
        $this->like("tblarea.NombreArea", $variable);
        $this->orLike("tblarea.LN", $variable);
        $this->orLike("tbldepartamento.NombreDpto", $variable);
        $this->orLike("tbldepartamento.CC", $variable);
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listadoAreasXDepartamento($idDepartamento)
    {
        $this->select('
            tblarea.IdArea,
            tblarea.LN,
            tblarea.NombreArea,
            tbldepartamento.NombreDpto,
            tbldepartamento.CC');
        $this->join('tbldepartamento', 'tblarea.IdDpto = tbldepartamento.IdDpto', 'left');
        $this->where("tblarea.IdDpto", $idDepartamento);
        $this->where("tblarea.Estado", "A");
        
        $datos = $this->findAll();
        return $datos;
    }
}