<?php

namespace App\Libraries;

class Scripts {

    public function __construct(){
		$this->items['baseUrl'] = base_url();        
    }

    public function crearContrasena(){
        //Carácteres para la contraseña
        $str = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
        $password = "";
        //Reconstruimos la contraseña segun la longitud que se quiera
        for($i=0;$i<8;$i++) {
           //obtenemos un caracter aleatorio escogido de la cadena de caracteres
           $password .= substr($str,rand(0,62),1); 
        }
        //Mostramos la contraseña generada
        return $password;           
    }
        
    public function crearCodigo($longitud) {
        $key = '';
        $pattern = '1234567890abcdefghijklmnopqrstuvwxyz';
        $max = strlen($pattern)-1;
        for($i=0;$i < $longitud;$i++) $key .= $pattern[mt_rand(0,$max)];
        return strtolower($key);
    }  

    public function correoBienvenida($correoElectronico,$usuario,$contrasena){
        $to = $correoElectronico;
        //$to = 'ricardobarcena.c@gmail.com';
        $subject = '¡Bienvenido!';              
        $message = '
            <html>
                <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700&display=swap" rel="stylesheet">
                </head>
                <body style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400;">

                    <!-- Hero Start -->
                    <div style="margin-top: 50px;">
                        <table cellpadding="0" cellspacing="0" style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400; max-width: 600px; border: none; margin: 0 auto; border-radius: 6px; overflow: hidden; background-color: #fff; box-shadow: 0 0 3px rgba(60, 72, 88, 0.15);">
                            <thead>
                                <tr style="background-color: #3b7ec1 !important; border: none; line-height: 68px; text-align: center; color: #fff; font-size: 24px; letter-spacing: 1px;">
                                    <th scope="col" style="padding: 20px 0; "><img src="http://localhost/smartdollar/public/images/logo-light-big.png" width="20%" alt=""></th>
                                </tr>
                            </thead>
                
                            <tbody>
                                <tr>
                                    <td style="padding: 48px 24px 0; color: #161c2d; font-size: 18px; font-weight: 600;">
                                        ¡Hola '.$correoElectronico.'!
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        ¡Gracias por registrarte en SmartDollar! A continuación te brindamos tus datos de acceso a la plataforma:
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        <b>USUARIO </b>:'.$usuario.'<br/>
                                        <b>CONTRASEÑA </b>: '.$contrasena.'
                                    </td>
                                </tr> 
                                <tr style="text-align: center">
                                    <td style="padding: 15px 24px;">
                                        <a href="'.base_url().'/nueva-operacion/" style="padding: 8px 20px; outline: none; text-decoration: none; font-size: 16px; letter-spacing: 0.5px; transition: all 0.3s; font-weight: 600; border-radius: 6px; background-color: #3b7ec1; border: 1px solid #3b7ec1; color: #ffffff;">Nueva Operación</a>
                                    </td>
                                </tr>                                              
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Atentamente <br> Equipo de SmartDollar
                                    </td>
                                </tr>                
                                <tr>
                                    <td style="padding: 16px 8px; color: #8492a6; background-color: #f8f9fc; text-align: center;">
                                        © '.date("Y").' Destinos & Cargas.
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- Hero End -->
                </body>
            </html>';
            //$filepath = 'public/assets/files/form_pep.pdf';
            $email = \Config\Services::email();
            $email->setTo($to);
            $email->setFrom('administrador@destinosycargas.com','Contacto Destinos & Cargas');
            $email->setSubject($subject);
            $email->setMessage($message);
            //$email->attach($filepath);
            $email->send();
    }

    public function correoConfirmacionIngreso($listaUsuarios){
        $to = $correoElectronico;
        //$to = 'ricardobarcena.c@gmail.com';
        $subject = '¡Pago confirmado!';              
        $message = '
            <html>
                <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700&display=swap" rel="stylesheet">
                </head>
                <body style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400;">

                    <!-- Hero Start -->
                    <div style="margin-top: 50px;">
                        <table cellpadding="0" cellspacing="0" style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400; max-width: 600px; border: none; margin: 0 auto; border-radius: 6px; overflow: hidden; background-color: #fff; box-shadow: 0 0 3px rgba(60, 72, 88, 0.15);">
                            <thead>
                                <tr style="background-color: #3b7ec1 !important; border: none; line-height: 68px; text-align: center; color: #fff; font-size: 24px; letter-spacing: 1px;">
                                    <th scope="col" style="padding: 20px 0; "><img src="http://localhost/smartdollar/public/images/logo-light-big.png" width="20%" alt=""></th>
                                </tr>
                            </thead>
                
                            <tbody>
                                <tr>
                                    <td style="padding: 48px 24px 0; color: #161c2d; font-size: 18px; font-weight: 600;">
                                        ¡Hola '.$listaUsuarios[0]['nombres'].'!
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        ¡Te informamos que tu pago ha sido aprobado! A partir de hoy puedes ingresar a nuestro sistema.
                                    </td>
                                </tr>                                            
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Atentamente <br> Equipo de Destinos & Cargas
                                    </td>
                                </tr>                
                                <tr>
                                    <td style="padding: 16px 8px; color: #8492a6; background-color: #f8f9fc; text-align: center;">
                                        © '.date("Y").' Destinos & Cargas.
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- Hero End -->
                </body>
            </html>';
            //$filepath = 'public/assets/files/form_pep.pdf';
            //echo($message);exit;
            $email = \Config\Services::email();
            $email->setTo($to);
            $email->setFrom('administrador@destinosycargas.com','Contacto Destinos & Cargas');
            $email->setSubject($subject);
            $email->setMessage($message);
            //$email->attach($filepath);
            $email->send();
    }    

    public function correoServicioRegistrado($codigoOperacion, $correo, $nombres, $apellidos){
        $to = $correo;
        //$to = 'ricardobarcena.c@gmail.com';
        $subject = 'Nuevo servicio registrado - '.$codigoOperacion;       
        $estilo = 'font-family: Arial; font-size: 11pt; text-align: justify; color:#1b1001';        
        $message = '
            <html>
                <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700&display=swap" rel="stylesheet">
                </head>
                <body style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400;">

                    <!-- Hero Start -->
                    <div style="margin-top: 50px;">
                        <table cellpadding="0" cellspacing="0" style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400; max-width: 600px; border: none; margin: 0 auto; border-radius: 6px; overflow: hidden; background-color: #fff; box-shadow: 0 0 3px rgba(60, 72, 88, 0.15);">
                            <thead>
                                <tr style="background-color: #3b7ec1 !important; border: none; line-height: 68px; text-align: center; color: #fff; font-size: 24px; letter-spacing: 1px;">
                                    <th scope="col" style="padding: 20px 0; "><img src="'.base_url().'/public/dashboard/assets/images/logo-light.png" width="20%" alt=""></th>
                                </tr>
                            </thead>
                
                            <tbody>
                                <tr>
                                    <td style="padding: 48px 24px 0; color: #161c2d; font-size: 18px; font-weight: 600;">
                                        ¡Hola '.$nombres.'!
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Gracias por confiar en nosotros, te enviamos el resumen de la operación:
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        <b>Código de Operación</b>: '.$datosSolicitud[0]['codigo_operacion'].'<br/>
                                        <b>Solicitante</b>: '.$nombres.' '.$apellidos.'<br/>
                                        <b>Fecha de registro</b>: '.date("d-m-Y H:i:s").'
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Puedes ingresar al siguiente enlace y revisar más detalles de la operación
                                    </td>
                                </tr>      
                                <tr style="text-align: center">
                                    <td style="padding: 15px 24px;">
                                        <a href="'.base_url().'/ver-solicitud/'.$codigoOperacion.'" style="padding: 8px 20px; outline: none; text-decoration: none; font-size: 16px; letter-spacing: 0.5px; transition: all 0.3s; font-weight: 600; border-radius: 6px; background-color: #3b7ec1; border: 1px solid #3b7ec1; color: #ffffff;">Ver detalle de la orden</a>
                                    </td>
                                </tr>                                              
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Atentamente <br> Equipo de Destinos & Cargas
                                    </td>
                                </tr>                
                                <tr>
                                    <td style="padding: 16px 8px; color: #8492a6; background-color: #f8f9fc; text-align: center;">
                                        © '.date("Y").' Destinos & Cargas.
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- Hero End -->
                </body>
            </html>';
            //$filepath = 'public/assets/files/form_pep.pdf';
            //echo($message);exit;
            $email = \Config\Services::email();
            $email->setTo($to);
            $email->setFrom('administrador@destinosycargas.com','Contacto Destinos & Cargas');
            $email->setSubject($subject);
            $email->setMessage($message);
            //$email->attach($filepath);
            $email->send();
    }

    public function correoNuevoServicioClienteCarga($datosSolicitud, $datosSolicitante, $datosTransportista, $datosVehiculo){
        $to = $datosSolicitante[0]['correo'];
        //$to = 'ricardobarcena.c@gmail.com';
        $subject = 'Nuevo servicio registrado - '.$datosSolicitud[0]['codigo_operacion'];       
        $estilo = 'font-family: Arial; font-size: 11pt; text-align: justify; color:#1b1001';        
        $message = '
            <html>
                <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700&display=swap" rel="stylesheet">
                </head>
                <body style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400;">

                    <!-- Hero Start -->
                    <div style="margin-top: 50px;">
                        <table cellpadding="0" cellspacing="0" style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400; max-width: 600px; border: none; margin: 0 auto; border-radius: 6px; overflow: hidden; background-color: #fff; box-shadow: 0 0 3px rgba(60, 72, 88, 0.15);">
                            <thead>
                                <tr style="background-color: #3b7ec1 !important; border: none; line-height: 68px; text-align: center; color: #fff; font-size: 24px; letter-spacing: 1px;">
                                    <th scope="col" style="padding: 20px 0; "><img src="'.base_url().'/public/dashboard/assets/images/logo-light.png" width="20%" alt=""></th>
                                </tr>
                            </thead>
                
                            <tbody>
                                <tr>
                                    <td style="padding: 48px 24px 0; color: #161c2d; font-size: 18px; font-weight: 600;">
                                        ¡Hola '.$datosSolicitante[0]['nombres'].'!
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Gracias por confiar en nosotros, te enviamos el resumen de la operación:
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        <b>Código de Operación</b>: '.$datosSolicitud[0]['codigo_operacion'].'<br/>
                                        <b>Solicitante</b>: '.$datosSolicitante[0]['nombres'].' '.$datosSolicitante[0]['apellidos'].'<br/>
                                        <b>Transportista</b>: '.$datosTransportista[0]['nombres'].' '.$datosTransportista[0]['apellidos'].'<br/>
                                        <b>Fecha estimada de inicio de servicio</b>: '.date("d-m-Y",strtotime($datosTransportista[0]['fecha_estimada_servicio'])).'<br/>
                                        <b>Monto</b>: S/ '.$datosSolicitud[0]['monto'].'<br/>
                                        <b>Método de Pago</b>: '.$datosSolicitud[0]['metodo_pago'].'<br/>
                                        <b>Fecha y hora de la transacción</b>: '.date("d-m-Y H:i:s").'
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Puedes ingresar al siguiente enlace y revisar más detalles de la operación
                                    </td>
                                </tr>      
                                <tr style="text-align: center">
                                    <td style="padding: 15px 24px;">
                                        <a href="'.base_url().'/ver-solicitud/'.$datosSolicitud[0]['codigo_operacion'].'" style="padding: 8px 20px; outline: none; text-decoration: none; font-size: 16px; letter-spacing: 0.5px; transition: all 0.3s; font-weight: 600; border-radius: 6px; background-color: #3b7ec1; border: 1px solid #3b7ec1; color: #ffffff;">Ver detalle de la orden</a>
                                    </td>
                                </tr>                                              
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Atentamente <br> Equipo de Destinos & Cargas
                                    </td>
                                </tr>                
                                <tr>
                                    <td style="padding: 16px 8px; color: #8492a6; background-color: #f8f9fc; text-align: center;">
                                        © '.date("Y").' Destinos & Cargas.
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- Hero End -->
                </body>
            </html>';
            //$filepath = 'public/assets/files/form_pep.pdf';
            //echo($message);exit;
            $email = \Config\Services::email();
            $email->setTo($to);
            $email->setFrom('administrador@destinosycargas.com','Contacto Destinos & Cargas');
            $email->setSubject($subject);
            $email->setMessage($message);
            //$email->attach($filepath);
            $email->send();
    }   

    public function correoNuevoServicioTransportista($datosSolicitud, $datosSolicitante, $datosTransportista, $datosVehiculo){
        $to = $datosTransportista[0]['correo'];
        //$to = 'ricardobarcena.c@gmail.com';
        $subject = 'Nuevo servicio registrado - '.$datosSolicitud[0]['codigo_operacion'];       
        $estilo = 'font-family: Arial; font-size: 11pt; text-align: justify; color:#1b1001';        
        $message = '
            <html>
                <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700&display=swap" rel="stylesheet">
                </head>
                <body style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400;">

                    <!-- Hero Start -->
                    <div style="margin-top: 50px;">
                        <table cellpadding="0" cellspacing="0" style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400; max-width: 600px; border: none; margin: 0 auto; border-radius: 6px; overflow: hidden; background-color: #fff; box-shadow: 0 0 3px rgba(60, 72, 88, 0.15);">
                            <thead>
                                <tr style="background-color: #3b7ec1 !important; border: none; line-height: 68px; text-align: center; color: #fff; font-size: 24px; letter-spacing: 1px;">
                                    <th scope="col" style="padding: 20px 0; "><img src="'.base_url().'/public/dashboard/assets/images/logo-light.png" width="20%" alt=""></th>
                                </tr>
                            </thead>
                
                            <tbody>
                                <tr>
                                    <td style="padding: 48px 24px 0; color: #161c2d; font-size: 18px; font-weight: 600;">
                                        ¡Hola '.$datosTransportista[0]['nombres'].'!
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                    Te informamos que tienes un nuevo servicio confirmado, adjuntamos los detalles:
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        <b>Código de Operación</b>: '.$datosSolicitud[0]['codigo_operacion'].'<br/>
                                        <b>Solicitante</b>: '.$datosSolicitante[0]['nombres'].' '.$datosSolicitante[0]['apellidos'].'<br/>
                                        <b>Transportista</b>: '.$datosTransportista[0]['nombres'].' '.$datosTransportista[0]['apellidos'].'<br/>
                                        <b>Fecha estimada de inicio de servicio</b>: '.date("d-m-Y",strtotime($datosTransportista[0]['fecha_estimada_servicio'])).'<br/>
                                        <b>Monto</b>: S/ '.$datosSolicitud[0]['monto'].'<br/>
                                        <b>Método de Pago</b>: '.$datosSolicitud[0]['metodo_pago'].'<br/>
                                        <b>Fecha y hora de la transacción</b>: '.date("d-m-Y H:i:s").'
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Puedes ingresar al siguiente enlace y revisar más detalles de la operación
                                    </td>
                                </tr>      
                                <tr style="text-align: center">
                                    <td style="padding: 15px 24px;">
                                        <a href="'.base_url().'/ver-solicitud/'.$datosSolicitud[0]['codigo_operacion'].'" style="padding: 8px 20px; outline: none; text-decoration: none; font-size: 16px; letter-spacing: 0.5px; transition: all 0.3s; font-weight: 600; border-radius: 6px; background-color: #3b7ec1; border: 1px solid #3b7ec1; color: #ffffff;">Ver detalle de la orden</a>
                                    </td>
                                </tr>                                              
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Atentamente <br> Equipo de Destinos & Cargas
                                    </td>
                                </tr>                
                                <tr>
                                    <td style="padding: 16px 8px; color: #8492a6; background-color: #f8f9fc; text-align: center;">
                                        © '.date("Y").' Destinos & Cargas.
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- Hero End -->
                </body>
            </html>';
            //$filepath = 'public/assets/files/form_pep.pdf';
            //echo($message);exit;
            $email = \Config\Services::email();
            $email->setTo($to);
            $email->setFrom('administrador@destinosycargas.com','Contacto Destinos & Cargas');
            $email->setSubject($subject);
            $email->setMessage($message);
            //$email->attach($filepath);
            $email->send();
    }

    public function correoInicioServicio($datosSolicitud, $datosSolicitante, $datosTransportista, $datosVehiculo){

        $to = $datosSolicitante[0]['correo'];
        //$to = 'ricardobarcena.c@gmail.com';
        $subject = 'Servicio '.$datosSolicitud[0]['codigo_operacion'].' iniciado';       
        $estilo = 'font-family: Arial; font-size: 11pt; text-align: justify; color:#1b1001';        
        $message = '
            <html>
                <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700&display=swap" rel="stylesheet">
                </head>
                <body style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400;">

                    <!-- Hero Start -->
                    <div style="margin-top: 50px;">
                        <table cellpadding="0" cellspacing="0" style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400; max-width: 600px; border: none; margin: 0 auto; border-radius: 6px; overflow: hidden; background-color: #fff; box-shadow: 0 0 3px rgba(60, 72, 88, 0.15);">
                            <thead>
                                <tr style="background-color: #3b7ec1 !important; border: none; line-height: 68px; text-align: center; color: #fff; font-size: 24px; letter-spacing: 1px;">
                                    <th scope="col" style="padding: 20px 0; "><img src="'.base_url().'/public/dashboard/assets/images/logo-light.png" width="20%" alt=""></th>
                                </tr>
                            </thead>
                
                            <tbody>
                                <tr>
                                    <td style="padding: 48px 24px 0; color: #161c2d; font-size: 18px; font-weight: 600;">
                                        ¡Hola '.$datosSolicitante[0]['nombres'].'!
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Te informamos que el chofer '.$datosTransportista[0]['nombres'].' '.$datosTransportista[0]['apellidos'].' ha iniciado el servicio
                                        '.$datosSolicitud[0]['codigo_operacion'].'
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        <b>Código de Operación</b>: '.$datosSolicitud[0]['codigo_operacion'].'<br/>
                                        <b>Solicitante</b>: '.$datosSolicitante[0]['nombres'].' '.$datosSolicitante[0]['apellidos'].'<br/>
                                        <b>Transportista</b>: '.$datosTransportista[0]['nombres'].' '.$datosTransportista[0]['apellidos'].'<br/>
                                        <b>Monto</b>: S/ '.$datosSolicitud[0]['monto'].'<br/>
                                        <b>Método de Pago</b>: '.$datosSolicitud[0]['metodo_pago'].'<br/>
                                        <b>Fecha y hora del inicio de servicio</b>: '.date("d-m-Y",strtotime($datosSolicitud[0]['fecha_inicio_ruta'])).'
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Puedes ingresar al siguiente enlace y revisar más detalles de la operación
                                    </td>
                                </tr>      
                                <tr style="text-align: center">
                                    <td style="padding: 15px 24px;">
                                        <a href="'.base_url().'/ver-solicitud/'.$datosSolicitud[0]['codigo_operacion'].'" style="padding: 8px 20px; outline: none; text-decoration: none; font-size: 16px; letter-spacing: 0.5px; transition: all 0.3s; font-weight: 600; border-radius: 6px; background-color: #3b7ec1; border: 1px solid #3b7ec1; color: #ffffff;">Ver detalle de la orden</a>
                                    </td>
                                </tr>                                              
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Atentamente <br> Equipo de Destinos & Cargas
                                    </td>
                                </tr>                
                                <tr>
                                    <td style="padding: 16px 8px; color: #8492a6; background-color: #f8f9fc; text-align: center;">
                                        © '.date("Y").' Destinos & Cargas.
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- Hero End -->
                </body>
            </html>';
            //$filepath = 'public/assets/files/form_pep.pdf';
            //echo($message);exit;
            $email = \Config\Services::email();
            $email->setTo($to);
            $email->setFrom('administrador@destinosycargas.com','Contacto Destinos & Cargas');
            $email->setSubject($subject);
            $email->setMessage($message);
            //$email->attach($filepath);
            $email->send();
    }

    public function correoFinalizacionServicio($datosSolicitud, $datosSolicitante, $datosTransportista, $datosVehiculo){

        $to = $datosSolicitante[0]['correo'];
        //$to = 'ricardobarcena.c@gmail.com';
        $subject = 'Servicio '.$datosSolicitud[0]['codigo_operacion'].' finalizado';       
        $estilo = 'font-family: Arial; font-size: 11pt; text-align: justify; color:#1b1001';        
        $message = '
            <html>
                <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700&display=swap" rel="stylesheet">
                </head>
                <body style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400;">

                    <!-- Hero Start -->
                    <div style="margin-top: 50px;">
                        <table cellpadding="0" cellspacing="0" style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400; max-width: 600px; border: none; margin: 0 auto; border-radius: 6px; overflow: hidden; background-color: #fff; box-shadow: 0 0 3px rgba(60, 72, 88, 0.15);">
                            <thead>
                                <tr style="background-color: #3b7ec1 !important; border: none; line-height: 68px; text-align: center; color: #fff; font-size: 24px; letter-spacing: 1px;">
                                    <th scope="col" style="padding: 20px 0; "><img src="'.base_url().'/public/dashboard/assets/images/logo-light.png" width="20%" alt=""></th>
                                </tr>
                            </thead>
                
                            <tbody>
                                <tr>
                                    <td style="padding: 48px 24px 0; color: #161c2d; font-size: 18px; font-weight: 600;">
                                        ¡Hola '.$datosSolicitante[0]['nombres'].'!
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Te informamos que el chofer '.$datosTransportista[0]['nombres'].' '.$datosTransportista[0]['apellidos'].' ha finalizado el servicio
                                        '.$datosSolicitud[0]['codigo_operacion'].'
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        <b>Código de Operación</b>: '.$datosSolicitud[0]['codigo_operacion'].'<br/>
                                        <b>Solicitante</b>: '.$datosSolicitante[0]['nombres'].' '.$datosSolicitante[0]['apellidos'].'<br/>
                                        <b>Transportista</b>: '.$datosTransportista[0]['nombres'].' '.$datosTransportista[0]['apellidos'].'<br/>
                                        <b>Monto</b>: S/ '.$datosSolicitud[0]['monto'].'<br/>
                                        <b>Método de Pago</b>: '.$datosSolicitud[0]['metodo_pago'].'<br/>
                                        <b>Fecha y hora del inicio de servicio</b>: '.date("d-m-Y",strtotime($datosSolicitud[0]['fecha_inicio_ruta'])).'<br/>
                                        <b>Fecha y hora final de servicio</b>: '.date("d-m-Y",strtotime($datosSolicitud[0]['fecha_final_solicitud'])).'
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Puedes ingresar al siguiente enlace y revisar más detalles de la operación
                                    </td>
                                </tr>      
                                <tr style="text-align: center">
                                    <td style="padding: 15px 24px;">
                                        <a href="'.base_url().'/ver-solicitud/'.$datosSolicitud[0]['codigo_operacion'].'" style="padding: 8px 20px; outline: none; text-decoration: none; font-size: 16px; letter-spacing: 0.5px; transition: all 0.3s; font-weight: 600; border-radius: 6px; background-color: #3b7ec1; border: 1px solid #3b7ec1; color: #ffffff;">Ver detalle de la orden</a>
                                    </td>
                                </tr>                                              
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Atentamente <br> Equipo de Destinos & Cargas
                                    </td>
                                </tr>                
                                <tr>
                                    <td style="padding: 16px 8px; color: #8492a6; background-color: #f8f9fc; text-align: center;">
                                        © '.date("Y").' Destinos & Cargas.
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- Hero End -->
                </body>
            </html>';
            //$filepath = 'public/assets/files/form_pep.pdf';
            //echo($message);exit;
            $email = \Config\Services::email();
            $email->setTo($to);
            $email->setFrom('administrador@destinosycargas.com','Contacto Destinos & Cargas');
            $email->setSubject($subject);
            $email->setMessage($message);
            //$email->attach($filepath);
            $email->send();
    }   
     
    public function correoRecuperacionUsuario($correoElectronico, $nombres, $token ,$fechaCaducidad){
        $to = $correoElectronico;
        //$to = 'ricardobarcena.c@gmail.com';
        $subject = 'Solicitud de Recuperación de contraseña';       
        $enlace = $this->items['baseUrl'] . '/recuperar';
        $estilo = 'font-family: Arial; font-size: 11pt; text-align: justify; color:#1b1001';        
        $message = '
            <html>
                <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700&display=swap" rel="stylesheet">
                </head>
                <body style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400;">

                    <!-- Hero Start -->
                    <div style="margin-top: 50px;">
                        <table cellpadding="0" cellspacing="0" style="font-family: Nunito, sans-serif; font-size: 15px; font-weight: 400; max-width: 600px; border: none; margin: 0 auto; border-radius: 6px; overflow: hidden; background-color: #fff; box-shadow: 0 0 3px rgba(60, 72, 88, 0.15);">
                            <thead>
                                <tr style="background-color: #3b7ec1 !important; border: none; line-height: 68px; text-align: center; color: #fff; font-size: 24px; letter-spacing: 1px;">
                                    <th scope="col" style="padding: 20px 0; "><img src="http://localhost/smartdollar/public/images/logo-light-big.png" width="20%" alt=""></th>
                                </tr>
                            </thead>
                
                            <tbody>
                                <tr>
                                    <td style="padding: 48px 24px 0; color: #161c2d; font-size: 18px; font-weight: 600;">
                                        ¡Hola '.$nombre.'!
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Este correo es para confirmar que has solicitado tu recuperación de contraseña.
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Te pedimos ingresar al siguiente <a href="'.$enlace.'">enlace</a> para recuperarla.<br/>
                                        Recuerda ingresar el siguiente token 
                                                        para poder recuperar tu contraseña : '.$token.' y este caduca el 
                                                        <b style="color: red">'.date("d-m-Y H:i:s",strtotime($fechaCaducidad)).'</b>, luego de ello deberás pedir uno nuevo.
                                    </td>
                                </tr>                                             
                                <tr>
                                    <td style="padding: 15px 24px 15px; color: #8492a6;">
                                        Atentamente <br> Equipo de Destinos & Cargas
                                    </td>
                                </tr>                
                                <tr>
                                    <td style="padding: 16px 8px; color: #8492a6; background-color: #f8f9fc; text-align: center;">
                                        © '.date("Y").' Destinos & Cargas.
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- Hero End -->
                </body>
            </html>';
            //$filepath = 'public/assets/files/form_pep.pdf';
            //echo($message);exit;
            $email = \Config\Services::email();
            $email->setTo($to);
            $email->setFrom('administrador@smartdollar.pe','Contacto Destinos & Cargas');
            $email->setSubject($subject);
            $email->setMessage($message);
            //$email->attach($filepath);
            $email->send();
            //echo($email->printDebugger(['headers'])); exit;
            //var_dump($email->send());exit;
    }
    
    public function dias_pasados($fecha_inicial,$fecha_final) {
        $dias = (strtotime($fecha_inicial)-strtotime($fecha_final))/86400;
        $dias = abs($dias); $dias = floor($dias);
        return $dias;
    }

    public function convertirDias($sum) {
        $years = ($sum / 365) ;
        $years = floor($years); 
        $month = ($sum % 365) / 30.5;
        $month = floor($month);
        $days =($sum % 365) % (30.5 * $month);
        // $days = ($sum % 365) % 30.5; // the rest of days

        // Echo all information set
        //echo 'DAYS RECEIVE : '.$sum.' days<br>';
        $tiempo = $years.' años - '.$month.' meses - '.$days.' días';
        return $tiempo;
    }   
    
    public function mail_attachment($para, $copia, $asunto, $mensaje, $archivos) {
        // Recipient 
        $to = $para; 

        // Sender 
        $from = 'hrinformesp@indracompany.com'; 
        $fromName = 'Usuario Genérico Administración de Personal'; 

        // Email subject 
        $subject = $asunto;

        // Attachment file 
        $files = $archivos; 

        // Email body content 
        /*$htmlContent = ' 
            <h3>PHP Email with Attachment by CodexWorld</h3> 
            <p>This email is sent from the PHP script with attachment.</p> 
        ';*/
        $htmlContent = $mensaje;
        
        // Header for sender info 
        $headers = "From: $fromName"." <".$from.">";
        $headers .= "\nCc: ".$copia;    

        // Boundary  
        $semi_rand = md5(time());  
        $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";  

        // Headers for attachment  
        $headers .= "\nMIME-Version: 1.0\n" . "Content-Type: multipart/mixed;\n" . " boundary=\"{$mime_boundary}\""; 

        // Multipart boundary  
        $message = "--{$mime_boundary}\n" . "Content-Type: text/html; charset=\"UTF-8\"\n" . 
        "Content-Transfer-Encoding: 7bit\n\n" . $htmlContent . "\n\n";  

        // Preparing attachment 

        if(count($files) > 0){
            for($i=0;$i<count($files);$i++){
                if(is_file($files[$i])){
                    $message .= "--{$mime_boundary}\n";
                    $fp =    @fopen($files[$i],"rb");
                    $data =  @fread($fp,filesize($files[$i]));
                    @fclose($fp);
                    $data = chunk_split(base64_encode($data));
                    $message .= "Content-Type: application/octet-stream; name=\"".basename($files[$i])."\"\n" . 
                    "Content-Description: ".basename($files[$i])."\n" .
                    "Content-Disposition: attachment;\n" . " filename=\"".basename($files[$i])."\"; size=".filesize($files[$i]).";\n" . 
                    "Content-Transfer-Encoding: base64\n\n" . $data . "\n\n";
                }
            }                
        } 
        $message .= "--{$mime_boundary}--"; 
        $returnpath = "-f" . $from; 

        // Send email 
        $mail = mail($to, $subject, $message, $headers, $returnpath);  

        // Email sending status 
        //echo $mail?var_dump("Email Sent Successfully!</h1>"):var_dump("Email Sent failed!</h1>");
    }    

    public function busca_edad($fecha_nacimiento){
        $dia=date("d");
        $mes=date("m");
        $ano=date("Y");

        $dianaz=date("d",strtotime($fecha_nacimiento));
        $mesnaz=date("m",strtotime($fecha_nacimiento));
        $anonaz=date("Y",strtotime($fecha_nacimiento));

        if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano=($ano-1); }

        if ($mesnaz > $mes) {
        $ano=($ano-1);}

        $edad=($ano-$anonaz);
        return $edad;
    }    

    public function scriptVistaGeneral() {
        /*
         * ----------------------------
         * CONFIGURACION DE INSTALACIÓN
         * ----------------------------
         */
        $obtieneConfiguracion = $this->ci->m_configuracion->mostrarDatos(array('interna' => 'instalacion'));
        $valores = json_decode($obtieneConfiguracion[0]->atributos);
        $this->items['insIntentoError'] = (isset($valores->intentoError)) ? $valores->intentoError : 3;
        $this->items['insTiempoBloqueo'] = (isset($valores->tiempoBloqueo)) ? $valores->tiempoBloqueo : 1;
        $this->items['insDuracionCaptcha'] = (isset($valores->duracionCaptcha)) ? $valores->duracionCaptcha : 240;
        $this->items['insClaveMaestra'] = (isset($valores->claveMaestra)) ? $valores->claveMaestra : 'lacaldas';
        $this->items['insEncriptacionSesion'] = (isset($valores->encriptacionSesion)) ? $valores->encriptacionSesion : '83fdfdc18845e48d5fe3b0ee4073418f';
        $this->items['insFtpActivo'] = (isset($valores->ftpActivo)) ? $valores->ftpActivo : FALSE;
        $this->items['insFtpDireccion'] = (isset($valores->ftpDireccion)) ? $valores->ftpDireccion : 'ftp.aplicacioneswebs.com';
        $this->items['insFtpUbicacion'] = (isset($valores->ftpUbicacion)) ? $valores->ftpUbicacion : 'sub';
        $this->items['insFtpUsuario'] = (isset($valores->ftpUsuario)) ? $valores->ftpUsuario : 'katylor';
        $this->items['insFtpClave'] = (isset($valores->ftpClave)) ? $valores->ftpClave : 'shinomegami1';
        $this->items['insFtpPuerto'] = (isset($valores->ftpPuerto)) ? $valores->ftpPuerto : 21;
        /*
         * ---------------------------------
         * CONFIGURACION GENERAL DEL SISTEMA
         * ---------------------------------
         */
        $obtieneConfiguracion = $this->ci->m_configuracion->mostrarDatos(array('interna' => 'sistema'));
        $valores = json_decode($obtieneConfiguracion[0]->atributos);
        $this->items['sisInfoTituloEmpresa'] = (isset($valores->sisInfoTituloEmpresa)) ? $valores->sisInfoTituloEmpresa : 'SISTEMA';
        $this->items['sisInfoNombreEmpresa'] = (isset($valores->sisInfoNombreEmpresa)) ? $valores->sisInfoNombreEmpresa : 'SISTEMA';
        $this->items['sisInfoCorreo'] = (isset($valores->sisInfoCorreo)) ? $valores->sisInfoCorreo : 'lacaldas.octubre@gmail.com';
        $this->items['sisInfoDireccion'] = (isset($valores->sisInfoDireccion)) ? $valores->sisInfoDireccion : 'Sin dirección';
        $this->items['sisImagenFondo'] = (isset($valores->sisImagenFondo) && $valores->sisImagenFondo != '') ? $valores->sisImagenFondo : 'sisFondoDefecto.png';
        $this->items['sisFavicon'] = (isset($valores->sisFavicon) && $valores->sisFavicon != '') ? $valores->sisFavicon : 'sisFaviconDefecto.png';
        $this->items['sisLogoPrincipal'] = (isset($valores->sisLogoPrincipal) && $valores->sisLogoPrincipal != '') ? $valores->sisLogoPrincipal : 'sisLogoDefecto.png';
        $this->items['sisMarcaAgua'] = (isset($valores->sisMarcaAgua) && $valores->sisMarcaAgua != '') ? 'public/imagen/logo/' . $valores->sisMarcaAgua : 'public/imagen/logo/sisMarcaAgua.png';
        $this->items['sisPieDePagina'] = (isset($valores->sisPieDePagina)) ? $valores->sisPieDePagina : '(c) Copyright 2016 - José Chipana - Cel. 982462802';
        /*
         * ---------------------------------
         * CONFIGURACION DEFECTO DEL SISTEMA
         * ---------------------------------
         */
        $this->items['proyectoTitulo'] = $this->items['sisInfoTituloEmpresa'];
        $this->items['proyectoNombre'] = $this->items['sisInfoNombreEmpresa'];
        $this->items['proyectoFavicon'] = base_url() . 'crop/35/35/logo-' . $this->items['sisFavicon'];
        $this->items['proyectoLogo'] = base_url() . 'crop/42/42/logo-' . $this->items['sisLogoPrincipal'];
        $this->items['proyectoFondo'] = base_url() . 'public/imagen/logo/' . $this->items['sisImagenFondo'];
        $this->items['proyectoPieDePagina'] = $this->items['sisPieDePagina'];
        /*
         * ------------------------------
         * LISTADO DE IMAGENES DE GALERIA
         * ------------------------------
         */
        $galeriaXml_1 = array();
        $galeriaXml_2 = array();

        /*
         * -----------------------------------
         * RETORNA TODOS LOS VALORES OBTENIDOS
         * -----------------------------------
         */
        return $this->items;
    }

    public function abrirFtp() {
        $config['hostname'] = $this->items['insFtpDireccion'];
        $config['username'] = $this->items['insFtpUsuario'];
        $config['password'] = $this->items['insFtpClave'];
        $config['port'] = $this->items['insFtpPuerto'];
        $config['pasive'] = FALSE;
        $config['debug'] = TRUE;
        $this->ci->ftp->connect($config);
    }

    public function cerrarFtp() {
        $this->ci->ftp->close();
    }

    public function RestarfechasEstadoT($f1, $f2) {
        $strStart = $f1;
        $strEnd = $f2;

        $dteStart = new DateTime($strStart);
        $dteEnd = new DateTime($strEnd);
        $dteDiff = $dteStart->diff($dteEnd);

        $strStart2 = $f1;
        $strEnd2 = $f2;
        $fecha1 = strtotime($strStart2);
        $fecha2 = strtotime($strEnd2);
        $Contadordp = 0;
        for ($fecha1; $fecha1 <= $fecha2; $fecha1 = strtotime('+1 day ' . date('Y-m-d', $fecha1))) {
            if ((strcmp(date('D', $fecha1), 'Sun') != 0) and ( strcmp(date('D', $fecha1), 'Sat') != 0)) {
                $Contadordp = $Contadordp + 1;
            }
        }
        if ($Contadordp == 0) {
            return $Contadordp;
        }

//        return $dteDiff->format("%a días %H h %I min");
//        return $dteDiff->format("%a dias %H h %I min") . "|" . $dteDiff->format("%a|%H|%I");
        return $Contadordp - 1;
    }

    public function array_flatten($array) {
        if (!is_array($array)) {
            return FALSE;
        }
        $result = array();
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $result = array_merge($result, $this->array_flatten($value));
            } else {
                $result[$key] = $value;
            }
        }
        return $result;
    }

    public function validarFecha($fecha) {
        if ($fecha != '') {
            return $fecha;
        } else {
            return null;
        }
    }

    public function validarFechaN($fecha) {
        if ($fecha != '' && $fecha != '0000-00-00') {
            return $fecha;
        } else {
            return null;
        }
    }

    public function validarNumero($numero) {
        if ($numero != '') {
            return $numero;
        } else {
            return 0;
        }
    }

}
