<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Usuarios extends BaseController
{
	public function __construct(){
		$this->log = new \App\Models\UsuarioLogModel();
		
		$this->modulo = new \App\Models\ModuloModel();
		$this->usuarioModelo = new \App\Models\UsuarioModelo();
        $this->usuarioPerfil = new \App\Models\UsuarioPerfilModelo();
        $this->usuarioPermisos = new \App\Models\UsuarioPermisosModelo();
        $this->usuarioRutas = new \App\Models\UsuarioRutasModelo();
        $this->usuarioSistemas = new \App\Models\UsuarioSistemasModelo();
        $this->usuarioDelegaciones = new \App\Models\UsuarioDelegacionesModel();
        
        $this->cargos = new \App\Models\CargosModel();
        
        $this->estructuraDirecciones = new \App\Models\EstructuraDireccionModel();
        $this->estructuraAreas = new \App\Models\EstructuraAreaModel();
        $this->estructuraSubareas = new \App\Models\EstructuraSubareaModel();
        $this->estructuraSubareaDelegaciones = new \App\Models\EstructuraSubareaDelegacionesModel();
        $this->estructuraDelegaciones = new \App\Models\EstructuraDelegacionModel();
        
        $this->correoStatusUsuario = new \App\Models\CorreoStatusUsuarioModel();
	}

    public function listarUsuarioDataTable(){
        $orderBy = " ORDER BY ";

        foreach ($this->request->getGet('order') as $order) {
            $orderBy .= $order['column'] + 1 . " {$order['dir']}, ";
        }

        $orderBy = substr($orderBy, 0, -2);
        $columns = $this->request->getGet('columns');
        $fields = ['tblusuario.IdUsuario','nombre_usuario','tblusuario.Matricula','tblusuario.NumeroDoc','perfil_usuario','tblusuario.Usuario','tblusuario.Estado', 'sistemas','acciones_usuario'];
        $where = '';

        foreach ($columns as $k => $column) {
            if ($this->request->getGet('search')['value']!="") {
                if($k == 1)
                {
                    $where .= "CONCAT(tblusuario.Nombres, ' ', tblusuario.Apellidos) LIKE '%".$this->request->getGet('search')['value']."%' OR ";
                }
                else if($k == 4 || $k == 7 || $k == 8){}
                else
                {
                    $where .= $fields[$k]." LIKE '%".$this->request->getGet('search')['value']."%' OR ";
                }
                
            }
        }

        $where = substr($where, 0, -5);
        $length = $this->request->getGet('length');
        $start = $this->request->getGet('start'); 

        /* LISTAR ORDEN DE COMPRA */
        $listaUsuarios = $this->usuarioModelo->listaGeneralUsuario($orderBy,$where,$length,$start);
        echo json_encode($listaUsuarios, JSON_NUMERIC_CHECK);
    }

    public function importarCSVUsuarioFlota()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("fileCSVUsuarioFlota");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileCSVUsuarioFlota' => [
                'mime_in[fileCSVUsuarioFlota,text/csv,text/plain]',
                'ext_in[fileCSVUsuarioFlota,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 3);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");
        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $brevete        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $numplaca       = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");

                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                if($matricula == '' || $matricula == null)
                {
                    $filasError[$fila]['MATRICULA'] = "EL CAMPO MATRÍCULA ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['MATRICULA'] = "MATRICULA NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Brevete:
                $datosUsuarioBrevete = $this->usuarioModelo->where("brevete",trim($brevete))->first();
                
                if($brevete == '' || $brevete == null)
                {
                    $filasError[$fila]['BREVETE'] = "EL CAMPO BREVETE ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!empty($datosUsuarioBrevete))
                    {
                        $filasError[$fila]['BREVETE'] = "BREVETE YA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Placa:
                if($numplaca == '' || $numplaca == null)
                {
                    $filasError[$fila]['PLACA'] = "EL CAMPO PLACA ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!preg_match('/[A-Z0-9]{3}[0-9]{3}/',$numplaca))
                    {
                        $filasError[$fila]['PLACA'] = "FORMATO DE PLACA NO VÁLIDO";
                        $ejecutarInsert = false;
                    }
                }
                
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayUpdate = array();
        
        $filaUpdate = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filaUpdate++;
            if($filaUpdate > 1)
            {
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $brevete        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $numplaca       = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                
                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                
                //Armar array de Usuario y modificar datos:
                $arrayUpdate[] = array (
                    'IdUsuario'         => $datosUsuario['IdUsuario'], 
                    'brevete'           => $brevete, 
                    'numero_placa'      => $numplaca,
                    'UsuarioModifica'   => $this->items['id'],
                    'FechaModifica'     => $fechaActual,  
                    'Localhost'         => $this->request->getIPAddress()
                );

            }
        }

        fclose($handleInsert);

        $statusUpdate = $this->usuarioModelo->updateBatch($arrayUpdate, 'IdUsuario');
        
        if($statusUpdate !== FALSE){
            
            $url = $this->complementos->obtenerURLactual();
            
            $aud = array(
                'IDUsuario'     => $this->items['id'],
                'FechaIngreso'  => $fechaActual,
                'Plataforma'    => $url['raiz'],
                'URL'           => $url['ruta'],
                'JSON'          => null,
                'Localhost'     => $this->request->getIPAddress()
            );
            
            $this->log->insert($aud);
            
            $message = sprintf($this->mensajeError->msg201, "Se actualizacion el total de ".($filaUpdate - 1)." fila(s).");
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
            exit;
        }
    }
	
    public function importarCSVUsuarioIT()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("fileCSVUsuarioIT");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileCSVUsuarioIT' => [
                'mime_in[fileCSVUsuarioIT,text/csv,text/plain]',
                'ext_in[fileCSVUsuarioIT,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 2);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $usuario        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");

                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                if($matricula == '' || $matricula == null)
                {
                    $filasError[$fila]['MATRICULA'] = "EL CAMPO MATRÍCULA ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['MATRICULA'] = "MATRICULA NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Usuario:
                if($usuario == '' || $usuario == null)
                {
                    $filasError[$fila]['USUARIO'] = "EL CAMPO USUARIO ES NECESARIO";
                    $ejecutarInsert = false;
                }
                
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayUpdate = array();
        
        $filaUpdate = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filaUpdate++;
            if($filaUpdate > 1)
            {
                //Asignamos valores de CSV a variables locales
                $matricula  = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $usuario    = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $correo     = $usuario."@verisure.pe";    
                
                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                
                //Armar array de Usuario y modificar datos:
                $arrayUpdate[] = array (
                    'IdUsuario'         => $datosUsuario['IdUsuario'], 
                    'Usuario'           => $usuario, 
                    'Correo'            => $correo,
                    'UsuarioModifica'   => $this->items['id'],
                    'FechaModifica'     => $fechaActual,  
                    'Localhost'         => $this->request->getIPAddress()
                );

            }
        }

        fclose($handleInsert);

        $statusUpdate = $this->usuarioModelo->updateBatch($arrayUpdate, 'IdUsuario');
        
        if($statusUpdate !== FALSE){
            
            $url = $this->complementos->obtenerURLactual();
            
            $aud = array(
                'IDUsuario'     => $this->items['id'],
                'FechaIngreso'  => $fechaActual,
                'Plataforma'    => $url['raiz'],
                'URL'           => $url['ruta'],
                'JSON'          => null,
                'Localhost'     => $this->request->getIPAddress()
            );
            
            $this->log->insert($aud);
            
            $message = sprintf($this->mensajeError->msg201, "Se actualizacion el total de ".($filaUpdate - 1)." fila(s).");
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
            exit;
        }
    }
	
    public function importarCSVUsuario()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("fileCSVUsuario");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileCSVUsuario' => [
                'mime_in[fileCSVUsuario,text/csv,text/plain]',
                'ext_in[fileCSVUsuario,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 15);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $nombres        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $apellidos      = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $tipoDoc        = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $nroDoc         = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $cargo          = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $manager        = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $fechaIngreso   = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCese      = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $fte            = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $cc             = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $ln             = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $subarea        = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $area           = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $direccion      = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");

                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                if($matricula == '' && $matricula == null)
                {
                    $filasError[$fila]['MATRICULA'] = "EL CAMPO MATRICULA ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!empty($datosUsuario))
                    {
                        $filasError[$fila]['MATRICULA'] = "MATRICULA YA EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Nombres:
                if($nombres == '' && $nombres == null)
                {
                    $filasError[$fila]['NOMBRES'] = "EL CAMPO NOMBRES ES NECESARIO";
                    $ejecutarInsert = false;
                }
                
                //Validamos Apellidos:
                if($apellidos == '' && $apellidos == null)
                {
                    $filasError[$fila]['APELLIDOS'] = "EL CAMPO APELLIDOS ES NECESARIO";
                    $ejecutarInsert = false;
                }
                
                
                //Validamos existencia de Cargo:
                $datoscargo = $this->cargos->where("Cargo",ucwords(mb_strtolower($cargo)))->first();
                if(empty($datoscargo))
                {
                    $filasError[$fila]['CARGO'] = "CARGO NO EXISTE";
                    $ejecutarInsert = false;
                }

                //Validamos existencia de manager:
                if($manager != '')
                {
                    $datosManager = $this->usuarioModelo->where("Matricula",trim($manager))->first();
                    if(empty($datosManager))
                    {
                        $filasError[$fila]['MATRICULA MANAGER'] = "MATRICULA DE MANAGER NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Fecha ingreso:
                if($fechaIngreso == '')
                {
                    $filasError[$fila]['FECHA INGRESO'] = "LA FECHA DE INGRESO ES REQUERIDA.";
                    $ejecutarInsert = false;
                }
                
                //Validamos FTE:
                if(!is_numeric($fte) && $fte != null && $fte != '')
                {
                    $filasError[$fila]['FTE'] = "EL FTE INGRESADO NO ES UN NÚMERO.";
                    $ejecutarInsert = false;
                }
                
                //Validamos CC:
                if(!is_numeric($cc) && $cc != null && $cc != '')
                {
                    $filasError[$fila]['CC'] = "EL CC INGRESADO NO ES UN NÚMERO.";
                    $ejecutarInsert = false;
                }
                
                //Validamos LN:
                if(!is_numeric($ln) && $ln != null && $ln != '')
                {
                    $filasError[$fila]['LN'] = "LA LN INGRESADA NO ES UN NÚMERO.";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia delegacion:
                $whereDelegacion = array("CC" => $cc, "LN" => $ln);
                $datosDelegacion = $this->estructuraDelegaciones->where($whereDelegacion)->first();
                if(empty($datosDelegacion))
                {
                    $filasError[$fila]['CC - LN'] = "NO EXISTE DELEGACIÓN CON EL CC Y LA LN INGRESADA";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia subarea:
                $datosSubarea = $this->estructuraSubareas->obtenerSubareaXNombres($subarea, $area, $direccion);
                if(empty($datosSubarea))
                {
                    $filasError[$fila]['SUBAREA'] = "NO EXISTE LA SUBÁREA INGRESADA";
                    $ejecutarInsert = false;
                }
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayInsert = array();
        $arrayUpdate = array();
        
        $fila = 0;
        $filainsert = 0;
        $filaupdate = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $fila++;
            if($fila > 1)
            {
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $nombres        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $apellidos      = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $tipoDoc        = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $nroDoc         = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $cargo          = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $manager        = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $fechaIngreso   = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCese      = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $fte            = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $cc             = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $ln             = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $subarea        = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $area           = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $direccion      = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
                
                //Obtenemos información relevante
                $whereDelegacion = array("CC" => $cc, "LN" => $ln);
                
                $datosCargo = $this->cargos->where("Cargo",$cargo)->first();
                $datosManager = $this->usuarioModelo->where("Matricula",trim($manager))->first();
                $datosSubarea = $this->estructuraSubareas->obtenerSubareaXNombres($subarea, $area, $direccion);
                $datosDelegacion = $this->estructuraDelegaciones->where($whereDelegacion)->first();
                
                if(strtotime($fechaIngreso)=='' || strtotime($fechaIngreso)==0 || strtotime($fechaIngreso) == false)
                {
                    $fechaIngreso = date_create_from_format('j/m/Y', $fechaIngreso);
                    $fechaIngreso = date_format($fechaIngreso, 'Y-m-d');
                }
                else
                {
                    $fechaIngreso = date("Y-m-d", strtotime($fechaIngreso));
                }
                
                if($fechaCese != '' && $fechaCese != null)
                {
                    if(strtotime($fechaCese)=='' || strtotime($fechaCese)==0 || strtotime($fechaCese) == false)
                    {
                        $fechaCese = date_create_from_format('j/m/Y', $fechaCese);
                        $fechaCese = date_format($fechaCese, 'Y-m-d');
                    }
                    else
                    {
                        $fechaCese = date("Y-m-d", strtotime($fechaCese));
                    }
                }
                
                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                // if(!empty($datosUsuario))
                // {
                //     if($fechaCese != '' && $fechaCese != null)
                //     {
                //         //Armar array de Usuario y modificar datos:
                //         $arrayUpdate[] = array (
                //             'IdUsuario'         => $datosUsuario['IdUsuario'], 
                //             'Matricula'         => $matricula, 
                //             'Nombres'           => $nombres, 
                //             'Apellidos'         => $apellidos, 
                //             'TipoDocumento'     => $tipoDoc, 
                //             'NumeroDoc'         => $nroDoc, 
                //             'Cargo'             => $cargo, 
                //             'CC'                => $cc, 
                //             'LN'                => $ln, 
                //             'Manager'           => $manager, 
                //             'FechaIngreso'      => $fechaIngreso, 
                //             'FechaCese'         => $fechaCese,
                //             'FTE'               => $fte, 
                //             'IDCargo'           => $datosCargo['IDCargo'], 
                //             'IDManager'         => $datosManager['IdUsuario'], 
                //             'IDSubarea'         => $datosSubarea['IDSubarea'], 
                //             'IDDelegacion'      => $datosDelegacion['IDDelegacion'], 
                //             'UsuarioModifica'   => $this->items['id'],
                //             'FechaModifica'     => $fechaActual,  
                //             'Localhost'         => $this->request->getIPAddress(),
                //             'Estado'            => 'Cesado',
                //             'UsuarioEstado'     => $this->items['id'],
                //             'FechaEstado'       => $fechaActual,
                //             'MotivoEstado'      => 'Cesado por CSV masivo.'
                //         );
                //     }
                //     else
                //     {
                //         //Armar array de Usuario y modificar datos:
                //         $arrayUpdate[] = array (
                //             'IdUsuario'         => $datosUsuario['IdUsuario'], 
                //             'Matricula'         => $matricula, 
                //             'Nombres'           => $nombres, 
                //             'Apellidos'         => $apellidos, 
                //             'TipoDocumento'     => $tipoDoc, 
                //             'NumeroDoc'         => $nroDoc, 
                //             'Cargo'             => $cargo, 
                //             'CC'                => $cc, 
                //             'LN'                => $ln, 
                //             'Manager'           => $manager, 
                //             'FechaIngreso'      => $fechaIngreso,
                //             'FTE'               => $fte, 
                //             'IDCargo'           => $datosCargo['IDCargo'], 
                //             'IDManager'         => $datosManager['IdUsuario'], 
                //             'IDSubarea'         => $datosSubarea['IDSubarea'], 
                //             'IDDelegacion'      => $datosDelegacion['IDDelegacion'], 
                //             'UsuarioModifica'   => $this->items['id'],
                //             'FechaModifica'     => $fechaActual,  
                //             'Localhost'         => $this->request->getIPAddress()
                //         );
                //     }
                    
                //     $filaupdate++;
                // }
                // else
                // {
                    //Armar array de Usuario e insertar datos:
                    $arrayInsert[] = array (
                        'Matricula'         => $matricula, 
                        'Nombres'           => $nombres, 
                        'Apellidos'         => $apellidos, 
                        'TipoDocumento'     => $tipoDoc, 
                        'NumeroDoc'         => $nroDoc, 
                        'Cargo'             => $cargo, 
                        'CC'                => $cc, 
                        'LN'                => $ln, 
                        'Manager'           => $manager, 
                        'FechaIngreso'      => $fechaIngreso, 
                        'FTE'               => $fte, 
                        'FechaHoraREG'      => $fechaActual,
                        'IDCargo'           => $datosCargo['IDCargo'], 
                        'IDManager'         => empty($datosManager) ? null : $datosManager['IdUsuario'], 
                        'IDSubarea'         => $datosSubarea['IDSubarea'], 
                        'IDDelegacion'      => $datosDelegacion['IDDelegacion'], 
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,  
                        'Localhost'         => $this->request->getIPAddress(),    
                        'UsuarioEstado'     => $this->items['id'],
                        'FechaEstado'       => $fechaActual,
                        'MotivoEstado'      => "Alta de usuario masivo.",
                        'Estado'            => 'Activo'
                    );
                    
                    $filainsert++;
                // }
            }
        }

        fclose($handleInsert);
        
        $mensajeConfirmacion = '';

        $statusInsert = $this->usuarioModelo->insertBatch($arrayInsert);
        // $statusUpdate = $this->usuarioModelo->updateBatch($arrayUpdate, 'IdUsuario');
        
        if($statusInsert !== FALSE){
            $mensajeConfirmacion .= "Se registraron el total de ".$filainsert." fila(s).<br>";
            
            $url = $this->complementos->obtenerURLactual();
            
            $aud = array(
                'IDUsuario'     => $this->items['id'],
                'FechaIngreso'  => $fechaActual,
                'Plataforma'    => $url['raiz'],
                'URL'           => $url['ruta'],
                'JSON'          => null,
                'Localhost'     => $this->request->getIPAddress()
            );
            
            $this->log->insert($aud);
            
        }
        else {
            $mensajeConfirmacion .= "No se pudo realizar el registro solicitado. Inténtelo luego.<br>";
        }
        
        // if($statusUpdate !== FALSE){
        //     $mensajeConfirmacion .= "Se actualizaron el total de ".$filaupdate." fila(s).";
        // }
        // else {
        //     $mensajeConfirmacion .= "No se pudo realizar la actualización de los registros. Inténtelo luego.";
        // }
        
        $message = sprintf($this->mensajeError->msg201, $mensajeConfirmacion);
        echo $this->alertas->alertaExito($message);
        //echo $this->alertas->refrescar(1);
        exit;
    }
    
    public function exportarTotalUsuarios()
    {
        $listadoUsuario = $this->usuarioModelo->listaGeneralUsuarios(array());
        
        $filename = "usuarios.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        //$writer->setFieldDelimiter(';');
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Matrícula"),
            WriterEntityFactory::createCell("Nombres"),
            WriterEntityFactory::createCell("Apellidos"),
            WriterEntityFactory::createCell("Tipo de documento"),
            WriterEntityFactory::createCell("Nro de documento"),
            WriterEntityFactory::createCell("Cargo"),
            WriterEntityFactory::createCell("Matricula Jefe Inmediato"),
            WriterEntityFactory::createCell("Fecha Ingreso"),
            WriterEntityFactory::createCell("Fecha Cese"),
            WriterEntityFactory::createCell("FTE"),
            WriterEntityFactory::createCell("CC"),
            WriterEntityFactory::createCell("LN"),
            WriterEntityFactory::createCell("Subárea"),
            WriterEntityFactory::createCell("Área"),
            WriterEntityFactory::createCell("Dirección")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoUsuario as $key=>$item)
        {
            $ingreso = date("Y-m-d", strtotime($item['FechaIngreso']));
            $cese = date("Y-m-d", strtotime($item['FechaCese']));
			$cells = [
                WriterEntityFactory::createCell($item['Matricula']),
                WriterEntityFactory::createCell($item['Nombres']),
                WriterEntityFactory::createCell($item['Apellidos']),
                WriterEntityFactory::createCell($item['TipoDocumento']),
                WriterEntityFactory::createCell($item['NumeroDoc']),
                WriterEntityFactory::createCell($item['Cargo']),
                WriterEntityFactory::createCell($item['Matricula_Manager']),
                WriterEntityFactory::createCell($ingreso),
                WriterEntityFactory::createCell($cese),
                WriterEntityFactory::createCell($item['FTE']),
                WriterEntityFactory::createCell($item['CC']),
                WriterEntityFactory::createCell($item['LN']),
                WriterEntityFactory::createCell($item['Subarea']),
                WriterEntityFactory::createCell($item['Area']),
                WriterEntityFactory::createCell($item['Direccion'])
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }
    
    public function exportarUsuariosSinCorreo()
    {
        $listadoUsuario = $this->usuarioModelo->listaGeneralUsuarios(array("estado"=>"Activo","correo"=>""));
        
        $filename = "usuarios.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        //$writer->setFieldDelimiter(';');
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Matrícula"),
            WriterEntityFactory::createCell("Usuario")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoUsuario as $key=>$item)
        {
			$cells = [
                WriterEntityFactory::createCell($item['Matricula']),
                WriterEntityFactory::createCell('')
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }
	
	public function registrarUsuario()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $matricula      = mb_strtoupper($this->request->getPost('txtMatriculaUsuario_i'));
        $nombre         = mb_strtoupper($this->request->getPost('txtNombresUsuario_i'));
        $apellido       = mb_strtoupper($this->request->getPost('txtApellidosUsuario_i'));
        $tipoDocumento  = $this->request->getPost('txtTipoDocumentoUsuario_i') ;
        $documento      = $this->request->getPost('txtDocumentoUsuario_i');
        $cargo          = $this->request->getPost('txtCargoUsuario_i');
        $manager        = $this->request->getPost('txtManagerUsuario_i') ;
        $fechaIngreso   = $this->request->getPost('txtFechaIngresoUsuario_i');
        $fte            = $this->request->getPost('txtFTEUsuario_i');
        //$area           = $this->request->getPost('txtAreaUsuario_i') ;
        $subarea        = $this->request->getPost('txtSubareaEstrucUsuario_i') ;
        $delegacion     = $this->request->getPost('txtDelegacionSubareaEstrucUsuario_i') ;
        $correo         = mb_strtolower($this->request->getPost('txtCorreoUsuario_i'));
        $usuario        = mb_strtolower($this->request->getPost('txtUsuarioIngreso_i'));
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        if($tipoDocumento == 'DNI')
        {
            $minCaracteres = '8';
            $maxCaracteres = '8';
        }
        else
        {
            $minCaracteres = '8';
            $maxCaracteres = '12';
        }
        
        $error = '';
        $error .= $this->complementos->validaCampo($matricula, 'required|trim|minlength[1]|maxlength[7]', 'Matrícula');
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|alphaspace|minlength[1]|maxlength[200]', 'Nombres');
        $error .= $this->complementos->validaCampo($apellido, 'required|trim|alphaspace|minlength[1]|maxlength[200]', 'Apellidos');
        $error .= $this->complementos->validaCampo($tipoDocumento, 'required|trim|alpha|minlength[1]|maxlength[4]', 'Tipo de Documento');
        $error .= $this->complementos->validaCampo($documento, 'required|trim|numeric|minlength['.$minCaracteres.']|maxlength['.$maxCaracteres.']', 'Documento');
        $error .= $this->complementos->validaCampo($cargo, 'required|trim|numeric', 'Cargo');
        $error .= $this->complementos->validaCampo($manager, 'required|trim|numeric', 'Jefe Directo');
        $error .= $this->complementos->validaCampo($fechaIngreso, 'required|trim|dateDos', 'Fecha de Ingreso');
        $error .= $this->complementos->validaCampo($fte, 'required|trim|decimal', 'FTE');
        //$error .= $this->complementos->validaCampo($area, 'required|trim|numeric', 'Área');
        $error .= $this->complementos->validaCampo($subarea, 'required|trim|numeric', 'Subárea');
        $error .= $this->complementos->validaCampo($delegacion, 'required|trim|numeric', 'Delegación');
        $error .= $this->complementos->validaCampo($correo, 'required|trim|email|minlength[1]|maxlength[200]', 'Correo Corporativo');
        $error .= $this->complementos->validaCampo($usuario, 'required|trim|minlength[1]|maxlength[150]', 'Usuario');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$matriculaExistente = $this->usuarioModelo->where('Matricula', $matricula)->findAll();
		$documentoExistente = $this->usuarioModelo->where('NumeroDoc', $documento)->findAll();
		$usuarioExistente = $this->usuarioModelo->where('Usuario', $usuario)->findAll();
        
        if(count($matriculaExistente)>0)
        {
            $msgExistencia .= "<li>La matrícula ya fue registrada. [CAMPO] <small>MATRÍCULA</small></li>";
        }

        if(count($documentoExistente)>0)
        {
            $msgExistencia .= "<li>El Nro Documento ya fue registrado. [CAMPO] <small>DOCUMENTO</small></li>";
        }

        if(count($usuarioExistente)>0)
        {
            $msgExistencia .= "<li>El usuario ya fue registrado. [CAMPO] <small>USUARIO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
        $data = array (
            //'IdArea'        => $area,
            'Matricula'     => $matricula,
            'Nombres'       => $nombre,
            'Apellidos'     => $apellido,
            'TipoDocumento' => $tipoDocumento,
            'NumeroDoc'     => $documento,
            'Correo'        => $correo,
            'Usuario'       => $usuario,
            'FechaIngreso'  => $fechaIngreso,
            'FTE'           => $fte,
            'IDCargo'       => $cargo,
            'IDManager'     => $manager,
            'IDSubarea'     => $subarea,
            'IDDelegacion'  => $delegacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Alta de usuario.",    
            'Estado'        => 'Activo'
        );

        $lastId = $this->usuarioModelo->insert($data, TRUE);

		if($lastId !== FALSE){
		    
			$message = sprintf($this->mensajeError->msg502, $matricula);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	

    public function obtenerDatosUsuario()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idUsuario = $this->request->getPost("idUsuario");

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idUsuario, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosUsuario = $this->usuarioModelo->obtenerUsuario($idUsuario);

		if(!empty($datosUsuario)){
			$resultado = array(
				'idusuario'     => (string) $idUsuario,
				'matricula'     => (string) $datosUsuario['Matricula'],
				'nombres'       => (string) $datosUsuario['Nombres'],
				'apellidos'     => (string) $datosUsuario['Apellidos'],
				'tipodoc'       => (string) $datosUsuario['TipoDocumento'],
				'documento'     => (string) $datosUsuario['NumeroDoc'],
				'idmanager'     => (string) $datosUsuario['IDManager'],
				'fechaingreso'  => (string) $datosUsuario['FechaIngreso'],
				'fte'           => (string) $datosUsuario['FTE'],
				'correo'        => (string) $datosUsuario['Correo'],
				'usuario'       => (string) $datosUsuario['Usuario'],
				'idcargo'       => (string) $datosUsuario['IDCargo'],
				'idsubarea'     => (string) $datosUsuario['IDSubarea'],
				'idarea'        => (string) $datosUsuario['IDArea'],
				'iddireccion'   => (string) $datosUsuario['IDDireccion'],
				'iddelegacion'  => (string) $datosUsuario['IDDelegacion'],
				'fechacese'     => (string) date("d-m-Y", strtotime($datosUsuario['FechaCese']))
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);	
    }
    
    public function actualizarUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $matricula      = mb_strtoupper($this->request->getPost('txtMatriculaUsuario_i'));
        $nombre         = mb_strtoupper($this->request->getPost('txtNombresUsuario_i'));
        $apellido       = mb_strtoupper($this->request->getPost('txtApellidosUsuario_i'));
        $tipoDocumento  = $this->request->getPost('txtTipoDocumentoUsuario_i') ;
        $documento      = $this->request->getPost('txtDocumentoUsuario_i');
        $cargo          = $this->request->getPost('txtCargoUsuario_i');
        $manager        = $this->request->getPost('txtManagerUsuario_i') ;
        $fechaIngreso   = $this->request->getPost('txtFechaIngresoUsuario_i');
        $fte            = $this->request->getPost('txtFTEUsuario_i');
        //$area           = $this->request->getPost('txtAreaUsuario_i') ;
        $subarea        = $this->request->getPost('txtSubareaEstrucUsuario_i') ;
        $delegacion     = $this->request->getPost('txtDelegacionSubareaEstrucUsuario_i') ;
        $correo         = mb_strtolower($this->request->getPost('txtCorreoUsuario_i'));
        $usuario        = mb_strtolower($this->request->getPost('txtUsuarioIngreso_i'));
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        if($tipoDocumento == 'DNI')
        {
            $minCaracteres = '8';
            $maxCaracteres = '8';
        }
        else
        {
            $minCaracteres = '8';
            $maxCaracteres = '12';
        }
        
        $error = '';
        $error .= $this->complementos->validaCampo($matricula, 'required|trim|minlength[1]|maxlength[7]', 'Matrícula');
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|alphaspace|minlength[1]|maxlength[200]', 'Nombres');
        $error .= $this->complementos->validaCampo($apellido, 'required|trim|alphaspecial|minlength[1]|maxlength[200]', 'Apellidos');
        $error .= $this->complementos->validaCampo($tipoDocumento, 'required|trim|alpha|minlength[1]|maxlength[4]', 'Tipo de Documento');
        $error .= $this->complementos->validaCampo($documento, 'required|trim|minlength['.$minCaracteres.']|maxlength['.$maxCaracteres.']', 'Documento');
        $error .= $this->complementos->validaCampo($cargo, 'required|trim|numeric', 'Cargo');
        // $error .= $this->complementos->validaCampo($manager, 'required|trim|numeric', 'Jefe Directo');
        $error .= $this->complementos->validaCampo($fechaIngreso, 'required|trim|dateDos', 'Fecha de Ingreso');
        $error .= $this->complementos->validaCampo($fte, 'required|trim|decimal', 'FTE');
        //$error .= $this->complementos->validaCampo($area, 'required|trim|numeric', 'Área');
        $error .= $this->complementos->validaCampo($subarea, 'required|trim|numeric', 'Subárea');
        $error .= $this->complementos->validaCampo($delegacion, 'required|trim|numeric', 'Delegación');
        $error .= $this->complementos->validaCampo($correo, 'required|trim|email|minlength[1]|maxlength[200]', 'Correo Corporativo');
        $error .= $this->complementos->validaCampo($usuario, 'required|trim|minlength[1]|maxlength[150]', 'Usuario');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            //'IdArea'            => $area,
            'Matricula'         => $matricula,
            'Nombres'           => $nombre,
            'Apellidos'         => $apellido,
            'TipoDocumento'     => $tipoDocumento,
            'NumeroDoc'         => $documento,
            'Correo'            => $correo,
            'Usuario'           => $usuario,
            'FechaIngreso'      => $fechaIngreso,
            'FTE'               => $fte,
            'IDCargo'           => $cargo,
            'IDManager'         => $manager,
            'IDSubarea'         => $subarea,
            'IDDelegacion'      => $delegacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->usuarioModelo->update([$idUsuario], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $nombre);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
    }
    
    public function modificarEstadoUsuario()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idUsuario = $this->request->getPost('idUsuario');
        $fechacese = $this->request->getPost('fechacese');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|numeric', 'ID Usuario');
        $error .= $this->complementos->validaCampo($fechacese, 'required|trim|dateDos', 'Fecha Cese');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[6]|maxlength[6]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'FechaCese'         => $fechacese,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->usuarioModelo->update([$idUsuario], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarPasswordUsuario()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idUsuario = $this->request->getPost('idUsuario');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|numeric', 'ID Usuario');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * -------------
        * GENERAR CONTRASEÑA
        * -------------
        */
		
		$infoUsuario = $this->usuarioModelo->where('IdUsuario', $idUsuario)->first();
    	
        $passwordxdni="Verisure".substr($infoUsuario['NumeroDoc'],-4).date("Y");
        //$passwordxdni="Verisure*";
        $user_password_hash=password_hash($passwordxdni,PASSWORD_DEFAULT);
        
        $data = array (
            'Password'          => $user_password_hash,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $this->usuarioModelo->update([$idUsuario], $data);

		if($lastId !== FALSE){
		    /*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO
            * ----------------------------
            */
            
            $arrayCuerpo = array(
                "TITULO"        => "CAMBIO DE CONTRASEÑA",
                "USUARIO"       => ucwords(mb_strtolower($infoUsuario['Nombres'].' '.$infoUsuario['Apellidos'])),
                "USER"          => $infoUsuario['Usuario'],
                "PASSWORD"      => $passwordxdni
            );
    
            $cuerpo = $this->plantillasCorreo->cuerpoCambioPasswordGenerado($arrayCuerpo);
            
            /*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
            */
    
            $asunto='CAMBIO DE CONTRASEÑA - SISTEMAS VERISURE';
            //$correoDestino = array($asignado['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => 'desarrollo@verisure.pe',
                "CORREOS_DESTINOS" => array($infoUsuario['Correo']),
                "CORREOS_COPIA" => array(),
                "CORREOS_OCULTO" => array('josejesus.cuadros@verisure.pe'),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );
    
            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
    
            $dataCorreo = array(
                "IDUsuario"     => $idUsuario,
                "Asunto"        => $asunto,
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );
    
            $this->correoStatusUsuario->insert($dataCorreo, TRUE);
			$message = sprintf($this->mensajeError->msg503, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarPerfilUsuario($idUsuario){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $perfil = $this->request->getPost('txtPerfilUsuario');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($perfil, 'required|trim', 'Perfil');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * ACTUALIZACIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IdUsuario'         => $idUsuario,
            'IDPerfil'          => $perfil,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );
        
        $lastId = $this->usuarioPerfil->save($data);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function listarPermisosUsuario($idUsuario)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaPermisos = $this->usuarioPermisos->listarPermisosUsuario($idUsuario);
            $usuario = $this->usuarioModelo->where("IdUsuario",$idUsuario)->first();
			$listaModulos = $this->modulo->findAll();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Permisos | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Permisos de Usuario',
                'previo'                => 'listar-usuarios',
				'listaPermisos'         => $listaPermisos,
                'listaModulos'          => $listaModulos,
                'usuarioSeleccionado'   => $usuario,
                'idUsuario'             => $idUsuario
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_permisos_usuario',$data);			
		} else {
			return view('errors/500');
		}
	}

	public function listarRutasUsuario($idUsuario)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaRutas = $this->usuarioRutas->listarRutasUsuario($idUsuario);
            $usuario = $this->usuarioModelo->where("IdUsuario",$idUsuario)->first();
			$listaModulos = $this->modulo->findAll();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Rutas | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Rutas de Usuario',
                'previo'                => 'listar-usuarios',
				'listaRutas'            => $listaRutas,
                'listaModulos'          => $listaModulos,
                'usuarioSeleccionado'   => $usuario,
                'idUsuario'             => $idUsuario
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_rutas_usuario',$data);			
		} else {
			return view('errors/500');
		}
	}
    
    public function guardarPermisosUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $permisos = $this->request->getPost('permisos') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($permisos) && empty($permisos))
        {
            $error .= "<li>No hay permisos seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoPermisosPrev = $this->usuarioPermisos->where("IdUsuario", $idUsuario)->findAll();

        if(count($listadoPermisosPrev) > 0)
        {
            $this->usuarioPermisos->delete($idUsuario);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataPermisos = array();

        foreach($permisos as $key => $value)
        {
            $dataPermisos[] = array (
                'IdUsuario'         => $idUsuario, 
                'IDAccionModulo'    => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->usuarioPermisos->insertBatch($dataPermisos, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function guardarRutasUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $rutas = $this->request->getPost('rutas') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($rutas) && empty($rutas))
        {
            $error .= "<li>No hay rutas seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoRutasPrev = $this->usuarioRutas->where("IdUsuario", $idUsuario)->findAll();

        if(count($listadoRutasPrev) > 0)
        {
            $this->usuarioRutas->delete($idUsuario);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataRutas = array();

        foreach($rutas as $key => $value)
        {
            $dataRutas[] = array (
                'IdUsuario'         => $idUsuario, 
                'IDRuta'            => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->usuarioRutas->insertBatch($dataRutas, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listarSistemasUsuario()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idUsuario = $this->request->getPost('idUsuario');
		
		$listadoSistemas = $this->usuarioSistemas->listarSistemasUsuario($idUsuario);
        
        $sistemas=array();

		if (!empty($listadoSistemas)) {
            foreach ($listadoSistemas as $items) {
                $sistemas[] = array(
					'idsistema' => (string) $items['IDSistema'],
         	        'sistema' => (string) $items['Sistema'],
         	        'raiz' => (string) $items['Raiz'],
         	        'activo' => (string) $items['ACTIVO']
                );
            }

            $resultado = array(
				'listadoSistemas' => json_encode($sistemas)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }
    
    public function guardarSistemasUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $sistemas = $this->request->getPost('sistemas');
        $nombre = $this->request->getPost('nombre');
        $raiz = $this->request->getPost('raiz');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoSistemasPrev = $this->usuarioSistemas->where("IdUsuario", $idUsuario)->findAll();

        if(count($listadoSistemasPrev) > 0)
        {
            $this->usuarioSistemas->delete($idUsuario);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataSistemas = array();
        $sistemasAutorizados = array();

        foreach($sistemas as $key => $value)
        {
            $dataSistemas[] = array (
                'IdUsuario'         => $idUsuario, 
                'IDSistema'         => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
            $sistemasAutorizados[$key] = array("NOMBRE" => $nombre[$key], "RAIZ" => $raiz[$key]);
        }
        
        $lastId = $this->usuarioSistemas->insertBatch($dataSistemas, TRUE);

		if($lastId !== FALSE){
		    
    		/*
            * -------------
            * GENERAR CONTRASEÑA
            * -------------
            */
    		
    		$infoUsuario = $this->usuarioModelo->where('IdUsuario', $idUsuario)->first();
        	
        	if($infoUsuario['Password'] == '' || $infoUsuario['Password'] == null)
        	{
                $passwordxdni="Verisure".substr($infoUsuario['NumeroDoc'],-4);
                $user_password_hash=password_hash($passwordxdni,PASSWORD_DEFAULT);
                
                $data = array (
                    'Password'          => $user_password_hash,
                    'UsuarioModifica'   => $this->items['id'],
                    'FechaModifica'     => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );
        
                $this->usuarioModelo->update([$idUsuario], $data);
    
                /*
                * ----------------------------
                * PREPARACIÓN DE CUERPO DE CORREO
                * ----------------------------
                */
                
                $arrayCuerpo = array(
                    "TITULO"        => "ALTA DE USUARIO - SISTEMAS VERISURE",
                    "USUARIO"       => ucwords(mb_strtolower($infoUsuario['Nombres'].' '.$infoUsuario['Apellidos'])),
                    "MATRICULA"     => $infoUsuario['Matricula'],
                    "USER"          => $infoUsuario['Usuario'],
                    "PASSWORD"      => $passwordxdni,
                    "AUTORIZADOS"   => $sistemasAutorizados
                );
        
                $cuerpo = $this->plantillasCorreo->cuerpoAvisoAltaUsuario($arrayCuerpo);
                
                /*
                * ----------------------------
                * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                * ----------------------------
                */
        
                $asunto='ALTA DE USUARIO - SISTEMAS VERISURE';
                //$correoDestino = array($asignado['Correo']);
                $configCorreo = array(
                    "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                    "CORREO_ORIGEN" => 'desarrollo@verisure.pe',
                    "CORREOS_DESTINOS" => array($infoUsuario['Correo']),
                    "CORREOS_COPIA" => array(),
                    "CORREOS_OCULTO" => array('josejesus.cuadros@verisure.pe'),
                    "ASUNTO" => $asunto,
                    "MENSAJE" => $cuerpo
                );
        
                $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
        
                $dataCorreo = array(
                    "IDUsuario"     => $idUsuario,
                    "Asunto"        => $asunto,
                    "Response"      => $estadoCorreo['RESPUESTA'],
                    "Error"         => $estadoCorreo['ERROR'],
                    'UsuarioCrea'   => $this->items['id'],
                    'FechaCrea'     => $fechaActual,    
                    'Localhost'     => $this->request->getIPAddress()
                );
        
                $this->correoStatusUsuario->insert($dataCorreo, TRUE);
		    }
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listarDelegacionesUsuario($idUsuario)
    {
        if(isset($this->items['id']))
        {
			/* BUSCAR ACCIONES */
			$usuario = $this->usuarioModelo->where("IdUsuario",$idUsuario)->first();
			$listaDelegaciones = $this->usuarioDelegaciones->listarDelegacionesXUsuario($idUsuario);
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Delegaciones - '.ucwords(mb_strtolower($usuario['Nombres'])).' '.ucwords(mb_strtolower($usuario['Apellidos'])).' | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Delegaciones Encargadas - '.ucwords(mb_strtolower($usuario['Nombres'])).' '.ucwords(mb_strtolower($usuario['Apellidos'])),
                'previo'            => 'listar-usuarios',
				'listaDelegaciones' => $listaDelegaciones,
                'idUsuarioSelect'   => $idUsuario
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_usuario_delegaciones',$data);			
		} else {
			return view('errors/500');	
		}
    }
    
    public function asociarDelegacionUsuario()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idDelegacion = $this->request->getPost('idDelegacion');
        $idUsuario = $this->request->getPost('idUsuario');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idDelegacion, 'required|trim|number', 'ID Delegación');
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereCC = array(
            'IDUsuario'     => $idUsuario,
            'IDDelegacion'  => $idDelegacion
        );
        
		$combinacionExistente = $this->usuarioDelegaciones->where($whereCC)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>La delegación ya está encargada al usuario. [CAMPO] <small>DELEGACIÓN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDUsuario'         => $idUsuario, 
            'IDDelegacion'      => $idDelegacion,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual,
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->usuarioDelegaciones->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idDelegacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function eliminarDelegacionUsuario()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idUsuario = $this->request->getPost('idUsuario') ;
        $idDelegacion = $this->request->getPost('idDelegacion');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idDelegacion, 'required|trim|number', 'ID Delegación');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IDUsuario'     => $idUsuario, 
            'IDDelegacion'  => $idDelegacion
        );

        $lastId = $this->usuarioDelegaciones->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idDelegacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerUsuarios(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoUsuarios = $this->usuarioModelo->findAll();
        
        $usuarios=array();

		if (!empty($listadoUsuarios)) {
            foreach ($listadoUsuarios as $items) {
                $usuarios[] = array(
					'id' => (string) $items['IdUsuario'],
         	        'usuario' => (string) $items['Matricula'].' | '.$items['Nombres'].' '.$items['Apellidos'],
                );
            }

            $resultado = array(
				'listadoUsuarios' => json_encode($usuarios)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}
	
}