<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;

class Acceso extends BaseController
{

	public function __construct(){
		$this->usuarioModelo = new \App\Models\UsuarioModelo();
		$this->usuarioPerfil = new \App\Models\UsuarioPerfilModelo();
		$this->log = new \App\Models\UsuarioLogModel();
	}

	public function login(){
		/* VERIFICAR ACCESO */
		if(isset($this->session->get('sesionUsuario')['accesoTmpId'])){
            /* ACCESO SEGÚN PERFIL */
// 			switch($this->session->get('sesionUsuario')['accesoTmpNivel']){
// 				case 401: case 402: case 403: //usuario
//                     echo $this->alertas->reDireccion($this->items['baseUrl'] . '/dashboard', 1);
//                     break;
// 				case 500: //administrador                    
//                     echo $this->alertas->reDireccion($this->items['baseUrl'] . '/dashboard', 1);                    										
// 					break;
// 			}
		} else {
            $data = array (
                'titulo' => 'Gestión de Usuarios | Verisure',
            );
            $data = array_merge($data, $this->items);
            return view('dashboard/iniciar-sesion',$data);
        }
	}

    public function entrar(){
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $usuario = $this->request->getPost('usuario');
        $contrasena = $this->request->getPost('contrasena');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($usuario, 'required|trim|minlength[5]|maxlength[100]', 'Usuario');
        $error .= $this->complementos->validaCampo($contrasena, 'required|trim|minlength[5]|maxlength[50]', 'Contraseña');
                
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */

		/* VALIDAR SI EL USUARIO EXISTE */	
		$datosUsuario = $this->usuarioModelo->validarIngresoUsuario($usuario);

        /* VALIDO SI EXISTE USUARIO INGRESADO */ 
		if(empty($datosUsuario)){
			$message = sprintf($this->mensajeError->msg1, 'Usuario');
			echo $this->alertas->alertaError($message);
			EXIT;
		}
        
		/* VALIDAR SI EL USUARIO SE ENCUENTRA ACTIVO */		
		if ($datosUsuario['Estado']!='Activo'){
			$message = sprintf($this->mensajeError->msg201, 'El usuario se encuentra cesado.');
			echo $this->alertas->alertaError($message);
			EXIT;
		}

		/* VALIDAR SI LA CONTRASEÑA INGRESADA ES IGUAL A LA DEL USUARIO */		
		if (!password_verify($contrasena,$datosUsuario['Password']) ){
			$message = sprintf($this->mensajeError->msg3, 'Usuario o Clave');
			echo $this->alertas->alertaError($message);
			EXIT;
		}
		
        /* VALIDAR SI TIENE PERMISO PARA ACCEDER AL SISTEMA */
		$permisoSistema = $this->usuarioModelo->validarSistemaUsuario($datosUsuario['IdUsuario'],$this->items['raiz']);
		
		if (empty($permisoSistema)){
			$message = sprintf($this->mensajeError->msg201, 'No cuenta con el permiso respectivo para acceder al sistema. Contactar con Soporte IT.');
			echo $this->alertas->alertaError($message);
			EXIT;
		}
		else if($permisoSistema['Estado'] == 'I')
		{
		    $message = sprintf($this->mensajeError->msg201, 'El sistema al que desea acceder se encuentra desactivado. Contactar con Soporte IT.');
			echo $this->alertas->alertaError($message);
			EXIT;
		}
		
        /* VALIDACIÓN FINAL DE ACCESO */
        
        if(!empty($datosUsuario))
        {
            $perfil = $this->usuarioPerfil->obtenerPerfilUsuario($datosUsuario['IdUsuario']);

            if(!empty($perfil))
            {
                $datos = array('sesionUsuario' =>
                    array(
                        'session' => 'on',
                        'accesoTmpId' => $datosUsuario['IdUsuario'],
                        'accesoTmpUsuario' => $datosUsuario['Usuario'],
                        'accesoTmpIDPerfil' => $perfil['IDPerfil'],
                        'accesoTmpPerfil' => $perfil['Perfil'],
                        'accesoTmpNombres' => $datosUsuario['Nombres'],
                        'accesoTmpApellidos' => $datosUsuario['Apellidos'],
                        'accesoTmpTipoDocumento' => $datosUsuario['TipoDocumento'],
                        'accesoTmpNumeroDocumento' => $datosUsuario['NumeroDoc'],
                        'accesoTmpCorreoElectronico' => $datosUsuario['Correo'],
                        'accesoTmpCargo' => $datosUsuario['Cargo'],
                        'accesoTmpIdCargo' => $datosUsuario['IDCargo'],
                        'accesoTmpIdSubarea' => $datosUsuario['IDSubarea'],
                        'accesoTmpIdArea' => $datosUsuario['IDArea'],
                        'accesoTmpIdDpto' => $datosUsuario['IDDireccion'],
                        'accesoTmpIdDelegacion' => $datosUsuario['IDDelegacion'],
                        'accesoTmpCC' => $datosUsuario['CC']
                    )
                );  
                $this->session->set($datos);
                
                //Obtener url actual
                $uri = current_url(true);
                //Obtener ruta: 3->ruta localhost 2->hosting
                $ruta = $uri->getSegment(3);
        		$raiz = $uri->getSegment(1);
        		
                $aud = array(
                    'IDUsuario'     => $datosUsuario['IdUsuario'],
                    'FechaIngreso'  => $fechaActual,
                    'Plataforma'    => $raiz,
                    'URL'           => $ruta,
                    'JSON'          => json_encode($datos),
                    'Localhost'     => $this->request->getIPAddress()
                );
                
                $this->log->insert($aud);
                
                $message = sprintf($this->mensajeError->msg501, $datosUsuario['Usuario']);
                echo $this->alertas->alertaExito($message);

                /* ACCESO SEGÚN PERFIL 
                switch($accesoUsuario[0]['perfil_id']){				
                    case 401: case 402: case 403: //usuario
                        echo $this->alertas->reDireccion($this->items['baseUrl'] . '/listar-clientes', 1);
                        break;
                    case 500: //administrador              
                        echo $this->alertas->reDireccion($this->items['baseUrl'] . '/listar-clientes', 1);                    										
                        break;
                }            */
                echo $this->alertas->reDireccion($this->items['baseUrl'] . '/' .$perfil['URLBase'], 1);
                EXIT;
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, 'Su usuario no cuenta con perfil asignado en este sistema.');
			    echo $this->alertas->alertaPeligro($message);
			    EXIT;
            }
        }
    }

	public function olvidoContrasena(){
        $data = array (
            'titulo' => 'Olvidé mi contraseña | Verisure',
        );
        $data = array_merge($data, $this->items);
		return view('dashboard/olvido-contrasena',$data);
	}

    public function solicitarRecuperacion(){

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $usuario = $this->request->getPost('usuario');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($usuario, 'required|trim|email|minlength[5]|maxlength[100]', 'Usuario');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }     

		/* VALIDAR SI EL USUARIO EXISTE */
		$whereUsuario = array('usuario' => $usuario, 'eliminacion_logica' => 1);		
		$datosUsuario = $this->usuarioModelo->where($whereUsuario)->findAll();

		if(empty($datosUsuario)){
			$message = sprintf($this->mensajeError->msg1, 'Usuario');
			echo $this->alertas->alertaError($message);
			EXIT;
		} else {
            /* GENERA TOKEN DE ACCESO */
            $token = $this->scripts->crearCodigo(6);

            $tokenCifrado = md5($token);
            $fechaCaducidadToken = date("Y-m-d H:i:s",strtotime(date("Y-m-d H:i:s")."+ 1 days"));
            
            $datosRecuperacion = array (
                'token' => $tokenCifrado,
                'fecha_solicitud_recuperacion' => date("Y-m-d H:i:s"),
                'fecha_caducidad_token' => $fechaCaducidadToken
            );
            $lastId = $this->usuarioModelo->update([$datosUsuario[0]['id_usuario']],$datosRecuperacion);

            /* ENVIAR CORREO A COLABORADOR */
            $this->scripts->correoRecuperacionUsuario($datosUsuario[0]['correo'], $datosUsuario[0]['nombres_apellidos'],$token,$fechaCaducidadToken);

            $message = sprintf($this->mensajeError->msg503, $datosUsuario[0]['usuario']);
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->bootstrap_recuperacion($tokenCifrado);
            //echo $this->alertas->reDireccion($this->items['baseUrl'] . '/inicio', 1);                  
        }        
    }
    
	public function recuperarCuenta($token){
        $data = array (
            'titulo' => 'Restaurar contraseña',
            'token' => $token
        );
        $data = array_merge($data, $this->items);
		return view('dashboard/recuperar-cuenta',$data);
	}

    public function grabarRecuperacion($token){

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $confirmarContrasena = $this->request->getPost('confirmar_contrasena');
        $contrasena = $this->request->getPost('contrasena');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($confirmarContrasena, 'required|trim|minlength[1]|maxlength[50]', 'Confirmar contraseña');
        $error .= $this->complementos->validaCampo($contrasena, 'required|trim|minlength[1]|maxlength[50]', 'Contraseña');

        if($contrasena != $confirmarContrasena){
            $error .= "Las contraseñas no coinciden";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }  
        
		/* VALIDAR SI EL USUARIO EXISTE */
		$whereUsuario = array('token' => $token, 'eliminacion_logica' => 1);		
		$datosUsuario = $this->usuarioModelo->where($whereUsuario)->findAll();
		
		if(empty($datosUsuario)){
			$message = sprintf($this->mensajeError->msg2, 'Token');
			echo $this->alertas->alertaError($message);
			EXIT;
		} else {
            /* VALIDAR SI EL TOKEN HA CADUCADO */
            if(strtotime(date("Y-m-d H:i:s")) > strtotime($datosUsuario[0]['fecha_caducidad_token'])){
                $message = sprintf($this->mensajeError->msg17, 'Token');
                echo $this->alertas->alertaError($message);
                EXIT;
            }        

            $datosRecuperacion = array (
                'contrasena' => md5($contrasena),
                'fecha_cambio_contrasena' => date("Y-m-d H:i:s"),
            );
            $lastId = $this->usuarioModelo->update([$datosUsuario[0]['id_usuario']],$datosRecuperacion);

            $message = sprintf($this->mensajeError->msg503, $datosUsuario[0]['usuario']);
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->reDireccion($this->items['baseUrl'] . '/iniciar-sesion', 1);
        }         
    }
    
    public function salir(){
        $this->session->stop('sesionUsuario');
        $this->session->destroy('sesionUsuario');
        $this->session->remove('sesionUsuario');
        echo $this->alertas->reDireccion($this->items['baseUrl'] . '/', 1);
    }    
}
