
const tableTipologia = new DataTable('#tblTipologia');
const tableBanco = new DataTable('#tblBancos');
const tableFormasPago = new DataTable('#tblFormasPago');
const tableModalidadPago = new DataTable('#tblModalidadPago');
const tableCuentaContable = new DataTable('#tblCuentaContable');
const tableCategoriasCuentaContable = new DataTable('#tblCategoriasCuentaContable');
const tableSubcategoriasCuentaContable = new DataTable('#tblSubcategoriasCuentaContable');
const tableUsuariosAccesoProveedor = new DataTable("#tblUsuariosAccesoProveedor");

const tableRequerimientos = new DataTable('#tblRequerimientos');
const tableMotivosRequerimiento = new DataTable('#tblMotivosRequerimiento');
const tablePeticiones = new DataTable('#tblPeticiones', {
    responsive: true,
    columnDefs: [
        { width: '50px', targets: 0 },
        { responsivePriority: 1, targets: 0 },
        { responsivePriority: 2, targets: 1 },
        { width: '50px', targets: 10 },
        { responsivePriority: 1, targets: 10 }
    ]
});

let pondImportOC = "";
let pondAutorizacionOC = "";
let pondRegistrarPeticion;
let pondAdjuntosComentario;
let pondAdjuntosPeticionCompletada;
$(function () {
    
    
    $('#smartwizard-noc').smartWizard({
        selected: 0, // Initial selected step, 0 = first step
         //theme: 'default', // theme for the wizard, related css need to include for other than default theme
         justified: true, // Nav menu justification. true/false
         autoAdjustHeight: false, // Automatically adjust content height
         backButtonSupport: true, // Enable the back button support
         enableUrlHash: true, // Enable selection of the step based on url hash
         toolbar: {
            position: 'bottom', // none|top|bottom|both
            showNextButton: true, // show/hide a Next button
            showPreviousButton: true, // show/hide a Previous button
            extraHtml: '<button type="submit" class="btn btn-success d-none" id="enviarSolicitud">Enviar solicitud</button>' // Extra html to show on toolbar
         },
         keyboard: {
              keyNavigation: false // Enable/Disable keyboard navigation(left and right keys are used if enabled)
          },
         lang: { // Language variables for button
            next: 'Siguiente',
            previous: 'Atrás'
         }
    });
    
    if ($('#smartwizard-noc').hasClass('sw-main')) 
    {
        $('#smartwizard-noc').smartWizard('reset');
    }
    
    
    $("#cboUsuariosExternos").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Externo',
        // dropdownParent: $('#editarPerfilUsuario .modal-body'),
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/busqueda-externo-acceso',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
});
async function porcentaje() {     
        try{
            var demo_pie_1 = $('#demo-pie-1');
            var label_pie_1 = $('#label-pie-1');
            var demo_pie_2 = $('#demo-pie-2');
            var label_pie_2 = $('#label-pie-2');
            var demo_pie_6 = $('#demo-pie-6');
            var label_pie_6 = $('#label-pie-6');
            var demo_pie_3 = $('#demo-pie-3');
            var label_pie_3 = $('#label-pie-3');
            var demo_pie_5 = $('#demo-pie-5');
            var label_pie_5 = $('#label-pie-5');
            var demo_pie_4 = $('#demo-pie-4');
            var label_pie_4 = $('#label-pie-4');
            // console.log(response);
            await $.ajax({
                type: "POST",
                url: baseUrl + '/compras-grafica',
                dataType: 'json',
                success: function(datos) {
                    //PENDIENTE FIRMA 1
                    // console.log(datos[0].anulado);
                    demo_pie_1.attr("data-percent", `${datos[0].porcentaje_firma1}`);
                    label_pie_1.text(datos[0].pendiente_firma1);
                    demo_pie_1.pieChart({
                        barColor: '#8a8c8e',
                        trackColor: '#ddd',
                        lineCap: 'butt',
                        lineWidth: 8,
                        size: 110,
                        onStep: function(from, to, percent) {
                            $(this.element).find('.pie-value').text(Math.round(percent) + '%');
                        }
                    });
                    //PENDIENTE FIRMA 2
                    demo_pie_2.attr("data-percent", `${datos[0].porcentaje_firma2}`);
                    label_pie_2.text(datos[0].pendiente_firma2);
                    demo_pie_2.pieChart({
                        barColor: '#ffc632',
                        trackColor: '#ddd',
                        lineCap: 'butt',
                        lineWidth: 8,
                        size: 110,
                        onStep: function(from, to, percent) {
                            $(this.element).find('.pie-value').text(Math.round(percent) + '%');
                        }
                    });
                    //PENDIENTE FIRMA 3
                    demo_pie_6.attr("data-percent", `${datos[0].porcentaje_firma3}`);
                    label_pie_6.text(datos[0].pendiente_firma3);
                    demo_pie_6.pieChart({
                        barColor: '#FDBA04',
                        trackColor: '#ddd',
                        lineCap: 'butt',
                        lineWidth: 8,
                        size: 110,
                        onStep: function(from, to, percent) {
                            $(this.element).find('.pie-value').text(Math.round(percent) + '%');
                        }
                    });
                    //APROBADO
                    demo_pie_3.attr("data-percent", `${datos[0].porcentaje_aprobado}`);
                    label_pie_3.text(datos[0].aprobado);
                    demo_pie_3.pieChart({
                        barColor: '#00a37d',
                        trackColor: '#ddd',
                        lineCap: 'butt',
                        lineWidth: 8,
                        size: 110,
                        onStep: function(from, to, percent) {
                            $(this.element).find('.pie-value').text(Math.round(percent) + '%');
                        }
                    });
                    //ANULADO
                    demo_pie_5.attr("data-percent", `${datos[0].porcentaje_anulado}`);
                    label_pie_5.text(datos[0].anulado);
                    demo_pie_5.pieChart({
                        barColor: '#636466',
                        trackColor: '#ddd',
                        lineCap: 'butt',
                        lineWidth: 8,
                        size: 110,
                        onStep: function(from, to, percent) {
                            $(this.element).find('.pie-value').text(Math.round(percent) + '%');
                        }
                    });
                    //RECHAZADO
                    demo_pie_4.attr("data-percent", `${datos[0].porcentaje_rechazado}`);
                    label_pie_4.text(datos[0].rechazado);
                    demo_pie_4.pieChart({
                        barColor: '#ed002f',
                        trackColor: '#ddd',
                        lineCap: 'butt',
                        lineWidth: 8,
                        size: 110,
                        onStep: function(from, to, percent) {
                            $(this.element).find('.pie-value').text(Math.round(percent) + '%');
                        }
                    });
                }

            });
        } catch(e){
            console.log(e);
        }
    }
/* FUNCIONES GENERALES */

/* ------------------------------- */

function selectCodigoDetraccion(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-codigos-detraccion', 
    {}, 
    function(response) {
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var codigosDetraccion = $.parseJSON(response.listadoCodigosDetraccion);
            
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < codigosDetraccion.length; i++){
                $("#"+elemento).append('\
                    <option value="' + codigosDetraccion[i].id + '" '+(idSeleccionado == codigosDetraccion[i].id ? 'selected' : '')+'>' + codigosDetraccion[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectTipologia(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-tipologias', 
    {}, 
    function(response) {
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var tipologias = $.parseJSON(response.listadoTipologias);
            var selected = "";
            for(var i = 0; i < tipologias.length; i++){
                if (typeof idSeleccionado === 'string') 
                {
                    selected = (idSeleccionado == tipologias[i].id ? 'selected' : '');
                } 
                else if (Array.isArray(idSeleccionado)) 
                {
                    selected = ($.inArray(tipologias[i].id, idSeleccionado) !== -1 ? 'selected' : '');
                }
                
                $("#"+elemento).append('\
                    <option value="' + tipologias[i].id + '" '+selected+'>' + tipologias[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectCuentaContable(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-cuentas-contables', 
    {}, 
    function(response) {
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var cuentascontables = $.parseJSON(response.listadoCuentasContables);
            
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < cuentascontables.length; i++){
                $("#"+elemento).append('\
                    <option value="' + cuentascontables[i].id + '" '+(idSeleccionado == cuentascontables[i].id ? 'selected' : '')+'>' + cuentascontables[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectCategoriaCuentaContable(elemento, idCuentaContable, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-categoria-cuenta-contable', 
    {
        idCuentaContable: idCuentaContable
    }, 
    function(response) {
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var categorias = $.parseJSON(response.listadoCategorias);
            
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < categorias.length; i++){
                $("#"+elemento).append('\
                    <option value="' + categorias[i].id + '" '+(idSeleccionado == categorias[i].id ? 'selected' : '')+'>' + categorias[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectSubcategoriaCuentaContable(elemento, idCategoriaCC, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-subcategoria-cuenta-contable', 
    {
        idCategoria: idCategoriaCC
    }, 
    function(response) {
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var subcategorias = $.parseJSON(response.listadoSubcategorias);
            
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < subcategorias.length; i++){
                $("#"+elemento).append('\
                    <option value="' + subcategorias[i].id + '" '+(idSeleccionado == subcategorias[i].id ? 'selected' : '')+'>' + subcategorias[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectBanco(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-bancos', 
    {}, 
    function(response) {
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var bancos = $.parseJSON(response.listadoBancos);

            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < bancos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + bancos[i].id + '" '+(idSeleccionado == bancos[i].id ? 'selected' : '')+'>' + bancos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectFormaPago(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-formas-pago', 
    {}, 
    function(response) {
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var formasPago = $.parseJSON(response.listadoFormasPago);

            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < formasPago.length; i++){
                $("#"+elemento).append('\
                    <option value="' + formasPago[i].id + '" '+(idSeleccionado == formasPago[i].id ? 'selected' : '')+'>' + formasPago[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectModalidadPago(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-modalidad-pago', 
    {}, 
    function(response) {
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var modalidadPago = $.parseJSON(response.listadoModalidadPago);

            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < modalidadPago.length; i++){
                $("#"+elemento).append('\
                    <option value="' + modalidadPago[i].id + '" '+(idSeleccionado == modalidadPago[i].id ? 'selected' : '')+'>' + modalidadPago[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectCompradores(elemento, idSeleccionado, nombreSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-usuarios-comprador', 
    {}, 
    function(response) {
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var compradores = $.parseJSON(response.listadoUsuarios);

            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < compradores.length; i++){
                $("#"+elemento).append('\
                    <option value="' + compradores[i].id + '" '+(idSeleccionado == compradores[i].id ? 'selected' : '')+'>' + compradores[i].text +'</td>\n\
                ');
            }
            
            const ids = compradores.map(item => item.id);
            
            if(!ids.includes(idSeleccionado) && idSeleccionado != '')
            {
                $("#"+elemento).append('\
                    <option value="' + idSeleccionado + '" selected>' + nombreSeleccionado +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectProveedores(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-proveedores', 
    {}, 
    function(response) {
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var proveedores = $.parseJSON(response.listadoProveedores);

            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < proveedores.length; i++){
                $("#"+elemento).append('\
                    <option value="' + proveedores[i].id + '" '+(idSeleccionado == proveedores[i].id ? 'selected' : '')+'>' + proveedores[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectTipoRequerimientos(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-tipo-requerimiento', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var requerimientos = $.parseJSON(response.listadoTipoRequerimientos);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < requerimientos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + requerimientos[i].id + '" '+(idSeleccionado == requerimientos[i].id ? 'selected' : '')+'>' + requerimientos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
}

function selectRequerimientos(elemento, tipoRequerimiento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-requerimiento', 
    {
        tipoRequerimiento: tipoRequerimiento
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var requerimientos = $.parseJSON(response.listadoRequerimientos);
            
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < requerimientos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + requerimientos[i].id + '" '+(idSeleccionado == requerimientos[i].id ? 'selected' : '')+'>' + requerimientos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
}

function selectMotivosRequerimiento(elemento, idRequerimiento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-motivo-requerimiento', 
    {
        idRequerimiento: idRequerimiento
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var motivos = $.parseJSON(response.listadoMotivos);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < motivos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + motivos[i].id + '" '+(idSeleccionado == motivos[i].id ? 'selected' : '')+'>' + motivos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
}

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES TIPOLOGÍA */

/* ------------------------------- */

$(document).on('click', '.datos-tipologia', function(e) {
    $('#btnEjecutarTipologia').addClass("d-none");
    var idTipologia = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' textarea').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' textarea').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        $('#exampleinformacionTipologia').text("Registrar tipología");
        $('#formInformacionTipologia').attr('action', baseUrl + '/registrar-tipologia');
        $('#btnEjecutarTipologia').removeClass("d-none");
        $('#btnEjecutarTipologia').html('<i class="mdi mdi-content-save"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' textarea').removeAttr("disabled");
        
        Swal.close();
        
        $('#txtDescripcionTipologia_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-tipologia', 
        {         
            idTipologia : idTipologia
        }, 
        function(response) 
        {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionTipologia').text("Información de la tipología");
                    $('#btnEjecutarTipologia').addClass("d-none");
                    $('#formInformacionTipologia').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' textarea').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionTipologia').text("Actualizar elemento de demo");
                    $('#formInformacionTipologia').attr('action', baseUrl + '/actualizar-tipologia/' + idTipologia);
                    $('#btnEjecutarTipologia').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' textarea').removeAttr("disabled");
                }

                $('#txtIDTipologia_i').val(response.idtipologia);
                $('#txtDescripcionTipologia_i').val(response.descripcion);
                $('#txtObservacionTipologia_i').val(response.observacion);
            }
        }, 'json'); 
    }
    
    $(formulario).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-tipologia', function() {
    var idTipologia = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la tipología?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idTipologia"   : idTipologia,
                "estado"        : estado,
                "motivo"        : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-tipologia',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES BANCO */

/* ------------------------------- */

$(document).on('click', '.datos-banco', function(e) {
    $('#btnEjecutarBanco').addClass("d-none");
    var idBanco = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        $('#exampleinformacionBanco').text("Registrar Banco");
        $('#formInformacionBanco').attr('action', baseUrl + '/registrar-banco');
        $('#btnEjecutarBanco').removeClass("d-none");
        $('#btnEjecutarBanco').html('<i class="mdi mdi-content-save"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        
        Swal.close();
        
        $('#txtCodigoInternoBanco_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-banco', 
        {         
            idBanco : idBanco
        }, 
        function(response) 
        {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionBanco').text("Información del banco");
                    $('#btnEjecutarBanco').addClass("d-none");
                    $('#formInformacionBanco').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionBanco').text("Actualizar banco");
                    $('#formInformacionBanco').attr('action', baseUrl + '/actualizar-banco/' + idBanco);
                    $('#btnEjecutarBanco').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                }

                $('#txtIDBanco_i').val(response.idbanco);
                $('#txtCodigoInternoBanco_i').val(response.codigointerno);
                $('#txtNombreBanco_i').val(response.banco);
            }
        }, 'json'); 
    }
    
    $(formulario).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-banco', function() {
    var idBanco = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el banco?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idBanco"       : idBanco,
                "estado"        : estado,
                "motivo"        : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-banco',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES FORMAS DE PAGO */

/* ------------------------------- */

$(document).on('click', '.datos-forma-pago', function(e) {
    $('#btnEjecutarFormaPago').addClass("d-none");
    var idFormaPago = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        $('#exampleinformacionFormaPago').text("Registrar Forma de Pago");
        $('#formInformacionFormaPago').attr('action', baseUrl + '/registrar-forma-pago');
        $('#btnEjecutarFormaPago').removeClass("d-none");
        $('#btnEjecutarFormaPago').html('<i class="mdi mdi-content-save"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        
        Swal.close();
        
        $('#txtCodigoFormaPago_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-forma-pago', 
        {         
            idFormaPago : idFormaPago
        }, 
        function(response) 
        {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionFormaPago').text("Información de la forma de pago");
                    $('#btnEjecutarFormaPago').addClass("d-none");
                    $('#formInformacionFormaPago').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionFormaPago').text("Actualizar Forma de Pago");
                    $('#formInformacionFormaPago').attr('action', baseUrl + '/actualizar-forma-pago/' + idFormaPago);
                    $('#btnEjecutarFormaPago').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                }

                $('#txtIDFormaPago_i').val(response.idformapago);
                $('#txtCodigoFormaPago_i').val(response.codigo);
                $('#txtFormaPago_i').val(response.formapago);
            }
        }, 'json'); 
    }
    
    $(formulario).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-forma-pago', function() {
    var idFormaPago = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la forma de pago?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idFormaPago"   : idFormaPago,
                "estado"        : estado,
                "motivo"        : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-forma-pago',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* FUNCIONES MODALIDAD DE PAGO */

/* ------------------------------- */

$(document).on('click', '.datos-modalidad-pago', function(e) {
    $('#btnEjecutarModalidadPago').addClass("d-none");
    var idModalidadPago = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        $('#exampleinformacionModalidadPago').text("Registrar Modalidad de Pago");
        $('#formInformacionModalidadPago').attr('action', baseUrl + '/registrar-modalidad-pago');
        $('#btnEjecutarModalidadPago').removeClass("d-none");
        $('#btnEjecutarModalidadPago').html('<i class="mdi mdi-content-save"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        
        Swal.close();
        
        $('#txtCodigoModalidadPago_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-modalidad-pago', 
        {         
            idModalidadPago : idModalidadPago
        }, 
        function(response) 
        {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionModalidadPago').text("Información de la modalidad de pago");
                    $('#btnEjecutarModalidadPago').addClass("d-none");
                    $('#formInformacionModalidadPago').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionModalidadPago').text("Actualizar Modalidad de Pago");
                    $('#formInformacionModalidadPago').attr('action', baseUrl + '/actualizar-modalidad-pago/' + idModalidadPago);
                    $('#btnEjecutarModalidadPago').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                }

                $('#txtIDModalidadPago_i').val(response.idmodalidadpago);
                $('#txtCodigoModalidadPago_i').val(response.codigo);
                $('#txtModalidadPago_i').val(response.modalidadpago);
            }
        }, 'json'); 
    }
    
    $(formulario).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-modalidad-pago', function() {
    var idModalidadPago = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la modalidad de pago?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idModalidadPago"   : idModalidadPago,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-modalidad-pago',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES PROVEEDOR */

/* ------------------------------- */

$(document).on('click', '#btnExportarProveedor', function() {
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    window.open(baseUrl+"/exportar-proveedores/",'_blank');
    
    Swal.close();
});
/* ------------------------------- */
$(document).on('change', '#pais', function() {
    var modal = $(this).attr("data-modal");
    var idPais = $(this).val();
    
    $("#departamento").empty();
    $("#provincia").empty();
    $("#distrito").empty();
    
    selectRegionDepartamentos('departamento', idPais, '', modal);
});

$(document).on('change', '#departamento', function() {
    var modal = $(this).attr("data-modal");
    var idDepartamento = $(this).val();
    
    $("#provincia").empty();
    $("#distrito").empty();
    
    selectRegionProvincia('provincia', idDepartamento, '', modal);
});

$(document).on('change', '#provincia', function() {
    var modal = $(this).attr("data-modal");
    var idProvincia = $(this).val();
    
    $("#distrito").empty();
    
    selectRegionDistrito('distrito', idProvincia, '', modal);
});

// $(document).on('change', '#cuenta_detraccion', function() {
    
//     if($(this).prop('checked')){
//     	$('#ctnCodigoDetraccion').removeClass("d-none");
//     }else{
//     	$('#ctnCodigoDetraccion').addClass("d-none");
//     }
// });

/* ------------------------------- */

$(document).on('change', '#pais_e', function() {
    var modal = $(this).attr("data-modal");
    var idPais = $(this).val();
    
    $("#departamento_e").empty();
    $("#provincia_e").empty();
    $("#distrito_e").empty();
    
    selectRegionDepartamentos('departamento_e', idPais, '', modal);
});

$(document).on('change', '#departamento_e', function() {
    var modal = $(this).attr("data-modal");
    var idDepartamento = $(this).val();
    
    $("#provincia_e").empty();
    $("#distrito_e").empty();
    
    selectRegionProvincia('provincia_e', idDepartamento, '', modal);
});

$(document).on('change', '#provincia_e', function() {
    var modal = $(this).attr("data-modal");
    var idProvincia = $(this).val();
    
    $("#distrito_e").empty();
    
    selectRegionDistrito('distrito_e', idProvincia, '', modal);
});

// $(document).on('change', '#cuenta_detraccion', function() {
    
//     if($(this).prop('checked')){
//     	$('#ctnCodigoDetraccion').removeClass("d-none");
//     }else{
//     	$('#ctnCodigoDetraccion').addClass("d-none");
//     }
// });

/* ------------------------------- */

function agregarModalidadPago(contenedorElementos)
{
    var random = generarRandom(5);
    
    var modalidadPago = $("#modalidadPago").val();
    var banco = $("#banco").val();
    var cuenta = $("#nrocuenta").val();
    var cci = $("#cci").val();
    var moneda = $("#moneda").val();
    var prioridad = $("#prioridad").val();
    
    var lblmodalidadPago = $('select[id="modalidadPago"] option:selected').text();
    var lblbanco = $('select[id="banco"] option:selected').text();
    var lblmoneda = $('select[id="moneda"] option:selected').text();
    
    if(modalidadPago == '')
    {
        Swal.fire({
            html: 'Debe seleccionar una modalidad de pago.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(banco == '')
    {
        Swal.fire({
            html: 'Debe seleccionar un banco.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(cuenta == '')
    {
        Swal.fire({
            html: 'Debe digitar el número de cuenta.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(cci == '')
    {
        Swal.fire({
            html: 'Debe digitar el código interbancario.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(moneda == '')
    {
        Swal.fire({
            html: 'Debe seleccionar la moneda.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(prioridad == '')
    {
        Swal.fire({
            html: 'Debe digitar la prioridad.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        let contenedor = `<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="modPago${random}" style="border-radius: 10px;">
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Modalidad de Pago:</label>
    			    <input type="hidden" name="modalidadpago[${random}]" value="`+modalidadPago+`">
    				<input type="text" class="form-control" value="`+lblmodalidadPago+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Banco:</label>
    			    <input type="hidden" name="banco[${random}]" value="`+banco+`">
    				<input type="text" class="form-control" value="`+lblbanco+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Cuenta:</label>
    			    <input type="hidden" name="cuenta[${random}]" value="`+cuenta+`">
    				<input type="text" class="form-control" value="`+cuenta+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">CCI:</label>
    			    <input type="hidden" name="cci[${random}]" value="`+cci+`">
    				<input type="text" class="form-control" value="`+cci+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Moneda:</label>
    			    <input type="hidden" name="moneda[${random}]" value="`+moneda+`">
    				<input type="text" class="form-control" value="`+lblmoneda+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-2 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Prioridad:</label>
    			    <input type="hidden" name="prioridad[${random}]" value="`+prioridad+`">
    				<input type="text" class="form-control" value="`+prioridad+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
    			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico('modPago${random}');" data-tooltip="tooltip" aria-label="Eliminar Modalidad de Pago">
                    <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                </button>
    		</div>
    	</div>`;
    
        $("#"+contenedorElementos).append(contenedor);
        
        var modalidadPago = $("#modalidadPago").val("").trigger('change');
        var banco = $("#banco").val("").trigger('change');
        var cuenta = $("#nrocuenta").val("");
        var cci = $("#cci").val("");
        var moneda = $("#moneda").val("").trigger('change');
        var prioridad = $("#prioridad").val("");
    }
}

/* ------------------------------- */

$(document).on('click', '#btnNuevoProveedor', function(e) {
    
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').val("");
    // $(formulario + ' select').val("").trigger('change');
    $(formulario + ' select').empty();
    
    selectTipologia("tipologia", "", formulario.substring(1));
    selectBanco("banco", "", formulario.substring(1));
    selectFormaPago("formapago", "", formulario.substring(1));
    selectModalidadPago("modalidadPago", "", formulario.substring(1));
    selectRegionPais("pais", "", formulario.substring(1));
    selectMoneda("moneda", "", formulario.substring(1));
    selectCodigoDetraccion("codigo_detraccion", "", formulario.substring(1));
    
    $(formulario).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.btnInformacionProveedor', function(e) 
{
    $('#btnEjecutarProveedor').addClass("d-none");
    
    var idProveedor = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' select').empty();
    $(formulario + ' textarea').val("");
    
    selectTipologia("tipologia_e", "", formulario.substring(1));
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    $.post(baseUrl + '/obtener-datos-proveedor', 
    {         
        idProveedor : idProveedor
    }, 
    function(response) 
    {
        Swal.close();
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            if(accion == 'ver')
            {
                $('#exampleeditarProveedor').text("Información del proveedor");
                $('#btnEjecutarProveedor').addClass("d-none");
                $('#formEditarProveedor').attr('action', '');

                $(formulario + ' input[type=text]').attr("disabled","disabled");
                $(formulario + ' select').attr("disabled","disabled");
            }
            else
            {
                $('#exampleeditarProveedor').text("Actualizar Proveedor");
                $('#formEditarProveedor').attr('action', baseUrl + '/actualizar-proveedor/' + idProveedor);
                $('#btnEjecutarProveedor').removeClass("d-none");

                $(formulario + ' input[type=text]').removeAttr("disabled");
                $(formulario + ' select').removeAttr("disabled");
            }

            $('#proveedor_e').val(response.proveedor);
            $('#ruc_e').val(response.ruc);
            $('#contacto_e').val(response.contacto);
            
            selectRegionPais("pais_e", response.idpais, formulario.substring(1));
            selectRegionDepartamentos('departamento_e', response.idpais, response.iddepartamento, formulario.substring(1));
            selectRegionProvincia('provincia_e', response.iddepartamento, response.idprovincia, formulario.substring(1));
            selectRegionDistrito('distrito_e', response.idprovincia, response.iddistrito, formulario.substring(1));
            
            $('#direccion_e').val(response.direccion);
            $('#correo_e').val(response.correo);
            $('#telefono01_e').val(response.telefono01);
            $('#telefono02_e').val(response.telefono02);
            
            selectFormaPago("formapago_e", response.formapago, formulario.substring(1));
            
            $('#cuenta_detraccion_e').val(response.cuentadetraccion);
            selectCodigoDetraccion("codigo_detraccion_e", response.codigodetraccion, formulario.substring(1));
            
            $('#observaciones_e').val(response.observacion);
            
            let arrayTipologias = response.tipologia.split('|');
                
            arrayTipologias.forEach(function(valor) {
                $("#tipologia_e option[value='" + valor + "']").prop("selected", true).trigger("change");
            });
            
        }
    }, 'json'); 
    
    $(formulario).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-proveedor', function() {
    var idProveedor = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el proveedor?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idProveedor"   : idProveedor,
                "estado"        : estado,
                "motivo"        : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-proveedor',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

function recargarTablaModalidadPagoProveedor(idProveedor)
{
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    $('#tblModalidadPagoProveedor').DataTable().destroy();
    
    $("#tblModalidadPagoProveedor").DataTable({
        "ajax": {
            "url": baseUrl + "/recargar-tabla-modalidad-pago-proveedor",
            "type": "POST",
            "data": {
                "idProveedor" : idProveedor
            },
            "dataSrc": function (json) {
                
                for ( var i=0, ien=json.data.length ; i<ien ; i++ ) 
                {
                    json.data[i]['estado'] = "<button class='badge "+(json.data[i]['estado'] == 'A' ? 'bg-success' : 'bg-danger')+" border-0 cambiar-estado-proveedor-pago' data-estado='"+json.data[i]['estado']+"' data-id='"+json.data[i]['idproveedorpago']+"' data-proveedor='"+json.data[i]['idproveedor']+"'>"+(json.data[i]['estado'] == 'A' ? 'ACTIVO' : 'INACTIVO')+"</button>";
                
                    json.data[i]['acciones'] = `<center>
                        <div class='btn-group' role='group' aria-label=''>
                            <button type="button" class="btn bg-warning px-2 py-1 d-flex justify-content-center align-items-center color-white informacionModalidadPagoProveedor" data-tooltip="tooltip" aria-label="Editar Modalidad de Pago" data-collapse="#ctnModalidadPagoProveedorModal" data-form="#formModalidadPagoProveedor" data-modal="#editarModalidadPagoProveedor" data-id="`+json.data[i]['idproveedorpago']+`" data-accion="editar">
                                <span class='mdi mdi-pencil' ></span>
                            </button>
                        </div>
                    </center>`;
                }
                
                Swal.close();
                return json.data;
            },
            "error": function (xhr, error, thrown) {
                alert(thrown.message)
            }
        },
        columnDefs: [
            { className: "text-center align-middle", targets: "_all" }
        ],
        columns: [
           { data: 'idproveedorpago' },
           { data: 'modalidadpago' },
           { data: 'banco' },
           { data: 'cuentabancaria' },
           { data: 'cuentainterbancaria' },
           { data: 'moneda' },
           { data: 'prioridad' },
           { data: 'estado' },
           { data: 'acciones' }
        ]
    });
}

/* ------------------------------- */

$(document).on('click', '.modalidadPagoProveedor', function(e) 
{
    // $('#btnEjecutarProveedor').addClass("d-none");
    
    var idProveedor = $(this).data('id');
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    
    $("#ctnModalidadPagoProveedorModal").collapse("hide");
      
    $.post(baseUrl + '/obtener-datos-proveedor', 
    {         
        idProveedor : idProveedor
    }, 
    function(response) 
    {
        Swal.close();
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            $('#ruc_pp').val(response.ruc);
            $('#proveedor_pp').val(response.proveedor);
            $('#idproveedor_pp').val(idProveedor);
        }
    }, 'json'); 
    
    recargarTablaModalidadPagoProveedor(idProveedor);
    
    $(formulario).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.informacionModalidadPagoProveedor', function(e) 
{
    var contenedor = $(this).data('collapse');
    var formulario = $(this).data('form');
    var modal = $(this).data('modal');
    var idProveedorPago = $(this).data('id');
    var accion = $(this).data('accion');
    
    if($(contenedor).hasClass("show"))
    {
        
    }
    else
    {
        $(contenedor).collapse("show")
    }
    
    $('#btnEjecutarModalidadPagoProveedor').addClass("d-none");
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' input[type=number]').val("");
    $(formulario + ' select').empty();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        $('#lblTituloMPPR').text("Registrar Modalidad de Pago");
        $('#formModalidadPagoProveedor').attr('action', baseUrl + '/registrar-modalidad-pago-proveedor');
        $('#btnEjecutarModalidadPagoProveedor').removeClass("d-none");
        $('#btnEjecutarModalidadPagoProveedor').html('<i class="mdi mdi-content-save" style="font-size: 24px; color: #FFF"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' input[type=number]').removeAttr("disabled");
        $(formulario + ' select').removeAttr("disabled");
        
        selectBanco("banco_pp", "", modal.substring(1));
        selectModalidadPago("modalidadPago_pp", "", modal.substring(1));
        selectMoneda("moneda_pp", "", modal.substring(1));
        
        Swal.close();
        
        $('#modalidadPago_pp').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-modalidad-pago-proveedor', 
        {         
            idProveedorPago : idProveedorPago
        }, 
        function(response) 
        {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#lblTituloMPPR').text("Información de la Modalidad de Pago");
                    $('#btnEjecutarModalidadPagoProveedor').addClass("d-none");
                    $('#formModalidadPagoProveedor').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' select').attr("disabled","disabled");
                }
                else
                {
                    $('#lblTituloMPPR').text("Actualizar Modalidad de Pago");
                    $('#formModalidadPagoProveedor').attr('action', baseUrl + '/actualizar-modalidad-pago-proveedor/' + idProveedorPago);
                    $('#btnEjecutarModalidadPagoProveedor').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' input[type=number]').removeAttr("disabled");
                    $(formulario + ' select').removeAttr("disabled");
                }

                $('#idproveedorpago_pp').val(response.idproveedorpago);
                $('#nrocuenta_pp').val(response.cuenta);
                $('#cci_pp').val(response.cci);
                $('#prioridad_pp').val(response.prioridad);
                
                selectBanco("banco_pp", response.banco, modal.substring(1));
                selectModalidadPago("modalidadPago_pp", response.modalidadpago, modal.substring(1));
                selectMoneda("moneda_pp", response.moneda, modal.substring(1));
    
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('submit', '.formularioModalidadPagoProveedor', function() {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    var contenedor = formulario.data('collapse');
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    var formData = new FormData(this);

    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        dataType: 'json',
        success: function(response) {
            if(response.insert)
            {
                Swal.close();
                
                $(contenedor).collapse("hide");
                
                $('#' + idForm + ' input[type=text]').val("");
                $('#' + idForm + ' input[type=number]').val("");
                $('#' + idForm + ' select').empty();
                
                recargarTablaModalidadPagoProveedor(formData.get("idproveedor_pp"));
                
                formulario.find('.respuesta').html(response.mensaje);
            }
            else
            {
                Swal.close();
                formulario.find('.respuesta').html(response.mensaje);
            }
            //$.unblockUI({});
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-proveedor-pago', function() {
    var idProveedorPago= $(this).data("id");
    var idProveedor= $(this).data("proveedor");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la modalidad de pago del proveedor?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idProveedorPago"   : idProveedorPago,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-modalidad-pago-proveedor',
                type: "POST",
                data: parametros,
                dataType: 'json',
                success: function(response) {
                    if(response.insert)
                    {
                        recargarTablaModalidadPagoProveedor(idProveedor);
                    }
                    
                    $('.respuesta_global').html(response.mensaje);
                    
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});


/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES CUENTAS CONTABLES */

/* ------------------------------- */

$(document).on('click', '.datos-cuenta-contable', function(e) {
    $('#btnEjecutarCuentaContable').addClass("d-none");
    var idCuentaContable = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' textarea').attr("disabled","disabled");

    $(formulario + ' input[type=text]').val("");
    $(formulario + ' textarea').text("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        $('#exampleinformacionCuentaContable').text("Registrar Cuenta Contable");
        $('#formInformacionCuentaContable').attr('action', baseUrl + '/registrar-cuenta-contable');
        $('#btnEjecutarCuentaContable').removeClass("d-none");
        $('#btnEjecutarCuentaContable').html('<i class="mdi mdi-content-save me-2 color-white" style="font-size: 18px;"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' textarea').removeAttr("disabled");
        
        Swal.close();
        
        $('#txtCodigoCuentaContable_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-cuenta-contable', 
        {         
            idCuentaContable : idCuentaContable
        }, 
        function(response) 
        {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionCuentaContable').text("Información de Cuenta Contable");
                    $('#btnEjecutarCuentaContable').addClass("d-none");
                    $('#formInformacionCuentaContable').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' textarea').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionCuentaContable').text("Actualizar Cuenta Contable");
                    $('#formInformacionCuentaContable').attr('action', baseUrl + '/actualizar-cuenta-contable/' + idCuentaContable);
                    $('#btnEjecutarCuentaContable').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' textarea').removeAttr("disabled");
                }

                $('#txtIDCuentaContable_i').val(response.idcuentacontable);
                $('#txtCodigoCuentaContable_i').val(response.codigo);
                $('#txtNombreCuentaContable_i').val(response.cuentacontable);
                $('#txtDescripcionCuentaContable_i').val(response.descripcion);
                $('#txtObservacionCuentaContable_i').text(response.observacion);
            }
        }, 'json'); 
    }
    
    $(formulario).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-cuenta-contable', function() {
    var idCuentaContable = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la cuenta contable?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idCuentaContable"  : idCuentaContable,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-cuenta-contable',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-categoria-cc', function(e) {
    $('#btnEjecutarCategoriaCC').addClass("d-none");
    var idCategoriaCC = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' textarea').attr("disabled","disabled");

    $(formulario + ' input[type=text]').val("");
    $(formulario + ' textarea').text("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        $('#exampleinformacionCategoriaCuentaContable').text("Registrar Categoría");
        $('#formInformacionCategoriasCuentaContable').attr('action', baseUrl + '/registrar-categoria-cuenta-contable');
        $('#btnEjecutarCategoriaCC').removeClass("d-none");
        $('#btnEjecutarCategoriaCC').html('<i class="mdi mdi-content-save me-2 color-white" style="font-size: 18px;"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' textarea').removeAttr("disabled");
        
        Swal.close();
        
        $('#txtCategoriaCC_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-categoria-cuenta-contable', 
        {         
            idCategoriaCC : idCategoriaCC
        }, 
        function(response) 
        {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionCategoriaCuentaContable').text("Información de la Categoría");
                    $('#btnEjecutarCategoriaCC').addClass("d-none");
                    $('#formInformacionCategoriasCuentaContable').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' textarea').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionCategoriaCuentaContable').text("Actualizar Categoría");
                    $('#formInformacionCategoriasCuentaContable').attr('action', baseUrl + '/actualizar-categoria-cuenta-contable/' + idCategoriaCC);
                    $('#btnEjecutarCategoriaCC').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' textarea').removeAttr("disabled");
                }

                $('#txtIDCategoriaCC_i').val(response.idcategoriacc);
                $('#txtCategoriaCC_i').val(response.categoria);
                $('#txtObservacionCategoriaCC_i').val(response.observacion);
            }
        }, 'json'); 
    }
    
    $(formulario).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-categoria-cc', function() {
    var idCategoriaCC = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la categoría?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idCategoriaCC" : idCategoriaCC,
                "estado"        : estado,
                "motivo"        : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-categoria-cuenta-contable',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-subcategoria-cc', function(e) {
    $('#btnEjecutarSubcategoriaCC').addClass("d-none");
    var idSubcategoriaCC = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' textarea').attr("disabled","disabled");

    $(formulario + ' input[type=text]').val("");
    $(formulario + ' textarea').text("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        $('#exampleinformacionSubcategoriaCuentaContable').text("Registrar Subcategoría");
        $('#formInformacionSubcategoriasCuentaContable').attr('action', baseUrl + '/registrar-subcategoria-cuenta-contable');
        $('#btnEjecutarSubcategoriaCC').removeClass("d-none");
        $('#btnEjecutarSubcategoriaCC').html('<i class="mdi mdi-content-save me-2 color-white" style="font-size: 18px;"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' textarea').removeAttr("disabled");
        
        Swal.close();
        
        $('#txtCategoriaCC_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-subcategoria-cuenta-contable', 
        {         
            idSubcategoriaCC : idSubcategoriaCC
        }, 
        function(response) 
        {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionSubcategoriaCuentaContable').text("Información de la Subcategoría");
                    $('#btnEjecutarSubcategoriaCC').addClass("d-none");
                    $('#formInformacionSubcategoriasCuentaContable').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' textarea').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionSubcategoriaCuentaContable').text("Actualizar Subcategoría");
                    $('#formInformacionSubcategoriasCuentaContable').attr('action', baseUrl + '/actualizar-subcategoria-cuenta-contable/' + idSubcategoriaCC);
                    $('#btnEjecutarSubcategoriaCC').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' textarea').removeAttr("disabled");
                }

                $('#txtIDSubcategoriaCC_i').val(response.idsubcategoriacc);
                $('#txtSubcategoriaCC_i').val(response.subcategoria);
                $('#txtObservacionSubcategoriaCC_i').val(response.observacion);
            }
        }, 'json'); 
    }
    
    $(formulario).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-subcategoria-cc', function() {
    var idSubcategoriaCC = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la subcategoría?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idSubcategoriaCC"  : idSubcategoriaCC,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-subcategoria-cuenta-contable',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */
/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES ORDEN COMPRA */

/* ------------------------------- */

$(document).on('click', '#navOrdenCompraHistorico', function(e) {
    if (DataTable.isDataTable('#tblHistoricoOrdenCompra')) {
        $('#tblHistoricoOrdenCompra').DataTable().destroy();
    }
    
    serversideHistoricoOrdenCompra();
});

/* ------------------------------- */

function serversideHistoricoOrdenCompra()
{
    /***SERVERSIDE HISTÓRICO ORDEN DE COMPRA***/
	assetListHOC = {
			dt: null,
			init: function () {
				dt = $('#tblHistoricoOrdenCompra').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/ordenCompraServersideHistorico",
						type: 'GET'
					},
					"columns": [
						{"title": "# OC", "data": "oc", "class": "text-center", "searchable": true },
						{"title": "Fecha de Emisión", "data": "emision", "class": "text-center", "searchable": true },
						{"title": "Concepto", "data": "concepto", "class": "text-center", "searchable": true },
						{"title": "Proveedor", "data": "proveedor", "class": "text-center", "searchable": true },
						{"title": "Solicitante", "data": "solicitante", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "CC", "data": "cc", "class": "text-center", "searchable": true },
						{"title": "Monto Total", "data": "total", "class": "text-center", "searchable": true },
						{"title": "Estado",
							"data": "Estado",
							class: 'text-center',
							render: function(data, type, row){  // con row obtienes la información por fila
								if (row.Estado == 'Aprobado') {
                                    return "<span class='badge badge-aprobadoCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'PreAprobado') {
                                    return "<span class='badge badge-amarilloCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'PendienteAprobacion') {
                                    return "<span class='badge badge-amarilloCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'Anulado') {
                                    return "<span class='badge bg-danger'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'PendienteFirma1') {
                                    return "<span class='badge badge-amarilloCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'PendienteFirma2') {
                                    return "<span class='badge badge-amarilloCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'PendienteFirma3') {
                                    return "<span class='badge badge-amarilloCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'Rechazado') {
                                    return "<span class='badge bg-danger'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'Cancelado') {
                                    return "<span class='badge bg-black'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == '' || row.Estado == null) {
                                    return "<span class='badge' >" + row.Estado + "</span>";
                                }
							}
						},
						{"title": "Comprador", "data": "comprador", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "Categoría de Compra", "data": "categoria", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],

					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListHOC.init();
	/****FIN SERVERSIDE HISTÓRICO ORDEN DE COMPRA****/
}

/* ------------------------------- */
/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES NUEVA ORDEN COMPRA */

/* ------------------------------- */

// $('#txtFechaPedidoOC').datepicker({
//     autoclose: true,
//     language: 'es',
//     firstDay: 1,
//     todayHighlight: true,
//     format: 'dd/mm/yyyy',
//     minDate:0
//     // startDate: new Date()
//     // endDate: "Thu Apr 20 2023 15:51:20 GMT-0500"
// });

/* ------------------------------- */

function agregarItemOC()
{
    var random = generarRandom(5);
    
    var descripcion = $("#descripcionItem").val();
    var cantidad    = $("#cantidadItem").val();
    var precio      = $("#precioItem").val();
    var simbolo     = $('#cboMonedaOC option:selected').attr("data-simbolo");
    
    ultimoCaracterPrecio = precio.slice(-1);
    
    if(descripcion == '')
    {
        Swal.fire({
            html: 'Debe ingresar una descripción al item.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(cantidad == '')
    {
        Swal.fire({
            html: 'Debe ingresar la cantidad del item.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(precio == '')
    {
        Swal.fire({
            html: 'Debe ingresar el precio unitario del item.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if (isNaN(ultimoCaracterPrecio)) 
    {
        Swal.fire({
            html: 'El último caracter debe ser un número.',
            heightAuto: true,
            showConfirmButton: true
        });
    } 
    else if (formatoDecimal(precio) === false) 
    {
        Swal.fire({
            html: 'El precio no tiene formato decimal válido.',
            heightAuto: true,
            showConfirmButton: true
        });
    } 
    else 
    {
        var total = cantidad*precio;
        
        let contenedor = `<div class="row col-12 m-0 my-2 p-0 border-sistema-2px" id="itemOC${random}" style="border-radius: 10px;">
    		<div class="col-6 m-0 p-2">
    			<div>
    			    <input type="hidden" name="correlativo[]" value="`+random+`">
    				<input type="text" class="form-control" value="`+descripcion+`" name="descripcionitemoc[${random}]">
    			</div>
    		</div>
    		<div class="col-1 m-0 p-2">
    			<div>
    				<input type="text" class="form-control recalculartotalesitemoc" data-random="`+random+`" min="1" step="1" value="`+cantidad+`" name="cantidaditemoc[${random}]" onkeypress="return validarNumerosEnteros(event, this);">
    			</div>
    		</div>
    		<div class="col-2 m-0 p-2">
    		    <div class="input-group">
                    <span class="input-group-text lblSimboloMoneda">`+simbolo+`</span>
                    <input type="text" class="form-control recalculartotalesitemoc" data-random="`+random+`" min="0.0001" step="0.0001" value="`+precio+`" name="precioitemoc[${random}]" onkeypress="return validarNumerosDecimales(event, this);">
                </div>
    		</div>
    		<div class="col-2 m-0 p-2">
    			<div class="input-group">
                    <span class="input-group-text lblSimboloMoneda">`+simbolo+`</span>
                    <input type="text" class="form-control" value="`+parseFloat(total).toFixed(2)+`" name="totalitemoc$[${random}]" id="totalitemoc${random}" disabled>
                </div>
    		</div>
    		<div class="col-1 m-0 p-2 d-flex align-items-center justify-content-center">
    			<button type="button" class="btn bg-danger px-2 py-1" onclick="eliminarBloqueDinamico('itemOC${random}'); return calcularMontosItemOC();" data-tooltip="tooltip" aria-label="Eliminar Item OC">
                    <i class="mdi mdi-trash-can" style="font-size: 15px; color: #FFF"></i>
                </button>
    		</div>
    	</div>`;
    
        $("#ctnDetalleItemOC").append(contenedor);
        
        $("#descripcionItem").val("");
        $("#cantidadItem").val("");
        $("#precioItem").val("");
        
        calcularMontosItemOC();
        
    }
}

/* ------------------------------- */

function calcularMontosItemOC()
{
    var subtotal = 0;
    var igv = 0;
    var total = 0;
    var afectaigv = $("#cboIGVOC").val();
    
    $("input[name='correlativo[]']").each(function() {
        var precio = $("input[name='precioitemoc["+$(this).val()+"]']").val();
        var cantidad = $("input[name='cantidaditemoc["+$(this).val()+"]']").val();
        var totalItem = $("input[name='totalitemoc$["+$(this).val()+"]']").val();
        subtotal += parseFloat(totalItem);
    });
    
    if(afectaigv == "Afecta")
    {
        igv = subtotal * 0.18;
    }
    
    total = subtotal + igv;
    
    $("#subtotaldetalleoc").val(parseFloat(subtotal).toFixed(2));
    $("#igvdetalleoc").val(parseFloat(igv).toFixed(2));
    $("#totaldetalleoc").val(parseFloat(total).toFixed(2));
        
}

/* ------------------------------- */

$(document).on("keyup",".recalculartotalesitemoc",function(){
    
    var random = $(this).data("random");
    var precio = $("input[name='precioitemoc["+random+"]']").val();
    var cantidad = $("input[name='cantidaditemoc["+random+"]']").val();
    var totalItem = precio*cantidad;
    $("#totalitemoc"+random).val(parseFloat(totalItem).toFixed(2));
    calcularMontosItemOC();
})

/* ------------------------------- */

$(document).on("click",".sw-btn-next , .sw-btn-prev , .nav-link",function(){
    $(".toolbar-bottom").addClass('mt-4');
    $("ul.contenedorTab li>a").each(function(){

        var value = $(this);
        if(value.hasClass('active')){
            var valueA = value.attr("href");
            if(valueA=="#step-4"){
                $("#enviarSolicitud").removeClass("d-none");
            }else{
                $("#enviarSolicitud").addClass("d-none");
            }
        }
        
    })
})

/* ------------------------------- */

$(document).on('change', '#cboCategoriaOC', function() {
    // var modal = $(this).attr("data-modal");
    var idCategoria = $(this).val();
    
    selectSubcategoriaCuentaContable('cboSubcategoriaOC', idCategoria, '', '');
});

/* ------------------------------- */

$(document).on('change', '#cboDelegacionOC', function() {
    var idDelegacion = $(this).val();
    var option = $(this).find("option:selected");
    
    var cc = option.data("cc");
    var ln = option.data("ln");
    
    $("#txtCCOC").val(cc);
    $("#txtLNOC").val(ln);
    
    $("#cboSubareaOC").empty();
    
    $.post(baseUrl + '/listado-estructura-delegacion', 
    {         
        idDelegacion : idDelegacion
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            
            var global = $.parseJSON(response.listadoGlobal);
            
            $("#cboSubareaOC").append('\
                <option value="" selected>Seleccione una opción</td>\n\
            ');
            
            if(global.length > 0)
            {
                var selected = global.length == 1 ? 'selected' : '';
                
                for(var i = 0; i < global.length; i++){
                    $("#cboSubareaOC").append('\
                        <option value="' + global[i].id + '" '+selected+' >' + global[i].text +'</td>\n\
                    ');
                }
            }
            $('#cboSubareaOC').select2();
        }
    }, 'json'); 
});

/* ------------------------------- */

$(document).on('change', '#cboMonedaOC', function() {
    // var modal = $(this).attr("data-modal");
    var simbolo = $('#cboMonedaOC option:selected').attr("data-simbolo");
    $('.lblSimboloMoneda').html(simbolo);
});

/* ------------------------------- */

$(document).on('change', '#cboProveedorOC', function() {
    var idProveedor = $(this).val();
    
    var parametros = {
        "idProveedor"  : idProveedor
	};
	
    $.ajax({        
        url: baseUrl + '/obtener-datos-proveedor',
        type: "POST",
        data: parametros,
        dataType: 'json',
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                $('#lblRUCOC').val(response.ruc);
                $('#txtProveedorNombreOC').val(response.proveedor);
                $('#lblContactoOC').val(response.contacto);
                $('#lblPaisOC').val(response.pais);
                $('#lblDepartamento').val(response.departamento);
                $('#lblProvincia').val(response.provincia);
                $('#lblDistritoOC').val(response.distrito);
                
                $('#lblDireccionOC').val(response.direccion);
                $('#lblEmailOC').val(response.correo);
                $('#lblTelefono01OC').val(response.telefono01);
                $('#lblTelefono02OC').val(response.telefono02);
                
                selectFormaPago("cboFormaPagoOC", response.formapago, "");
                
                let arrayTipologias = response.tipologia.split('|');
                selectTipologia("cboMultiTipologiaOC", arrayTipologias, "");
                
                $('#txtCuentaDetraccionOC').val(response.cuentadetraccion);
                selectCodigoDetraccion("cboCodigoDetraccionOC", response.codigodetraccion, "");
                
                $('#txtCuentaOC').val(response.cuentabancaria);
                $('#txtCCIOC').val(response.cci);
                
                selectBanco("cboBancoOC", response.banco, "");
                selectModalidadPago("cboModalidadPagoOC", response.modalidadpago, "");
                selectMoneda("cboMonedaOC", response.moneda, "");
                $('.lblSimboloMoneda').html(response.simbolomoneda);
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
});

/* ------------------------------- */

$('#smartwizard-noc').on('click', '.sw-btn-next', function() {
    let stepInfo = $('#smartwizard-noc').smartWizard("getStepInfo");
    
    if(stepInfo.currentStep === 0)
    {
        var hoy = new Date();
        hoy.setHours(0,0,0,0);
        
        if($("#txtFechaPedidoOC").val() < $("#txtFechaPedidoOC").attr('min')  )
        {
            Swal.fire({
                html: 'La fecha de pedido debe ser mayor o igual a la fecha actual.',
                heightAuto: true,
                showConfirmButton: true
            });
            
            return false;
        }
    }
    else if(stepInfo.currentStep === 1)
    {
        calcularMontosItemOC();
    }
    else if(stepInfo.currentStep === 2)
    {
        recargarPrevisualizacionNuevaOrdenCompra();
    }
});

/* ------------------------------- */

function recargarPrevisualizacionNuevaOrdenCompra()
{
    //Recargamos Información General
    
    $('#lblConceptoOrdenCompra').val($('#conceptoOC').val());
    $('#lblSolicitanteOrdenCompra').val($('#solicitante').val());
    $('#lblFechaPedidoOrdenCompra').val($('#txtFechaPedidoOC').val());
    
    if($('#cboFormaPagoOC').val() == '')
    {
        $('#lblFormaPagoOrdenCompra').val('');
    }
    else
    {
        $('#lblFormaPagoOrdenCompra').val($('#cboFormaPagoOC option:selected').text());
    }
    
    if($('#cboDelegacionOC').val() == '')
    {
        $('#lblCentroCostoOrdenCompra').val('');
    }
    else
    {
        $('#lblCentroCostoOrdenCompra').val($('#cboDelegacionOC option:selected').text());
    }
    
    if($('#cboSubareaOC').val() == '')
    {
        $('#lblSubareaOrdenCompra').val('');
    }
    else
    {
        $('#lblSubareaOrdenCompra').val($('#cboSubareaOC option:selected').text());
    }
    
    //Recargamos Información Proveedor
    
    $('#lblProveedorOrdenCompra').val($('#txtProveedorNombreOC').val());
    $('#lblRUCOrdenCompra').val($('#lblRUCOC').val());
    $('#lblContactoOrdenCompra').val($('#lblContactoOC').val());
    $('#lblPaisOrdenCompra').val($('#lblPaisOC').val());
    $('#lblDepartamentoOrdenCompra').val($('#lblDepartamento').val());
    $('#lblProvinciaOrdenCompra').val($('#lblProvincia').val());
    $('#lblDistritoOrdenCompra').val($('#lblDistritoOC').val());
    $('#lblDireccionOrdenCompra').val($('#lblDireccionOC').val());
    $('#lblEmailOrdenCompra').val($('#lblEmailOC').val());
    $('#lblTelefono01OrdenCompra').val($('#lblTelefono01OC').val());
    $('#lblTelefono02OrdenCompra').val($('#lblTelefono02OC').val());

    //Recargamos Información Pago
    
    $('#lblMedioPagoOrdenCompra').val($('#cboModalidadPagoOC option:selected').text());
    
    if($('#cboBancoOC').val() == '')
    {
        $('#lblBancoOrdenCompra').val('');
    }
    else
    {
        $('#lblBancoOrdenCompra').val($('#cboBancoOC option:selected').text());
    }
    
    $('#lblCuentaBancariaOrdenCompra').val($('#txtCuentaOC').val());
    $('#lblCCIOrdenCompra').val($('#txtCCIOC').val());
    $('#lblCuentaDetraccionOrdenCompra').val($('#txtCuentaDetraccionOC').val());
    
    if($('#cboCodigoDetraccionOC').val() == '')
    {
        $('#lblCodigoDetraccionOrdenCompra').val('');
    }
    else
    {
        $('#lblCodigoDetraccionOrdenCompra').val($('#lblCodigoDetraccionOrdenCompra option:selected').text());
    }
    
    //Recargamos Información Detalle Item
    var simbolo = $('#cboMonedaOC option:selected').attr("data-simbolo");
    
    var correlativo = 0;
    
    $("#tblItemOrdenCompra > tbody").empty();
    
    $("input[name='correlativo[]']").each(function() {
        correlativo++;
        var descripcion = $("input[name='descripcionitemoc["+$(this).val()+"]']").val();
        var precio = $("input[name='precioitemoc["+$(this).val()+"]']").val();
        var cantidad = $("input[name='cantidaditemoc["+$(this).val()+"]']").val();
        var totalItem = $("#totalitemoc"+$(this).val()).val();
        
        $("#tblItemOrdenCompra > tbody").append("<tr><td class='text-center'>" + correlativo +
            "</td><td class='text-center'>" + descripcion +
            "</td><td class='text-center'>" + cantidad +
            "</td><td class='text-center'>" + simbolo + " " + precio +
            "</td><td class='text-center'>" + simbolo + " " + totalItem +
            "</td></tr>");
    });
    
    var subtotal = $('#subtotaldetalleoc').val();
    var igv = $('#igvdetalleoc').val();
    var total = $('#totaldetalleoc').val();
    
    $("#tblItemOrdenCompra > tbody").append("<tr><td class='text-end' colspan='4'>Subtotal</td>"+
            "<td class='text-center'>" + simbolo + " " + subtotal + "</td></tr>"+
            "<tr><td class='text-end' colspan='4'>IGV</td>"+
            "<td class='text-center'>" + simbolo + " " + igv + "</td></tr>"+
            "<tr><td class='text-end' colspan='4'>Total</td>"+
            "<td class='text-center'>" + simbolo + " " + total + "</td></tr>");
    
}

/* ------------------------------- */

$(document).on('submit', '.formularioRegistrarOrdenCompra', function(event) {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    var formData = new FormData(this);
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        dataType: 'json',
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            if(response.popup)
            {
                Swal.fire({
                    text: response.mensaje1,
                    icon: 'warning',
                    showCancelButton: false,
                    cancelButtonText: 'No',
                    confirmButtonColor: '#282e38',
                    confirmButtonText: 'OK'
                });
            }
            else
            {
                formulario.find('.respuesta').html(response.mensaje1);
            }
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
    
    
});

/* ------------------------------- */
/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES EDITAR RESPONSABLES FIRMA ORDEN COMPRA */

/* ------------------------------- */

$(document).on('click', '.responsablesFirmaOrdenCompra', function() {
    
    var idOrdenCompra = $(this).data('id');
    
    $("#idoc_roc").val(idOrdenCompra);
    
    var modal = $(this).data('bs-target');
    var formulario = $(this).data('form');
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' select').empty();
    $(formulario + ' textarea').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    $.post(baseUrl + '/obtener-datos-orden-compra', 
    {         
        idOrdenCompra : idOrdenCompra
    }, 
    function(response) 
    {
        Swal.close();
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            $('#concepto_roc').val(response.concepto);
            $('#proveedor_roc').val(response.proveedor);
            $("#cc_roc").val(response.cc);
            $("#ln_roc").val(response.ln);
            selectDelegacionesEstructura("cboDelegacionOC_roc", "TOTAL", response.iddelegacion, modal.substring(1));
            selectEstructuraDelegacion("cboSubareaOC_roc", response.iddelegacion, response.idsubarea, modal.substring(1));
            selectResponsablesSubarea("cboResponsableFirma01OC_roc", response.idsubarea, response.idfirma01, response.matriculafirma01+" | "+response.nombrefirma01, modal.substring(1));
            selectResponsablesArea("cboResponsableFirma02OC_roc", response.idarea, response.idfirma02, response.matriculafirma02+" | "+response.nombrefirma02, modal.substring(1));
            selectResponsablesDireccion("cboResponsableFirma03OC_roc", response.iddireccion, response.idfirma03, response.matriculafirma03+" | "+response.nombrefirma03, modal.substring(1));
        }
    }, 'json'); 
    
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('change', '#cboDelegacionOC_roc', function() {
    var idDelegacion = $(this).val();
    var modal = $(this).data("modal");
    var option = $(this).find("option:selected");
    
    var cc = option.data("cc");
    var ln = option.data("ln");
    
    $("#cc_roc").val(cc);
    $("#ln_roc").val(ln);
    
    $("#cboResponsableFirma01OC_roc").empty();
    $("#cboResponsableFirma02OC_roc").empty();
    $("#cboResponsableFirma03OC_roc").empty();
    
    selectEstructuraDelegacion("cboSubareaOC_roc", idDelegacion, "", modal);
    
});

/* ------------------------------- */

$(document).on('change', '#cboSubareaOC_roc', function() {
    var idSubarea = $(this).val();
    var modal = $(this).data("modal");
    var option = $(this).find("option:selected");
    
    var idArea = option.data("area");
    var idDireccion = option.data("direccion");
    
    selectResponsablesSubarea("cboResponsableFirma01OC_roc", idSubarea, "", "", modal);
    selectResponsablesArea("cboResponsableFirma02OC_roc", idArea, "", "", modal);
    selectResponsablesDireccion("cboResponsableFirma03OC_roc", idDireccion, "", "", modal);
});

/* ------------------------------- */
/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES EDITAR ORDEN COMPRA */

/* ------------------------------- */

$(document).on('change', '#categoria_eoc', function() {
    // var modal = $(this).attr("data-modal");
    var idCategoria = $(this).val();
    
    selectSubcategoriaCuentaContable('subcategoria_eoc', idCategoria, '', '');
});

/* ------------------------------- */

$(document).on('change', '#delegacion_eoc', function() {
    var idDelegacion = $(this).val();
    var option = $(this).find("option:selected");
    
    var cc = option.data("cc");
    var ln = option.data("ln");
    
    $("#cc_eoc").val(cc);
    $("#ln_eoc").val(ln);
    
    selectEstructuraDelegacion("subarea_eoc", idDelegacion, "", "");
    
});

/* ------------------------------- */

$(document).on('change', '#igv_eoc', function() {
    var igvafecta = $(this).val();
    var idOrdencompra = $(this).data("oc");
    recargarTablaDetalleOrdenCompra(idOrdencompra, igvafecta);
});

/* ------------------------------- */

$(document).on('change', '#proveedor_eoc', function() {
    var idProveedor = $(this).val();
    
    var parametros = {
        "idProveedor"  : idProveedor
	};
	
    $.ajax({        
        url: baseUrl + '/obtener-datos-proveedor',
        type: "POST",
        data: parametros,
        dataType: 'json',
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                $('#ruc_eoc').val(response.ruc);
                $('#contacto_eoc').val(response.contacto);
                $('#pais_eoc').val(response.pais);
                $('#departamento_eoc').val(response.departamento);
                $('#provincia_eoc').val(response.provincia);
                $('#distrito_eoc').val(response.distrito);
                
                $('#direccion_eoc').val(response.direccion);
                $('#correo_eoc').val(response.correo);
                $('#telefono_eoc').val(response.telefono01);
                
                selectFormaPago("formapago_eoc", response.formapago, "");
                
                $('#txtCuentaDetraccionOC').val(response.cuentadetraccion);
                selectCodigoDetraccion("cboCodigoDetraccionOC", response.codigodetraccion, "");
                
                $('#cuentabancaria_eoc').val(response.cuentabancaria);
                $('#cuentainterbancaria_eoc').val(response.cci);
                
                selectBanco("banco_eoc", response.banco, "");
                selectModalidadPago("modalidadpago_eoc", response.modalidadpago, "");
                selectMoneda("moneda_eoc", response.moneda, "");
                $('.lblSimboloMoneda').html(response.simbolomoneda);
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
});

/* ------------------------------- */

function recargarTablaDetalleOrdenCompra(idOrdenCompra, igvafecta)
{
    var subtotal = 0;
    var condicionigv = "Noafecta";
    var simbolo = "";
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    if ($('#tblDetalleOrdenCompra_eoc').hasClass('dataTable')) 
    {
        $('#tblDetalleOrdenCompra_eoc').DataTable().destroy();
    }
    
    tbldetalleoc = $("#tblDetalleOrdenCompra_eoc").DataTable({
        "responsive": true,
        "ajax": {
            "url": baseUrl + "/recargar-tabla-detalle-orden-compra",
            "type": "POST",
            "data": {
                "idOrdenCompra" : idOrdenCompra
            },
            "dataSrc": function (json) {
                
                for ( var i=0, ien=json.data.length ; i<ien ; i++ ) 
                {
                    condicionigv = json.data[i]['afectaigv'];
                    simbolo = json.data[i]['moneda'];
                    
                    if(json.data[i]['estado'] == "A")
                    {
                        subtotal += parseFloat(json.data[i]['preciototal']);
                        json.data[i]['preciototal'] = json.data[i]['moneda']+' '+json.data[i]['preciototal'];
                    }
                    else
                    {
                        json.data[i]['preciototal'] = json.data[i]['moneda']+' 0';
                    }
                    
                    json.data[i]['preciounitario'] = json.data[i]['moneda']+' '+json.data[i]['preciounitario'];
                    
                    
                    // json.data[i]['estado'] = "<button class='badge "+(json.data[i]['estado'] == 'A' ? 'bg-success' : 'bg-danger')+" border-0 cambiar-estado-proveedor-pago' data-estado='"+json.data[i]['estado']+"' data-id='"+json.data[i]['iddetalleoc']+"' data-oc='"+json.data[i]['idordencompra']+"'>"+(json.data[i]['estado'] == 'A' ? 'ACTIVO' : 'INACTIVO')+"</button>";
                    
                    if(json.data[i]['estadooc'] != "Aprobado" && json.data[i]['estadooc'] != "Anulado" && json.data[i]['estadooc'] != "Rechazado" && json.data[i]['estadooc'] != "Cancelado" && json.data[i]['perfillogueado'] == 1)
                    {
                        json.data[i]['acciones'] = `<center>
                            <div class='btn-group' role='group' aria-label=''>
                                <button type="button" class="btn bg-danger px-2 py-1 d-flex justify-content-center align-items-center color-white mx-1 cambiar-estado-detalle-orden-compra" data-estado='`+json.data[i]['estado']+`' data-id="`+json.data[i]['iddetalleoc']+`" data-oc='`+json.data[i]['idordencompra']+`' data-tooltip="tooltip" aria-label="Cambiar estado Detalle" >
                                    <span class='mdi mdi-trash-can' ></span>
                                </button>
                                <button type="button" class="btn bg-warning px-2 py-1 d-flex justify-content-center align-items-center color-white mx-1 datos-detalle-orden-compra" data-form="#formInformacionDetalleOrdenCompra" data-bs-target="#informacionDetalleOrdenCompra" data-id="`+json.data[i]['iddetalleoc']+`" data-oc='`+json.data[i]['idordencompra']+`' data-accion="editar">
                                    <span class='mdi mdi-pencil' ></span>
                                </button>
                            </div>
                        </center>`;
                    }
                }
                
                Swal.close();
                return json.data;
            },
            "error": function (xhr, error, thrown) {
                alert(thrown.message)
            }
        },
        columnDefs: [
            { className: "text-center align-middle", targets: "_all" }
        ],
        columns: [
           { data: 'correlativo' },
           { data: 'descripcion' },
           { data: 'cantidad' },
           { data: 'preciounitario' },
           { data: 'preciototal' },
           { data: 'acciones' }
        ]
    });
    
    tbldetalleoc.on('draw.dt', function () {
        var igv = 0;
        var total = 0;
        
        if((igvafecta == "" && condicionigv == "Afecta") || igvafecta == "Afecta")
        {
            igv = parseFloat(subtotal) * 0.18;
        }

        total = parseFloat(subtotal) + parseFloat(igv);
        
        $("#subtotaldetalleeoc").val(parseFloat(subtotal).toFixed(2));
        $("#igvdetalleeoc").val(parseFloat(igv).toFixed(2));
        $("#totaldetalleeoc").val(parseFloat(total).toFixed(2));
        $(".lblSimboloMoneda").text(simbolo);
    });
}

/* ------------------------------- */

$(document).on('click', '.datos-detalle-orden-compra', function(e) {
    $('#btnEjecutarDetalleOrdenCompra').addClass("d-none");
    
    var idDetalleOC = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('form');
    var modal = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        $('#exampleinformacionDetalleOrdenCompra').text("Registrar Detalle");
        $('#formInformacionDetalleOrdenCompra').attr('action', baseUrl + '/registrar-detalle-orden-compra');
        $('#btnEjecutarDetalleOrdenCompra').removeClass("d-none");
        $('#btnEjecutarDetalleOrdenCompra').html('<i class="mdi mdi-content-save me-2 color-white" style="font-size: 18px;"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        
        Swal.close();
        
        $('#descripcionItem_eoc').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-detalle-orden-compra', 
        {         
            idDetalleOC : idDetalleOC
        }, 
        function(response) 
        {
            Swal.close();
            if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionDetalleOrdenCompra').text("Información del Detalle");
                    $('#btnEjecutarDetalleOrdenCompra').addClass("d-none");
                    $('#formInformacionDetalleOrdenCompra').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionDetalleOrdenCompra').text("Actualizar Detalle");
                    $('#formInformacionDetalleOrdenCompra').attr('action', baseUrl + '/actualizar-detalle-orden-compra/' + idDetalleOC);
                    $('#btnEjecutarDetalleOrdenCompra').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                }

                $('#txtIDDetalleOC_eoc').val(response.iddetalle);
                $('#txtIDOrdenCompra_eoc').val(response.idordencompra);
                $('#descripcionItem_eoc').val(response.descripcion);
                $('#cantidadItem_eoc').val(response.cantidad);
                $('#precioItem_eoc').val(response.precio);
                $('#totalItem_eoc').val(response.total);
            }
        }, 'json'); 
    }
    
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-detalle-orden-compra', function() {
    var idDetalle = $(this).data("id");
    var idOrdenCompra = $(this).data("oc");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'ELIMINAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el detalle de la OC?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idDetalle"     : idDetalle,
                "idOrdenCompra" : idOrdenCompra,
                "estado"        : estado,
                "motivo"        : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-detalle-orden-compra',
                type: "POST",
                data: parametros,
                dataType: 'json',
                success: function(response) {
                    
                    if(response.ejecucion)
                    {
                        recargarTablaDetalleOrdenCompra(idOrdenCompra, "");
                    }
                    
                    $('.respuesta_global').html(response.mensaje1);
                    
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('submit', '.formularioInformacionDetalleOrdenCompra', function(event) {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    var modal = $(this).data("modal");
    
    var formData = new FormData(this);
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        dataType: 'json',
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            if(response.ejecucion)
            {
                recargarTablaDetalleOrdenCompra(formData.get("txtIDOrdenCompra_eoc"), "");
                $(modal).modal("hide");
            }
            
            if(response.popup)
            {
                Swal.fire({
                    text: response.mensaje1,
                    icon: 'warning',
                    showCancelButton: false,
                    cancelButtonText: 'No',
                    confirmButtonColor: '#282e38',
                    confirmButtonText: 'OK'
                });
            }
            else
            {
                formulario.find('.respuesta').html(response.mensaje1);
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */
function VentanaCentrada(theURL, winName, features, myWidth, myHeight, isCenter) {
  if (window.screen && isCenter && isCenter === "true") {
    var myLeft = (screen.width - myWidth) / 2;
    var myTop = (screen.height - myHeight) / 2;
    features += (features !== "") ? "," : "";
    features += "left=" + myLeft + ",top=" + myTop;
  }

  var newWindow = window.open(theURL, winName, features + ((features !== "") ? "," : "") + "width=" + myWidth + ",height=" + myHeight);

  newWindow.onload = function() {
    // Agregar enlace de descarga del PDF
    var downloadLink = newWindow.document.createElement("a");
    downloadLink.href = theURL; // URL del PDF
    downloadLink.download = "documento.pdf"; // Nombre del archivo a descargar
    downloadLink.innerText = "Descargar PDF";
    newWindow.document.body.appendChild(downloadLink);
  };
}
/* ------------------------------- */

function imprimir_oc(idOrdenCompra) {
 VentanaCentrada(baseUrl + '/ver-pdf-orden-compra/' + idOrdenCompra, 'OC', '', '1024', '768', 'true');
}

/* ------------------------------- */

function validarCambioEstadoOrdenCompra(idOrdenCompra, estado)
{
    var modal = "#cambioEstadoOrdenCompra";
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    $.post(baseUrl + '/validar-cambio-estado-orden-compra', 
    {         
        idOrdenCompra   : idOrdenCompra,
        estado          : estado
    }, 
    function(response) 
    {
        Swal.close();
        
        if(response.popup)
        {
            Swal.fire({
                text: response.mensaje1,
                icon: 'warning',
                showCancelButton: false,
                cancelButtonText: 'No',
                confirmButtonColor: '#282e38',
                confirmButtonText: 'OK'
            });
        }
        else 
        {
            $('#ctnMensajeCambioEstadoOC').html(response.mensaje1);
            
            $(modal).modal("show");
        }
    }, 'json');
        
}

/* ------------------------------- */

$(document).on('submit', '.formularioCambioEstadoOrdenCompra', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    var formData = new FormData(this);
        
    if(pondAutorizacionOC != '')
    {
        const pondFiles = pondAutorizacionOC.getFiles();
        
        if (pondFiles.length === 0) {
            Swal.fire({
                text: "Debe adjuntar la justificación de la aprobación solicitada.",
                icon: 'warning',
                showCancelButton: false,
                cancelButtonText: 'No',
                confirmButtonColor: '#282e38',
                confirmButtonText: 'OK'
            });
            return false;
        }
        for (var i = 0; i < pondFiles.length; i++) {
            formData.append('fileAutorizacion[]', pondFiles[i].file);
        }
        
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '#actualizarOrdenCompra', function(event) {
    event.preventDefault();
    var formulario = $("#formEditarOrdenCompra");
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    var formData = new FormData(formulario[0]);
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            $('.respuesta_global').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES IMPORTAR | EXPORTAR ORDEN COMPRA */

/* ------------------------------- */

$(document).on('click', '#btnImportarOC', function(event) {
    // event.preventDefault();
    const inputElement = document.querySelector('inputGroupFile01');
    // console.log( pondImportOC );
    if (pondImportOC && pondImportOC.isFilePond) {
        const filePondInstance = pondImportOC.getInstance();
        console.log("es filepond");
        if (filePondInstance) {
            filePondInstance.destroy();
            console.log("se destruye");
        }
    }
    // if (pondImportOC != "") {
    //     const filePondInstance = pondImportOC.getInstance();
    //     if (filePondInstance) {
    //         filePondInstance.destroy();
    //     }
    // }
    
     pondImportOC = FilePond.create(
        document.querySelector("#inputGroupFile01"), {
            labelIdle: 'Arrastra y suelta el CSV de importación o <span class="filepond--label-action">explora</span>',
            allowMultiple: false,
            instantUpload: false,
            allowProcess: false
        }
    );
    console.log("se crea filepond");
    // return false;
    
});

/* ------------------------------- */

function descargarEstructuraDepartamental()
{
    window.open(baseUrl+"/exportar-estructura-departamental/",'_blank');
}

function descargarSubcategoriasCuentaContable()
{
    window.open(baseUrl+"/exportar-subcategorias-cuenta-contable/",'_blank');
}
/* ------------------------------- */

$(document).on('submit', '.formularioImportarOC', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondImportOC.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar la plantilla a subir.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '#exportarOrdenCompra', function(event) {
    let fechaInicio = $("#fechaInicio").val();
    let fechaFin = $("#fechaFin").val();
    
    if(fechaInicio == '')
    {
        Swal.fire({
            html: 'Debe seleccionar una fecha de inicio.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(fechaFin == '')
    {
        Swal.fire({
            html: 'Debe seleccionar una fecha de fin.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else 
    {
        window.open(baseUrl+"/exportar-orden-compra/"+fechaInicio+"/"+fechaFin,'_blank');
    }
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES ADICIONALES ACCESO EXTERNOS */

/* ------------------------------- */

$(document).on('click', '.eliminar-externo-proveedor', function() {
    var idExterno   = $(this).data("externo");
    var idProveedor = $(this).data("proveedor");
    
    Swal.fire({
        title: '¿Estas seguro que deseas eliminar al usuario del proveedor?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {
            
            var parametros = {
                "idExterno"     : idExterno,
                "idProveedor"   : idProveedor
    		};
            $.ajax({        
                url: baseUrl + '/eliminar-externo-proveedor',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarExternoProveedor', function(e) {
    var idExterno = $("#cboUsuariosExternos").val();
    var idProveedor = $(this).data("proveedor");
    var textExterno = $("#cboUsuariosExternos").select2('data')[0]['text'].split("|");

    var nombreExterno = textExterno[0];
    
    if(idExterno == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el usuario externo a asociar.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        Swal.fire({
            title: '¿Estas seguro que deseas asociar al usuario externo '+nombreExterno+' al proveedor?',
            //text: "Recuerda que esta acción es permanente.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#282e38',
            cancelButtonColor: '#f35d5d',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
                
                var parametros = {
                    "idExterno"     : idExterno,
                    "idProveedor"   : idProveedor
        		};
                $.ajax({        
                    url: baseUrl + '/asociar-externo-proveedor',
                    type: "POST",
                    data: parametros,
                    success: function(response) {
                        $('.respuesta_global').html(response);
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        Swal.close();
                    
                        Swal.fire({
                            title: 'Ha ocurrido un error interno',
                            text: errorThrown,
                            icon: 'error',
                            showCancelButton: false,
                            confirmButtonColor: '#E4002B',
                            confirmButtonText: 'Confirmar'
                        });
                    }
                });
            }
        });
    }
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES VALIDACIÓN DE COMPROBANTES ORDEN COMPRA */

/* ------------------------------- */

$(document).on('click', '.validar-comprobante-oc', function(e) 
{
    let modal = $(this).data("bs-target");
    
    let idComprobanteOC = $(this).data("comprobante");
    $('#txtIDComprobanteOC_vcoc').val(idComprobanteOC);
    // pondFacturaProveedor.removeFiles();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    $.post(baseUrl + '/obtener-datos-comprobante-orden-compra', 
    {         
        idComprobanteOC : idComprobanteOC
    }, 
    function(response) 
    {
        Swal.close();
        if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            $('#txtIDOrdenCompra_vcoc').val(response.idordencompra);
            $('#txtNroOrdenCompra').val(response.idordencompra);
            $("#txtConceptoOrdenCompra").val(response.concepto);
            $("#txtProveedorOrdenCompra").val(response.proveedor);
            $("#txtFechaEmisionOrdenCompra").val(response.fechaemision);
            $("#txtMontoTotalOrdenCompra").val(response.montototal);
            $("#spnSimboloMontoOrdenCompra").text(response.simbolo);
            $("#btnDescargarComprobanteOC").attr("download", response.nombrefichero);
            $("#btnDescargarComprobanteOC").attr("href", response.rutafichero);
        }
    }, 'json'); 
    
    $(modal).modal("show");
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES VALIDACIÓN DE COMPROBANTES ORDEN COMPRA */

/* ------------------------------- */

$(document).on('click', '#btnNuevaPeticion', function(e) 
{
    let modal = $(this).data("bs-target");
    
    $(modal).modal("show");
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES REQUERIMIENTOS DE PETICIONES */

/* ------------------------------- */

$(document).on('click', '.datos-requerimiento', function(e) {
    $('#btnEjecutarRequerimiento').addClass("d-none");
    var idRequerimiento = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtRequerimiento_i').attr("disabled","disabled");
    $('#txtTipoRequerimiento_i').attr("disabled","disabled");
    $('#txtObservacionRequerimiento_i').attr("disabled","disabled");
    
    $('#txtRequerimiento_i').val("");
    $('#txtTipoRequerimiento_i').val("");
    $('#txtObservacionRequerimiento_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionRequerimiento').text("Registrar Requerimiento");
        $('#formInformacionRequerimiento').attr('action', baseUrl + '/registrar-requerimiento');
        $('#btnEjecutarRequerimiento').removeClass("d-none");
        $('#btnEjecutarRequerimiento').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtRequerimiento_i').removeAttr("disabled");
        $('#txtTipoRequerimiento_i').removeAttr("disabled");
        $('#txtObservacionRequerimiento_i').removeAttr("disabled");
        
        $('#txtRequerimiento_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-requerimiento', 
        {         
            idRequerimiento : idRequerimiento
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionRequerimiento').text("Información del Requerimiento");
                    $('#btnEjecutarRequerimiento').addClass("d-none");
                    $('#formInformacionRequerimiento').attr('action', '');

                    $('#txtRequerimiento_i').attr("disabled","disabled");
                    $('#txtTipoRequerimiento_i').attr("disabled","disabled");
                    $('#txtObservacionRequerimiento_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionRequerimiento').text("Actualizar Requerimiento");
                    $('#formInformacionRequerimiento').attr('action', baseUrl + '/actualizar-requerimiento/' + idRequerimiento);
                    $('#btnEjecutarRequerimiento').removeClass("d-none");

                    $('#txtRequerimiento_i').removeAttr("disabled");
                    $('#txtTipoRequerimiento_i').removeAttr("disabled");
                    $('#txtObservacionRequerimiento_i').removeAttr("disabled");
                }

                $('#txtIDRequerimiento_i').val(response.idrequerimiento);
                $('#txtRequerimiento_i').val(response.requerimiento);
                $('#txtTipoRequerimiento_i').val(response.tipo);
                $('#txtObservacionRequerimiento_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-requerimiento', function() {
    var idRequerimiento = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el requerimiento?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idRequerimiento"   : idRequerimiento,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-requerimiento',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-motivo-requerimiento', function(e) {
    $('#btnEjecutarMotivoRequerimiento').addClass("d-none");
    var idMotivo = $(this).data('id');
    var accion = $(this).data('accion');
    var modal = $(this).data('bs-target');
    
    $('#txtMotivoRequerimiento_i').attr("disabled","disabled");
    $('#txtObservacionMotivoReq_i').attr("disabled","disabled");
    $('#txtUsuarioResponsable_mr').attr("disabled","disabled");
    
    $('#txtMotivoRequerimiento_i').val("");
    $('#txtObservacionMotivoReq_i').val("");
    $('#txtUsuarioResponsable_mr').empty();
        
    if(accion == 'crear')
    {
        $('#exampleinformacionMotivoRequerimiento').text("Registrar Motivo Requerimiento");
        $('#formInformacionMotivoRequerimiento').attr('action', baseUrl + '/registrar-motivo-requerimiento');
        $('#btnEjecutarMotivoRequerimiento').removeClass("d-none");
        $('#btnEjecutarMotivoRequerimiento').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtMotivoRequerimiento_i').removeAttr("disabled");
        $('#txtObservacionMotivoReq_i').removeAttr("disabled");
        $('#txtUsuarioResponsable_mr').removeAttr("disabled");
        
        selectCompradores("txtUsuarioResponsable_mr", "", "", modal.substring(1));
        
        $('#txtMotivoRequerimiento_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-motivo-requerimiento', 
        {         
            idMotivo : idMotivo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionMotivoRequerimiento').text("Información del Motivo de Requerimiento");
                    $('#btnEjecutarMotivoRequerimiento').addClass("d-none");
                    $('#formInformacionMotivoRequerimiento').attr('action', '');

                    $('#txtMotivoRequerimiento_i').attr("disabled","disabled");
                    $('#txtObservacionMotivoReq_i').attr("disabled","disabled");
                    $('#txtUsuarioResponsable_mr').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionMotivoRequerimiento').text("Actualizar Motivo del Requerimiento");
                    $('#formInformacionMotivoRequerimiento').attr('action', baseUrl + '/actualizar-motivo-requerimiento/' + idMotivo);
                    $('#btnEjecutarMotivoRequerimiento').removeClass("d-none");

                    $('#txtMotivoRequerimiento_i').removeAttr("disabled");
                    $('#txtObservacionMotivoReq_i').removeAttr("disabled");
                    $('#txtUsuarioResponsable_mr').removeAttr("disabled");
                }

                $('#txtIDMotivoRequerimiento_i').val(response.idmotivo);
                $('#txtMotivoRequerimiento_i').val(response.motivo);
                $('#txtObservacionMotivoReq_i').val(response.observacion);
                selectCompradores("txtUsuarioResponsable_mr", response.responsable, "", modal.substring(1));
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-motivo-requerimiento', function() {
    var idMotivo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el motivo del requerimiento?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idMotivo"  : idMotivo,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-motivo-requerimiento',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES PETICIONES */

/* ------------------------------- */

$(document).on('change', '#txtTipoRequerimiento_poc', function() {
   
    var tipoRequerimiento   = $(this).val();
    var modal               = $(this).attr("data-modal");
    
    $("#txtRequerimiento_poc").empty();
    $("#txtMotivoRequerimiento_poc").empty();
    $("#txtCompradorResponsable_poc").empty();
    
    selectRequerimientos('txtRequerimiento_poc', tipoRequerimiento, '', modal);
});

/* ------------------------------- */

$(document).on('change', '#txtRequerimiento_poc', function() {
    
    var idRequerimiento = $(this).val();
    var modal           = $(this).attr("data-modal");
    // var peticion = $("#txtPeticion_i").val().trim();
    
    $("#txtMotivoRequerimiento_poc").empty();
    $("#txtCompradorResponsable_poc").empty();
    
    selectMotivosRequerimiento('txtMotivoRequerimiento_poc', idRequerimiento, '', modal);
    // selectGruposTrabajoRequerimiento('txtGruposTrabajoPeticion_i', idRequerimiento, '', modal);
    
    var textRequerimiento = $("#txtRequerimiento_poc option:selected").text();
    $("#txtRequerimientoTextPeticion").val(textRequerimiento);
});

/* ------------------------------- */

$(document).on('change', '#txtMotivoRequerimiento_poc', function() {
    
    var idMotivo    = $(this).val();
    var modal       = $(this).attr("data-modal");
    
    $("#txtCompradorResponsable_poc").empty();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    $.post(baseUrl + '/obtener-datos-motivo-requerimiento', 
    {         
        idMotivo : idMotivo
    }, 
    function(response) {
        
        Swal.close();
        
        selectCompradores("txtCompradorResponsable_poc", response.responsable, "", modal);
        
    }, 'json');
});

/* ------------------------------- */

$(document).on('click', '#btnNuevaPeticion', function(e) {
    
    var modal       = $(this).data('bs-target');
    var formulario  = $(this).data('form');
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' input[type=email]').val("");
    $(formulario + ' input[type=date]').val("");
    $(formulario + ' input[type=file]').val("");
    $(formulario + ' textarea').val("");
    $(formulario + ' select').val("");
    
    // $(formulario + ' select').val(null).trigger('change');
    
    // selectGruposTrabajo('txtGruposTrabajoPeticion_i', '', formulario.substring(1))
    selectTipoRequerimientos("txtTipoRequerimiento_poc", "", modal.substring(1));
    selectMoneda("cboMoneda_poc", "", modal.substring(1));
    pondRegistrarPeticion.removeFiles();
    
    $(modal).modal("show");
});

/* ------------------------------- */
$(document).on('submit', '.formularioRegistrarPeticion', function() {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondRegistrarPeticion.getFiles();
    
    // if (pondFiles.length === 0) {
    //     Swal.fire({
    //         text: "Debe adjuntar el correo para la validación.",
    //         icon: 'warning',
    //         showCancelButton: false,
    //         cancelButtonText: 'No',
    //         confirmButtonColor: '#282e38',
    //         confirmButtonText: 'OK'
    //     });
    //     return false;
    // }
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    var formData = new FormData(this);

    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile[]', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            clickOne(true);
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            clickOne(false);
            formulario.find('.respuesta').html(response);
            console.log(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            clickOne(false);
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
});
/* ------------------------------- */

function confirmarEstadoGestionPeticion(idPeticion, estado, categorizacion)
{
    var mensaje = "";
    var texthtml = "";
    
    if(estado == 'INIC')
    {
        mensaje = '¿Todo listo para comenzar la gestión?[INICIADO]';
        if(categorizacion == '' || categorizacion == null)
        {
            texthtml = '<div class="row col-12 m-0 p-0 px-2 my-2 d-flex">\n\
			    <div class="col-5 p-0 d-flex justify-content-start align-items-center">\n\
					<label class="form-label">Categorización</label>\n\
				</div>\n\
			    <div class="col-7 p-0">\n\
					<div class="input-group">\n\
						<select class="form-select" id="txtCategorizacionPeticion_i" name="txtCategorizacionPeticion_i">\n\
							<option value="RR" selected>Recurrente</option>\n\
							<option value="NR">No Recurrente</option>\n\
							<option value="CT">Compra Técnica</option>\n\
							<option value="LI">Licitación</option>\n\
						</select>\n\
					</div>\n\
				</div>\n\
			</div>';
        }
    }
    else if(estado == 'ESPE')
    {
        mensaje = '¿Deseas poner en pausa la gestión?[EN ESPERA]';
    }
    else if(estado == 'COMP')
    {
        mensaje = '¿Deseas terminar la gestión?[COMPLETADO]';
    }
    else if(estado == 'APRO')
    {
        mensaje = '¿Deseas aprobar la petición gestionada?[APROBADO]';
    }
    else if(estado == 'REEV')
    {
        mensaje = '¿Deseas reevaluar la petición gestionada?[REEVALUADO]';
    }
    else if(estado == 'RECH')
    {
        mensaje = '¿Deseas rechazar la petición gestionada?[RECHAZADO]';
    }
    else if(estado == 'CANC')
    {
        mensaje = '¿Deseas cancelar la petición gestionada?[CANCELADO]';
    }
    
    
    Swal.fire({
        title: mensaje,
        html: texthtml,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        customClass: {
            container: 'my-swal-container' // Clase personalizada para el contenedor
        },
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // // Si el valor es válido, debes regresar undefined. Si no, una cadena
            // if (!obs) {
            //     return "Por favor escribe el motivo";
            // } else {
            //     return undefined;
            // }
        },
        didOpen: () => {
            // Aplicar CSS después de que el Swal se haya abierto
            const textarea = document.querySelector('.swal2-textarea');
            if (textarea) {
                textarea.style.padding = '10px'; // Ajustar padding según sea necesario
                textarea.style.border = '1px solid #dcdcdc'; // Estilo opcional para el borde
                textarea.style.borderRadius = '4px'; // Estilo opcional para bordes redondeados
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            var inputCat = $("#txtCategorizacionPeticion_i");
            
            if(inputCat.length > 0)
            {
                var categorizacion = inputCat.val();
            }
            else
            {
                var categorizacion = "";
            }
            
            var parametros = {
                "txtEstadoPeticion_i" : estado,
                "txtMotivoCambioEstadoPeticion_i" : motivo,
                "categorizacion" : categorizacion
    		};
            $.ajax({        
                url: baseUrl + '/cambio-estado-peticion/'+idPeticion,
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
}

/* ------------------------------- */

$(document).on('click', '#btnAgregarComentarioPeticion', function(e) 
{
    var modal = $(this).data('bs-target');
    pondAdjuntosComentario.removeFiles();
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('submit', '.formularioAgregarComentarioPeticion', function() {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondAdjuntosComentario.getFiles();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    var formData = new FormData(this);
    
    if(pondFiles.length > 0)
    {
        for (var i = 0; i < pondFiles.length; i++) 
        {
            const file = pondFiles[i].file;
            console.log(file.size);
            if (file.size > 0)
            {
                formData.append('itemsFile[]', pondFiles[i].file);
            }
        }
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            clickOne(true);
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            clickOne(false);
            formulario.find('.respuesta').html(response);
            console.log(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            clickOne(false);
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
});
/* ------------------------------- */

$(document).on('click', '#btnAsignarUsuarioPeticion', function(e) 
{
    var modal = $(this).data('bs-target');
    selectCompradores("txtAsignarUsuarioPeticion_i", "", "", modal.substring(1));
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('click', '#btnCompletarPeticion', function(e) 
{
    var modal = $(this).data('bs-target');
    pondAdjuntosPeticionCompletada.removeFiles();
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('submit', '.formularioCompletarPeticion', function() {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondAdjuntosPeticionCompletada.getFiles();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    var formData = new FormData(this);
    
    if(pondFiles.length > 0)
    {
        for (var i = 0; i < pondFiles.length; i++) 
        {
            const file = pondFiles[i].file;
            
            if (file.size > 0)
            {
                formData.append('valorizadoCompletado[]', pondFiles[i].file);
            }
        }
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            clickOne(true);
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            clickOne(false);
            formulario.find('.respuesta').html(response);
            console.log(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            clickOne(false);
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
});

/* ------------------------------- */

$(document).on('click', '#btnGnerarOCPeticion', function(e) 
{
    var modal = $(this).data('bs-target');
    $('#cboCompradorOC').select2({
        dropdownParent: $(modal+' .modal-body')
    });
    $('#cboEnvioFacturaOC').select2({
        dropdownParent: $(modal+' .modal-body')
    });
    $('#cboBudgetOC').select2({
        dropdownParent: $(modal+' .modal-body')
    });
    $('#cboIGVOC').select2({
        dropdownParent: $(modal+' .modal-body')
    });
    
    selectCategoriaCuentaContable("cboCategoriaOC", "TOTAL", "", modal.substring(1));
    selectDelegacionesEstructura("cboDelegacionOC", "TOTAL", "", modal.substring(1));
    selectCompradores("cboCompradorOC", "", "", modal.substring(1));
    
    $("#cboProveedorOC").select2({
        minimumInputLength: 2,
        dropdownParent: $(modal+' .modal-body'),
        placeholder: 'Seleccione Proveedor',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-proveedores-autocompletado',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });

    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('click', '#navPeticionesHistorico', function(e) {
    if (DataTable.isDataTable('#tblHistoricoPeticiones')) {
        $('#tblHistoricoPeticiones').DataTable().destroy();
    }
    
    serversideHistoricoPeticiones();
});

function serversideHistoricoPeticiones()
{
    /***SERVERSIDE HISTÓRICO PETICIONES***/
	assetListVM = {
		dt: null,
		init: function () {
			dt = $('#tblHistoricoPeticiones').DataTable({
				"serverSide": true,
				"processing": true,
				"ajax": {
					"url": baseUrl + "/peticionesServersideHistorico",
					type: 'GET'
				},
				"columns": [
					{"title": "Nro Petición", "data": "NroPeticion", "class": "text-center", "searchable": true },
					{"title": "Orden de Compra", "data": "NroOrdenCompra", "class": "text-center", "searchable": true },
					{"title": "Fecha de Creación", "data": "FechaCreacion", "class": "text-center", "searchable": true },
					{"title": "Fecha Último Cambio", "data": "FechaUltimoCambio", "class": "text-center", "searchable": true },
					{"title": "Delegación Solicitante", "data": "DelegacionSolicitante", "class": "text-center", "searchable": true },
					{"title": "Perfil Solicitante", "data": "Perfil", "class": "text-center", "searchable": true },
					{"title": "Requerimiento", "data": "Requerimiento", "class": "text-center", "searchable": true },
					{"title": "Motivo", "data": "Motivo", "class": "text-center", "searchable": true },
					{"title": "Usuario Último Cambio", "data": "UsuarioUltimoCambio", "class": "text-center", "searchable": true },
					{"title": "Estado", "data": "BtnEstado", "class": "text-center", "searchable": true },
					{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false },
				],
				"lengthMenu": [[10, 25, 50], [10, 25, 50]],
				responsive: true,
				autoWidth: false,
				"aaSorting": [[0, 'desc']],
			});
		}
	}

	assetListVM.init();
	/****FIN SERVERSIDE HISTÓRICO PETICIONES****/
}

/* ------------------------------- */

/* ------------------------------- */

$(document).on('click', '#btnGuardarComprobantesValidados', function(e) 
{
    let results = {};
    $('.ctnValidacionComprobante').each(function() {
        // Obtener el nombre de los botones de radio
        let idComprobante = $(this).find('input[type="radio"]').attr('name');
        // Obtener el valor seleccionado
        let value = $(this).find('input[type="radio"]:checked').attr('value');

        // Guardar en el objeto
        results[idComprobante] = value;
    });
    
    Swal.fire({
        title: '¿Estas seguro que deseas guardar la validación de los comprobantes?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {
            // var formData = new FormData();
            // formData.append('validacion', results);
            var parametros = {
                "validacion" : results
    		};
            $.ajax({        
                url: baseUrl + '/guardar-validacion-comprobantes-orden-compra',
                type: "POST",
                data: parametros,
                // contentType: false,
                // cache: false,
                // processData: false,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });
});

/* ------------------------------- */
