<?php
namespace App\Models;
use CodeIgniter\Model;
use \App\Libraries\Globales;

class PeticionesModel extends Model
{
    protected $table      = 'peticiones';
    protected $primaryKey = 'IDPeticion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Peticion', 'IDMotivo', 'Detalle', 'LinkAsociado', 'IDOrdenCompra', 'Producto', 'Cantidad', 'PresupuestoAsignado', 'TipoMoneda', 'Categorizacion', 'UsuarioAsignado', 'UsuarioCrea', 'FechaCrea', 'IDSubareaCrea', 'IDAreaCrea', 'IDDireccionCrea', 'IDPerfilCrea', 'IDDelegacionCrea', 'IDCargoCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'IDDireccionEstado', 'IDAreaEstado', 'IDSubareaEstado', 'IDDelegacionEstado', 'IDPerfilEstado', 'IDCargoEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listadoPeticiones($array)
    {
        $this->select('
            peticiones.IDPeticion,
            peticiones.Peticion,
            peticiones.IDOrdenCompra,
            peticiones.IDMotivo,
            requerimientos_motivos.Motivo,
            requerimientos_motivos.IDRequerimiento,
            requerimientos.Requerimiento,
            peticiones.Detalle,
            peticiones.LinkAsociado,
            peticiones.UsuarioAsignado,
            peticiones.UsuarioCrea,
            peticiones.FechaCrea,
            peticiones.IDSubareaCrea,
            peticiones.IDAreaCrea,
            peticiones.IDDireccionCrea,
            peticiones.IDDelegacionCrea,
            peticiones.IDPerfilCrea,
            perfil.Perfil AS "PerfilSolicitante",
            peticiones.Estado,
            peticiones.UsuarioEstado,
            peticiones.FechaEstado,
            peticiones.MotivoEstado');
        $this->join('requerimientos_motivos', 'peticiones.IDMotivo = requerimientos_motivos.IDMotivo', 'left');
        $this->join('requerimientos', 'requerimientos_motivos.IDRequerimiento = requerimientos.IDRequerimiento', 'left');
        $this->join('perfil', 'peticiones.IDPerfilCrea = perfil.IDPerfil', 'left');
        
        if(!empty($array))
        {
            if(isset($array['IDPerfil']) && in_array($array["IDPerfil"], array(1)))
            {
                $this->whereNotIn('peticiones.Estado', array("APRO", "CANC", "AA"));
            }
            else if(isset($array['IDPerfil']) && in_array($array["IDPerfil"], array(2)))
            {
                //VISUALIZO TODAS LAS PETICIONES DE MI GRUPO DE TRABAJO QUE NO ESTÉN APROBADOS CANCELADOS O AA
                $this->groupStart(); // Inicia un grupo de condiciones
                $this->whereNotIn('peticiones.Estado', array("APRO", "COMP","CANC", "AA"));
                $this->groupEnd(); // Finaliza el grupo de condiciones
                
                //VISUALIZO TODAS LAS PETICIONES CREADAS POR MI QUE NO ESTÉN APROBADOS COMPLETADOS CANCELADOS O AA
                $this->orGroupStart(); // Inicia un grupo de condiciones
                $this->where("peticiones.UsuarioCrea", $array['asignado']);
                $this->whereNotIn('peticiones.Estado', array("APRO", "CANC", "AA"));
                $this->groupEnd(); // Finaliza el grupo de condiciones
                
            }
            else
            {
                //VISUALIZO TODAS LAS PETICIONES CREADAS POR MI QUE NO ESTÉN APROBADOS COMPLETADOS CANCELADOS O AA
                $this->groupStart(); // Inicia un grupo de condiciones
                $this->where("peticiones.UsuarioCrea", $array['asignado']);
                $this->whereNotIn('peticiones.Estado', array("APRO", "CANC", "AA"));
                $this->groupEnd(); // Finaliza el grupo de condiciones
                
                //VISUALIZO TODAS LAS PETICIONES ASIGNADAS A MI
                $this->orGroupStart(); // Inicia un grupo de condiciones
                $this->where("peticiones.UsuarioAsignado", $array['asignado']);
                $this->groupEnd(); // Finaliza el grupo de condiciones
                
                //VISUALIZO TODAS LAS PETICIONES DE MI GRUPO DE TRABAJO QUE NO ESTÉN ASIGNADAS A ALGUIEN Y NO SEA ESTADO APROBADOS CANCELADOS O AA
                $this->orGroupStart(); // Inicia un grupo de condiciones
                
                    $this->groupStart(); // Inicia un grupo de condiciones
                        $this->where("peticiones.UsuarioAsignado IS NULL");
                        $this->orWhere('peticiones.UsuarioAsignado', "");
                    $this->groupEnd(); 
                    
                    $this->whereNotIn('peticiones.Estado', array("APRO", "COMP", "CANC", "AA"));
                
                $this->groupEnd(); // Finaliza el grupo de condiciones
                    
            }
        }
        
        // if($array['IDUsuario'] == 3660)
        // {
        // $this->get();
        // return $this->getLastQuery();
        // }
        // else
        // {
        $datos = $this->findAll();
        return $datos;
        // }
    }
    
    public function obtenerPeticion($idPeticion)
    {
        $this->select('
            peticiones.IDPeticion,
            peticiones.Peticion,
            peticiones.IDOrdenCompra,
            peticiones.IDMotivo,
            requerimientos_motivos.Motivo,
            requerimientos_motivos.IDRequerimiento,
            requerimientos.Requerimiento,
            peticiones.Detalle,
            peticiones.LinkAsociado,
            peticiones.UsuarioAsignado,
            peticiones.UsuarioCrea,
            peticiones.FechaCrea,
            peticiones.IDSubareaCrea,
            peticiones.IDAreaCrea,
            peticiones.IDDireccionCrea,
            peticiones.IDPerfilCrea,
            peticiones.IDDelegacionCrea,
            peticiones.IDPerfilCrea,
            perfil.Perfil AS "PerfilSolicitante",
            peticiones.Estado,
            peticiones.UsuarioEstado,
            peticiones.FechaEstado,
            peticiones.MotivoEstado,
            peticiones.IDSubareaEstado,
            peticiones.IDAreaEstado,
            peticiones.IDDireccionEstado,
            peticiones.IDPerfilEstado,
            peticiones.IDDelegacionEstado,
            peticiones.IDPerfilCrea,
            peticiones.Producto,
            peticiones.Cantidad,
            peticiones.PresupuestoAsignado,
            peticiones.TipoMoneda,
            peticiones.Categorizacion
            ');
        $this->join('requerimientos_motivos', 'peticiones.IDMotivo = requerimientos_motivos.IDMotivo', 'left');
        $this->join('requerimientos', 'requerimientos_motivos.IDRequerimiento = requerimientos.IDRequerimiento', 'left');
        $this->join('perfil', 'peticiones.IDPerfilCrea = perfil.IDPerfil', 'left');
        
        $this->where('peticiones.IDPeticion', $idPeticion);
        
        $datos = $this->first();
        return $datos;
    }
    
    
    public function listaGeneralPeticiones($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'peticiones.IDPeticion', 
            1 => 'peticiones.IDOrdenCompra', 
            2 => 'peticiones.FechaCrea', 
            3 => 'peticiones.FechaEstado',
            5 => 'perfil.Perfil', 
            6 => 'requerimientos.Requerimiento', 
            7 => 'requerimientos_motivos.Motivo', 
            9 => 'peticiones.Estado');
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('peticiones.IDPeticion AS "NroPeticion",
            peticiones.IDOrdenCompra AS "NroOrdenCompra",
            peticiones.FechaCrea,
            peticiones.FechaEstado,
            peticiones.IDDelegacionCrea,
            peticiones.IDPerfilCrea,
            perfil.Perfil,
            peticiones.IDMotivo,
            requerimientos_motivos.Motivo,
            requerimientos_motivos.IDRequerimiento,
            requerimientos.Requerimiento,
            peticiones.UsuarioEstado,
            peticiones.UsuarioAsignado,
            peticiones.Estado');
            
        $this->join('requerimientos_motivos', 'peticiones.IDMotivo = requerimientos_motivos.IDMotivo', 'left');
        $this->join('requerimientos', 'requerimientos_motivos.IDRequerimiento = requerimientos.IDRequerimiento', 'left');
        $this->join('perfil', 'peticiones.IDPerfilCrea = perfil.IDPerfil', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(in_array($adicionales['IDPerfil'], array(1,2)))
        {
            $this->whereIn('peticiones.Estado', array("APRO", "COMP", "CANC", "AA"));
        }
        else
        {
            $this->whereIn('peticiones.Estado', array("APRO", "CANC", "AA"));
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        return $result;
    }

    // public function listaGeneralPeticiones($orderBy,$where,$length,$start) 
    // {
        
    //     $this->globales = new Globales();
        
    //     $sSelect = "IDPeticion, FechaCrea, FechaEstado, DelegacionSolicitante, PerfilSolicitante, NroProspecto, Requerimiento, Motivo, NombreUsuarioEstado, GrupoTrabajo, Estado, 'SININFO' AS acciones_usuario";
    //     $sTable = "vista_peticiones_historico";
    //     $whereRespuesta = $where==""?"":"WHERE (".$where.")";
    //     $consulta = "SELECT " . $sSelect ." FROM ".  $sTable . " " .$whereRespuesta ."  " . $orderBy . " LIMIT ". $length ." OFFSET " .$start;
        
    //     $obtieneConsulta = $this->db->query($consulta);
    //     // return $this->db->getLastQuery();
    //     $consultaTotal = "SELECT count(IDPeticion) as total FROM vista_peticiones_historico";
    //     $totalRegistros = $this->db->query($consultaTotal);
    //     $obtieneTotalRegistros = $totalRegistros->getResultArray();
    //     // echo $consulta;
    //     // exit;
    //     if ($obtieneConsulta->getNumRows() > 0) {
            
    //         $dataServerside = $obtieneConsulta->getResultArray();
            
    //         foreach($dataServerside as $key=>$value)
    //         {
    //             $dataServerside[$key]['TextoEstado'] = $this->globales->estadosPeticion()[$value['Estado']]['PASADO'];
    //             $dataServerside[$key]['FondoEstado'] = $this->globales->estadosPeticion()[$value['Estado']]['FONDO'];
    //         }
            
    //         $datos = [
    //             // 'draw' => "4",
    //             'data' => $dataServerside,
    //             'recordsTotal' => $obtieneTotalRegistros[0]['total'],
    //             'recordsFiltered' => (int)(($obtieneTotalRegistros[0]['total']*$length)/$length)
    //         ];
    //         return $datos;
    //     } else {
    //         return FALSE;
    //     }
    // }

    public function obtenerCantidadPeticiones($array)
    {
        $this->select('IDPeticion');
        
        if(!empty($array))
        {
            if(isset($array['idperfil']) && !in_array($array['idperfil'], array(1,2)))
            {
                $this->groupStart(); // Inicia un grupo de condiciones
                
                if(isset($array['idusuario']) && $array['idusuario'] != '')
                {
                    $this->orWhere("UsuarioCrea", $array['idusuario']);
                }
                
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
            
            if(isset($array['mes']) && $array['mes'] != '')
            {
                $this->where("MONTH(FechaCrea)", $array['mes']);
            }
            
            if(isset($array['estadosno']) && !empty($array['estadosno']))
            {
                $this->whereNotIn("Estado", $array['estadosno']);
            }
            
            if(isset($array['estado']) && $array['estado'] != '')
            {
                $this->where("Estado", $array['estado']);
            }
        }
        
        $datos = $this->findAll();
        return $datos;
        // $this->get();
        // return $this->getLastQuery();
    }
}