<?php
namespace App\Models;
use CodeIgniter\Model;

class PeticionesComentariosModel extends Model
{
    protected $table      = 'peticiones_comentarios';
    protected $primaryKey = 'IDComentarioPeticion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDPeticion', 'Comentario', 'Link', 'UsuarioCrea', 'IDDireccionCrea', 'IDAreaCrea', 'IDSubareaCrea', 'IDDelegacionCrea', 'IDPerfilCrea', 'IDCargoCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listadoComentariosPeticion($idPeticion)
    {
        $this->select('
            IDComentarioPeticion,
            IDPeticion,
            "COME" AS Estado,
            UsuarioCrea AS IDUsuario,
            IDDireccionCrea AS IDDireccion,
            IDAreaCrea AS IDArea,
            IDSubareaCrea AS IDSubarea,
            IDDelegacionCrea AS IDDelegacion,
            IDPerfilCrea AS IDPerfil,
            IDCargoCrea AS IDCargo,
            FechaCrea AS Fecha,
            Comentario,
            Link');
            
        $this->where('peticiones_comentarios.IDPeticion', $idPeticion);
        $this->orderBy('Fecha', 'DESC');
        
        $datos = $this->findAll();
        return $datos;
    }
    
    // public function listarTimelinePeticion($idPeticion)
    // {
    //     $estados = $this->db->table('aud_peticiones_estado');
    //     $estados->select('IDPeticion_ALTER AS IDPeticion,
    //     Valor_NEW AS Estado,
    //     UsuarioModifica AS IDUsuario,
    //     IDDireccionModifica AS IDDireccion,
    //     IDAreaModifica AS IDArea,
    //     IDSubareaModifica AS IDSubarea,
    //     IDDelegacionModifica AS IDDelegacion,
    //     IDPerfilModifica AS IDPerfil,
    //     IDCargoModifica AS IDCargo,
    //     FechaModifica AS Fecha,
    //     MotivoModifica AS Comentario,
    //     "" AS Link');
    //     $estados->where('IDPeticion_ALTER', $idPeticion);
        
    //     $comentarios = $this->db->table('peticiones_comentarios');
    //     $comentarios->select('IDPeticion,
    //     "COME" AS Estado,
    //     UsuarioCrea AS IDUsuario,
    //     IDDireccionCrea AS IDDireccion,
    //     IDAreaCrea AS IDArea,
    //     IDSubareaCrea AS IDSubarea,
    //     IDDelegacionCrea AS IDDelegacion,
    //     IDPerfilCrea AS IDPerfil,
    //     IDCargoCrea AS IDCargo,
    //     FechaCrea AS Fecha,
    //     Comentario,
    //     Link');
    //     $comentarios->where('IDPeticion', $idPeticion);
    //     $comentarios->union($estados);
        
    //     $sql = $this->db->newQuery()->fromSubquery($comentarios, 'q')->orderBy('Fecha', 'DESC')->getCompiledSelect();
    //     // $sql = $estados->union($comentarios)->orderBy('Fecha', 'DESC')->getCompiledSelect();
    //     $datos = $this->db->query($sql)->getResultArray();
        
    //     return $datos;
    // }
}