<?php
namespace App\Models;
use CodeIgniter\Model;

class OrdenCompraComprobantesModel extends Model
{
    protected $table      = 'ordencompra_comprobantes';
    protected $primaryKey = 'IDComprobanteOC';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDOrdenCompra', 'Nombre', 'Extension', 'Observacion', 'Token', 'NroFactura', 'FechaEmisionFactura', 'ComprobanteValido', 'UsuarioValidacion', 'FechaValidacion', 'ObservacionValidacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'UsuarioCreaProveedor', 'FechaCreaProveedor', 'UsuarioModificaProveedor', 'FechaModificaProveedor', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listadoComprobantesOrdenCompra($array)
    {
        $this->select('ordencompra_comprobantes.IDComprobanteOC,
            ordencompra.IDOrdenCompra, 
            ordencompra.IDProveedor, 
            proveedor.Nombre AS "Proveedor", 
            ordencompra.Concepto, 
            ordencompra.Total, 
            ordencompra.TipoMoneda, 
            ordencompra_comprobantes.Nombre AS "NombreComprobante", 
            ordencompra_comprobantes.Extension, 
            ordencompra_comprobantes.ComprobanteValido, 
            ordencompra_comprobantes.FechaCrea, 
            ordencompra_comprobantes.FechaCreaProveedor');
        
        $this->join('ordencompra', 'ordencompra_comprobantes.IDOrdenCompra = ordencompra.IDOrdenCompra', 'left');
        $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        
        if(!empty($array))
        {
            if(isset($array['pendientes']) && $array['pendientes'] == "Y" )
            {
                $this->where('ordencompra_comprobantes.ComprobanteValido IS NULL');
            }
            
            if(isset($array['IDOrdenCompra']) && $array['IDOrdenCompra'] != "" && $array['IDOrdenCompra'] != null )
            {
                $this->where('ordencompra_comprobantes.IDOrdenCompra', $array['IDOrdenCompra']);
            }
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerComprobanteOrdenCompra($idComprobanteOC)
    {
        $this->select('ordencompra_comprobantes.IDComprobanteOC,
            ordencompra.IDOrdenCompra, 
            ordencompra.IDProveedor, 
            proveedor.Nombre AS "Proveedor", 
            ordencompra.Concepto, 
            ordencompra.Total, 
            ordencompra.TipoMoneda, 
            ordencompra.FechaCrea AS "FechaEmision", 
            ordencompra_comprobantes.Nombre AS "NombreComprobante", 
            ordencompra_comprobantes.Extension,
            ordencompra_comprobantes.FechaCrea, 
            ordencompra_comprobantes.FechaCreaProveedor');
        
        $this->join('ordencompra', 'ordencompra_comprobantes.IDOrdenCompra = ordencompra.IDOrdenCompra', 'left');
        $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        
        $this->where('ordencompra_comprobantes.IDComprobanteOC', $idComprobanteOC);
        
        $datos = $this->first();
        return $datos;
    }
    

}