<?php
namespace App\Models;
use CodeIgniter\Model;

class VAReposicionesModel extends Model
{
    protected $table      = 'reposiciones';
    protected $primaryKey = 'IDReposicion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['UsuarioAdjudicado', 'CargoAdjudicado', 'AreaAdjudicado', 'DepartamentoAdjudicado', 'DelegacionAdjudicado','TokenLinkFirma', 'LiberadoFirma', 'FechaRegistroFirma', 'ConceptoRegistroFirma', 'Motivo', 'Observacion', 'Cuotas', 'UsuarioCrea', 'CargoCrea', 'AreaCrea', 'DepartamentoCrea', 'FechaCrea', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarReposiciones($cc)
    {
        $builder = $this->db->table('vista_listar_reposiciones');
        if(!empty($cc))
        {
            $builder->whereIn('CCAdjudicado', $cc);
        }
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
}