<?php
namespace App\Models;
use CodeIgniter\Model;

class VADevolucionesModel extends Model
{
    protected $table      = 'devoluciones';
    protected $primaryKey = 'IDDevolucion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['UsuarioDevolucion', 'CargoDevolucion', 'AreaDevolucion', 'DepartamentoDevolucion', 'DelegacionDevolucion', 'Motivo', 'Observacion', 'TokenLinkFirma', 'LiberadoFirma', 'FechaRegistroFirma', 'ConceptoRegistroFirma', 'UsuarioCrea', 'CargoCrea', 'AreaCrea', 'DepartamentoCrea', 'FechaCrea', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarDevoluciones($cc)
    {
        $builder = $this->db->table('vista_listar_devoluciones');
        if(!empty($cc))
        {
            $builder->whereIn('CCUsuario', $cc);
        }
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    /*public function listarLineas()
    {
        $this->select('
            lineas.IDLinea,
            lineas.Numero,
            lineas.ICCID,
            operadores.Operador,
            operadores_planes.Plan,
            lineas_contrato.Estado AS "ESTADO_CONTRATO",
            lineas.Estado AS "ESTADO_LINEA"');
        $this->join('lineas_contrato', 'lineas.IDLinea = lineas_contrato.IDLinea', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        //$this->where('lineas_seguro.IDLinea', $idLinea);

        $datos = $this->findAll();
        return $datos;
    }*/
}