<?php
namespace App\Models;
use CodeIgniter\Model;

class VAAsignacionesDetalleModel extends Model
{
    protected $table      = 'asignaciones_detalle';
    protected $primaryKey = 'IDDetalleAsignacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDAsignacion', 'TipoElemento', 'IDElemento', 'Observacion', 'MontoReposicion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarDetalleAsignacion($idAsignacion)
    {
        $this->select('asignaciones_detalle.IDDetalleAsignacion,
            asignaciones_detalle.TipoElemento,
            asignaciones_detalle.IDElemento,
            asignaciones_detalle.Observacion,
            asignaciones_detalle.MontoReposicion,
            devoluciones_detalle.IDDetalleDevolucion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion','left');
        $this->where('asignaciones_detalle.IDAsignacion', $idAsignacion);
        /*$this->groupBy('asignaciones.UsuarioAsignado');*/
        $datos = $this->findAll();
        return $datos;
    }

    public function validarElementoAsignado($tipo, $id)
    {
        $this->select('asignaciones.IDAsignacion, 
            asignaciones.UsuarioAsignado, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado, 
            asignaciones.UsuarioRemitente');
        $this->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('asignaciones_detalle.TipoElemento', $tipo);
        $this->where('asignaciones_detalle.IDElemento', $id);
        $this->where('devoluciones_detalle.IDDevolucion IS NULL');

        $datos = $this->findAll();
        return $datos;
    }
    
    public function detalleAsignacionSinPaqueteria()
    {
        $this->select('asignaciones_detalle.IDDetalleAsignacion,
            asignaciones_detalle.TipoElemento,
            asignaciones_detalle.IDElemento');
        $this->join('paqueteria_detalle', 'asignaciones_detalle.IDDetalleAsignacion = paqueteria_detalle.IDDetalleAsignacion','left');
        $this->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion', 'left');
        $this->where('asignaciones.FechaRegistroFirma IS NULL');
        $this->where('paqueteria_detalle.IDDetallePaqueteria IS NULL');
        /*$this->groupBy('asignaciones.UsuarioAsignado');*/
        $datos = $this->findAll();
        return $datos;
    }

    public function obtenerDetalleAsignacion($idDetalleAsignacion)
    {
        $this->select('asignaciones_detalle.IDDetalleAsignacion, 
            asignaciones.IDAsignacion, 
            asignaciones.UsuarioAsignado, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado, 
            asignaciones.UsuarioRemitente,
            devoluciones_detalle.IDDevolucion');
        $this->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('asignaciones_detalle.IDDetalleAsignacion', $idDetalleAsignacion);

        $datos = $this->first();
        return $datos;
    }
    
    public function listarDetalleAsignadosUsuario($idUsuario)
    {
        $this->select('asignaciones.IDAsignacion, 
            asignaciones_detalle.IDDetalleAsignacion, 
            asignaciones.UsuarioAsignado, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado, 
            asignaciones.UsuarioRemitente');
        $this->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('asignaciones.UsuarioAsignado', $idUsuario);
        $this->where('devoluciones_detalle.IDDevolucion IS NULL');

        $datos = $this->findAll();
        return $datos;
    }

    public function obtenerMovilesRobadosUsuario($idUsuario)
    {
        $this->select('asignaciones_detalle.IDDetalleAsignacion, 
            asignaciones.IDAsignacion, 
            asignaciones.UsuarioAsignado, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado, 
            asignaciones.UsuarioRemitente,
            devoluciones_detalle.*');
        $this->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('asignaciones.UsuarioAsignado', $idUsuario);
        $this->where('devoluciones_detalle.MotivoDevolucion', "ROB");
        $this->where('asignaciones_detalle.TipoElemento', "MOVIL");

        $datos = $this->findAll();
        return $datos;
    }
}