<?php
namespace App\Models;
use CodeIgniter\Model;

class TipoModel extends Model
{
    protected $table      = 'tipo';
    protected $primaryKey = 'id_tipo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['id_categoria', 'nombre_tipo', 'observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerTipo($idTipo)
    {
        $this->select('tipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria,
            categoria.clave');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->where('tipo.id_tipo', $idTipo);

        $datos = $this->first();
        return $datos;
    }
    
}