<?php
namespace App\Models;
use CodeIgniter\Model;

class SubTipoModel extends Model
{
    protected $table      = 'subtipo';
    protected $primaryKey = 'id_subtipo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['id_tipo', 'nombre_subtipo', 'observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerSubtipo($idSubtipo)
    {
        $this->select('subtipo.id_subtipo,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria,
            categoria.clave');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->where('subtipo.id_subtipo', $idSubtipo);

        $datos = $this->first();
        return $datos;
    }
    
}