<?php
namespace App\Models;
use CodeIgniter\Model;

class PaqueteriaModel extends Model
{
    protected $table      = 'paqueteria';
    protected $primaryKey = 'IDPaqueteria';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['CCRemitente', 'UsuarioRemitente', 'FechaEnvio', 'DiasEstimadoTransito', 'Proveedor', 'CCDestinatario', 'UsuarioDestinatario', 'FechaRecepcion', 'UsuarioRecepcion', 'ObservacionRecepcion', 'Descripcion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'FechaEstado', 'UsuarioEstado', 'MotivoCambio', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarPaqueteria()
    {
        $this->select('paqueteria.IDPaqueteria,
            paqueteria.CCRemitente,
            paqueteria.UsuarioRemitente,
            paqueteria.FechaEnvio,
            paqueteria.DiasEstimadoTransito,
            paqueteria.FechaRecepcion,
            paqueteria.CCDestinatario,
            paqueteria.UsuarioDestinatario,
            paqueteria.Proveedor,
            paqueteria.Descripcion,
            paqueteria.Estado');
        /*$this->join('asignaciones_detalle', 'asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion');
        $this->join('devoluciones', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones.IDDetalleAsignacion', 'left');
        $this->where('devoluciones.IDDevolucion IS NULL');
        $this->groupBy('asignaciones.UsuarioAsignado');*/
        $datos = $this->findAll();
        return $datos;
    }

}