<?php
namespace App\Models;
use CodeIgniter\Model;

class EstructuraDelegacionModel extends Model
{
    protected $DBGroup      = 'baseT';
    protected $table        = 'estructura_delegacion';
    protected $primaryKey   = 'IDDelegacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['CC', 'LN', 'Delegacion', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoDelegacionesBusqueda($array)
    {
        $this->select('
            IDDelegacion,
            CC,
            LN,
            Delegacion');
            
        if(isset($array['variable']) && $array['variable'] != '')
        {
            $this->where("(CC LIKE '%".$array['variable']."%' OR 
                LN LIKE '%".$array['variable']."%' OR
                Delegacion LIKE '%".$array['variable']."%')");
        }
        
        $this->where("Estado", "A");
        
        $datos = $this->findAll();
        return $datos;
    }
    // public function listadoCargosSelect($variable)
    // {
    //     $this->select('IDCargo,
    //         Cargo,
    //         Categoria');
    //     $this->like("Cargo", $variable);
    //     $this->orLike("Categoria", $variable);
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }
}