<?php namespace App\Models;

use CodeIgniter\Model;

class ClienteModelo extends Model {
    protected $table = 'cliente';
    protected $primaryKey = 'id_cliente';
    protected $allowedFields = ['id_cliente','reincidente_id','numero_cliente','fecha_instalacion','segmento','ubicacion','fecha_registro','eliminacion_logica'];

    public function listaGeneralClientes($orderBy,$where,$length,$start) {
        $sSelect = "id_cliente,numero_cliente,fecha_instalacion,segmento,ubicacion,reincidente_id";
        $sTable = "cliente";
        $sWhere = "numero_cliente";
        $whereRespuesta = $where==""?"":"(".$where ."')" . " AND ";
        $consulta = "SELECT " . $sSelect ." FROM ".  $sTable . " WHERE " .$whereRespuesta . $sWhere ."  " . $orderBy . " LIMIT ". $length ." OFFSET " .$start;
        
        $obtieneConsulta = $this->db->query($consulta);
        $consultaTotal = "SELECT count(id_cliente) as total FROM cliente";
        $totalRegistros = $this->db->query($consultaTotal);
        $obtieneTotalRegistros = $totalRegistros->getResultArray();

        if ($obtieneConsulta->getNumRows() > 0) {
            $datos = [
                // 'draw' => "4",
                'data' => $obtieneConsulta->getResultArray(),
                'recordsTotal' => $obtieneTotalRegistros[0]['total'],
                'recordsFiltered' => (int)(($obtieneTotalRegistros[0]['total']*$length)/$length)
            ];
            return $datos;
        } else {
            return FALSE;
        }
    }
}
