var baseUrl = "https://www.verismart.com.pe/activos";
toastr.options = {
    "positionClass": "toast-bottom-center",
    "newestOnTop": true,
    "preventDuplicates": true
}

const tableDetallePaqueteriaEnvio = new DataTable('#tblDetallePaqueteriaEnvio');
const tblDetalleGuiaPaqueteria = new DataTable('#tblDetalleGuiaPaqueteria');
$(function () {

    tblDetalleGuiaPaqueteria.destroy();
    $("#txtCCDestinatario").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione CC',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-cc-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $("#txtDestinatario").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Destinatario',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-usuarios-cc',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });

    $("#txtRemitente").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Remitente',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-usuarios-cc',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });

    $("#txtDireccionDestinatario").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Dirección Destinatario',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-direccion',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $("#txtDireccionRemitente").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Dirección Remitente',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-direccion',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });

/*
    $("#txtElementoPaqueteria").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Elemento',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-elemento-paqueteria-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });*/
    
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarElementoPaqueteria', function(e) {
    var elemento = $("#txtElementoPaqueteria").val();
    var lblelemento = $("#txtElementoPaqueteria option:selected").text();
    var observacionElemento = $("#txtObservacionElemento").val();

    if(elemento == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el elemento a asignar',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        tableDetallePaqueteriaEnvio.row
            .add([
                lblelemento+"<input type='hidden' name='elemento[]' value='"+elemento+"'><input type='hidden' name='etiquetaelemento[]' value='"+lblelemento+"'>",
                observacionElemento+"<input type='hidden' name='obselemento[]' value='"+observacionElemento+"'>",
                "<button class='btn btn-danger btnDelete'><span class='mdi mdi-trash-can'></span></button>"
            ])
            .draw(false);
        
        $("#txtElementoPaqueteria").val("");
        $("#txtObservacionElemento").val("");
    }
});

tableDetallePaqueteriaEnvio.on('click', 'button.btnDelete', function() {
    let $tr = $(this).closest('tr');
  
    // Le pedimos al DataTable que borre la fila
    tableDetallePaqueteriaEnvio.row($tr).remove().draw(false);
  });
/* ------------------------------- */

function downloadGuiaPaqueteria(idDiv)
{
    var divToPrint = document.getElementById(idDiv);
    var print = 'onload="window.print()"';
    var newWin = window.open('', 'Print-Window');
    newWin.document.open();
    newWin.document.write('<html><head><meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"><title>GuiaPaqueteria</title><meta name="viewport" content="width=device-width, initial-scale=1">\n\
                                <meta http-equiv="cache-control" content="no-cache" />\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css">\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">\n\
                                <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">\n\
                                <link href="'+baseUrl+'/public/css/bootstrap.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/libs/bootstrap-switch/css/bootstrap3/bootstrap-switch.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/icons.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/app.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/custom.min.css" rel="stylesheet" type="text/css">\n\
                                <link rel="stylesheet" href="'+baseUrl+'/public/js/pages/plugins/toastr/toastr.min.css">\n\
                                <link rel="stylesheet" href="'+baseUrl+'/public/js/pages/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">\n\
                            </head>\n\
                            <body '+ print +' class="'+baseUrl+'">\n\
                                ' + divToPrint.innerHTML + '\n\
                                <script>$(document).ready(function () {$(".table").dataTable().fnDestroy(); $(".table").DataTable({"language": {"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"}, responsive: true, stateSave: true});});</script>\n\
                            </body>\n\
                          </html>');
    newWin.document.close();
}
