<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<?php
								if (in_array("ADDOPE", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-operador" data-bs-toggle="modal" data-bs-target="#informacionOperador" data-id="0" data-accion="crear" id="crear-operador">
									<i class="mdi mdi-plus-circle"></i> Agregar Operador
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<!--<th scope="col" style="width: 10px;">
											<div class="form-check">
												<input class="form-check-input fs-15" type="checkbox" id="checkAll" value="option">
											</div>
										</th>-->
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Operador</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaOperadores as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDOperador'] ?></td>
										<td class="text-center align-middle"><?= $items['Operador'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
										<?php
										if (in_array("ESTOPE", $permisos)) 
										{
										?>
											<button class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-danger' ?> border-0 cambiar-estado-operador" data-estado="<?=$items['Estado']?>" data-id="<?=$items['IDOperador']?>"><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></button>
										<?php
										}
										else
										{
										?>
											<span class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-danger' ?>"><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></span>
										<?php
										}
										?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-operador" data-bs-toggle="modal" data-bs-target="#informacionOperador" data-id="<?= $items['IDOperador'] ?>" data-accion="ver" id="ver-operador">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDOPE", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-operador" data-bs-toggle="modal" data-bs-target="#informacionOperador" data-id="<?= $items['IDOperador'] ?>" data-accion="editar" id="editar-operador">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													?>
													<li>
														<a href="<?= $baseUrl ?>/listar-planes/<?= $items['IDOperador'] ?>" class="dropdown-item">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Planes
														</a>
													</li>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Operador -->
<div class="modal fade" id="informacionOperador" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionOperador" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionOperador">Información de operador</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionOperador" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDOperador_i" name="txtIDOperador_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtOperador_i" class="form-label">Operador</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Operador" id="txtOperador_i" name="txtOperador_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacion_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacion_i" name="txtObservacion_i" rows="4"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarOperador" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>