<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
                                <button class="btn btn-info d-flex align-items-center mx-1" data-bs-toggle="modal" data-bs-target="#exportarMoviles">
									<i class="mdi mdi-file-export" style="font-size: 18px;"></i> Exportar
								</button>
								<?php
								if (in_array("ADDMOV", $permisos)) 
								{
								?>
                                <button class="btn btn-primary d-flex align-items-center mx-1 datos-movil" data-bs-toggle="modal" data-bs-target="#informacionMovil" data-id="0" data-accion="crear" id="crear-movil">
									<i class="mdi mdi-plus-circle"></i> Agregar móvil
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<!--<th scope="col" style="width: 10px;">
											<div class="form-check">
												<input class="form-check-input fs-15" type="checkbox" id="checkAll" value="option">
											</div>
										</th>-->
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">IMEI</th>
										<th class="text-center align-middle">Marca</th>
										<th class="text-center align-middle">Modelo</th>
										<th class="text-center align-middle">Fecha Compra</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">¿Equipo Stock?</th>
										<th class="text-center align-middle">Asignado</th>
										<th class="text-center align-middle">Matrícula</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaMoviles as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDMovil'] ?></td>
										<td class="text-center align-middle"><?= $items['IMEI'] ?></td>
										<td class="text-center align-middle"><?= $items['Marca'] ?></td>
										<td class="text-center align-middle"><?= $items['Modelo'] ?></td>
										<td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['FechaCompra'])) ?></td>
										<td class="text-center align-middle"><?= $items['EstadoInformacion'] ?></td>
										<td class="text-center align-middle">
										    <span class="badge <?= $items['EquipoStock'] == 'Y' ? 'bg-warning color-white' : 'bg-light text-dark' ?> border-0"><?= $items['EquipoStock'] == 'Y' ? 'SI' : 'NO' ?></span>
										</td>
										<td class="text-center align-middle">
											<?php
											if($items['UsuarioAsignado'] != '--')
											{
											?>
											<span class="badge <?= $items['EstadoAsignado'] == 'Activo' ? 'bg-light text-dark' : 'bg-danger color-white' ?> border-0"><?= $items['UsuarioAsignado'] ?></span>
											<?php
											}
											else
											{
											?>
											No asignado
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<?php
											if($items['MatriculaAsignado'] != '--')
											{
											?>
											<span><?= $items['MatriculaAsignado'] ?></span>
											<?php
											}
											else
											{
											?>
											No asignado
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-movil" data-bs-toggle="modal" data-bs-target="#informacionMovil" data-id="<?= $items['IDMovil'] ?>" data-accion="ver" id="ver-movil">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPMOBA", $permisos) || in_array("UPMOFU", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-movil" data-bs-toggle="modal" data-bs-target="#informacionMovil" data-id="<?= $items['IDMovil'] ?>" data-accion="<?= in_array("UPMOFU", $permisos) ? "editar-full" : "editar-basic" ?>" id="editar-movil">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Movil -->
<div class="modal fade" id="informacionMovil" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionMovil" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionMovil">Información de móvil</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionMovil" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDMovil_i" name="txtIDMovil_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-2 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px;">
						    <h5 class="color-white m-0">¿Equipo Stock?</h5>
						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center">
								<input class="form-check-input form-check-input-green" type="checkbox" role="switch" name="chkEquipoStock_i" id="chkEquipoStock_i" >
								<label class="form-check-label" for="chkEquipoStock_i"></label>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtMarca_i" class="form-label">Marca</label>
								<select class="form-select" aria-label="Marca" id="txtMarca_i" name="txtMarca_i" data-categoria="MOVIL">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtModeloComercial_i" class="form-label">Modelo</label>
								<select class="form-select" aria-label="Tipo" id="txtModeloComercial_i" name="txtModeloComercial_i">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-6 col-12 mb-3">
							<label for="txtProveedor_i" class="form-label">Proveedor</label>
							<select class="form-select" aria-label="Proveedor" id="txtProveedor_i" name="txtProveedor_i">
								<option selected="" value="">Seleccione una opción</option>
								<option value="ENTEL">ENTEL</option>
								<option value="LOGÍSTICA">LOGÍSTICA</option>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtIMEI_i" class="form-label">IMEI</label>
								<input type="number" class="form-control" id="txtIMEI_i" name="txtIMEI_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtFechaCompra_i" class="form-label">Fecha Compra</label>
								<input type="date" class="form-control" id="txtFechaCompra_i" name="txtFechaCompra_i" value="<?= date("Y-m-d") ?>">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtPrecioCompra_i" class="form-label">Precio Compra</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioCompra_i" name="txtPrecioCompra_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtPrecioLista_i" class="form-label">Precio Lista</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioLista_i" name="txtPrecioLista_i">
							</div>
						</div>
						<div class="m-0" id="ctnEstadosMovil">
							<div class="col-xxl-12 col-md-6 col-12 mb-3">
								<label for="txtEstadoMovil_i" class="form-label">Estado</label>
								<select class="form-select" aria-label="Estado" id="txtEstadoMovil_i" name="txtEstadoMovil_i">
									<option selected="" value="">Seleccione una opción</option>
									<option value="ACT">ACTIVO</option>
								</select>
							</div>
							<div class="col-xxl-12 col-md-6 col-12 mb-3">
								<label for="txtMotivoMovil_i" class="form-label">Motivo</label>
								<select class="form-select" aria-label="Motivo" id="txtMotivoMovil_i" name="txtMotivoMovil_i">
									<option selected="" value="">Seleccione una opción</option>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarMovil" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Exportar Móviles -->
<div class="modal fade bd-example-modal-lg" id="exportarMoviles" tabindex="-1" role="dialog" aria-labelledby="exampleexportarMoviles" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleexportarMoviles">Exportar Móviles</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="col-12 m-0">
					<a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/exportar-movil/noasignado' ?>'>
					    No Asignados
					</a>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>