<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
                                <button class="btn btn-info d-flex align-items-center mx-1" data-bs-toggle="modal" data-bs-target="#exportarLineas">
									<i class="mdi mdi-file-export" style="font-size: 18px;"></i> Exportar
								</button>
								<?php
								if (in_array("CSVLIN", $permisos)) 
								{
								?>
								<button class="btn btn-success d-flex align-items-center mx-1 datos-linea" data-bs-toggle="modal" data-bs-target="#subirCSVLinea">
									<i class="mdi mdi-file-upload" style="font-size: 18px;"></i> Subir CSV
								</button>
								<?php
								}

								if (in_array("ADDLIN", $permisos)) 
								{
								?>
                                <button class="btn btn-primary d-flex align-items-center mx-1 datos-linea" data-bs-toggle="modal" data-bs-target="#informacionLinea" data-id="0" data-accion="crear" id="crear-linea">
									<i class="mdi mdi-plus-circle" style="font-size: 18px;"></i> Agregar línea
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Línea</th>
										<th class="text-center align-middle">ICCID</th>
										<th class="text-center align-middle">Operador</th>
										<th class="text-center align-middle">Plan</th>
										<!--<th class="text-center align-middle">Móviles x Seguro</th>
										<th class="text-center align-middle">Último Equipo x Seguro</th>-->
										<th class="text-center align-middle">Estado Contrato</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Usuario</th>
										<th class="text-center align-middle">Matrícula</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaLineas as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDLinea'] ?></td>
										<td class="text-center align-middle"><?= $items['Numero'] ?></td>
										<td class="text-center align-middle"><?= $items['ICCID'] ?></td>
										<td class="text-center align-middle">
											<?= $items['Operador'] != "" ? $items['Operador'] : '<span class="badge bg-info border-0">SIN CONTRATO</span>' ?>
										</td>
										<td class="text-center align-middle">
											<?= $items['Plan'] != "" ? $items['Plan'] : '<span class="badge bg-info border-0">SIN CONTRATO</span>' ?>	
										</td>
										<!--<td class="text-center align-middle">
											
										</td>
										<td class="text-center align-middle">
											
										</td>-->
										<td class="text-center align-middle">
											<?php
											if($items['ESTADO_CONTRATO'] != '')
											{
												if($items['ESTADO_CONTRATO'] == 'VIGENTE')
												{
												?>
												<span class="badge bg-secondary border-0"><?= $items['ESTADO_CONTRATO'] ?></span>
												<?php
												}
												else
												{
												?>
												<span class="badge bg-primary border-0"><?= $items['ESTADO_CONTRATO'] ?></span>
												<?php
												}
											} 
											else
											{
											?>
											<span class="badge bg-info border-0">SIN CONTRATO</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
										<?php
											if($items['ESTADO_LINEA'] == 'ACT')
											{
											?>
											<span class="badge bg-success border-0">ACTIVO</span>
											<?php
											} 
											else if($items['ESTADO_LINEA'] == 'SUS')
											{
											?>
											<span class="badge bg-warning border-0">SUSPENDIDA</span>
											<?php
											}
											else if($items['ESTADO_LINEA'] == 'BAJ')
											{
											?>
											<span class="badge bg-danger border-0">BAJA</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<?php
											if($items['UsuarioAsignado'] != '--')
											{
											?>
											<span class="badge <?= $items['EstadoAsignado'] == 'Activo' ? 'bg-light text-dark' : 'bg-danger color-white' ?> border-0"><?= $items['UsuarioAsignado'] ?></span>
											<?php
											}
											else
											{
											?>
											No asignado
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<?php
											if($items['MatriculaAsignado'] != '--')
											{
											?>
											<span><?= $items['MatriculaAsignado'] ?></span>
											<?php
											}
											else
											{
											?>
											No asignado
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-linea" data-bs-toggle="modal" data-bs-target="#informacionLinea" data-id="<?= $items['IDLinea'] ?>" data-accion="ver" id="ver-linea">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDLIN", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-linea" data-bs-toggle="modal" data-bs-target="#informacionLinea" data-id="<?= $items['IDLinea'] ?>" data-accion="editar" id="editar-linea">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													?>
													<li>
														<a href="<?= $baseUrl ?>/contrato-linea/<?= $items['IDLinea'] ?>" class="dropdown-item">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Contratos
														</a>
													</li>
													<li>
														<a href="<?= $baseUrl ?>/seguro-linea/<?= $items['IDLinea'] ?>" class="dropdown-item">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Seguros
														</a>
													</li>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Añadir Linea -->
<div class="modal fade" id="informacionLinea" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionLinea" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionLinea">Agregar Línea</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formInformacionLinea" autocomplete="off" action="<?= $baseUrl ?>/grabar-linea" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDLinea_i" name="txtIDLinea_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtNumero" class="form-label">Número</label>
                            <div class="input-group">
                                <input type="number" class="form-control" aria-label="Número" id="txtNumero" name="txtNumero">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtICCID" class="form-label">ICCID</label>
                                <input type="number" class="form-control" id="txtICCID" name="txtICCID">
                            </div>
                        </div>
						<div id="ctnEstadosLinea">
							<div class="col-xxl-12 col-md-6 col-12 mb-3">
								<label for="txtEstadoLinea" class="form-label">Estado</label>
								<select class="form-select" aria-label="Estado" id="txtEstadoLinea" name="txtEstadoLinea">
									<option selected="" value="">Seleccione una opción</option>
								</select>
							</div>
							<div class="col-xxl-12 col-md-6 col-12 mb-3">
								<label for="txtMotivoLinea" class="form-label">Motivo</label>
								<select class="form-select" aria-label="Situación" id="txtMotivoLinea" name="txtMotivoLinea">
									<option selected="" value="">Seleccione una opción</option>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarLinea" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Información Usuario -->
<div class="modal fade" id="informacionMovil" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionMovil" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionMovil">Información de móvil</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDMovil_i" name="txtIDMovil_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtMarca_i" class="form-label">Marca</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Marca" id="txtMarca_i" name="txtMarca_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtModeloComercial_i" class="form-label">Modelo Comercial</label>
								<input type="text" class="form-control" id="txtModeloComercial_i" name="txtModeloComercial_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-6 col-12 mb-3">
							<label for="txtProveedor_i" class="form-label">Proveedor</label>
							<select class="form-select" aria-label="Proveedor" id="txtProveedor_i" name="txtProveedor_i">
								<option selected="" value="">Seleccione una opción</option>
								<option value="ENTEL">ENTEL</option>
								<option value="LOGÍSTICA">LOGÍSTICA</option>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtIMEI_i" class="form-label">IMEI</label>
								<input type="number" class="form-control" id="txtIMEI_i" name="txtIMEI_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtFechaCompra_i" class="form-label">Fecha Compra</label>
								<input type="date" class="form-control" id="txtFechaCompra_i" name="txtFechaCompra_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtPrecioCompra_i" class="form-label">Precio Compra</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioCompra_i" name="txtPrecioCompra_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtPrecioLista_i" class="form-label">Precio Lista</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioLista_i" name="txtPrecioLista_i">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Subir CSV -->
<div class="modal fade bd-example-modal-lg" id="subirCSVLinea" tabindex="-1" role="dialog" aria-labelledby="examplesubirCSVLinea" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="examplesubirCSVLinea">Subir CSV de Linea</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formSubirCSVLinea" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-linea" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- Las fechas deben contar con el formato "YYYY-MM-DD".</p>
						<p>2.- Los valores de monedas deben ser enteros (no 3,999 para indicar 3999) y solo usar punto(.) para separar enteros de decimales (3999.99).</p>
						<p>3.- Evitar espacios en blanco al inicio y al final del campo</p>
						<p>4.- Información de columna [PLAN]: [Básico, Intermedios 1, Intermedios 2, Dirección]</p>
						<p>5.- Información de columna [DIA FACTURACION]: Solo colocar día, no mes ni año.</p>
						<p>6.- Información de columna [PERMANENCIA]: [SP, 12, 18]</p>
						<p>7.- Información de columna [MODELO]: [A24, A34, A54, Iphone 15 Pro]</p>
						<p>8.- Información de columna [PROVEEDOR]: [ENTEL, LOGISTICA]</p>
						<p>9.- Información de columna [USUARIO]: Considerar el usuario asignado al trabajador.</p>
						<p>10.- Información de columna [TIPO ASIGNADO]: [ASIGNADO, TEMPORAL].</p>
						<p style="color: red;">Si deja vacío la columna [PLAN], no se va a agregar el contrato.</p>
						<p style="color: red;">Si deja vacío la columna [MODELO], no se va a agregar el móvil.</p>
						<p style="color: red;">Si deja vacío la columna [USUARIO ASIGNADO], no se va a realizar la asignación.</p>
					</div>
					<div class="col-12 mb-3 d-flex justify-content-end">
						
							<a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv linea.csv' ?>' download='Plantilla CSV Línea'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVLinea" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVLinea" name="fileCSVLinea">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Exportar Líneas -->
<div class="modal fade bd-example-modal-lg" id="exportarLineas" tabindex="-1" role="dialog" aria-labelledby="exampleexportarLineas" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleexportarLineas">Exportar Líneas</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="col-12 m-0">
					<a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/exportar-linea/noasignado' ?>'>
					    No Asignados
					</a>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>