<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<?php
								if (in_array("ADDCON", $permisos)) 
								{
								?>
                                <button class="btn btn-primary" id="crear-contrato" data-linea="<?= $linea['IDLinea'] ?>">
									<i class="mdi mdi-plus-circle"></i> Agregar Contrato
								</button>
								<?php
								}
								?>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblContratoLinea" class="table table-bordered nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Operador</th>
										<th class="text-center align-middle">Plan</th>
										<th class="text-center align-middle">Inicio Contrato</th>
										<th class="text-center align-middle">Tiempo Permanencia</th>
										<th class="text-center align-middle">Tiempo Transcurrido</th>
										<th class="text-center align-middle">Equipo Asociado</th>
										<th class="text-center align-middle">Penalidad</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php
									foreach($listaContratos as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDContrato'] ?></td>
										<td class="text-center align-middle"><?= $items['Operador'] ?></td>
										<td class="text-center align-middle"><?= $items['Plan'] ?></td>
										<td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['InicioContrato'])) ?></td>
										<td class="text-center align-middle"><?= $periodoPermanencia[$items['PeriodoPermanencia']] ?></td>
										<td class="text-center align-middle">
											<?php
											if($items['Permanencia'] == 'Y')
											{
												$mesesPermanencia = $items['PeriodoPermanencia'];
												if(is_numeric($mesesPermanencia))
												{
													$inicioContrato = new DateTime($items['InicioContrato']);

													$finContrato = new DateTime($items['InicioContrato']);
													$finContrato->add(new DateInterval('P'.$mesesPermanencia.'M'));

													$fechaActual = new DateTime();
													$fechaActual->setTime(0,0,0);
													
													if($fechaActual <= $finContrato && $fechaActual >= $inicioContrato)
													{
														$interval=$fechaActual->diff($inicioContrato);
														# obtenemos la diferencia en meses
														$intervalMeses=$interval->format("%m");
														# obtenemos la diferencia en años y la multiplicamos por 12 para tener los meses
														$intervalAnos = $interval->format("%y")*12;

														$transcurrido = $intervalAnos + $intervalMeses;
														$restante = $mesesPermanencia - $transcurrido;
														echo $transcurrido."M | ".$restante."M | ".$items['PeriodoPermanencia'];
													}
													else
													{
														?>
														<span class="badge bg-warning border-0">SIN PERMANENCIA</span>
														<?php
													}

												}
												else
												{
												?>
												<span class="badge bg-warning border-0">SIN PERMANENCIA</span>
												<?php
												}
											}
											else
											{
											?>
											<span class="badge bg-warning border-0">SIN PERMANENCIA</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<?php
											if($items['IMEI']!='' || $items['IMEI'] != null)
											{
											?>
											<span class="badge bg-danger border-0">
												<a href="#!" class="datos-movil px-2 py-2" style="color: #FFF;" data-bs-toggle="modal" data-bs-target="#informacionMovil" data-id="<?= $items['EquipoAsociado'] ?>" data-accion="ver" id="ver-movil">
													<?= $items['IMEI'] ?>
												</a>
											</span>
											<?php
											}
											else
											{
												echo "--";
											}
											?>
										</td>
										<td class="text-center align-middle">
											<?php
											echo "S/. ".$items['Penalidad'];
											?>
										</td>
										<td class="text-center align-middle">
											<?php
											if($items['Estado'] != '')
											{
												if($items['Estado'] == 'VIGENTE')
												{
												?>
												<span class="badge bg-secondary border-0"><?= $items['Estado'] ?></span>
												<?php
												}
												else
												{
												?>
												<span class="badge bg-primary border-0"><?= $items['Estado'] ?></span>
												<?php
												}
											} 
											else
											{
											?>
											<span class="badge bg-info border-0">SIN CONTRATO</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-contrato" data-bs-toggle="modal" data-bs-target="#informacionContrato" data-id="<?= $items['IDContrato'] ?>" data-accion="ver" id="ver-contrato">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDCON", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-contrato" data-bs-toggle="modal" data-bs-target="#informacionContrato" data-id="<?= $items['IDContrato'] ?>" data-accion="editar" id="editar-contrato">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Añadir Contrato -->
<div class="modal fade" id="agregarContrato" tabindex="-1" role="dialog" aria-labelledby="exampleagregarContrato" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleagregarContrato">Agregar Contrato</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" autocomplete="off" action="<?= $baseUrl ?>/grabar-contrato" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" name="txtIdLinea" id="txtIdLinea" value="<?= $linea['IDLinea'] ?>">
					<div class="row">
					    <div class="col-xxl-12 col-md-12 col-12 mb-3" id="ctnPenalidadContratoVigente">
					        
					    </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtOperador" class="form-label">Operador</label>
								<select class="form-select" aria-label="Operador" id="txtOperador" name="txtOperador">
									<option selected="" value="">Seleccione una opción</option>
								</select>
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtPlan" class="form-label">Plan</label>
                            <select class="form-select" aria-label="Plan" id="txtPlan" name="txtPlan">
								<option selected="" value="">Seleccione una opción</option>
							</select>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtInicioContrato" class="form-label">Inicio Contrato</label>
                            <div class="input-group">
                                <input type="date" class="form-control" aria-label="Inicio de contrato" id="txtInicioContrato" name="txtInicioContrato">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtDiaFacturacion" class="form-label">Día facturación</label>
                            <div class="input-group">
                                <input type="number" min="1" max="31" class="form-control" aria-label="Día de facturación" id="txtDiaFacturacion" name="txtDiaFacturacion">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtPeriodoPermanencia" class="form-label">Permanencia</label>
									<select class="form-select" aria-label="Periodo de permanencia" id="txtPeriodoPermanencia" name="txtPeriodoPermanencia">
									<option selected="" value="">Seleccione una opción</option>
									<option value="SP">SIN PERMANENCIA</option>
									<option value="12">12 Meses</option>
									<option value="18">18 Meses</option>
									<option value="24">24 Meses</option>
								</select>
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtValorCuota" class="form-label">Cuota de equipo</label>
                            <div class="input-group">
                                <input type="number" step="0.01" class="form-control" aria-label="Valor de cuota de equipo" id="txtValorCuota" name="txtValorCuota">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-6 col-12 mb-3">
							<label for="txtEstado_contrato" class="form-label">Estado</label>
                            <select class="form-select" aria-label="Estado" id="txtEstado_contrato" name="txtEstado_contrato">
								<option value="VIGENTE">VIGENTE</option>
                            </select>
                        </div>
						<div class="col-12 row m-0 mb-3" style="border-radius: 30px; background-color: green; padding: 10px; color: #FFF;">
							<p class="col-6 m-0 d-flex align-items-center">¿El contrato incluye equipo?</p>
							<div class="col-6 d-flex justify-content-end" style="">
								<div class="bootstrap-switch-on bootstrap-switch bootstrap-switch-wrapper bootstrap-switch-animate " id="ctn-switch-contrato-equipo" style="width: 75px;background-color: #FFF;">
									<div class="bootstrap-switch-container" style="width: 117px; margin-left: 0px;">
										<input type="checkbox" id="chkIncluyeMovil" name="chkIncluyeMovil" data-bootstrap-switch="" data-off-text="NO" data-off-color="danger" data-on-text="SI" data-on-color="success">
									</div>
								</div>
							</div>
						</div>
						<div id="ctnRegistroEquipo" class="m-0 py-0 d-none">
							<div class="col-xxl-12 col-md-12 col-12 mb-3">
								<div>
									<label for="txtMarca" class="form-label">Marca</label>
									<select class="form-select" aria-label="Marca" id="txtMarca" name="txtMarca" data-categoria="MOVIL">
										<option selected="" value="">Seleccione una opción</option>
										
									</select>
								</div>
							</div>
							<div class="col-xxl-12 col-md-12 col-12 mb-3">
								<div>
									<label for="txtModeloComercial" class="form-label">Modelo</label>
									<select class="form-select" aria-label="Tipo" id="txtModeloComercial" name="txtModeloComercial">
										<option selected="" value="">Seleccione una opción</option>
										
									</select>
								</div>
							</div>
							<div class="col-xxl-12 col-md-6 col-12 mb-3">
								<label for="txtProveedor" class="form-label">Proveedor</label>
								<select class="form-select" aria-label="Proveedor" id="txtProveedor" name="txtProveedor">
									<option selected="" value="">Seleccione una opción</option>
									<option value="ENTEL">ENTEL</option>
									<option value="LOGÍSTICA">LOGÍSTICA</option>
								</select>
							</div>
							<div class="col-xxl-12 col-md-12 col-12 mb-3">
								<div>
									<label for="txtIMEI" class="form-label">IMEI</label>
									<input type="number" class="form-control" id="txtIMEI" name="txtIMEI">
								</div>
							</div>
							<div class="col-xxl-12 col-md-12 col-12 mb-3">
								<div>
									<label for="txtFechaCompra" class="form-label">Fecha Compra</label>
									<input type="date" class="form-control" id="txtFechaCompra" value="<?= date("Y-m-d") ?>" name="txtFechaCompra">
								</div>
							</div>
							<div class="col-xxl-12 col-md-12 col-12 mb-3">
								<div>
									<label for="txtPrecioCompra" class="form-label">Precio Compra</label>
									<input type="number" class="form-control" id="txtPrecioCompra" name="txtPrecioCompra">
								</div>
							</div>
							<div class="col-xxl-12 col-md-12 col-12 mb-3">
								<div>
									<label for="txtPrecioLista" class="form-label">Precio Lista</label>
									<input type="number" class="form-control" id="txtPrecioLista" name="txtPrecioLista">
								</div>
							</div>
							<div class="col-xxl-12 col-md-6 col-12 mb-3">
								<label for="txtEstado_equipo" class="form-label">Estado</label>
								<select class="form-select" aria-label="Estado" id="txtEstado_equipo" name="txtEstado_equipo">
									<option value="ACT">ACTIVO</option>
								</select>
							</div>
							<div class="col-xxl-12 col-md-6 col-12 mb-3">
								<label for="txtMotivo_equipo" class="form-label">Motivo</label>
								<select class="form-select" aria-label="Motivo" id="txtMotivo_equipo" name="txtMotivo_equipo">
									<option value="NUE">NUEVO</option>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
		<script>
			
			
                
			</script>
	</div>
</div>

<!-- Modal Información Contrato -->
<div class="modal fade" id="informacionContrato" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionContrato" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionContrato">Información de contrato</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionContrato" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDContrato_i" name="txtIDContrato_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtOperador_i" class="form-label">Operador</label>
								<select class="form-select" aria-label="Operador" id="txtOperador_i" name="txtOperador_i">
									<option selected="" value="">Seleccione una opción</option>
								</select>
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtPlan_i" class="form-label">Plan</label>
                            <select class="form-select" aria-label="Plan" id="txtPlan_i" name="txtPlan_i">
								<option selected="" value="">Seleccione una opción</option>
							</select>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtInicioContrato_i" class="form-label">Inicio Contrato</label>
                            <div class="input-group">
                                <input type="date" class="form-control" aria-label="Inicio de contrato" id="txtInicioContrato_i" name="txtInicioContrato_i">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtDiaFacturacion_i" class="form-label">Día facturación</label>
                            <div class="input-group">
                                <input type="number" min="1" max="31" class="form-control" aria-label="Día de facturación" id="txtDiaFacturacion_i" name="txtDiaFacturacion_i">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtPeriodoPermanencia_i" class="form-label">Permanencia</label>
									<select class="form-select" aria-label="Periodo de permanencia" id="txtPeriodoPermanencia_i" name="txtPeriodoPermanencia_i">
									<option selected="" value="">Seleccione una opción</option>
									<option value="SP">SIN PERMANENCIA</option>
									<option value="12">12 Meses</option>
									<option value="18">18 Meses</option>
									<option value="24">24 Meses</option>
								</select>
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtValorCuota_i" class="form-label">Cuota de equipo</label>
                            <div class="input-group">
                                <input type="number" step="0.01" class="form-control" aria-label="Valor de cuota de equipo" id="txtValorCuota_i" name="txtValorCuota_i">
                            </div>
                        </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarContrato" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Información Movil -->
<div class="modal fade" id="informacionMovil" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionMovil" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionMovil">Información de móvil</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionMovil" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDMovil_i" name="txtIDMovil_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtMarca_i" class="form-label">Marca</label>
								<select class="form-select" aria-label="Marca" id="txtMarca_i" name="txtMarca_i">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtModeloComercial_i" class="form-label">Modelo</label>
								<select class="form-select" aria-label="Tipo" id="txtModeloComercial_i" name="txtModeloComercial_i">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-6 col-12 mb-3">
							<label for="txtProveedor_i" class="form-label">Proveedor</label>
							<select class="form-select" aria-label="Proveedor" id="txtProveedor_i" name="txtProveedor_i">
								<option selected="" value="">Seleccione una opción</option>
								<option value="ENTEL">ENTEL</option>
								<option value="LOGÍSTICA">LOGÍSTICA</option>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtIMEI_i" class="form-label">IMEI</label>
								<input type="number" class="form-control" id="txtIMEI_i" name="txtIMEI_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtFechaCompra_i" class="form-label">Fecha Compra</label>
								<input type="date" class="form-control" id="txtFechaCompra_i" name="txtFechaCompra_i" value="<?= date("Y-m-d") ?>">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtPrecioCompra_i" class="form-label">Precio Compra</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioCompra_i" name="txtPrecioCompra_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtPrecioLista_i" class="form-label">Precio Lista</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioLista_i" name="txtPrecioLista_i">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarMovil" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>