<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<?php
								if (in_array("ASIDIS", $permisos)) 
								{
								?>
								<a class="btn btn-primary" href="<?= $baseUrl ?>/nueva-asignacion" >
									<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Asignar dispositivos
								</a>
								<?php
								}
								?>
                                <!--<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#asignarDispositivos" data-id="0" data-accion="crear" id="btnAsignarDispositivos">
									<i class="mdi mdi-plus-circle"></i> Asignar
								</button>-->
                            </div>
                        </div>
						<div class="card-body">
							<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Usuario</th>
										<th class="text-center align-middle">Asignaciones Activas</th>
										<th class="text-center align-middle">Acción</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaAsignaciones as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['NombreAsignado'] ?></td>
										<td class="text-center align-middle"><?= $items['CANTIDAD_ELEMENTOS'] ?></td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<!--<li>
														<a href="#!" class="dropdown-item datos-operador" data-bs-toggle="modal" data-bs-target="#informacionOperador" data-id="<?= $items['UsuarioAsignado'] ?>" data-accion="ver" id="ver-operador">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-operador" data-bs-toggle="modal" data-bs-target="#informacionOperador" data-id="<?= $items['UsuarioAsignado'] ?>" data-accion="editar" id="editar-operador">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>-->
													
													<li>
														<a href="<?= $baseUrl ?>/listar-asignaciones/<?= $items['UsuarioAsignado'] ?>" class="dropdown-item">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Asignados
														</a>
													</li>
													
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Operador -->
<div class="modal fade" id="asignarDispositivos" tabindex="-1" role="dialog" aria-labelledby="exampleasignarDispositivos" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleasignarDispositivos">Asignar Dispositivos</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAsignarDispositivos" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtAsignado" class="form-label">Usuario Asignado</label>
								<select class="form-select" aria-label="Asignado" id="txtAsignado" name="txtAsignado">
									<option selected="" value="">Seleccione una opción</option>
								</select>
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtFechaAsignado" class="form-label">Fecha Asignación</label>
                            <div class="input-group">
                                <input type="date" class="form-control" aria-label="Fecha de asignación" id="txtFechaAsignado" name="txtFechaAsignado">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtTipoAsignado" class="form-label">Tipo de asignación</label>
								<select class="form-select" aria-label="Tipo de asignación" id="txtTipoAsignado" name="txtTipoAsignado">
									<option selected="" value="">Seleccione una opción</option>
									<option value="ASIGNADO">ASIGNADO</option>
									<option value="TEMPORAL">TEMPORAL</option>
								</select>
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacion" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacion" name="txtObservacion" rows="4"></textarea>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtRemitente" class="form-label">Usuario Remitente</label>
								<select class="form-select" aria-label="Remitente" id="txtRemitente" name="txtRemitente">
									<option selected="" value="">Seleccione una opción</option>
								</select>
                            </div>
                        </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarOperador" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>