<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="row col-lg-12">
					<div class="col-12 col-md-8">
						<div class="card">
							<div class="card-header d-flex align-items-center">
								<h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
								<div>
									<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
								</div>
							</div>
							<div class="card-body">
								<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
									<thead>
										<tr>
											<th class="text-center align-middle">Código</th>
											<th class="text-center align-middle">Tipo Elemento</th>
											<th class="text-center align-middle">Marca</th>
											<th class="text-center align-middle">Modelo</th>
											<th class="text-center align-middle">Serie</th>
											<th class="text-center align-middle">Observación</th>
											<th class="text-center align-middle">Monto Reposición</th>
											<th class="text-center align-middle">¿Devuelto?</th>
										</tr>
									</thead>
									<tbody>
										<?php
										foreach($listaDetalle as $items){ ?>
										<tr>
											<td class="text-center align-middle"><?= $items['IDDetalleAsignacion'] ?></td>
											<td class="text-center align-middle"><?= $items['TIPO'] ?></td>
											<td class="text-center align-middle"><?= $items['Marca'] ?></td>
											<td class="text-center align-middle"><?= $items['Modelo'] ?></td>
											<td class="text-center align-middle"><?= $items['Serie'] ?></td>
											<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
											<td class="text-center align-middle"><?= $items['MonedaReposicion'] == 'PEN' ? "S/." : ($items['MonedaReposicion'] == 'EUR' ? "€" : "$") ?> <?= $items['MontoReposicion'] ?></td>
											<td class="text-center align-middle">
												<?php
												if($items['IDDetalleDevolucion'] != NULL && $items['IDDetalleDevolucion'] != '')
												{
												?>
												<span class="badge bg-success border-0">SI</span>
												<?php
												} 
												else
												{
												?>
												<span class="badge bg-danger border-0">NO</span>
												<?php
												} 
												?>
											</td>
										</tr>
										<?php } ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<div class="col-12 col-md-4">
						<div class="card">
							<div class="card-header d-flex align-items-center">
								<h5 class="card-title mb-0 flex-grow-1">Adjuntos</h5>
								<div>
									<?php
									if (in_array("ADJASI", $permisos)) 
									{
									?>
									<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#agregarAdjuntoAsignacion" id="btnAdjuntarDocumentoAsignacion">
										<i class="mdi mdi-plus-circle"></i> Agregar
									</button>
									<?php
									}
									?>
								</div>
							</div>
							<div class="card-body">
								<table id="tblAdjuntoAsignacion" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
									<thead>
										<tr>
											<th class="text-center align-middle">Código</th>
											<th class="text-center align-middle">Adjunto</th>
											<th class="text-center align-middle">Observación</th>
											<th class="text-center align-middle">Fecha</th>
										</tr>
									</thead>
									<tbody>
									<?php 
										foreach($listaAdjunto as $items)
										{
										    if($items['Firma'] != 'Y')
										    {
										?>
										<tr>
											<td class="text-center align-middle"><?= $items['IDAdjuntoAsignacion'] ?></td>
											<td class="text-center align-middle">
												<?php
												$ruta = "public/docs/ActaAsignacion/";
												$nombreArchivo = $items['IDAsignacion'].'-'.$items['IDAdjuntoAsignacion'].'.'.$items['Extension'];
												$nombreDescargar = $items['Nombre'].'.'.$items['Extension'];

												if (file_exists($ruta.$nombreArchivo)) 
												{
												?>
												<span class="badge bg-success border-0" >
													<a class='texto-indicador' href='<?= base_url().'/'.$ruta.$nombreArchivo ?>' download='<?= $nombreDescargar ?>'><?= $nombreDescargar ?></a>
												</span>
												<?php
												}
												else
												{
												?>
												<span class="badge bg-warning border-0" >
													<?= $items['Nombre'] ?>
												</span>
												<?php
												}
												?>
												</td>
											<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
											<td class="text-center align-middle"><?= date("d-m-Y H:i:s", strtotime($items['FechaCrea'])) ?></td>
										</tr>
										<?php 
										    }
										} 
										?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Adjuntar Documento -->
<div class="modal fade" id="agregarAdjuntoAsignacion" tabindex="-1" role="dialog" aria-labelledby="exampleagregarAdjuntoAsignaciona" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleagregarAdjuntoAsignaciona">Adjuntar documento a asignación</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formAdjuntarDocumentoAsignacion" autocomplete="off" action="<?= $baseUrl ?>/adjuntar-documento-asignacion/<?= $idAsignacion ?>" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<label for="txtNombreAdjunto_i" class="form-label">Nombre</label>
						<div class="input-group">
							<input type="text" class="form-control" aria-label="Nombre" id="txtNombreAdjunto_i" name="txtNombreAdjunto_i">
						</div>
					</div>
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<div>
							<label for="txtObservacionAdjunto_i" class="form-label">Observación</label>
							<textarea class="form-control" id="txtObservacionAdjunto_i" name="txtObservacionAdjunto_i" rows="4"></textarea>
						</div>
					</div>
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<label for="fileAdjuntoAsignacion" class="form-label">Seleccione Adjunto:</label>
						<input class="form-control" type="file" id="fileAdjuntoAsignacion" name="fileAdjuntoAsignacion">
					</div>
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<div class="form-check form-switch">
							<label class="col-12 form-check-label" for="chkAdjuntoFirma">¿Adjunto reemplaza firma?</label>
							<input class="form-check-input" type="checkbox" role="switch" name="chkAdjuntoFirma" id="chkAdjuntoFirma">
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>