<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<ul class="nav nav-tabs nav-justified nav-border-top nav-border-top-success mb-3 bg-white" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link active" data-bs-toggle="tab" href="#nav-solicitudes-curso" role="tab" aria-selected="true">
                        <i class="ri-home-5-line align-middle me-1"></i> Solicitudes en Curso
                    </a>
                </li>
                <li class="nav-item" role="presentation" id="navPeticionesHistorico">
                    <a class="nav-link" data-bs-toggle="tab" href="#nav-solicitudes-historico" role="tab" aria-selected="false" tabindex="-1">
                        <i class="ri-user-line me-1 align-middle"></i> Histórico de Solicitudes
                    </a>
                </li>
            </ul>
            <div class="tab-content text-muted" style="background-color: transparent;">
                <div class="tab-pane active show" id="nav-solicitudes-curso" role="tabpanel" style="background-color: transparent!important">
                    <div class="row">
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Total de reposiciones</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['Totales'] ?>"><?= $cantidadesGenerales['Totales'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="547">547</span>k</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-success mb-0"> <i class="ri-arrow-up-line align-middle"></i> 17.32 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-ticket-account" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div> <!-- end card-->
                        </div>
                        <!--end col-->
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Reposiciones del mes</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['Mes'] ?>"><?= $cantidadesGenerales['Mes'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="124">124</span>k</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-danger mb-0"> <i class="ri-arrow-down-line align-middle"></i> 0.96 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-calendar-month-outline" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Reposiciones pendientes</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['Pendientes'] ?>"><?= $cantidadesGenerales['Pendientes'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="107">107</span>K</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-danger mb-0"> <i class="ri-arrow-down-line align-middle"></i> 3.87 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-timer-sand" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Reposiciones sin iniciar</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['NoIniciados'] ?>"><?= $cantidadesGenerales['NoIniciados'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="15.95">15.95</span>%</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-success mb-0"> <i class="ri-arrow-up-line align-middle"></i> 1.09 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-clock-alert-outline" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card" id="ticketsList">
                                <div class="card-header border-0">
                                    <div class="d-flex align-items-center">
                                        <h5 class="card-title mb-0 flex-grow-1">Reposición</h5>
                                        <div class="flex-shrink-0">
                                            <div class="d-flex flex-wrap gap-2">
                                                <button class="btn btn-danger add-btn" data-bs-toggle="modal" data-bs-target="#registrarReposicion" id="btnNuevaReposicion"><i class="ri-add-line align-bottom me-1"></i> Reposición</button>
                                                <!--<button type="button" class="btn btn-primary" > <i class="ri-equalizer-fill me-1 align-bottom"></i>-->
                                                <!--    Filters-->
                                                <!--</button>-->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--end card-body-->
                                <div class="card-body">
                                    <div class="mb-4 table-responsive">
                                        <table class="table table-bordered dt-responsive nowrap table-striped align-middle" id="tblSolicitudesReposicion" width="100%">
                                            <thead>
                                                <tr>
                                                    <th class="sort desc">Nro Solicitud</th>
                                                    <th class="sort">Fecha de Solicitud</th>
                                                    <th class="sort">Fecha Último Cambio</th>
                                                    <th class="sort">Solicitante</th>
                                                    <th class="sort">Adjudicado</th>
                                                    <th class="sort">Elemento</th>
                                                    <th class="sort">Motivo Reposición</th>
                                                    <th class="sort">Estado</th>
                                                    <th class="sort">Acción</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                foreach($listadoSolicitudes as $items)
                                                {
                                                ?>
                                                <tr>
                                                    <td class="text-center align-middle"><?= $items['IDSolicitudReposicion'] ?></td>
                                                    <td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['FechaCrea'])) ?><br><?= date("H:i:s", strtotime($items['FechaCrea'])) ?><br></td>
                                                    <td class="text-center align-middle">
                                                        <?= $items['FechaModifica'] == '' || $items['FechaModifica'] == null ? date("d-m-Y", strtotime($items['FechaCrea'])) : date("d-m-Y", strtotime($items['FechaModifica'])) ?>
                                                        <br>
                                                        <?= $items['FechaModifica'] == '' || $items['FechaModifica'] == null ? date("H:i:s", strtotime($items['FechaCrea'])) : date("H:i:s", strtotime($items['FechaModifica'])) ?>
                                                    </td>
                                                    <td class="text-center align-middle"><?= $items['NombreSolicitante'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['NombreAdjudicado'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['Elemento'] ?></td>
                                                    <td class="text-center align-middle">
                                                        <span class="badge bg-sistema border-0">
            												<?= $motivosDevolucion[$items['MotivoReposicion']] ?>
            											</span>
                                                    </td>
                                                    <td class="text-center align-middle">
                                                        <span class="badge <?= $estadosSolicitud[$items['Estado']]['FONDO'] ?> border-0">
            												<?= $estadosSolicitud[$items['Estado']]['PASADO'] ?>
            											</span>
                                                    </td>
                                                    <td class="text-center align-middle">
                                                        <span class="badge bg-sistema border-0 p-2">
                                                            <a href="<?= $baseUrl ?>/solicitud-reposicion-informacion/<?= $items['IDSolicitudReposicion'] ?>" class="color-white">
            													<i class="ri-eye-fill align-bottom" style="font-size: 18px;"></i>
            												</a>
            											</span>
                                                    </td>
                                                </tr>
                                                <?php
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!--end card-body-->
                            </div>
                            <!--end card-->
                        </div>
                        <!--end col-->
                    </div>
                </div>
                <div class="tab-pane" id="nav-solicitudes-historico" role="tabpanel" style="background-color: transparent;">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card" id="ticketsList">
                                <div class="card-header border-0">
                                    <div class="d-flex align-items-center">
                                        <h5 class="card-title mb-0 flex-grow-1">Histórico de Solicitudes</h5>
                                        <div class="flex-shrink-0">
                                            <div class="d-flex flex-wrap gap-2">
                                                <!--<button type="button" class="btn btn-primary" > <i class="ri-equalizer-fill me-1 align-bottom"></i>-->
                                                <!--    Filters-->
                                                <!--</button>-->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--end card-body-->
                                <div class="card-body">
                                    <div class="mb-4">
                                        <table class="table table-bordered dt-responsive nowrap table-striped align-middle" id="tblHistoricoSolicitudes">
                                            
                                        </table>
                                    </div>
                                </div>
                                <!--end card-body-->
                            </div>
                            <!--end card-->
                        </div>
                        <!--end col-->
                    </div>
                </div>
            </div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Registrar Petición -->
<div class="modal fade zoomIn" id="registrarReposicion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleRegistrarReposicion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema d-flex justify-content-start align-items-center p-3">
				<h5 class="modal-title color-white" id="exampleRegistrarReposicion">Solicitar Reposición</h5>
                <button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
			</div>
			<form id="formRegistrarReposicion" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/solicitar-reposicion-item" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="step-arrow-nav mb-4">
                        <ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabSolicitudReposicion" data-bs-toggle="pill" data-bs-target="#tabcontentSolicitudReposicion" type="button" role="tab" aria-controls="tabcontentSolicitudReposicion" aria-selected="true" data-position="0">Información de Usuario</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabDetalleReposicion" data-bs-toggle="pill" data-bs-target="#tabcontenDetalleReposicion" type="button" role="tab" aria-controls="tabcontenDetalleReposicion" aria-selected="false" data-position="1">Elementos a reponer</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentSolicitudReposicion" role="tabpanel" aria-labelledby="tabSolicitudReposicion">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-8 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Usuario Solicitante</label>
            								<input type="text" class="form-control" style="color: #0000FF" value="<?= $nombres.' '.$apellidos ?>" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Matrícula Solicitante</label>
            								<input type="text" class="form-control" style="color: #0000FF" value="<?= $matriculaLog ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                    <div class="col-xxl-8 col-md-12 col-12 px-3">
                                        <div>
                                            <label for="txtAdjudicadoReposicion" class="form-label">Usuario Adjudicado</label>
                                            <select class="form-select" aria-label="Adjudicado" id="txtAdjudicadoReposicion" name="txtAdjudicadoReposicion">
                                                <option selected="" value="">Seleccione una opción</option>
                                            </select>
                                        </div>
                                    </div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtMatriculaAdjudicado" class="form-label" >Matrícula Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtMatriculaAdjudicado" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtNombreAdjudicado" class="form-label" >Nombre Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtNombreAdjudicado" name="txtNombreAdjudicado" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtApellidoAdjudicado" class="form-label">Apellido Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtApellidoAdjudicado" name="txtApellidoAdjudicado" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtDocumentoAdjudicado" class="form-label">Documento Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtDocumentoAdjudicado" name="txtDocumentoAdjudicado" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtDireccionAdjudicado" class="form-label" >Dirección Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtDireccionAdjudicado" name="txtDireccionAdjudicado" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtAreaAdjudicado" class="form-label">Área Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtAreaAdjudicado" name="txtAreaAdjudicado" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtCargoAdjudicado" class="form-label">Cargo Adjudicado</label>
            								<input type="text" class="form-control validarNextTab" id="txtCargoAdjudicado" name="txtCargoAdjudicado" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            						    <div>
                                            <label for="txtMotivoReposicion" class="form-label">Motivo de reposición</label>
                                            <select class="form-select validarNextTab" aria-label="Motivo" id="txtMotivoReposicion" name="txtMotivoReposicion">
                                                <option selected="" value="">Seleccione una opción</option>
                                                <option value="ROB">ROBO</option>
                                                <option value="PER">PÉRDIDA</option>
                                                <option value="NOD">NO DEVOLUCIÓN</option>
                                                <option value="FAL">FALLA</option>
                                                <option value="REN">RENOVACIÓN</option>
                                            </select>
                                        </div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtObservacion" class="form-label">Observación</label>
            								<textarea class="form-control validarNextTab" id="txtObservacion" name="txtObservacion" rows="4"></textarea>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            						    <div>
                						    <label class="form-label">Adjuntar Denuncia Policial</label>
                						    <div class="input-group">
                                                <input type="file" class="form-control" id="fileAdjuntoReposicion" name="fileAdjuntoReposicion" disabled>
                                            </div>
                                        </div>
            						</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabDetalleReposicion" id="btnNextTab" disabled><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Ingresar elementos</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade" id="tabcontenDetalleReposicion" role="tabpanel" aria-labelledby="tabDetalleReposicion">
                            <div>
        					    <div class="row col-12 m-0 p-0 mb-0 d-flex">
        					        <div class="alert alert-warning border-0" role="alert">
                                        <li>La reposición generará automáticamente la autorización de descuento que será enviada al correo del trabajador para que pueda ser firmado y poder gestionar el envío de un nuevo dispositivo.</li>
                                        <li>En casos particulares, la autorización de descuento se enviará luego de un proceso de revisión del dispositivo devuelto, por lo que se verá reflejado si se generó el documento o está siendo validado.</li>
                                        <li>El monto a descontarse y las cuotas dependerá del motivo por el cual se solicita la reposición y/o el resultado de la revisión del dispositivo.</li>
                                    </div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-10 col-md-12 col-12 px-3">
            							<div>
                                            <label for="txtItemReposicion" class="form-label">Item</label>
                                            <select class="form-select" aria-label="Item" id="txtItemReposicion" name="txtItemReposicion">
                                                <option selected="" value="">Seleccione una opción</option>
                                            </select>
                                        </div>
            						</div>
            						<div class="col-xxl-2 col-md-12 col-12 px-3 d-flex justify-content-end align-items-center">
            						    <button type="button" class="btn bg-success px-2 py-1 ms-3" onclick="return agregarItemReposicion();" data-tooltip="tooltip" aria-label="Agregar Item a la reposición">
                                            <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i>
                                        </button>
            						</div>
        					    </div>
                                <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
            					    Elementos para reponer
            					</div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex" id="ctnElementosReposicion">
            						
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabSolicitudReposicion"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a la asignación</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                    </div>
                    <!-- end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>