<?php
namespace App\Models;
use CodeIgniter\Model;

class VAReposicionesDetalleModel extends Model
{
    protected $table      = 'reposiciones_detalle';
    protected $primaryKey = 'IDDetalleReposicion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDReposicion', 'IDDetalleAsignacion', 'TotalDescuento', 'TotalVerisure', 'TotalTrabajador', 'Observacion', 'TotalCuotas', 'MesFacturacion', 'AnioFacturacion', 'Bolsa', 'Cobrado', 'FechaCobro', 'MontoCobro', 'ObservacionCobro', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarDetalleReposicion($idReposicion)
    {
        $this->select('reposiciones_detalle.IDDetalleReposicion,
            reposiciones_detalle.IDReposicion,
            reposiciones_detalle.TotalDescuento,
            reposiciones_detalle.TotalVerisure,
            reposiciones_detalle.TotalTrabajador,
            reposiciones_detalle.Observacion,
            asignaciones_detalle.IDDetalleAsignacion,
            asignaciones_detalle.TipoElemento,
            asignaciones_detalle.IDElemento');
        $this->join('asignaciones_detalle', 'reposiciones_detalle.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion','left');
        $this->where('reposiciones_detalle.IDReposicion', $idReposicion);
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listarDescuentosMes($mes, $anio)
    {
        $this->select('reposiciones_detalle.IDDetalleReposicion,
            reposiciones_detalle.IDReposicion,
            reposiciones_detalle.IDDetalleAsignacion,
            reposiciones_detalle.TotalTrabajador,
            reposiciones_detalle.TotalCuotas,
            reposiciones_detalle.Observacion,
            reposiciones_detalle.Cobrado,
            reposiciones_detalle.FechaCobro,
            reposiciones_detalle.MontoCobro,
            reposiciones_detalle.ObservacionCobro,
            reposiciones.UsuarioAdjudicado,
            asignaciones_detalle.IDDetalleAsignacion,
            asignaciones_detalle.TipoElemento,
            asignaciones_detalle.IDElemento');
        $this->join('reposiciones', 'reposiciones_detalle.IDReposicion  = reposiciones.IDReposicion');
        $this->join('asignaciones_detalle', 'reposiciones_detalle.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion','left');
        $this->where('reposiciones_detalle.MesFacturacion', $mes);
        $this->where('reposiciones_detalle.AnioFacturacion', $anio);
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerDescuentosPendientesMes($mes, $anio)
    {
        $this->select('reposiciones_detalle.IDDetalleReposicion,
            reposiciones_detalle.IDReposicion,
            reposiciones_detalle.IDDetalleAsignacion,
            reposiciones_detalle.TotalTrabajador,
            reposiciones_detalle.Observacion,
            reposiciones_detalle.TotalCuotas,
            reposiciones_detalle.MesFacturacion,
            reposiciones_detalle.AnioFacturacion,
            reposiciones_detalle.Bolsa,
            reposiciones.UsuarioAdjudicado,
            asignaciones_detalle.TipoElemento,
            asignaciones_detalle.IDElemento');
        $this->join('reposiciones', 'reposiciones_detalle.IDReposicion  = reposiciones.IDReposicion');
        $this->join('asignaciones_detalle', 'reposiciones_detalle.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion','left');
        $this->where('reposiciones_detalle.MesFacturacion', $mes);
        $this->where('reposiciones_detalle.AnioFacturacion', $anio);
        $this->where('reposiciones_detalle.Cobrado', "N");
        
        $datos = $this->findAll();
        return $datos;
    }
}