<?php
namespace App\Models;
use CodeIgniter\Model;

class VAMovilesModel extends Model
{
    protected $table      = 'moviles';
    protected $primaryKey = 'IDMovil';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDModelo', 'Proveedor', 'IMEI', 'FechaCompra', 'PrecioCompra', 'PrecioLista', 'EquipoStock', 'FechaEstado', 'UsuarioEstado', 'Estado', 'Situacion', 'MotivoCambio', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoMoviles($estado)
    {
        $this->select('
            moviles.IDMovil ,
            moviles.IDModelo,
            marcas_dispositivos.Modelo,
            marcas.Marca,
            moviles.Proveedor,
            moviles.IMEI,
            moviles.FechaCompra,
            moviles.PrecioCompra,
            moviles.PrecioLista,
            moviles.EquipoStock,
            moviles.Estado,
            moviles.Situacion,
            asignacion.UsuarioAsignado');
        $this->join('marcas_dispositivos', 'moviles.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="MOVIL") AS asignacion', 'moviles.IDMovil = asignacion.IDElemento', 'left');
        
        if($estado != '')
        {
            $this->where('moviles.Estado', $estado);
        }
        

        $datos = $this->findAll();
        return $datos;
    }

    public function listadoMovilesFiltro($array)
    {
        $this->select('
            moviles.IDMovil ,
            moviles.IDModelo,
            marcas_dispositivos.Modelo,
            marcas.Marca,
            moviles.Proveedor,
            moviles.IMEI,
            moviles.FechaCompra,
            moviles.PrecioCompra,
            moviles.PrecioLista,
            moviles.EquipoStock,
            moviles.Estado,
            moviles.Situacion,
            asignacion.UsuarioAsignado');
        $this->join('marcas_dispositivos', 'moviles.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="MOVIL") AS asignacion', 'moviles.IDMovil = asignacion.IDElemento', 'left');
        
        if(isset($array['estado']) && $array['estado'] != '' && $array['estado'] != null)
        {
            $this->where('moviles.Estado', $array['estado']);
        }
        
        if(isset($array['libre']) && $array['libre'] == 'Y')
        {
            $this->where('asignacion.UsuarioAsignado IS NULL');
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function obtenerMovil($idMovil)
    {
        $this->select('
            moviles.IDMovil ,
            moviles.IDModelo,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.IDMarca,
            marcas.Marca,
            moviles.Proveedor,
            moviles.IMEI,
            moviles.FechaCompra,
            moviles.PrecioCompra,
            moviles.PrecioLista,
            moviles.EquipoStock');
        $this->join('marcas_dispositivos', 'moviles.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->where('moviles.IDMovil', $idMovil);
        
        $datos = $this->first();
        return $datos;
    }
    
    public function listarMovilesDisponibles($variable)
    {
        $consulta = "SELECT 
            moviles.IDMovil,
            moviles.IMEI, 
            marcas_dispositivos.Modelo,
            marcas.Marca 
        FROM 
            moviles 
        INNER JOIN 
            marcas_dispositivos ON moviles.IDModelo = marcas_dispositivos.IDDispositivo 
        INNER JOIN
        	marcas ON marcas_dispositivos.IDMarca = marcas.IDMarca
        WHERE   
            (moviles.IMEI LIKE '%".$variable."%' OR marcas_dispositivos.Modelo LIKE '%".$variable."%' OR marcas.Marca LIKE '%".$variable."%') AND
            moviles.Estado IN ('ACT') AND 
            moviles.IDMovil NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL AND 
                    asignaciones_detalle.TipoElemento = 'MOVIL')";

        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }
}