<?php
namespace App\Models;
use CodeIgniter\Model;

class VAMarcasDispositivosModel extends Model
{
    protected $table      = 'marcas_dispositivos';
    protected $primaryKey = 'IDDispositivo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDMarca', 'Modelo', 'Subtipo', 'FechaEstado', 'UsuarioEstado', 'Estado', 'MotivoCambio', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerDispositivo($idDispositivo)
    {
        $this->select('
            marcas_dispositivos.IDDispositivo,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.Estado,
            marcas_dispositivos.Subtipo,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->where('marcas_dispositivos.IDDispositivo', $idDispositivo);

        $datos = $this->first();
        return $datos;
    }

    public function listadoDispositivosXMarca($idMarca)
    {
        $this->select('
            marcas_dispositivos.IDDispositivo,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.Estado,
            subtipo.nombre_subtipo,
            tipo.nombre_tipo,
            categoria.nombre_categoria');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->where('marcas_dispositivos.IDMarca', $idMarca);

        $datos = $this->findAll();
        return $datos;
    }

    public function listadoDispositivosXFiltros($array)
    {
        $this->select('
            marcas_dispositivos.IDDispositivo,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.Estado,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');

        if(isset($array['idMarca']) && $array['idMarca'] != '')
        {
            $this->where('marcas_dispositivos.IDMarca', $array['idMarca']);
        }
        
        if(isset($array['estado']) && $array['estado'] != '')
        {
            $this->where('marcas_dispositivos.Estado', $array['estado']);
        }

        if(isset($array['clave']) && $array['clave'] != '')
        {
            $this->where('categoria.clave', $array['clave']);
        }
        
        if(isset($array['modelo']) && $array['modelo'] != '')
        {
            $this->where('marcas_dispositivos.Modelo', $array['modelo']);
        }
        
        if(isset($array['marca']) && $array['marca'] != '')
        {
            $this->where('marcas.Marca', $array['marca']);
        }
        $datos = $this->findAll();
        return $datos;
    }

}