<?php
namespace App\Models;
use CodeIgniter\Model;

class VALineasSeguroModel extends Model
{
    protected $table      = 'lineas_seguro';
    protected $primaryKey = 'IDSeguro';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDLinea', 'NroSeguro', 'Servicio', 'Plan', 'CostoPlan', 'InicioContrato', 'FechaEstado', 'UsuarioEstado', 'Estado', 'MotivoCambio', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function buscarSeguro($idSeguro)
    {
        $this->select('
            LS.IDLinea,
            L.Numero,
            LS.IDSeguro,
            LS.NroSeguro,
            LS.Servicio,
            LS.Plan,
            LS.CostoPlan,
            LS.InicioContrato,
            LS.Estado');
        $this->from('lineas_seguro AS LS');
        $this->join('lineas AS L', 'LS.IDLinea = L.IDLinea', 'left');
        $this->where('LS.IDSeguro', $idSeguro);

        $datos = $this->first();
        return $datos;
    }

    public function listadoSegurosXLinea($idLinea)
    {
        $this->select('
            lineas_seguro.IDSeguro,
            lineas_seguro.IDLinea,
            lineas_seguro.NroSeguro,
            lineas_seguro.Servicio,
            lineas_seguro.Plan,
            lineas_seguro.CostoPlan,
            lineas_seguro.InicioContrato,
            lineas_seguro.Estado,
            COUNT(lineas_seguro_moviles.IDMovil) "Total_asegurados"');
        $this->join('lineas_seguro_moviles', 'lineas_seguro.IDSeguro = lineas_seguro_moviles.IDSeguro', 'left');
        $this->where('lineas_seguro.IDLinea', $idLinea);

        $datos = $this->findAll();
        return $datos;
        /*
        
        $this->db->free_db_resource();
        $this->db->query('SET SQL_BIG_SELECTS=1');
        $this->db->select('RC.CCODCAMPANAREQ,
            RC.CCODCOTIZACION,
            IF(RC.CCODCOTIZACION ="", ECLIRC.CRSOCIALEMPRESA, ECLI.CRSOCIALEMPRESA) AS "CLIENTE",
            IF(RC.CCODCOTIZACION ="", EMRC.CNOMMARCA, EM.CNOMMARCA) AS "MARCA",
            ECAD.CRSOCIALEMPRESA AS "CADENA",
            IF(RC.CCODCOTIZACION ="", CMRC.CFORMATOMEDIO, CM.CFORMATOMEDIO) AS "LINEAL",
            IF(RC.CCODCOTIZACION ="", CMRC.CNOMMEDIO, CM.CNOMMEDIO) AS "MEDIO",
            IF(RC.CCODCOTIZACION ="", RC.CCAMPANA, C.CGLOSA) AS "CAMPANA",
            IF(RC.CARTEMOTIVO ="", RC.CARTEMOTIVO, C.CARTEMOTIVO) AS "ARTEMOTIVO",
            C.CUSERENCARGADO,
            CONCAT(UE.CNOMUSUARIO, " ", UE.CAPEUSUARIO) AS "SOLICITANTE",
            UE.CEMAILTRABAJO AS "SOLICITANTE_EMAIL",
            RC.DFECHAMODIFICA AS "FECHA_MODIFICACION",
            RC.DFECHACREA AS "FECHA_CREACION",
            RC.CESTADO');
        $this->db->from('rc_campana AS RC');
        $this->db->join('cot_cotizacion AS C', 'RC.CCODCOTIZACION = C.CCODCOTIZACION', 'left');
        $this->db->join('emp_marca AS EM', 'C.CCODMARCA = EM.CCODMARCA', 'left');
        $this->db->join('empresa AS ECLI', 'EM.CCODEMPRESA = ECLI.CCODEMPRESA', 'left');
        $this->db->join('empresa AS ECAD', 'C.CCODCADENA = ECAD.CCODEMPRESA', 'left');
        $this->db->join('conf_medio AS CM', 'C.CCODMEDIO = CM.CCODMEDIO', 'left');
        $this->db->join('usuario AS UE', 'C.CUSERENCARGADO = UE.CCODUSUARIO', 'left');
        $this->db->join('emp_marca AS EMRC', 'RC.CCODMARCA = EMRC.CCODMARCA', 'left');
        $this->db->join('empresa AS ECLIRC', 'EMRC.CCODEMPRESA = ECLIRC.CCODEMPRESA', 'left');
        $this->db->join('conf_medio AS CMRC', 'RC.CTIPOMEDIO = CMRC.CCODMEDIO', 'left');
        $this->db->where('RC.CCODCAMPANAREQ', $codCampana);
        
        $sql = $this->db->get_compiled_select();
        $query = $this->db->query($sql);
        $array = $query->result_array();
        return $array;
         */
    }
    
}