<?php
namespace App\Models;
use CodeIgniter\Model;

class VALineasContratoModel extends Model
{
    protected $table      = 'lineas_contrato';
    protected $primaryKey = 'IDContrato';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDLinea', 'IDPlan', 'InicioContrato', 'DiaFacturacion', 'Permanencia', 'PeriodoPermanencia', 'EquipoAsociado', 'MontoCuota', 'MontoDeducible', 'FechaPagoDeducible', 'FechaEstado', 'UsuarioEstado', 'Estado', 'Situacion', 'MotivoCambio', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerContrato($idContrato)
    {
        $this->select('
            lineas_contrato.IDContrato,
            lineas_contrato.IDLinea,
            lineas_contrato.IDPlan,
            operadores.IDOperador,
            operadores.Operador,
            operadores_planes.Plan,
            operadores_planes.PrecioPlan,
            operadores_planes.PrecioFinal,
            lineas_contrato.InicioContrato,
            lineas_contrato.PeriodoPermanencia,
            lineas_contrato.EquipoAsociado,
            lineas_contrato.DiaFacturacion,
            moviles.IMEI,
            moviles.PrecioCompra,
            moviles.PrecioLista,
            lineas_contrato.Estado,
            lineas_contrato.Permanencia,
            lineas_contrato.MontoCuota');
        $this->join('moviles', 'lineas_contrato.EquipoAsociado = moviles.IDMovil', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->where('lineas_contrato.IDContrato', $idContrato);

        $datos = $this->first();
        return $datos;
    }
    
    public function listarContratosXLinea($idLinea)
    {
        $this->select('
            lineas_contrato.IDContrato,
            lineas_contrato.IDLinea,
            lineas_contrato.IDPlan,
            operadores.Operador,
            operadores_planes.Plan,
            operadores_planes.PrecioFinal,
            lineas_contrato.InicioContrato,
            lineas_contrato.PeriodoPermanencia,
            lineas_contrato.EquipoAsociado,
            lineas_contrato.DiaFacturacion,
            moviles.IMEI,
            moviles.PrecioCompra,
            moviles.PrecioLista,
            lineas_contrato.Estado,
            lineas_contrato.Permanencia,
            lineas_contrato.MontoCuota');
        $this->join('moviles', 'lineas_contrato.EquipoAsociado = moviles.IDMovil', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->where('lineas_contrato.IDLinea', $idLinea);

        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerContratosXEquipo($idEquipo)
    {
        $this->select('
            lineas_contrato.IDContrato,
            lineas_contrato.IDLinea,
            lineas_contrato.IDPlan,
            operadores.Operador,
            operadores_planes.Plan,
            operadores_planes.PrecioFinal,
            lineas_contrato.InicioContrato,
            lineas_contrato.PeriodoPermanencia,
            lineas_contrato.EquipoAsociado,
            lineas_contrato.DiaFacturacion,
            moviles.IMEI,
            moviles.PrecioCompra,
            moviles.PrecioLista,
            lineas_contrato.Estado,
            lineas_contrato.Permanencia,
            lineas_contrato.MontoCuota');
        $this->join('moviles', 'lineas_contrato.EquipoAsociado = moviles.IDMovil', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->where('lineas_contrato.EquipoAsociado', $idEquipo);

        $datos = $this->first();
        return $datos;
    }
}