<?php
namespace App\Models;
use CodeIgniter\Model;

class VADevolucionesDetalleModel extends Model
{
    protected $table      = 'devoluciones_detalle';
    protected $primaryKey = 'IDDetalleDevolucion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDDevolucion', 'IDDetalleAsignacion', 'MotivoDevolucion', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'Localhost', 'Estado', 'ObservacionValidado', 'FechaValidado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarDetalleDevolucion($idDevolucion)
    {
        $this->select('devoluciones_detalle.IDDetalleDevolucion,
            devoluciones_detalle.IDDevolucion,
            devoluciones_detalle.MotivoDevolucion,
            devoluciones_detalle.Observacion,
            devoluciones_detalle.Estado,
            devoluciones_detalle.ObservacionValidado,
            devoluciones_detalle.FechaValidado,
            asignaciones_detalle.IDDetalleAsignacion,
            asignaciones_detalle.TipoElemento,
            asignaciones_detalle.IDElemento,
            reposiciones_detalle.IDReposicion');
        $this->join('asignaciones_detalle', 'devoluciones_detalle.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion','left');
        $this->join('reposiciones_detalle', 'devoluciones_detalle.IDDetalleAsignacion = reposiciones_detalle.IDDetalleAsignacion','left');
        $this->where('devoluciones_detalle.IDDevolucion', $idDevolucion);
        
        $datos = $this->findAll();
        return $datos;
    }

}