<?php
namespace App\Models;
use CodeIgniter\Model;

class VAAsignacionesModel extends Model
{
    protected $table      = 'asignaciones';
    protected $primaryKey = 'IDAsignacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['UsuarioAsignado', 'CargoAsignado', 'DireccionAsignado', 'AreaAsignado', 'SubareaAsignado', 'DelegacionAsignado','FechaAsignado', 'TipoAsignado', 'Observacion', 'UsuarioRemitente', 'CargoRemitente', 'DireccionRemitente', 'AreaRemitente', 'SubareaRemitente', 'DelegacionRemitente', 'Legales', 'TokenLinkFirma', 'LiberadoFirma', 'FechaRegistroFirma', 'ConceptoRegistroFirma','UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarUsuariosAsignacionesActivas()
    {
        $this->select('asignaciones.UsuarioAsignado,
        COUNT(asignaciones.IDAsignacion) AS "CANTIDAD_ELEMENTOS"');
        $this->join('asignaciones_detalle', 'asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('devoluciones_detalle.IDDevolucion IS NULL');
        $this->groupBy('asignaciones.UsuarioAsignado');
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listarAsignacionesUsuario($idAsignado)
    {
        $this->select('asignaciones.IDAsignacion, 
            asignaciones.UsuarioAsignado, 
            COUNT(asignaciones_detalle.IDDetalleAsignacion) AS "CANTIDAD_DETALLE",
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado,
            asignaciones.Observacion,
            asignaciones.UsuarioRemitente');
        $this->join('asignaciones_detalle', 'asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('devoluciones_detalle.IDDevolucion IS NULL');
        $this->where('asignaciones.UsuarioAsignado',$idAsignado);
        $this->groupBy('asignaciones.IDAsignacion');

        $datos = $this->findAll();
        return $datos;
    }

    /*public function listarAsignaciones()
    {
        $this->select('asignaciones.IDAsignacion, 
            asignaciones.UsuarioAsignado, 
            COUNT(asignaciones_detalle.IDDetalleAsignacion) AS "CANTIDAD_DETALLE",
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado,
            asignaciones.Observacion,
            asignaciones.FechaRegistroFirma,
            asignaciones.UsuarioRemitente');
        $this->join('asignaciones_detalle', 'asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('devoluciones_detalle.IDDevolucion IS NULL');
        $this->groupBy('asignaciones.IDAsignacion');

        $datos = $this->findAll();
        return $datos;
    }*/
    
    public function listarAsignaciones($cc)
    {
        $builder = $this->db->table('vista_listar_asignaciones');
        if(!empty($cc))
        {
            $builder->whereIn('CCAsignado', $cc);
        }
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
}